/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.compose;

import androidx.compose.material.SwipeableState;
import androidx.compose.runtime.internal.StabilityInferred;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.TimeLineProvider;
import com.dynatrace.android.agent.measurement.MeasurementProvider;
import com.dynatrace.android.agent.measurement.MeasurementProviderImpl;
import com.dynatrace.android.agent.util.Utility;
import com.dynatrace.android.compose.SemanticsManager;
import com.dynatrace.android.compose.SwipeActionRecorder;
import com.dynatrace.android.compose.SwipeableInfo;
import com.dynatrace.android.useraction.UserActionFactory;
import com.dynatrace.android.useraction.UserActionFactoryImpl;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/dynatrace/android/compose/SwipeableComposeCallback;", "", "()V", "tag", "", "enterAction", "", "state", "Landroidx/compose/material/SwipeableState;", "useSemantics", "", "agent.instrumentorAPI.compose_release"})
@StabilityInferred(parameters=1)
public final class SwipeableComposeCallback {
    @NotNull
    public static final SwipeableComposeCallback INSTANCE = new SwipeableComposeCallback();
    @NotNull
    private static final String tag = Global.LOG_PREFIX + "SwipeableCompose";
    public static final int $stable;

    private SwipeableComposeCallback() {
    }

    public final void enterAction(@NotNull SwipeableState<?> state, boolean useSemantics) {
        Intrinsics.checkNotNullParameter(state, (String)"state");
        if (!Global.isAlive.get()) {
            return;
        }
        MeasurementProviderImpl measurementProvider = new MeasurementProviderImpl(TimeLineProvider.GLOBAL_TIME_LINE_PROVIDER);
        UserActionFactoryImpl userActionFactory = new UserActionFactoryImpl();
        SwipeableInfo swipeableInfo = new SwipeableInfo(state.getCurrentValue(), state.getTargetValue(), state);
        if (Global.DEBUG) {
            Utility.zlogD((String)tag, (String)("onUA: " + swipeableInfo));
        }
        SwipeActionRecorder swipeActionRecorder = new SwipeActionRecorder((MeasurementProvider)measurementProvider, (UserActionFactory)userActionFactory, swipeableInfo, SemanticsManager.INSTANCE.fetchNameAndClear(), useSemantics);
        swipeActionRecorder.recordAction();
    }
}

