/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.agent.events.enrichment;

import com.dynatrace.agent.events.EventModifier;
import com.dynatrace.agent.events.enrichment.AttributeAggregator;
import com.dynatrace.agent.events.enrichment.AttributeSupplier;
import com.dynatrace.agent.events.enrichment.CachedMetricsSupplier;
import com.dynatrace.agent.events.enrichment.EnrichedJsonContainer;
import com.dynatrace.agent.events.enrichment.EnrichmentAttribute;
import com.dynatrace.agent.events.enrichment.JsonObjectExtensionsKt;
import com.dynatrace.agent.events.enrichment.StoredMetricsSupplier;
import com.dynatrace.agent.events.enrichment.merge.ModifiedJsonMerger;
import com.dynatrace.agent.events.enrichment.sanitation.JsonAttributeSanitationKt;
import com.dynatrace.agent.storage.preference.MetricsData;
import com.dynatrace.android.agent.util.Utility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000`\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\n\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u001aG\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0010\u0010\t\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0018\u00010\nH\u0000\u00a2\u0006\u0002\u0010\f\u001a$\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00012\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011H\u0000\u001a\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00152\u0006\u0010\u0016\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u000eH\u0000\u001a$\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u000e2\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011H\u0000\u001a7\u0010\u001b\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001c\u001a\u00020\u000e2\u0010\u0010\t\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0018\u00010\n2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0000\u00a2\u0006\u0002\u0010\u001e\u001a\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\"\u001a\u00020#H\u0000\u001a\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010%\u001a\u00020#H\u0000\u001a\u001a\u0010&\u001a\u00020'*\b\u0012\u0004\u0012\u00020\u00130\u00152\u0006\u0010(\u001a\u00020\u0013H\u0002\u001a\f\u0010)\u001a\u00020'*\u00020\u0001H\u0000\u00a8\u0006*"}, d2={"enrichRumEvent", "Lorg/json/JSONObject;", "rumEvent", "overridableAttributeAggregator", "Lcom/dynatrace/agent/events/enrichment/AttributeAggregator;", "protectedAttributeAggregator", "eventModifiers", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lcom/dynatrace/agent/events/EventModifier;", "eventContext", "", "", "(Lorg/json/JSONObject;Lcom/dynatrace/agent/events/enrichment/AttributeAggregator;Lcom/dynatrace/agent/events/enrichment/AttributeAggregator;Ljava/util/concurrent/ConcurrentLinkedQueue;[Ljava/lang/Object;)Lorg/json/JSONObject;", "enrichJsonWithAttributes", "Lcom/dynatrace/agent/events/enrichment/EnrichedJsonContainer;", "inputJson", "enrichmentAttributes", "", "", "Lcom/dynatrace/agent/events/enrichment/EnrichmentAttribute;", "findExistingOverriddenKeys", "", "json", "integrateOverriddenKeys", "jsonContainer", "integrateProtectedAttributes", "protectedAttributes", "applyModifications", "enrichedJsonContainer", "modifiers", "(Lcom/dynatrace/agent/events/enrichment/EnrichedJsonContainer;[Ljava/lang/Object;Ljava/util/concurrent/ConcurrentLinkedQueue;)Lcom/dynatrace/agent/events/enrichment/EnrichedJsonContainer;", "collectStoredMetricsSuppliers", "", "Lcom/dynatrace/agent/events/enrichment/AttributeSupplier;", "metricsData", "Lcom/dynatrace/agent/storage/preference/MetricsData;", "collectCachedMetricsSuppliers", "metricsCache", "addUniqueByKey", "", "attribute", "ensureEventPropertiesCharacteristic", "com.dynatrace.agent_release"})
@SourceDebugExtension(value={"SMAP\nEnrichmentPipeline.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnrichmentPipeline.kt\ncom/dynatrace/agent/events/enrichment/EnrichmentPipelineKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,354:1\n1557#2:355\n1628#2,3:356\n360#2,7:359\n*S KotlinDebug\n*F\n+ 1 EnrichmentPipeline.kt\ncom/dynatrace/agent/events/enrichment/EnrichmentPipelineKt\n*L\n192#1:355\n192#1:356,3\n324#1:359,7\n*E\n"})
public final class EnrichmentPipelineKt {
    @Nullable
    public static final JSONObject enrichRumEvent(@NotNull JSONObject rumEvent, @NotNull AttributeAggregator overridableAttributeAggregator, @NotNull AttributeAggregator protectedAttributeAggregator, @NotNull ConcurrentLinkedQueue<EventModifier> eventModifiers, @Nullable Object[] eventContext) {
        JSONObject jSONObject;
        Intrinsics.checkNotNullParameter((Object)rumEvent, (String)"rumEvent");
        Intrinsics.checkNotNullParameter((Object)overridableAttributeAggregator, (String)"overridableAttributeAggregator");
        Intrinsics.checkNotNullParameter((Object)protectedAttributeAggregator, (String)"protectedAttributeAggregator");
        Intrinsics.checkNotNullParameter(eventModifiers, (String)"eventModifiers");
        Utility.devLog("dtxEnrichment", "rum event: " + rumEvent);
        EnrichedJsonContainer enrichedJson = EnrichmentPipelineKt.enrichJsonWithAttributes(rumEvent, overridableAttributeAggregator.aggregatedAttributes());
        EnrichedJsonContainer jsonWithProtectedAttributes = EnrichedJsonContainer.copy$default(enrichedJson, EnrichmentPipelineKt.integrateProtectedAttributes(enrichedJson, protectedAttributeAggregator.aggregatedAttributes()), null, 2, null);
        Utility.devLog("dtxEnrichment", "rum event after basic enrichment: overridden attributes: " + enrichedJson.getOverriddenAttributes() + "; event: " + enrichedJson.getEnrichedJson());
        EnrichedJsonContainer enrichedJsonContainer = EnrichmentPipelineKt.applyModifications(jsonWithProtectedAttributes, eventContext, eventModifiers);
        if (enrichedJsonContainer == null) {
            return null;
        }
        EnrichedJsonContainer modifiedJson = enrichedJsonContainer;
        Utility.devLog("dtxEnrichment", "rum event after modifications: overridden attributes: " + modifiedJson.getOverriddenAttributes() + "; event: " + modifiedJson.getEnrichedJson());
        JSONObject event = jSONObject = EnrichmentPipelineKt.integrateOverriddenKeys(modifiedJson);
        boolean bl = false;
        EnrichmentPipelineKt.ensureEventPropertiesCharacteristic(event);
        JSONObject enrichedRumEvent = jSONObject;
        Utility.devLog("dtxEnrichment", "rum event after full enrichment: " + enrichedRumEvent);
        return enrichedRumEvent;
    }

    @NotNull
    public static final EnrichedJsonContainer enrichJsonWithAttributes(@NotNull JSONObject inputJson, @NotNull Map<String, EnrichmentAttribute> enrichmentAttributes) {
        Intrinsics.checkNotNullParameter((Object)inputJson, (String)"inputJson");
        Intrinsics.checkNotNullParameter(enrichmentAttributes, (String)"enrichmentAttributes");
        JSONObject json = JsonObjectExtensionsKt.deepCopy(inputJson);
        List<EnrichmentAttribute> overriddenByJson = EnrichmentPipelineKt.findExistingOverriddenKeys(json);
        json.remove("dt.support.api.overridden_fields");
        for (Map.Entry<String, EnrichmentAttribute> entry : enrichmentAttributes.entrySet()) {
            String key = entry.getKey();
            EnrichmentAttribute attribute = entry.getValue();
            Object value = json.opt(key);
            if (value != null && !value.equals(attribute.getValue())) {
                Utility.devLog("dtxEnrichment", "auto-enrichment value overwritten: " + attribute + " is overwritten with custom value: " + value);
                if (!JsonAttributeSanitationKt.getGenerationApiFields().contains(key)) continue;
                EnrichmentPipelineKt.addUniqueByKey(overriddenByJson, attribute);
                continue;
            }
            json.put(key, attribute.getValue());
        }
        return new EnrichedJsonContainer(json, overriddenByJson);
    }

    @NotNull
    public static final List<EnrichmentAttribute> findExistingOverriddenKeys(@NotNull JSONObject json) {
        ArrayList<EnrichmentAttribute> arrayList;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        JSONArray jSONArray = json.optJSONArray("dt.support.api.overridden_fields");
        if (jSONArray == null) {
            return new ArrayList();
        }
        JSONArray overriddenKeysArray = jSONArray;
        ArrayList<EnrichmentAttribute> $this$findExistingOverriddenKeys_u24lambda_u241 = arrayList = new ArrayList<EnrichmentAttribute>();
        boolean bl = false;
        int n = overriddenKeysArray.length();
        for (int i = 0; i < n; ++i) {
            if (overriddenKeysArray.get(i) instanceof String) {
                String string = overriddenKeysArray.getString(i);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
                $this$findExistingOverriddenKeys_u24lambda_u241.add(new EnrichmentAttribute(string, "unknown"));
                continue;
            }
            Utility.devLog("dtxEnrichment", "dropped existing overridden_key because it was no String: " + overriddenKeysArray.get(i));
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final JSONObject integrateOverriddenKeys(@NotNull EnrichedJsonContainer jsonContainer) {
        JSONObject jSONObject;
        List<EnrichmentAttribute> overriddenAttributes;
        Intrinsics.checkNotNullParameter((Object)jsonContainer, (String)"jsonContainer");
        JSONObject enrichedJson = jsonContainer.getEnrichedJson();
        if (enrichedJson.remove("dt.support.api.overridden_fields") != null) {
            Utility.devLog("dtxEnrichment", "protected attribute integration: encountered key 'dt.support.api.overridden_fields' which is protected and will be removed");
        }
        if (!((Collection)(overriddenAttributes = jsonContainer.getOverriddenAttributes())).isEmpty()) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = overriddenAttributes;
            String string = "dt.support.api.overridden_fields";
            JSONObject jSONObject2 = enrichedJson;
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                EnrichmentAttribute enrichmentAttribute = (EnrichmentAttribute)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getKey());
            }
            collection = (List)destination$iv$iv;
            Collection collection2 = collection;
            JSONObject jSONObject3 = jSONObject2.put(string, (Object)new JSONArray(collection2));
            Intrinsics.checkNotNull((Object)jSONObject3);
            jSONObject = jSONObject3;
        } else {
            jSONObject = enrichedJson;
        }
        return jSONObject;
    }

    @NotNull
    public static final JSONObject integrateProtectedAttributes(@NotNull EnrichedJsonContainer jsonContainer, @NotNull Map<String, EnrichmentAttribute> protectedAttributes) {
        Intrinsics.checkNotNullParameter((Object)jsonContainer, (String)"jsonContainer");
        Intrinsics.checkNotNullParameter(protectedAttributes, (String)"protectedAttributes");
        JSONObject enrichedJson = jsonContainer.getEnrichedJson();
        for (Map.Entry<String, EnrichmentAttribute> entry : protectedAttributes.entrySet()) {
            String key = entry.getKey();
            EnrichmentAttribute protectedAttribute = entry.getValue();
            if (enrichedJson.has(key)) {
                Utility.devLog("dtxEnrichment", "protected attribute integration: encountered key '" + key + "' which is protected and will be overwritten with " + protectedAttribute);
            }
            enrichedJson.put(key, protectedAttribute.getValue());
        }
        return enrichedJson;
    }

    @Nullable
    public static final EnrichedJsonContainer applyModifications(@NotNull EnrichedJsonContainer enrichedJsonContainer, @Nullable Object[] eventContext, @NotNull ConcurrentLinkedQueue<EventModifier> modifiers) {
        EnrichedJsonContainer enrichedJsonContainer2;
        Intrinsics.checkNotNullParameter((Object)enrichedJsonContainer, (String)"enrichedJsonContainer");
        Intrinsics.checkNotNullParameter(modifiers, (String)"modifiers");
        if (modifiers.isEmpty()) {
            return enrichedJsonContainer;
        }
        StringBuilder stringBuilder = new StringBuilder().append("apply modifications: with ").append(modifiers.size()).append(" modifier(s); context: ");
        Object object = eventContext;
        if (eventContext == null || (object = ArraysKt.joinToString$default((Object[])object, (CharSequence)", ", (CharSequence)"[", (CharSequence)"]", (int)0, null, EnrichmentPipelineKt::applyModifications$lambda$3, (int)24, null)) == null) {
            object = "null";
        }
        Utility.devLog("dtxEnrichment", stringBuilder.append((String)object).toString());
        JSONObject modifiableCopy = JsonObjectExtensionsKt.deepCopy(enrichedJsonContainer.getEnrichedJson());
        boolean modifierCausedException = false;
        Iterator<EventModifier> iterator = modifiers.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<EventModifier> iterator2 = iterator;
        while (iterator2.hasNext()) {
            JSONObject jSONObject;
            EventModifier modifier = iterator2.next();
            try {
                jSONObject = modifier.modifyEvent(modifiableCopy, eventContext);
            }
            catch (Exception throwable) {
                Utility.devLog("dtxEnrichment", "apply modifications: event modifier caused exception. EventModifier: " + Reflection.getOrCreateKotlinClass(modifier.getClass()).getSimpleName());
                modifierCausedException = true;
                jSONObject = modifiableCopy;
            }
            if ((modifiableCopy = jSONObject) != null) continue;
            Utility.devLog("dtxEnrichment", "apply modifications: event dropped by event modifier. EventModifier: " + Reflection.getOrCreateKotlinClass(modifier.getClass()).getSimpleName());
            break;
        }
        if (modifiableCopy == null) {
            enrichedJsonContainer2 = null;
        } else {
            EnrichedJsonContainer enrichedJsonContainer3;
            boolean isSessionPropertiesEvent = JsonObjectExtensionsKt.hasCharacteristic(enrichedJsonContainer.getEnrichedJson(), "characteristics.has_session_properties");
            EnrichedJsonContainer $this$applyModifications_u24lambda_u244 = enrichedJsonContainer3 = new ModifiedJsonMerger(enrichedJsonContainer, isSessionPropertiesEvent).merge(modifiableCopy);
            boolean bl = false;
            if (modifierCausedException) {
                $this$applyModifications_u24lambda_u244.getEnrichedJson().put("dt.support.api.has_enrich_exception", true);
            }
            enrichedJsonContainer2 = enrichedJsonContainer3;
        }
        return enrichedJsonContainer2;
    }

    @NotNull
    public static final List<AttributeSupplier> collectStoredMetricsSuppliers(@NotNull MetricsData metricsData) {
        Intrinsics.checkNotNullParameter((Object)metricsData, (String)"metricsData");
        return CollectionsKt.listOf((Object)new StoredMetricsSupplier(metricsData));
    }

    @NotNull
    public static final List<AttributeSupplier> collectCachedMetricsSuppliers(@NotNull MetricsData metricsCache) {
        Intrinsics.checkNotNullParameter((Object)metricsCache, (String)"metricsCache");
        return CollectionsKt.listOf((Object)new CachedMetricsSupplier(metricsCache));
    }

    private static final void addUniqueByKey(List<EnrichmentAttribute> $this$addUniqueByKey, EnrichmentAttribute attribute) {
        Object object;
        int existingIndex;
        block4: {
            int n;
            List<EnrichmentAttribute> $this$indexOfFirst$iv = $this$addUniqueByKey;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<EnrichmentAttribute> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                EnrichmentAttribute item$iv;
                EnrichmentAttribute overriddenAttribute = item$iv = iterator.next();
                boolean bl = false;
                if (Intrinsics.areEqual((Object)overriddenAttribute.getKey(), (Object)attribute.getKey())) {
                    n = index$iv;
                    break block4;
                }
                ++index$iv;
            }
            n = existingIndex = -1;
        }
        if (existingIndex >= 0) {
            Utility.devLog("dtxEnrichment", "key '" + attribute.getKey() + "' already in overridden keys list. Replacing it.");
            object = $this$addUniqueByKey.set(existingIndex, attribute);
        } else {
            object = $this$addUniqueByKey.add(attribute);
        }
    }

    public static final void ensureEventPropertiesCharacteristic(@NotNull JSONObject $this$ensureEventPropertiesCharacteristic) {
        Intrinsics.checkNotNullParameter((Object)$this$ensureEventPropertiesCharacteristic, (String)"<this>");
        if (JsonObjectExtensionsKt.hasKeyIn($this$ensureEventPropertiesCharacteristic, "event_properties.") && !JsonObjectExtensionsKt.hasCharacteristic($this$ensureEventPropertiesCharacteristic, "characteristics.has_event_properties")) {
            $this$ensureEventPropertiesCharacteristic.put("characteristics.has_event_properties", true);
        } else if (JsonObjectExtensionsKt.hasCharacteristic($this$ensureEventPropertiesCharacteristic, "characteristics.has_event_properties") && !JsonObjectExtensionsKt.hasKeyIn($this$ensureEventPropertiesCharacteristic, "event_properties.")) {
            $this$ensureEventPropertiesCharacteristic.remove("characteristics.has_event_properties");
        }
    }

    private static final CharSequence applyModifications$lambda$3(Object it) {
        Class<?> clazz = it;
        return String.valueOf(clazz != null && (clazz = clazz.getClass()) != null ? clazz.getName() : null);
    }
}

