/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.agent.events.enrichment;

import com.dynatrace.agent.events.enrichment.AttributeSupplier;
import com.dynatrace.agent.events.enrichment.EnrichmentAttribute;
import com.dynatrace.android.agent.util.Utility;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/dynatrace/agent/events/enrichment/AttributeAggregator;", "", "suppliers", "", "Lcom/dynatrace/agent/events/enrichment/AttributeSupplier;", "<init>", "(Ljava/util/List;)V", "aggregatedAttributes", "", "", "Lcom/dynatrace/agent/events/enrichment/EnrichmentAttribute;", "com.dynatrace.agent_release"})
public final class AttributeAggregator {
    @NotNull
    private final List<AttributeSupplier> suppliers;

    public AttributeAggregator(@NotNull List<? extends AttributeSupplier> suppliers) {
        Intrinsics.checkNotNullParameter(suppliers, (String)"suppliers");
        this.suppliers = suppliers;
    }

    @NotNull
    public final Map<String, EnrichmentAttribute> aggregatedAttributes() {
        TreeMap aggregatedAttributes = new TreeMap();
        for (AttributeSupplier supplier : this.suppliers) {
            for (EnrichmentAttribute suppliedAttribute : supplier.supply()) {
                if (aggregatedAttributes.containsKey(suppliedAttribute.getKey())) {
                    Utility.devLog("dtxEnrichment", "attribute aggregation: overriding existing attribute " + aggregatedAttributes.get(suppliedAttribute.getKey()) + " with " + suppliedAttribute);
                }
                ((Map)aggregatedAttributes).put(suppliedAttribute.getKey(), suppliedAttribute);
            }
        }
        return aggregatedAttributes;
    }
}

