/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.agent.lifecycle.callback;

import android.app.Activity;
import android.os.Bundle;
import com.dynatrace.agent.lifecycle.AppStartupManager;
import com.dynatrace.agent.lifecycle.VisibilityManager;
import com.dynatrace.agent.lifecycle.VisibilityManagerKt;
import com.dynatrace.agent.lifecycle.callback.BaseActivityLifecycleCallbacks;
import com.dynatrace.agent.lifecycle.model.AppStartupPhase;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/dynatrace/agent/lifecycle/callback/ActivityLifecycleListener;", "Lcom/dynatrace/agent/lifecycle/callback/BaseActivityLifecycleCallbacks;", "appStartupManager", "Lcom/dynatrace/agent/lifecycle/AppStartupManager;", "visibilityManager", "Lcom/dynatrace/agent/lifecycle/VisibilityManager;", "<init>", "(Lcom/dynatrace/agent/lifecycle/AppStartupManager;Lcom/dynatrace/agent/lifecycle/VisibilityManager;)V", "onActivityPostResumed", "", "activity", "Landroid/app/Activity;", "onActivityPreCreated", "savedInstanceState", "Landroid/os/Bundle;", "onActivityPreStarted", "onActivityStarted", "onActivityPaused", "onActivityStopped", "com.dynatrace.agent_release"})
public final class ActivityLifecycleListener
extends BaseActivityLifecycleCallbacks {
    @NotNull
    private final AppStartupManager appStartupManager;
    @NotNull
    private final VisibilityManager visibilityManager;

    public ActivityLifecycleListener(@NotNull AppStartupManager appStartupManager, @NotNull VisibilityManager visibilityManager) {
        Intrinsics.checkNotNullParameter((Object)appStartupManager, (String)"appStartupManager");
        Intrinsics.checkNotNullParameter((Object)visibilityManager, (String)"visibilityManager");
        this.appStartupManager = appStartupManager;
        this.visibilityManager = visibilityManager;
    }

    public void onActivityPostResumed(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.appStartupManager.onStartupPhase(AppStartupPhase.ACTIVITY_RESUMED);
    }

    public void onActivityPreCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.appStartupManager.onStartupPhase(AppStartupPhase.ACTIVITY_CREATE);
    }

    public void onActivityPreStarted(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.appStartupManager.onStartupPhase(AppStartupPhase.ACTIVITY_START);
    }

    @Override
    public void onActivityStarted(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.visibilityManager.onActivityStarted(VisibilityManagerKt.toIdHash(activity));
    }

    @Override
    public void onActivityPaused(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.visibilityManager.onActivityPaused(VisibilityManagerKt.toIdHash(activity));
    }

    @Override
    public void onActivityStopped(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.visibilityManager.onActivityStopped(VisibilityManagerKt.toIdHash(activity), activity.isChangingConfigurations());
    }
}

