/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.compiler.internal;

import com.dylibso.chicory.compiler.internal.CompilerInstruction;
import com.dylibso.chicory.compiler.internal.CompilerOpCode;
import com.dylibso.chicory.compiler.internal.CompilerUtil;
import com.dylibso.chicory.compiler.internal.Context;
import com.dylibso.chicory.compiler.internal.ShadedRefs;
import com.dylibso.chicory.runtime.Instance;
import com.dylibso.chicory.runtime.OpCodeIdentifier;
import com.dylibso.chicory.runtime.WasmException;
import com.dylibso.chicory.wasm.types.FunctionType;
import com.dylibso.chicory.wasm.types.ValType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.InstructionAdapter;

final class Emitters {
    private Emitters() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static void TRAP(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        CompilerUtil.emitInvokeStatic((MethodVisitor)asm, ShadedRefs.THROW_TRAP_EXCEPTION);
        asm.athrow();
    }

    public static ValType valType(long id, Context ctx) {
        return ValType.builder().fromId(id).build(ctx::type);
    }

    public static void DROP_KEEP(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        ValType type;
        int i;
        int keepStart = (int)ins.operand(0) + 1;
        int slot = ctx.tempSlot();
        for (i = ins.operandCount() - 1; i >= keepStart; --i) {
            type = Emitters.valType(ins.operand(i), ctx);
            asm.store(slot, CompilerUtil.asmType(type));
            slot += CompilerUtil.slotCount(type);
        }
        for (i = keepStart - 1; i >= 1; --i) {
            CompilerUtil.emitPop((MethodVisitor)asm, Emitters.valType(ins.operand(i), ctx));
        }
        for (i = keepStart; i < ins.operandCount(); ++i) {
            type = Emitters.valType(ins.operand(i), ctx);
            asm.load(slot -= CompilerUtil.slotCount(type), CompilerUtil.asmType(type));
        }
    }

    public static void RETURN(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        if (ctx.getType().returns().size() > 1) {
            asm.invokestatic(ctx.internalClassName(), CompilerUtil.valueMethodName(ctx.getType().returns()), CompilerUtil.valueMethodType(ctx.getType().returns()).toMethodDescriptorString(), false);
        }
        asm.areturn(Type.getType(CompilerUtil.jvmReturnType(ctx.getType())));
    }

    public static void DROP(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        CompilerUtil.emitPop((MethodVisitor)asm, Emitters.valType(ins.operand(0), ctx));
    }

    public static void ELEM_DROP(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        int index = (int)ins.operand(0);
        asm.load(ctx.instanceSlot(), InstructionAdapter.OBJECT_TYPE);
        asm.iconst(index);
        asm.aconst(null);
        CompilerUtil.emitInvokeVirtual((MethodVisitor)asm, ShadedRefs.INSTANCE_SET_ELEMENT);
    }

    public static void SELECT(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        ValType type = Emitters.valType(ins.operand(0), ctx);
        Label endLabel = new Label();
        asm.ifne(endLabel);
        if (CompilerUtil.slotCount(type) == 1) {
            asm.swap();
        } else {
            asm.dup2X2();
            asm.pop2();
        }
        asm.mark(endLabel);
        CompilerUtil.emitPop((MethodVisitor)asm, type);
    }

    private static void emitBoxValuesOnStack(Context ctx, InstructionAdapter asm, List<ValType> types) {
        ValType valType;
        int i;
        int slot = ctx.tempSlot() + types.stream().mapToInt(CompilerUtil::slotCount).sum();
        for (i = types.size() - 1; i >= 0; --i) {
            valType = types.get(i);
            asm.store(slot -= CompilerUtil.slotCount(valType), CompilerUtil.asmType(valType));
        }
        asm.iconst(types.size());
        asm.newarray(Type.LONG_TYPE);
        slot = ctx.tempSlot();
        for (i = 0; i < types.size(); ++i) {
            valType = types.get(i);
            asm.dup();
            asm.iconst(i);
            asm.load(slot, CompilerUtil.asmType(valType));
            slot += CompilerUtil.slotCount(valType);
            CompilerUtil.emitJvmToLong((MethodVisitor)asm, valType);
            asm.astore(Type.LONG_TYPE);
        }
    }

    public static void CALL(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        int funcId = (int)ins.operand(0);
        FunctionType functionType = ctx.functionTypes().get(funcId);
        CompilerUtil.emitInvokeStatic((MethodVisitor)asm, ShadedRefs.CHECK_INTERRUPTION);
        if (CompilerUtil.hasTooManyParameters(functionType)) {
            Emitters.emitBoxValuesOnStack(ctx, asm, functionType.params());
        }
        asm.load(ctx.memorySlot(), InstructionAdapter.OBJECT_TYPE);
        asm.load(ctx.instanceSlot(), InstructionAdapter.OBJECT_TYPE);
        CompilerUtil.emitInvokeFunction((MethodVisitor)asm, ctx.classNameForFuncGroup(ctx.internalClassName(), funcId), funcId, functionType);
        if (functionType.returns().size() > 1) {
            Emitters.emitUnboxResult(asm, ctx, functionType.returns());
        }
    }

    public static void CALL_INDIRECT(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        int typeId = (int)ins.operand(0);
        int tableIdx = (int)ins.operand(1);
        FunctionType functionType = ctx.types()[typeId];
        if (CompilerUtil.hasTooManyParameters(functionType)) {
            Emitters.emitBoxValuesOnStack(ctx, asm, functionType.params());
        }
        asm.iconst(tableIdx);
        asm.load(ctx.memorySlot(), InstructionAdapter.OBJECT_TYPE);
        asm.load(ctx.instanceSlot(), InstructionAdapter.OBJECT_TYPE);
        asm.invokestatic(ctx.internalClassName(), CompilerUtil.callIndirectMethodName(typeId), CompilerUtil.callIndirectMethodType(functionType).toMethodDescriptorString(), false);
        if (functionType.returns().size() > 1) {
            Emitters.emitUnboxResult(asm, ctx, functionType.returns());
        }
    }

    public static void REF_FUNC(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        asm.iconst((int)ins.operand(0));
    }

    public static void REF_NULL(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        asm.iconst(-1);
    }

    public static void REF_IS_NULL(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        CompilerUtil.emitInvokeStatic((MethodVisitor)asm, ShadedRefs.REF_IS_NULL);
    }

    public static void LOCAL_GET(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        int loadIndex = (int)ins.operand(0);
        ValType localType = CompilerUtil.localType(ctx.getType(), ctx.getBody(), loadIndex);
        asm.load(ctx.localSlotIndex(loadIndex), CompilerUtil.asmType(localType));
    }

    public static void LOCAL_SET(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        int index = (int)ins.operand(0);
        ValType localType = CompilerUtil.localType(ctx.getType(), ctx.getBody(), index);
        asm.store(ctx.localSlotIndex(index), CompilerUtil.asmType(localType));
    }

    public static void LOCAL_TEE(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        if (CompilerUtil.slotCount(Emitters.valType(ins.operand(1), ctx)) == 1) {
            asm.dup();
        } else {
            asm.dup2();
        }
        Emitters.LOCAL_SET(ctx, ins, asm);
    }

    public static void GLOBAL_GET(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        int globalIndex = (int)ins.operand(0);
        asm.iconst(globalIndex);
        asm.load(ctx.instanceSlot(), InstructionAdapter.OBJECT_TYPE);
        CompilerUtil.emitInvokeStatic((MethodVisitor)asm, ShadedRefs.READ_GLOBAL);
        CompilerUtil.emitLongToJvm((MethodVisitor)asm, ctx.globalTypes().get(globalIndex));
    }

    public static void GLOBAL_SET(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        int globalIndex = (int)ins.operand(0);
        CompilerUtil.emitJvmToLong((MethodVisitor)asm, ctx.globalTypes().get(globalIndex));
        asm.iconst(globalIndex);
        asm.load(ctx.instanceSlot(), InstructionAdapter.OBJECT_TYPE);
        CompilerUtil.emitInvokeStatic((MethodVisitor)asm, ShadedRefs.WRITE_GLOBAL);
    }

    public static void TABLE_GET(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        asm.iconst((int)ins.operand(0));
        asm.load(ctx.instanceSlot(), InstructionAdapter.OBJECT_TYPE);
        CompilerUtil.emitInvokeStatic((MethodVisitor)asm, ShadedRefs.TABLE_GET);
    }

    public static void TABLE_SET(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        asm.iconst((int)ins.operand(0));
        asm.load(ctx.instanceSlot(), InstructionAdapter.OBJECT_TYPE);
        CompilerUtil.emitInvokeStatic((MethodVisitor)asm, ShadedRefs.TABLE_SET);
    }

    public static void TABLE_SIZE(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        asm.iconst((int)ins.operand(0));
        asm.load(ctx.instanceSlot(), InstructionAdapter.OBJECT_TYPE);
        CompilerUtil.emitInvokeStatic((MethodVisitor)asm, ShadedRefs.TABLE_SIZE);
    }

    public static void TABLE_GROW(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        asm.iconst((int)ins.operand(0));
        asm.load(ctx.instanceSlot(), InstructionAdapter.OBJECT_TYPE);
        CompilerUtil.emitInvokeStatic((MethodVisitor)asm, ShadedRefs.TABLE_GROW);
    }

    public static void TABLE_FILL(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        asm.iconst((int)ins.operand(0));
        asm.load(ctx.instanceSlot(), InstructionAdapter.OBJECT_TYPE);
        CompilerUtil.emitInvokeStatic((MethodVisitor)asm, ShadedRefs.TABLE_FILL);
    }

    public static void TABLE_COPY(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        asm.iconst((int)ins.operand(0));
        asm.iconst((int)ins.operand(1));
        asm.load(ctx.instanceSlot(), InstructionAdapter.OBJECT_TYPE);
        CompilerUtil.emitInvokeStatic((MethodVisitor)asm, ShadedRefs.TABLE_COPY);
    }

    public static void TABLE_INIT(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        asm.iconst((int)ins.operand(0));
        asm.iconst((int)ins.operand(1));
        asm.load(ctx.instanceSlot(), InstructionAdapter.OBJECT_TYPE);
        CompilerUtil.emitInvokeStatic((MethodVisitor)asm, ShadedRefs.TABLE_INIT);
    }

    public static void MEMORY_INIT(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        asm.iconst((int)ins.operand(0));
        asm.load(ctx.memorySlot(), InstructionAdapter.OBJECT_TYPE);
        CompilerUtil.emitInvokeStatic((MethodVisitor)asm, ShadedRefs.MEMORY_INIT);
    }

    public static void MEMORY_COPY(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        asm.load(ctx.memorySlot(), InstructionAdapter.OBJECT_TYPE);
        CompilerUtil.emitInvokeStatic((MethodVisitor)asm, ShadedRefs.MEMORY_COPY);
    }

    public static void MEMORY_FILL(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        asm.load(ctx.memorySlot(), InstructionAdapter.OBJECT_TYPE);
        CompilerUtil.emitInvokeStatic((MethodVisitor)asm, ShadedRefs.MEMORY_FILL);
    }

    public static void MEMORY_GROW(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        asm.load(ctx.memorySlot(), InstructionAdapter.OBJECT_TYPE);
        CompilerUtil.emitInvokeStatic((MethodVisitor)asm, ShadedRefs.MEMORY_GROW);
    }

    public static void MEMORY_SIZE(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        asm.load(ctx.memorySlot(), InstructionAdapter.OBJECT_TYPE);
        CompilerUtil.emitInvokeStatic((MethodVisitor)asm, ShadedRefs.MEMORY_PAGES);
    }

    public static void DATA_DROP(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        asm.iconst((int)ins.operand(0));
        asm.load(ctx.memorySlot(), InstructionAdapter.OBJECT_TYPE);
        CompilerUtil.emitInvokeStatic((MethodVisitor)asm, ShadedRefs.MEMORY_DROP);
    }

    public static void I32_ADD(Context ctx, CompilerInstruction ins, MethodVisitor asm) {
        asm.visitInsn(96);
    }

    public static void I32_AND(Context ctx, CompilerInstruction ins, MethodVisitor asm) {
        asm.visitInsn(126);
    }

    public static void I32_CONST(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        asm.iconst((int)ins.operand(0));
    }

    public static void I32_MUL(Context ctx, CompilerInstruction ins, MethodVisitor asm) {
        asm.visitInsn(104);
    }

    public static void I32_OR(Context ctx, CompilerInstruction ins, MethodVisitor asm) {
        asm.visitInsn(128);
    }

    public static void I32_SHL(Context ctx, CompilerInstruction ins, MethodVisitor asm) {
        asm.visitInsn(120);
    }

    public static void I32_SHR_S(Context ctx, CompilerInstruction ins, MethodVisitor asm) {
        asm.visitInsn(122);
    }

    public static void I32_SHR_U(Context ctx, CompilerInstruction ins, MethodVisitor asm) {
        asm.visitInsn(124);
    }

    public static void I32_SUB(Context ctx, CompilerInstruction ins, MethodVisitor asm) {
        asm.visitInsn(100);
    }

    public static void I32_WRAP_I64(Context ctx, CompilerInstruction ins, MethodVisitor asm) {
        asm.visitInsn(136);
    }

    public static void I32_XOR(Context ctx, CompilerInstruction ins, MethodVisitor asm) {
        asm.visitInsn(130);
    }

    public static void I64_ADD(Context ctx, CompilerInstruction ins, MethodVisitor asm) {
        asm.visitInsn(97);
    }

    public static void I64_AND(Context ctx, CompilerInstruction ins, MethodVisitor asm) {
        asm.visitInsn(127);
    }

    public static void I64_CONST(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        asm.lconst(ins.operand(0));
    }

    public static void I64_EXTEND_I32_S(Context ctx, CompilerInstruction ins, MethodVisitor asm) {
        asm.visitInsn(133);
    }

    public static void I64_MUL(Context ctx, CompilerInstruction ins, MethodVisitor asm) {
        asm.visitInsn(105);
    }

    public static void I64_OR(Context ctx, CompilerInstruction ins, MethodVisitor asm) {
        asm.visitInsn(129);
    }

    public static void I64_SHL(Context ctx, CompilerInstruction ins, MethodVisitor asm) {
        asm.visitInsn(136);
        asm.visitInsn(121);
    }

    public static void I64_SHR_S(Context ctx, CompilerInstruction ins, MethodVisitor asm) {
        asm.visitInsn(136);
        asm.visitInsn(123);
    }

    public static void I64_SHR_U(Context ctx, CompilerInstruction ins, MethodVisitor asm) {
        asm.visitInsn(136);
        asm.visitInsn(125);
    }

    public static void I64_SUB(Context ctx, CompilerInstruction ins, MethodVisitor asm) {
        asm.visitInsn(101);
    }

    public static void I64_XOR(Context ctx, CompilerInstruction ins, MethodVisitor asm) {
        asm.visitInsn(131);
    }

    public static void F32_ADD(Context ctx, CompilerInstruction ins, MethodVisitor asm) {
        asm.visitInsn(98);
    }

    public static void F32_CONST(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        asm.fconst(Float.intBitsToFloat((int)ins.operand(0)));
    }

    public static void F32_DEMOTE_F64(Context ctx, CompilerInstruction ins, MethodVisitor asm) {
        asm.visitInsn(144);
    }

    public static void F32_DIV(Context ctx, CompilerInstruction ins, MethodVisitor asm) {
        asm.visitInsn(110);
    }

    public static void F32_MUL(Context ctx, CompilerInstruction ins, MethodVisitor asm) {
        asm.visitInsn(106);
    }

    public static void F32_NEG(Context ctx, CompilerInstruction ins, MethodVisitor asm) {
        asm.visitInsn(118);
    }

    public static void F32_SUB(Context ctx, CompilerInstruction ins, MethodVisitor asm) {
        asm.visitInsn(102);
    }

    public static void F64_ADD(Context ctx, CompilerInstruction ins, MethodVisitor asm) {
        asm.visitInsn(99);
    }

    public static void F64_CONST(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        asm.dconst(Double.longBitsToDouble(ins.operand(0)));
    }

    public static void F64_DIV(Context ctx, CompilerInstruction ins, MethodVisitor asm) {
        asm.visitInsn(111);
    }

    public static void F64_MUL(Context ctx, CompilerInstruction ins, MethodVisitor asm) {
        asm.visitInsn(107);
    }

    public static void F64_NEG(Context ctx, CompilerInstruction ins, MethodVisitor asm) {
        asm.visitInsn(119);
    }

    public static void F64_PROMOTE_F32(Context ctx, CompilerInstruction ins, MethodVisitor asm) {
        asm.visitInsn(141);
    }

    public static void F64_SUB(Context ctx, CompilerInstruction ins, MethodVisitor asm) {
        asm.visitInsn(103);
    }

    public static void I32_LOAD(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_READ_INT);
    }

    public static void I32_LOAD8_S(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_READ_BYTE);
    }

    public static void I32_LOAD8_U(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.I32_LOAD8_S(ctx, ins, asm);
        asm.iconst(255);
        asm.visitInsn(126);
    }

    public static void I32_LOAD16_S(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_READ_SHORT);
    }

    public static void I32_LOAD16_U(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.I32_LOAD16_S(ctx, ins, asm);
        asm.iconst(65535);
        asm.visitInsn(126);
    }

    public static void F32_LOAD(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_READ_FLOAT);
    }

    public static void I64_LOAD(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_READ_LONG);
    }

    public static void I64_LOAD8_S(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.I32_LOAD8_S(ctx, ins, asm);
        asm.visitInsn(133);
    }

    public static void I64_LOAD8_U(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.I32_LOAD8_U(ctx, ins, asm);
        asm.visitInsn(133);
    }

    public static void I64_LOAD16_S(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.I32_LOAD16_S(ctx, ins, asm);
        asm.visitInsn(133);
    }

    public static void I64_LOAD16_U(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.I32_LOAD16_U(ctx, ins, asm);
        asm.visitInsn(133);
    }

    public static void I64_LOAD32_S(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.I32_LOAD(ctx, ins, asm);
        asm.visitInsn(133);
    }

    public static void I64_LOAD32_U(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.I32_LOAD(ctx, ins, asm);
        asm.visitInsn(133);
        asm.lconst(0xFFFFFFFFL);
        asm.visitInsn(127);
    }

    public static void F64_LOAD(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_READ_DOUBLE);
    }

    public static void I32_STORE(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_WRITE_INT);
    }

    public static void I32_STORE8(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        asm.visitInsn(145);
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_WRITE_BYTE);
    }

    public static void I32_STORE16(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        asm.visitInsn(147);
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_WRITE_SHORT);
    }

    public static void F32_STORE(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_WRITE_FLOAT);
    }

    public static void I64_STORE8(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        asm.visitInsn(136);
        Emitters.I32_STORE8(ctx, ins, asm);
    }

    public static void I64_STORE16(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        asm.visitInsn(136);
        Emitters.I32_STORE16(ctx, ins, asm);
    }

    public static void I64_STORE32(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        asm.visitInsn(136);
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_WRITE_INT);
    }

    public static void I64_STORE(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_WRITE_LONG);
    }

    public static void F64_STORE(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_WRITE_DOUBLE);
    }

    public static void ATOMIC_INT_READ_BYTE(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_INT_BYTE_READ);
    }

    public static void ATOMIC_INT_READ_SHORT(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_INT_SHORT_READ);
    }

    public static void ATOMIC_INT_READ(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_INT_READ);
    }

    public static void ATOMIC_LONG_READ(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_LONG_READ);
    }

    public static void ATOMIC_LONG_READ_BYTE(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_LONG_BYTE_READ);
    }

    public static void ATOMIC_LONG_READ_SHORT(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_LONG_SHORT_READ);
    }

    public static void ATOMIC_LONG_READ_INT(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_LONG_INT_READ);
    }

    public static void ATOMIC_INT_STORE(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_INT_WRITE);
    }

    public static void ATOMIC_INT_STORE_BYTE(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_INT_BYTE_WRITE);
    }

    public static void ATOMIC_INT_STORE_SHORT(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_INT_SHORT_WRITE);
    }

    public static void ATOMIC_LONG_STORE(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_LONG_WRITE);
    }

    public static void ATOMIC_LONG_STORE_BYTE(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        asm.visitInsn(136);
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_LONG_BYTE_WRITE);
    }

    public static void ATOMIC_LONG_STORE_SHORT(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        asm.visitInsn(136);
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_LONG_SHORT_WRITE);
    }

    public static void ATOMIC_LONG_STORE_INT(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        asm.visitInsn(136);
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_LONG_INT_WRITE);
    }

    public static void ATOMIC_INT_RMW_ADD(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_INT_RMW_ADD);
    }

    public static void ATOMIC_INT_RMW_SUB(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_INT_RMW_SUB);
    }

    public static void ATOMIC_INT_RMW_AND(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_INT_RMW_AND);
    }

    public static void ATOMIC_INT_RMW_OR(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_INT_RMW_OR);
    }

    public static void ATOMIC_INT_RMW_XOR(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_INT_RMW_XOR);
    }

    public static void ATOMIC_INT_RMW_XCHG(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_INT_RMW_XCHG);
    }

    public static void ATOMIC_INT_RMW_CMPXCHG(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_INT_RMW_CMPXCHG);
    }

    public static void ATOMIC_INT_RMW8_ADD_U(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_INT_RMW8_ADD_U);
    }

    public static void ATOMIC_INT_RMW8_SUB_U(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_INT_RMW8_SUB_U);
    }

    public static void ATOMIC_INT_RMW8_AND_U(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_INT_RMW8_AND_U);
    }

    public static void ATOMIC_INT_RMW8_OR_U(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_INT_RMW8_OR_U);
    }

    public static void ATOMIC_INT_RMW8_XOR_U(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_INT_RMW8_XOR_U);
    }

    public static void ATOMIC_INT_RMW8_XCHG_U(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_INT_RMW8_XCHG_U);
    }

    public static void ATOMIC_INT_RMW8_CMPXCHG_U(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_INT_RMW8_CMPXCHG_U);
    }

    public static void ATOMIC_INT_RMW16_ADD_U(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_INT_RMW16_ADD_U);
    }

    public static void ATOMIC_INT_RMW16_SUB_U(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_INT_RMW16_SUB_U);
    }

    public static void ATOMIC_INT_RMW16_AND_U(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_INT_RMW16_AND_U);
    }

    public static void ATOMIC_INT_RMW16_OR_U(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_INT_RMW16_OR_U);
    }

    public static void ATOMIC_INT_RMW16_XOR_U(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_INT_RMW16_XOR_U);
    }

    public static void ATOMIC_INT_RMW16_XCHG_U(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_INT_RMW16_XCHG_U);
    }

    public static void ATOMIC_INT_RMW16_CMPXCHG_U(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_INT_RMW16_CMPXCHG_U);
    }

    public static void ATOMIC_LONG_RMW_ADD(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_LONG_RMW_ADD);
    }

    public static void ATOMIC_LONG_RMW_SUB(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_LONG_RMW_SUB);
    }

    public static void ATOMIC_LONG_RMW_AND(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_LONG_RMW_AND);
    }

    public static void ATOMIC_LONG_RMW_OR(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_LONG_RMW_OR);
    }

    public static void ATOMIC_LONG_RMW_XOR(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_LONG_RMW_XOR);
    }

    public static void ATOMIC_LONG_RMW_XCHG(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_LONG_RMW_XCHG);
    }

    public static void ATOMIC_LONG_RMW_CMPXCHG(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_LONG_RMW_CMPXCHG);
    }

    public static void ATOMIC_LONG_RMW8_ADD_U(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_LONG_RMW8_ADD_U);
    }

    public static void ATOMIC_LONG_RMW8_SUB_U(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_LONG_RMW8_SUB_U);
    }

    public static void ATOMIC_LONG_RMW8_AND_U(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_LONG_RMW8_AND_U);
    }

    public static void ATOMIC_LONG_RMW8_OR_U(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_LONG_RMW8_OR_U);
    }

    public static void ATOMIC_LONG_RMW8_XOR_U(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_LONG_RMW8_XOR_U);
    }

    public static void ATOMIC_LONG_RMW8_XCHG_U(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_LONG_RMW8_XCHG_U);
    }

    public static void ATOMIC_LONG_RMW8_CMPXCHG_U(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_LONG_RMW8_CMPXCHG_U);
    }

    public static void ATOMIC_LONG_RMW16_ADD_U(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_LONG_RMW16_ADD_U);
    }

    public static void ATOMIC_LONG_RMW16_SUB_U(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_LONG_RMW16_SUB_U);
    }

    public static void ATOMIC_LONG_RMW16_AND_U(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_LONG_RMW16_AND_U);
    }

    public static void ATOMIC_LONG_RMW16_OR_U(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_LONG_RMW16_OR_U);
    }

    public static void ATOMIC_LONG_RMW16_XOR_U(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_LONG_RMW16_XOR_U);
    }

    public static void ATOMIC_LONG_RMW16_XCHG_U(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_LONG_RMW16_XCHG_U);
    }

    public static void ATOMIC_LONG_RMW16_CMPXCHG_U(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_LONG_RMW16_CMPXCHG_U);
    }

    public static void ATOMIC_LONG_RMW32_ADD_U(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_LONG_RMW32_ADD_U);
    }

    public static void ATOMIC_LONG_RMW32_SUB_U(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_LONG_RMW32_SUB_U);
    }

    public static void ATOMIC_LONG_RMW32_AND_U(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_LONG_RMW32_AND_U);
    }

    public static void ATOMIC_LONG_RMW32_OR_U(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_LONG_RMW32_OR_U);
    }

    public static void ATOMIC_LONG_RMW32_XOR_U(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_LONG_RMW32_XOR_U);
    }

    public static void ATOMIC_LONG_RMW32_XCHG_U(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_LONG_RMW32_XCHG_U);
    }

    public static void ATOMIC_LONG_RMW32_CMPXCHG_U(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_LONG_RMW32_CMPXCHG_U);
    }

    public static void MEM_ATOMIC_WAIT32(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_WAIT32);
    }

    public static void MEM_ATOMIC_WAIT64(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_WAIT64);
    }

    public static void MEM_ATOMIC_NOTIFY(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        Emitters.emitLoadOrStore(ctx, ins, asm, ShadedRefs.MEMORY_ATOMIC_NOTIFY);
    }

    private static void emitLoadOrStore(Context ctx, CompilerInstruction ins, InstructionAdapter asm, Method method) {
        long offset = ins.operand(1);
        if (offset < 0L || offset >= Integer.MAX_VALUE) {
            CompilerUtil.emitInvokeStatic((MethodVisitor)asm, ShadedRefs.THROW_OUT_OF_BOUNDS_MEMORY_ACCESS);
            asm.athrow();
        }
        asm.iconst((int)offset);
        asm.load(ctx.memorySlot(), InstructionAdapter.OBJECT_TYPE);
        CompilerUtil.emitInvokeStatic((MethodVisitor)asm, method);
    }

    private static void emitUnboxResult(InstructionAdapter asm, Context ctx, List<ValType> types) {
        Emitters.emitUnboxResult(asm, types, ctx.tempSlot());
    }

    private static void emitUnboxResult(InstructionAdapter asm, List<ValType> types, int tempSlot) {
        asm.store(tempSlot, InstructionAdapter.OBJECT_TYPE);
        for (int i = 0; i < types.size(); ++i) {
            asm.load(tempSlot, InstructionAdapter.OBJECT_TYPE);
            asm.iconst(i);
            asm.aload(Type.LONG_TYPE);
            CompilerUtil.emitLongToJvm((MethodVisitor)asm, types.get(i));
        }
    }

    public static BytecodeEmitter intrinsify(CompilerOpCode opcode, Class<?> staticHelpers) {
        for (Method method : staticHelpers.getDeclaredMethods()) {
            if (!Modifier.isStatic(method.getModifiers()) || !method.isAnnotationPresent(OpCodeIdentifier.class) || method.getAnnotation(OpCodeIdentifier.class).value() != opcode.opcode()) continue;
            return (ctx, ins, asm) -> CompilerUtil.emitInvokeStatic((MethodVisitor)asm, method);
        }
        throw new IllegalArgumentException("Static helper " + staticHelpers.getName() + " does not provide an implementation of opcode " + opcode.name());
    }

    public static void THROW(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        int tagNumber = (int)ins.operand(0);
        FunctionType type = ctx.tagFunctionType(tagNumber);
        Emitters.emitBoxValuesOnStack(ctx, asm, type.params());
        asm.iconst(tagNumber);
        asm.load(ctx.instanceSlot(), InstructionAdapter.OBJECT_TYPE);
        CompilerUtil.emitInvokeStatic((MethodVisitor)asm, ShadedRefs.CREATE_WASM_EXCEPTION);
        asm.athrow();
    }

    public static void THROW_REF(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        asm.load(ctx.instanceSlot(), InstructionAdapter.OBJECT_TYPE);
        asm.swap();
        CompilerUtil.emitInvokeVirtual((MethodVisitor)asm, ShadedRefs.INSTANCE_GET_EXCEPTION);
        asm.athrow();
    }

    public static void CATCH_START(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        asm.store(ctx.tempSlot(), InstructionAdapter.OBJECT_TYPE);
    }

    public static void CATCH_END(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        asm.load(ctx.tempSlot(), InstructionAdapter.OBJECT_TYPE);
        asm.athrow();
    }

    public static void CATCH_UNBOX_PARAMS(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        int tag = (int)ins.operand(0);
        FunctionType tagFuncType = ctx.tagFunctionType(tag);
        if (!tagFuncType.params().isEmpty()) {
            asm.load(ctx.tempSlot(), InstructionAdapter.OBJECT_TYPE);
            asm.invokevirtual(Type.getInternalName(WasmException.class), "args", Type.getMethodDescriptor((Type)Type.getType(long[].class), (Type[])new Type[0]), false);
            Emitters.emitUnboxResult(asm, tagFuncType.params(), ctx.tempSlot() + 1);
        }
    }

    public static void CATCH_COMPARE_TAG(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        int tag = (int)ins.operand(0);
        asm.load(ctx.tempSlot(), InstructionAdapter.OBJECT_TYPE);
        asm.iconst(tag);
        asm.load(ctx.instanceSlot(), InstructionAdapter.OBJECT_TYPE);
        CompilerUtil.emitInvokeStatic((MethodVisitor)asm, ShadedRefs.EXCEPTION_MATCHES);
    }

    public static void CATCH_REGISTER_EXCEPTION(Context ctx, CompilerInstruction ins, InstructionAdapter asm) {
        asm.load(ctx.instanceSlot(), InstructionAdapter.OBJECT_TYPE);
        asm.load(ctx.tempSlot(), InstructionAdapter.OBJECT_TYPE);
        asm.invokevirtual(Type.getInternalName(Instance.class), "registerException", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[]{Type.getType(WasmException.class)}), false);
    }

    static class Builder {
        private final Map<CompilerOpCode, BytecodeEmitter> emitters = new EnumMap<CompilerOpCode, BytecodeEmitter>(CompilerOpCode.class);

        Builder() {
        }

        public Builder intrinsic(CompilerOpCode opCode, BytecodeEmitter emitter) {
            this.emitters.put(opCode, emitter);
            return this;
        }

        public Builder shared(CompilerOpCode opCode, Class<?> staticHelpers) {
            this.emitters.put(opCode, Emitters.intrinsify(opCode, staticHelpers));
            return this;
        }

        public Map<CompilerOpCode, BytecodeEmitter> build() {
            return Map.copyOf(this.emitters);
        }
    }

    @FunctionalInterface
    static interface BytecodeEmitter {
        public void emit(Context var1, CompilerInstruction var2, InstructionAdapter var3);
    }
}

