/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.model;

import com.dropbox.sign.ApiException;
import com.dropbox.sign.JSON;
import com.dropbox.sign.model.TemplateUpdateFilesResponseTemplate;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"template"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class TemplateUpdateFilesResponse {
    public static final String JSON_PROPERTY_TEMPLATE = "template";
    private TemplateUpdateFilesResponseTemplate template;

    public static TemplateUpdateFilesResponse init(String jsonData) throws Exception {
        return (TemplateUpdateFilesResponse)new ObjectMapper().readValue(jsonData, TemplateUpdateFilesResponse.class);
    }

    public static TemplateUpdateFilesResponse init(HashMap data) throws Exception {
        return (TemplateUpdateFilesResponse)new ObjectMapper().readValue(new ObjectMapper().writeValueAsString((Object)data), TemplateUpdateFilesResponse.class);
    }

    public TemplateUpdateFilesResponse template(TemplateUpdateFilesResponseTemplate template) {
        this.template = template;
        return this;
    }

    @Nonnull
    @JsonProperty(value="template")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TemplateUpdateFilesResponseTemplate getTemplate() {
        return this.template;
    }

    @JsonProperty(value="template")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTemplate(TemplateUpdateFilesResponseTemplate template) {
        this.template = template;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemplateUpdateFilesResponse templateUpdateFilesResponse = (TemplateUpdateFilesResponse)o;
        return Objects.equals(this.template, templateUpdateFilesResponse.template);
    }

    public int hashCode() {
        return Objects.hash(this.template);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TemplateUpdateFilesResponse {\n");
        sb.append("    template: ").append(this.toIndentedString(this.template)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public Map<String, Object> createFormData() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean fileTypeFound = false;
        try {
            if (this.template != null) {
                if (this.isFileTypeOrListOfFiles(this.template)) {
                    fileTypeFound = true;
                }
                if (this.template.getClass().equals(File.class) || this.template.getClass().equals(Integer.class) || this.template.getClass().equals(String.class) || this.template.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_TEMPLATE, this.template);
                } else if (this.isListOfFile(this.template)) {
                    for (int i = 0; i < this.getListSize(this.template); ++i) {
                        map.put("template[" + i + "]", this.getFromList(this.template, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_TEMPLATE, JSON.getDefault().getMapper().writeValueAsString((Object)this.template));
                }
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return fileTypeFound ? map : new HashMap<String, Object>();
    }

    private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
        return obj.getClass().equals(File.class) || this.isListOfFile(obj);
    }

    private boolean isListOfFile(Object obj) throws Exception {
        return obj instanceof List && !this.isListEmpty(obj) && this.getFromList(obj, 0) instanceof File;
    }

    private boolean isListEmpty(Object obj) throws Exception {
        return (Boolean)Class.forName(List.class.getName()).getMethod("isEmpty", new Class[0]).invoke(obj, new Object[0]);
    }

    private Object getFromList(Object obj, int index) throws Exception {
        return Class.forName(List.class.getName()).getMethod("get", Integer.TYPE).invoke(obj, index);
    }

    private int getListSize(Object obj) throws Exception {
        return (Integer)Class.forName(List.class.getName()).getMethod("size", new Class[0]).invoke(obj, new Object[0]);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

