/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.model;

import com.dropbox.sign.ApiException;
import com.dropbox.sign.JSON;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nullable;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"client_id", "files", "file_urls", "message", "subject", "test_mode"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class TemplateUpdateFilesRequest {
    public static final String JSON_PROPERTY_CLIENT_ID = "client_id";
    private String clientId;
    public static final String JSON_PROPERTY_FILES = "files";
    private List<File> files = null;
    public static final String JSON_PROPERTY_FILE_URLS = "file_urls";
    private List<String> fileUrls = null;
    public static final String JSON_PROPERTY_MESSAGE = "message";
    private String message;
    public static final String JSON_PROPERTY_SUBJECT = "subject";
    private String subject;
    public static final String JSON_PROPERTY_TEST_MODE = "test_mode";
    private Boolean testMode = false;

    public static TemplateUpdateFilesRequest init(String jsonData) throws Exception {
        return (TemplateUpdateFilesRequest)new ObjectMapper().readValue(jsonData, TemplateUpdateFilesRequest.class);
    }

    public static TemplateUpdateFilesRequest init(HashMap data) throws Exception {
        return (TemplateUpdateFilesRequest)new ObjectMapper().readValue(new ObjectMapper().writeValueAsString((Object)data), TemplateUpdateFilesRequest.class);
    }

    public TemplateUpdateFilesRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @JsonProperty(value="client_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getClientId() {
        return this.clientId;
    }

    @JsonProperty(value="client_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public TemplateUpdateFilesRequest files(List<File> files) {
        this.files = files;
        return this;
    }

    public TemplateUpdateFilesRequest addFilesItem(File filesItem) {
        if (this.files == null) {
            this.files = new ArrayList<File>();
        }
        this.files.add(filesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="files")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<File> getFiles() {
        return this.files;
    }

    @JsonProperty(value="files")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFiles(List<File> files) {
        this.files = files;
    }

    public TemplateUpdateFilesRequest fileUrls(List<String> fileUrls) {
        this.fileUrls = fileUrls;
        return this;
    }

    public TemplateUpdateFilesRequest addFileUrlsItem(String fileUrlsItem) {
        if (this.fileUrls == null) {
            this.fileUrls = new ArrayList<String>();
        }
        this.fileUrls.add(fileUrlsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="file_urls")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getFileUrls() {
        return this.fileUrls;
    }

    @JsonProperty(value="file_urls")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFileUrls(List<String> fileUrls) {
        this.fileUrls = fileUrls;
    }

    public TemplateUpdateFilesRequest message(String message) {
        this.message = message;
        return this;
    }

    @Nullable
    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMessage() {
        return this.message;
    }

    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMessage(String message) {
        this.message = message;
    }

    public TemplateUpdateFilesRequest subject(String subject) {
        this.subject = subject;
        return this;
    }

    @Nullable
    @JsonProperty(value="subject")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSubject() {
        return this.subject;
    }

    @JsonProperty(value="subject")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSubject(String subject) {
        this.subject = subject;
    }

    public TemplateUpdateFilesRequest testMode(Boolean testMode) {
        this.testMode = testMode;
        return this;
    }

    @Nullable
    @JsonProperty(value="test_mode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getTestMode() {
        return this.testMode;
    }

    @JsonProperty(value="test_mode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTestMode(Boolean testMode) {
        this.testMode = testMode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemplateUpdateFilesRequest templateUpdateFilesRequest = (TemplateUpdateFilesRequest)o;
        return Objects.equals(this.clientId, templateUpdateFilesRequest.clientId) && Objects.equals(this.files, templateUpdateFilesRequest.files) && Objects.equals(this.fileUrls, templateUpdateFilesRequest.fileUrls) && Objects.equals(this.message, templateUpdateFilesRequest.message) && Objects.equals(this.subject, templateUpdateFilesRequest.subject) && Objects.equals(this.testMode, templateUpdateFilesRequest.testMode);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.files, this.fileUrls, this.message, this.subject, this.testMode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TemplateUpdateFilesRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    files: ").append(this.toIndentedString(this.files)).append("\n");
        sb.append("    fileUrls: ").append(this.toIndentedString(this.fileUrls)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("    testMode: ").append(this.toIndentedString(this.testMode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public Map<String, Object> createFormData() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean fileTypeFound = false;
        try {
            int i;
            if (this.clientId != null) {
                if (this.isFileTypeOrListOfFiles(this.clientId)) {
                    fileTypeFound = true;
                }
                if (this.clientId.getClass().equals(File.class) || this.clientId.getClass().equals(Integer.class) || this.clientId.getClass().equals(String.class) || this.clientId.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_CLIENT_ID, this.clientId);
                } else if (this.isListOfFile(this.clientId)) {
                    for (i = 0; i < this.getListSize(this.clientId); ++i) {
                        map.put("client_id[" + i + "]", this.getFromList(this.clientId, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_CLIENT_ID, JSON.getDefault().getMapper().writeValueAsString((Object)this.clientId));
                }
            }
            if (this.files != null) {
                if (this.isFileTypeOrListOfFiles(this.files)) {
                    fileTypeFound = true;
                }
                if (this.files.getClass().equals(File.class) || this.files.getClass().equals(Integer.class) || this.files.getClass().equals(String.class) || this.files.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_FILES, this.files);
                } else if (this.isListOfFile(this.files)) {
                    for (i = 0; i < this.getListSize(this.files); ++i) {
                        map.put("files[" + i + "]", this.getFromList(this.files, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_FILES, JSON.getDefault().getMapper().writeValueAsString(this.files));
                }
            }
            if (this.fileUrls != null) {
                if (this.isFileTypeOrListOfFiles(this.fileUrls)) {
                    fileTypeFound = true;
                }
                if (this.fileUrls.getClass().equals(File.class) || this.fileUrls.getClass().equals(Integer.class) || this.fileUrls.getClass().equals(String.class) || this.fileUrls.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_FILE_URLS, this.fileUrls);
                } else if (this.isListOfFile(this.fileUrls)) {
                    for (i = 0; i < this.getListSize(this.fileUrls); ++i) {
                        map.put("file_urls[" + i + "]", this.getFromList(this.fileUrls, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_FILE_URLS, JSON.getDefault().getMapper().writeValueAsString(this.fileUrls));
                }
            }
            if (this.message != null) {
                if (this.isFileTypeOrListOfFiles(this.message)) {
                    fileTypeFound = true;
                }
                if (this.message.getClass().equals(File.class) || this.message.getClass().equals(Integer.class) || this.message.getClass().equals(String.class) || this.message.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_MESSAGE, this.message);
                } else if (this.isListOfFile(this.message)) {
                    for (i = 0; i < this.getListSize(this.message); ++i) {
                        map.put("message[" + i + "]", this.getFromList(this.message, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_MESSAGE, JSON.getDefault().getMapper().writeValueAsString((Object)this.message));
                }
            }
            if (this.subject != null) {
                if (this.isFileTypeOrListOfFiles(this.subject)) {
                    fileTypeFound = true;
                }
                if (this.subject.getClass().equals(File.class) || this.subject.getClass().equals(Integer.class) || this.subject.getClass().equals(String.class) || this.subject.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_SUBJECT, this.subject);
                } else if (this.isListOfFile(this.subject)) {
                    for (i = 0; i < this.getListSize(this.subject); ++i) {
                        map.put("subject[" + i + "]", this.getFromList(this.subject, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_SUBJECT, JSON.getDefault().getMapper().writeValueAsString((Object)this.subject));
                }
            }
            if (this.testMode != null) {
                if (this.isFileTypeOrListOfFiles(this.testMode)) {
                    fileTypeFound = true;
                }
                if (this.testMode.getClass().equals(File.class) || this.testMode.getClass().equals(Integer.class) || this.testMode.getClass().equals(String.class) || this.testMode.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_TEST_MODE, this.testMode);
                } else if (this.isListOfFile(this.testMode)) {
                    for (i = 0; i < this.getListSize(this.testMode); ++i) {
                        map.put("test_mode[" + i + "]", this.getFromList(this.testMode, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_TEST_MODE, JSON.getDefault().getMapper().writeValueAsString((Object)this.testMode));
                }
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return fileTypeFound ? map : new HashMap<String, Object>();
    }

    private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
        return obj.getClass().equals(File.class) || this.isListOfFile(obj);
    }

    private boolean isListOfFile(Object obj) throws Exception {
        return obj instanceof List && !this.isListEmpty(obj) && this.getFromList(obj, 0) instanceof File;
    }

    private boolean isListEmpty(Object obj) throws Exception {
        return (Boolean)Class.forName(List.class.getName()).getMethod("isEmpty", new Class[0]).invoke(obj, new Object[0]);
    }

    private Object getFromList(Object obj, int index) throws Exception {
        return Class.forName(List.class.getName()).getMethod("get", Integer.TYPE).invoke(obj, index);
    }

    private int getListSize(Object obj) throws Exception {
        return (Integer)Class.forName(List.class.getName()).getMethod("size", new Class[0]).invoke(obj, new Object[0]);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

