/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.model;

import com.dropbox.sign.ApiException;
import com.dropbox.sign.JSON;
import com.dropbox.sign.model.TemplateResponseDocumentCustomFieldBase;
import com.dropbox.sign.model.TemplateResponseDocumentFieldGroup;
import com.dropbox.sign.model.TemplateResponseDocumentFormFieldBase;
import com.dropbox.sign.model.TemplateResponseDocumentStaticFieldBase;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nullable;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"name", "index", "field_groups", "form_fields", "custom_fields", "static_fields"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class TemplateResponseDocument {
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_INDEX = "index";
    private Integer index;
    public static final String JSON_PROPERTY_FIELD_GROUPS = "field_groups";
    private List<TemplateResponseDocumentFieldGroup> fieldGroups = null;
    public static final String JSON_PROPERTY_FORM_FIELDS = "form_fields";
    private List<TemplateResponseDocumentFormFieldBase> formFields = null;
    public static final String JSON_PROPERTY_CUSTOM_FIELDS = "custom_fields";
    private List<TemplateResponseDocumentCustomFieldBase> customFields = null;
    public static final String JSON_PROPERTY_STATIC_FIELDS = "static_fields";
    private List<TemplateResponseDocumentStaticFieldBase> staticFields = null;

    public static TemplateResponseDocument init(String jsonData) throws Exception {
        return (TemplateResponseDocument)new ObjectMapper().readValue(jsonData, TemplateResponseDocument.class);
    }

    public static TemplateResponseDocument init(HashMap data) throws Exception {
        return (TemplateResponseDocument)new ObjectMapper().readValue(new ObjectMapper().writeValueAsString((Object)data), TemplateResponseDocument.class);
    }

    public TemplateResponseDocument name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public TemplateResponseDocument index(Integer index) {
        this.index = index;
        return this;
    }

    @Nullable
    @JsonProperty(value="index")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getIndex() {
        return this.index;
    }

    @JsonProperty(value="index")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIndex(Integer index) {
        this.index = index;
    }

    public TemplateResponseDocument fieldGroups(List<TemplateResponseDocumentFieldGroup> fieldGroups) {
        this.fieldGroups = fieldGroups;
        return this;
    }

    public TemplateResponseDocument addFieldGroupsItem(TemplateResponseDocumentFieldGroup fieldGroupsItem) {
        if (this.fieldGroups == null) {
            this.fieldGroups = new ArrayList<TemplateResponseDocumentFieldGroup>();
        }
        this.fieldGroups.add(fieldGroupsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="field_groups")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TemplateResponseDocumentFieldGroup> getFieldGroups() {
        return this.fieldGroups;
    }

    @JsonProperty(value="field_groups")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFieldGroups(List<TemplateResponseDocumentFieldGroup> fieldGroups) {
        this.fieldGroups = fieldGroups;
    }

    public TemplateResponseDocument formFields(List<TemplateResponseDocumentFormFieldBase> formFields) {
        this.formFields = formFields;
        return this;
    }

    public TemplateResponseDocument addFormFieldsItem(TemplateResponseDocumentFormFieldBase formFieldsItem) {
        if (this.formFields == null) {
            this.formFields = new ArrayList<TemplateResponseDocumentFormFieldBase>();
        }
        this.formFields.add(formFieldsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="form_fields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TemplateResponseDocumentFormFieldBase> getFormFields() {
        return this.formFields;
    }

    @JsonProperty(value="form_fields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFormFields(List<TemplateResponseDocumentFormFieldBase> formFields) {
        this.formFields = formFields;
    }

    public TemplateResponseDocument customFields(List<TemplateResponseDocumentCustomFieldBase> customFields) {
        this.customFields = customFields;
        return this;
    }

    public TemplateResponseDocument addCustomFieldsItem(TemplateResponseDocumentCustomFieldBase customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new ArrayList<TemplateResponseDocumentCustomFieldBase>();
        }
        this.customFields.add(customFieldsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="custom_fields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TemplateResponseDocumentCustomFieldBase> getCustomFields() {
        return this.customFields;
    }

    @JsonProperty(value="custom_fields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustomFields(List<TemplateResponseDocumentCustomFieldBase> customFields) {
        this.customFields = customFields;
    }

    public TemplateResponseDocument staticFields(List<TemplateResponseDocumentStaticFieldBase> staticFields) {
        this.staticFields = staticFields;
        return this;
    }

    public TemplateResponseDocument addStaticFieldsItem(TemplateResponseDocumentStaticFieldBase staticFieldsItem) {
        if (this.staticFields == null) {
            this.staticFields = new ArrayList<TemplateResponseDocumentStaticFieldBase>();
        }
        this.staticFields.add(staticFieldsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="static_fields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TemplateResponseDocumentStaticFieldBase> getStaticFields() {
        return this.staticFields;
    }

    @JsonProperty(value="static_fields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStaticFields(List<TemplateResponseDocumentStaticFieldBase> staticFields) {
        this.staticFields = staticFields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemplateResponseDocument templateResponseDocument = (TemplateResponseDocument)o;
        return Objects.equals(this.name, templateResponseDocument.name) && Objects.equals(this.index, templateResponseDocument.index) && Objects.equals(this.fieldGroups, templateResponseDocument.fieldGroups) && Objects.equals(this.formFields, templateResponseDocument.formFields) && Objects.equals(this.customFields, templateResponseDocument.customFields) && Objects.equals(this.staticFields, templateResponseDocument.staticFields);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.index, this.fieldGroups, this.formFields, this.customFields, this.staticFields);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TemplateResponseDocument {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    index: ").append(this.toIndentedString(this.index)).append("\n");
        sb.append("    fieldGroups: ").append(this.toIndentedString(this.fieldGroups)).append("\n");
        sb.append("    formFields: ").append(this.toIndentedString(this.formFields)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    staticFields: ").append(this.toIndentedString(this.staticFields)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public Map<String, Object> createFormData() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean fileTypeFound = false;
        try {
            int i;
            if (this.name != null) {
                if (this.isFileTypeOrListOfFiles(this.name)) {
                    fileTypeFound = true;
                }
                if (this.name.getClass().equals(File.class) || this.name.getClass().equals(Integer.class) || this.name.getClass().equals(String.class) || this.name.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_NAME, this.name);
                } else if (this.isListOfFile(this.name)) {
                    for (i = 0; i < this.getListSize(this.name); ++i) {
                        map.put("name[" + i + "]", this.getFromList(this.name, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_NAME, JSON.getDefault().getMapper().writeValueAsString((Object)this.name));
                }
            }
            if (this.index != null) {
                if (this.isFileTypeOrListOfFiles(this.index)) {
                    fileTypeFound = true;
                }
                if (this.index.getClass().equals(File.class) || this.index.getClass().equals(Integer.class) || this.index.getClass().equals(String.class) || this.index.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_INDEX, this.index);
                } else if (this.isListOfFile(this.index)) {
                    for (i = 0; i < this.getListSize(this.index); ++i) {
                        map.put("index[" + i + "]", this.getFromList(this.index, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_INDEX, JSON.getDefault().getMapper().writeValueAsString((Object)this.index));
                }
            }
            if (this.fieldGroups != null) {
                if (this.isFileTypeOrListOfFiles(this.fieldGroups)) {
                    fileTypeFound = true;
                }
                if (this.fieldGroups.getClass().equals(File.class) || this.fieldGroups.getClass().equals(Integer.class) || this.fieldGroups.getClass().equals(String.class) || this.fieldGroups.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_FIELD_GROUPS, this.fieldGroups);
                } else if (this.isListOfFile(this.fieldGroups)) {
                    for (i = 0; i < this.getListSize(this.fieldGroups); ++i) {
                        map.put("field_groups[" + i + "]", this.getFromList(this.fieldGroups, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_FIELD_GROUPS, JSON.getDefault().getMapper().writeValueAsString(this.fieldGroups));
                }
            }
            if (this.formFields != null) {
                if (this.isFileTypeOrListOfFiles(this.formFields)) {
                    fileTypeFound = true;
                }
                if (this.formFields.getClass().equals(File.class) || this.formFields.getClass().equals(Integer.class) || this.formFields.getClass().equals(String.class) || this.formFields.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_FORM_FIELDS, this.formFields);
                } else if (this.isListOfFile(this.formFields)) {
                    for (i = 0; i < this.getListSize(this.formFields); ++i) {
                        map.put("form_fields[" + i + "]", this.getFromList(this.formFields, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_FORM_FIELDS, JSON.getDefault().getMapper().writeValueAsString(this.formFields));
                }
            }
            if (this.customFields != null) {
                if (this.isFileTypeOrListOfFiles(this.customFields)) {
                    fileTypeFound = true;
                }
                if (this.customFields.getClass().equals(File.class) || this.customFields.getClass().equals(Integer.class) || this.customFields.getClass().equals(String.class) || this.customFields.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_CUSTOM_FIELDS, this.customFields);
                } else if (this.isListOfFile(this.customFields)) {
                    for (i = 0; i < this.getListSize(this.customFields); ++i) {
                        map.put("custom_fields[" + i + "]", this.getFromList(this.customFields, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_CUSTOM_FIELDS, JSON.getDefault().getMapper().writeValueAsString(this.customFields));
                }
            }
            if (this.staticFields != null) {
                if (this.isFileTypeOrListOfFiles(this.staticFields)) {
                    fileTypeFound = true;
                }
                if (this.staticFields.getClass().equals(File.class) || this.staticFields.getClass().equals(Integer.class) || this.staticFields.getClass().equals(String.class) || this.staticFields.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_STATIC_FIELDS, this.staticFields);
                } else if (this.isListOfFile(this.staticFields)) {
                    for (i = 0; i < this.getListSize(this.staticFields); ++i) {
                        map.put("static_fields[" + i + "]", this.getFromList(this.staticFields, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_STATIC_FIELDS, JSON.getDefault().getMapper().writeValueAsString(this.staticFields));
                }
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return fileTypeFound ? map : new HashMap<String, Object>();
    }

    private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
        return obj.getClass().equals(File.class) || this.isListOfFile(obj);
    }

    private boolean isListOfFile(Object obj) throws Exception {
        return obj instanceof List && !this.isListEmpty(obj) && this.getFromList(obj, 0) instanceof File;
    }

    private boolean isListEmpty(Object obj) throws Exception {
        return (Boolean)Class.forName(List.class.getName()).getMethod("isEmpty", new Class[0]).invoke(obj, new Object[0]);
    }

    private Object getFromList(Object obj, int index) throws Exception {
        return Class.forName(List.class.getName()).getMethod("get", Integer.TYPE).invoke(obj, index);
    }

    private int getListSize(Object obj) throws Exception {
        return (Integer)Class.forName(List.class.getName()).getMethod("size", new Class[0]).invoke(obj, new Object[0]);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

