/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.model;

import com.dropbox.sign.ApiException;
import com.dropbox.sign.JSON;
import com.dropbox.sign.model.TemplateResponseAccountQuota;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nullable;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"account_id", "email_address", "is_locked", "is_paid_hs", "is_paid_hf", "quotas"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class TemplateResponseAccount {
    public static final String JSON_PROPERTY_ACCOUNT_ID = "account_id";
    private String accountId;
    public static final String JSON_PROPERTY_EMAIL_ADDRESS = "email_address";
    private String emailAddress;
    public static final String JSON_PROPERTY_IS_LOCKED = "is_locked";
    private Boolean isLocked;
    public static final String JSON_PROPERTY_IS_PAID_HS = "is_paid_hs";
    private Boolean isPaidHs;
    public static final String JSON_PROPERTY_IS_PAID_HF = "is_paid_hf";
    private Boolean isPaidHf;
    public static final String JSON_PROPERTY_QUOTAS = "quotas";
    private TemplateResponseAccountQuota quotas;

    public static TemplateResponseAccount init(String jsonData) throws Exception {
        return (TemplateResponseAccount)new ObjectMapper().readValue(jsonData, TemplateResponseAccount.class);
    }

    public static TemplateResponseAccount init(HashMap data) throws Exception {
        return (TemplateResponseAccount)new ObjectMapper().readValue(new ObjectMapper().writeValueAsString((Object)data), TemplateResponseAccount.class);
    }

    public TemplateResponseAccount accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    @JsonProperty(value="account_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountId() {
        return this.accountId;
    }

    @JsonProperty(value="account_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public TemplateResponseAccount emailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
        return this;
    }

    @Nullable
    @JsonProperty(value="email_address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEmailAddress() {
        return this.emailAddress;
    }

    @JsonProperty(value="email_address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public TemplateResponseAccount isLocked(Boolean isLocked) {
        this.isLocked = isLocked;
        return this;
    }

    @Nullable
    @JsonProperty(value="is_locked")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsLocked() {
        return this.isLocked;
    }

    @JsonProperty(value="is_locked")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIsLocked(Boolean isLocked) {
        this.isLocked = isLocked;
    }

    public TemplateResponseAccount isPaidHs(Boolean isPaidHs) {
        this.isPaidHs = isPaidHs;
        return this;
    }

    @Nullable
    @JsonProperty(value="is_paid_hs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsPaidHs() {
        return this.isPaidHs;
    }

    @JsonProperty(value="is_paid_hs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIsPaidHs(Boolean isPaidHs) {
        this.isPaidHs = isPaidHs;
    }

    public TemplateResponseAccount isPaidHf(Boolean isPaidHf) {
        this.isPaidHf = isPaidHf;
        return this;
    }

    @Nullable
    @JsonProperty(value="is_paid_hf")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsPaidHf() {
        return this.isPaidHf;
    }

    @JsonProperty(value="is_paid_hf")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIsPaidHf(Boolean isPaidHf) {
        this.isPaidHf = isPaidHf;
    }

    public TemplateResponseAccount quotas(TemplateResponseAccountQuota quotas) {
        this.quotas = quotas;
        return this;
    }

    @Nullable
    @JsonProperty(value="quotas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TemplateResponseAccountQuota getQuotas() {
        return this.quotas;
    }

    @JsonProperty(value="quotas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setQuotas(TemplateResponseAccountQuota quotas) {
        this.quotas = quotas;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemplateResponseAccount templateResponseAccount = (TemplateResponseAccount)o;
        return Objects.equals(this.accountId, templateResponseAccount.accountId) && Objects.equals(this.emailAddress, templateResponseAccount.emailAddress) && Objects.equals(this.isLocked, templateResponseAccount.isLocked) && Objects.equals(this.isPaidHs, templateResponseAccount.isPaidHs) && Objects.equals(this.isPaidHf, templateResponseAccount.isPaidHf) && Objects.equals(this.quotas, templateResponseAccount.quotas);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.emailAddress, this.isLocked, this.isPaidHs, this.isPaidHf, this.quotas);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TemplateResponseAccount {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    emailAddress: ").append(this.toIndentedString(this.emailAddress)).append("\n");
        sb.append("    isLocked: ").append(this.toIndentedString(this.isLocked)).append("\n");
        sb.append("    isPaidHs: ").append(this.toIndentedString(this.isPaidHs)).append("\n");
        sb.append("    isPaidHf: ").append(this.toIndentedString(this.isPaidHf)).append("\n");
        sb.append("    quotas: ").append(this.toIndentedString(this.quotas)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public Map<String, Object> createFormData() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean fileTypeFound = false;
        try {
            int i;
            if (this.accountId != null) {
                if (this.isFileTypeOrListOfFiles(this.accountId)) {
                    fileTypeFound = true;
                }
                if (this.accountId.getClass().equals(File.class) || this.accountId.getClass().equals(Integer.class) || this.accountId.getClass().equals(String.class) || this.accountId.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_ACCOUNT_ID, this.accountId);
                } else if (this.isListOfFile(this.accountId)) {
                    for (i = 0; i < this.getListSize(this.accountId); ++i) {
                        map.put("account_id[" + i + "]", this.getFromList(this.accountId, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_ACCOUNT_ID, JSON.getDefault().getMapper().writeValueAsString((Object)this.accountId));
                }
            }
            if (this.emailAddress != null) {
                if (this.isFileTypeOrListOfFiles(this.emailAddress)) {
                    fileTypeFound = true;
                }
                if (this.emailAddress.getClass().equals(File.class) || this.emailAddress.getClass().equals(Integer.class) || this.emailAddress.getClass().equals(String.class) || this.emailAddress.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_EMAIL_ADDRESS, this.emailAddress);
                } else if (this.isListOfFile(this.emailAddress)) {
                    for (i = 0; i < this.getListSize(this.emailAddress); ++i) {
                        map.put("email_address[" + i + "]", this.getFromList(this.emailAddress, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_EMAIL_ADDRESS, JSON.getDefault().getMapper().writeValueAsString((Object)this.emailAddress));
                }
            }
            if (this.isLocked != null) {
                if (this.isFileTypeOrListOfFiles(this.isLocked)) {
                    fileTypeFound = true;
                }
                if (this.isLocked.getClass().equals(File.class) || this.isLocked.getClass().equals(Integer.class) || this.isLocked.getClass().equals(String.class) || this.isLocked.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_IS_LOCKED, this.isLocked);
                } else if (this.isListOfFile(this.isLocked)) {
                    for (i = 0; i < this.getListSize(this.isLocked); ++i) {
                        map.put("is_locked[" + i + "]", this.getFromList(this.isLocked, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_IS_LOCKED, JSON.getDefault().getMapper().writeValueAsString((Object)this.isLocked));
                }
            }
            if (this.isPaidHs != null) {
                if (this.isFileTypeOrListOfFiles(this.isPaidHs)) {
                    fileTypeFound = true;
                }
                if (this.isPaidHs.getClass().equals(File.class) || this.isPaidHs.getClass().equals(Integer.class) || this.isPaidHs.getClass().equals(String.class) || this.isPaidHs.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_IS_PAID_HS, this.isPaidHs);
                } else if (this.isListOfFile(this.isPaidHs)) {
                    for (i = 0; i < this.getListSize(this.isPaidHs); ++i) {
                        map.put("is_paid_hs[" + i + "]", this.getFromList(this.isPaidHs, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_IS_PAID_HS, JSON.getDefault().getMapper().writeValueAsString((Object)this.isPaidHs));
                }
            }
            if (this.isPaidHf != null) {
                if (this.isFileTypeOrListOfFiles(this.isPaidHf)) {
                    fileTypeFound = true;
                }
                if (this.isPaidHf.getClass().equals(File.class) || this.isPaidHf.getClass().equals(Integer.class) || this.isPaidHf.getClass().equals(String.class) || this.isPaidHf.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_IS_PAID_HF, this.isPaidHf);
                } else if (this.isListOfFile(this.isPaidHf)) {
                    for (i = 0; i < this.getListSize(this.isPaidHf); ++i) {
                        map.put("is_paid_hf[" + i + "]", this.getFromList(this.isPaidHf, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_IS_PAID_HF, JSON.getDefault().getMapper().writeValueAsString((Object)this.isPaidHf));
                }
            }
            if (this.quotas != null) {
                if (this.isFileTypeOrListOfFiles(this.quotas)) {
                    fileTypeFound = true;
                }
                if (this.quotas.getClass().equals(File.class) || this.quotas.getClass().equals(Integer.class) || this.quotas.getClass().equals(String.class) || this.quotas.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_QUOTAS, this.quotas);
                } else if (this.isListOfFile(this.quotas)) {
                    for (i = 0; i < this.getListSize(this.quotas); ++i) {
                        map.put("quotas[" + i + "]", this.getFromList(this.quotas, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_QUOTAS, JSON.getDefault().getMapper().writeValueAsString((Object)this.quotas));
                }
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return fileTypeFound ? map : new HashMap<String, Object>();
    }

    private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
        return obj.getClass().equals(File.class) || this.isListOfFile(obj);
    }

    private boolean isListOfFile(Object obj) throws Exception {
        return obj instanceof List && !this.isListEmpty(obj) && this.getFromList(obj, 0) instanceof File;
    }

    private boolean isListEmpty(Object obj) throws Exception {
        return (Boolean)Class.forName(List.class.getName()).getMethod("isEmpty", new Class[0]).invoke(obj, new Object[0]);
    }

    private Object getFromList(Object obj, int index) throws Exception {
        return Class.forName(List.class.getName()).getMethod("get", Integer.TYPE).invoke(obj, index);
    }

    private int getListSize(Object obj) throws Exception {
        return (Integer)Class.forName(List.class.getName()).getMethod("size", new Class[0]).invoke(obj, new Object[0]);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

