/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.model;

import com.dropbox.sign.ApiException;
import com.dropbox.sign.JSON;
import com.dropbox.sign.model.ListInfoResponse;
import com.dropbox.sign.model.TemplateResponse;
import com.dropbox.sign.model.WarningResponse;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"templates", "list_info", "warnings"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class TemplateListResponse {
    public static final String JSON_PROPERTY_TEMPLATES = "templates";
    private List<TemplateResponse> templates = new ArrayList<TemplateResponse>();
    public static final String JSON_PROPERTY_LIST_INFO = "list_info";
    private ListInfoResponse listInfo;
    public static final String JSON_PROPERTY_WARNINGS = "warnings";
    private List<WarningResponse> warnings = null;

    public static TemplateListResponse init(String jsonData) throws Exception {
        return (TemplateListResponse)new ObjectMapper().readValue(jsonData, TemplateListResponse.class);
    }

    public static TemplateListResponse init(HashMap data) throws Exception {
        return (TemplateListResponse)new ObjectMapper().readValue(new ObjectMapper().writeValueAsString((Object)data), TemplateListResponse.class);
    }

    public TemplateListResponse templates(List<TemplateResponse> templates) {
        this.templates = templates;
        return this;
    }

    public TemplateListResponse addTemplatesItem(TemplateResponse templatesItem) {
        if (this.templates == null) {
            this.templates = new ArrayList<TemplateResponse>();
        }
        this.templates.add(templatesItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="templates")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<TemplateResponse> getTemplates() {
        return this.templates;
    }

    @JsonProperty(value="templates")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTemplates(List<TemplateResponse> templates) {
        this.templates = templates;
    }

    public TemplateListResponse listInfo(ListInfoResponse listInfo) {
        this.listInfo = listInfo;
        return this;
    }

    @Nonnull
    @JsonProperty(value="list_info")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ListInfoResponse getListInfo() {
        return this.listInfo;
    }

    @JsonProperty(value="list_info")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setListInfo(ListInfoResponse listInfo) {
        this.listInfo = listInfo;
    }

    public TemplateListResponse warnings(List<WarningResponse> warnings) {
        this.warnings = warnings;
        return this;
    }

    public TemplateListResponse addWarningsItem(WarningResponse warningsItem) {
        if (this.warnings == null) {
            this.warnings = new ArrayList<WarningResponse>();
        }
        this.warnings.add(warningsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="warnings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<WarningResponse> getWarnings() {
        return this.warnings;
    }

    @JsonProperty(value="warnings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWarnings(List<WarningResponse> warnings) {
        this.warnings = warnings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemplateListResponse templateListResponse = (TemplateListResponse)o;
        return Objects.equals(this.templates, templateListResponse.templates) && Objects.equals(this.listInfo, templateListResponse.listInfo) && Objects.equals(this.warnings, templateListResponse.warnings);
    }

    public int hashCode() {
        return Objects.hash(this.templates, this.listInfo, this.warnings);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TemplateListResponse {\n");
        sb.append("    templates: ").append(this.toIndentedString(this.templates)).append("\n");
        sb.append("    listInfo: ").append(this.toIndentedString(this.listInfo)).append("\n");
        sb.append("    warnings: ").append(this.toIndentedString(this.warnings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public Map<String, Object> createFormData() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean fileTypeFound = false;
        try {
            int i;
            if (this.templates != null) {
                if (this.isFileTypeOrListOfFiles(this.templates)) {
                    fileTypeFound = true;
                }
                if (this.templates.getClass().equals(File.class) || this.templates.getClass().equals(Integer.class) || this.templates.getClass().equals(String.class) || this.templates.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_TEMPLATES, this.templates);
                } else if (this.isListOfFile(this.templates)) {
                    for (i = 0; i < this.getListSize(this.templates); ++i) {
                        map.put("templates[" + i + "]", this.getFromList(this.templates, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_TEMPLATES, JSON.getDefault().getMapper().writeValueAsString(this.templates));
                }
            }
            if (this.listInfo != null) {
                if (this.isFileTypeOrListOfFiles(this.listInfo)) {
                    fileTypeFound = true;
                }
                if (this.listInfo.getClass().equals(File.class) || this.listInfo.getClass().equals(Integer.class) || this.listInfo.getClass().equals(String.class) || this.listInfo.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_LIST_INFO, this.listInfo);
                } else if (this.isListOfFile(this.listInfo)) {
                    for (i = 0; i < this.getListSize(this.listInfo); ++i) {
                        map.put("list_info[" + i + "]", this.getFromList(this.listInfo, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_LIST_INFO, JSON.getDefault().getMapper().writeValueAsString((Object)this.listInfo));
                }
            }
            if (this.warnings != null) {
                if (this.isFileTypeOrListOfFiles(this.warnings)) {
                    fileTypeFound = true;
                }
                if (this.warnings.getClass().equals(File.class) || this.warnings.getClass().equals(Integer.class) || this.warnings.getClass().equals(String.class) || this.warnings.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_WARNINGS, this.warnings);
                } else if (this.isListOfFile(this.warnings)) {
                    for (i = 0; i < this.getListSize(this.warnings); ++i) {
                        map.put("warnings[" + i + "]", this.getFromList(this.warnings, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_WARNINGS, JSON.getDefault().getMapper().writeValueAsString(this.warnings));
                }
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return fileTypeFound ? map : new HashMap<String, Object>();
    }

    private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
        return obj.getClass().equals(File.class) || this.isListOfFile(obj);
    }

    private boolean isListOfFile(Object obj) throws Exception {
        return obj instanceof List && !this.isListEmpty(obj) && this.getFromList(obj, 0) instanceof File;
    }

    private boolean isListEmpty(Object obj) throws Exception {
        return (Boolean)Class.forName(List.class.getName()).getMethod("isEmpty", new Class[0]).invoke(obj, new Object[0]);
    }

    private Object getFromList(Object obj, int index) throws Exception {
        return Class.forName(List.class.getName()).getMethod("get", Integer.TYPE).invoke(obj, index);
    }

    private int getListSize(Object obj) throws Exception {
        return (Integer)Class.forName(List.class.getName()).getMethod("size", new Class[0]).invoke(obj, new Object[0]);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

