/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.model;

import com.dropbox.sign.ApiException;
import com.dropbox.sign.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nullable;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"account_id", "email_address", "new_owner_email_address", "new_team_id", "new_role"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class TeamRemoveMemberRequest {
    public static final String JSON_PROPERTY_ACCOUNT_ID = "account_id";
    private String accountId;
    public static final String JSON_PROPERTY_EMAIL_ADDRESS = "email_address";
    private String emailAddress;
    public static final String JSON_PROPERTY_NEW_OWNER_EMAIL_ADDRESS = "new_owner_email_address";
    private String newOwnerEmailAddress;
    public static final String JSON_PROPERTY_NEW_TEAM_ID = "new_team_id";
    private String newTeamId;
    public static final String JSON_PROPERTY_NEW_ROLE = "new_role";
    private NewRoleEnum newRole;

    public static TeamRemoveMemberRequest init(String jsonData) throws Exception {
        return (TeamRemoveMemberRequest)new ObjectMapper().readValue(jsonData, TeamRemoveMemberRequest.class);
    }

    public static TeamRemoveMemberRequest init(HashMap data) throws Exception {
        return (TeamRemoveMemberRequest)new ObjectMapper().readValue(new ObjectMapper().writeValueAsString((Object)data), TeamRemoveMemberRequest.class);
    }

    public TeamRemoveMemberRequest accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    @JsonProperty(value="account_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountId() {
        return this.accountId;
    }

    @JsonProperty(value="account_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public TeamRemoveMemberRequest emailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
        return this;
    }

    @Nullable
    @JsonProperty(value="email_address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEmailAddress() {
        return this.emailAddress;
    }

    @JsonProperty(value="email_address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public TeamRemoveMemberRequest newOwnerEmailAddress(String newOwnerEmailAddress) {
        this.newOwnerEmailAddress = newOwnerEmailAddress;
        return this;
    }

    @Nullable
    @JsonProperty(value="new_owner_email_address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNewOwnerEmailAddress() {
        return this.newOwnerEmailAddress;
    }

    @JsonProperty(value="new_owner_email_address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNewOwnerEmailAddress(String newOwnerEmailAddress) {
        this.newOwnerEmailAddress = newOwnerEmailAddress;
    }

    public TeamRemoveMemberRequest newTeamId(String newTeamId) {
        this.newTeamId = newTeamId;
        return this;
    }

    @Nullable
    @JsonProperty(value="new_team_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNewTeamId() {
        return this.newTeamId;
    }

    @JsonProperty(value="new_team_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNewTeamId(String newTeamId) {
        this.newTeamId = newTeamId;
    }

    public TeamRemoveMemberRequest newRole(NewRoleEnum newRole) {
        this.newRole = newRole;
        return this;
    }

    @Nullable
    @JsonProperty(value="new_role")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public NewRoleEnum getNewRole() {
        return this.newRole;
    }

    @JsonProperty(value="new_role")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNewRole(NewRoleEnum newRole) {
        this.newRole = newRole;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TeamRemoveMemberRequest teamRemoveMemberRequest = (TeamRemoveMemberRequest)o;
        return Objects.equals(this.accountId, teamRemoveMemberRequest.accountId) && Objects.equals(this.emailAddress, teamRemoveMemberRequest.emailAddress) && Objects.equals(this.newOwnerEmailAddress, teamRemoveMemberRequest.newOwnerEmailAddress) && Objects.equals(this.newTeamId, teamRemoveMemberRequest.newTeamId) && Objects.equals((Object)this.newRole, (Object)teamRemoveMemberRequest.newRole);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountId, this.emailAddress, this.newOwnerEmailAddress, this.newTeamId, this.newRole});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TeamRemoveMemberRequest {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    emailAddress: ").append(this.toIndentedString(this.emailAddress)).append("\n");
        sb.append("    newOwnerEmailAddress: ").append(this.toIndentedString(this.newOwnerEmailAddress)).append("\n");
        sb.append("    newTeamId: ").append(this.toIndentedString(this.newTeamId)).append("\n");
        sb.append("    newRole: ").append(this.toIndentedString((Object)this.newRole)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public Map<String, Object> createFormData() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean fileTypeFound = false;
        try {
            int i;
            if (this.accountId != null) {
                if (this.isFileTypeOrListOfFiles(this.accountId)) {
                    fileTypeFound = true;
                }
                if (this.accountId.getClass().equals(File.class) || this.accountId.getClass().equals(Integer.class) || this.accountId.getClass().equals(String.class) || this.accountId.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_ACCOUNT_ID, this.accountId);
                } else if (this.isListOfFile(this.accountId)) {
                    for (i = 0; i < this.getListSize(this.accountId); ++i) {
                        map.put("account_id[" + i + "]", this.getFromList(this.accountId, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_ACCOUNT_ID, JSON.getDefault().getMapper().writeValueAsString((Object)this.accountId));
                }
            }
            if (this.emailAddress != null) {
                if (this.isFileTypeOrListOfFiles(this.emailAddress)) {
                    fileTypeFound = true;
                }
                if (this.emailAddress.getClass().equals(File.class) || this.emailAddress.getClass().equals(Integer.class) || this.emailAddress.getClass().equals(String.class) || this.emailAddress.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_EMAIL_ADDRESS, this.emailAddress);
                } else if (this.isListOfFile(this.emailAddress)) {
                    for (i = 0; i < this.getListSize(this.emailAddress); ++i) {
                        map.put("email_address[" + i + "]", this.getFromList(this.emailAddress, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_EMAIL_ADDRESS, JSON.getDefault().getMapper().writeValueAsString((Object)this.emailAddress));
                }
            }
            if (this.newOwnerEmailAddress != null) {
                if (this.isFileTypeOrListOfFiles(this.newOwnerEmailAddress)) {
                    fileTypeFound = true;
                }
                if (this.newOwnerEmailAddress.getClass().equals(File.class) || this.newOwnerEmailAddress.getClass().equals(Integer.class) || this.newOwnerEmailAddress.getClass().equals(String.class) || this.newOwnerEmailAddress.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_NEW_OWNER_EMAIL_ADDRESS, this.newOwnerEmailAddress);
                } else if (this.isListOfFile(this.newOwnerEmailAddress)) {
                    for (i = 0; i < this.getListSize(this.newOwnerEmailAddress); ++i) {
                        map.put("new_owner_email_address[" + i + "]", this.getFromList(this.newOwnerEmailAddress, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_NEW_OWNER_EMAIL_ADDRESS, JSON.getDefault().getMapper().writeValueAsString((Object)this.newOwnerEmailAddress));
                }
            }
            if (this.newTeamId != null) {
                if (this.isFileTypeOrListOfFiles(this.newTeamId)) {
                    fileTypeFound = true;
                }
                if (this.newTeamId.getClass().equals(File.class) || this.newTeamId.getClass().equals(Integer.class) || this.newTeamId.getClass().equals(String.class) || this.newTeamId.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_NEW_TEAM_ID, this.newTeamId);
                } else if (this.isListOfFile(this.newTeamId)) {
                    for (i = 0; i < this.getListSize(this.newTeamId); ++i) {
                        map.put("new_team_id[" + i + "]", this.getFromList(this.newTeamId, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_NEW_TEAM_ID, JSON.getDefault().getMapper().writeValueAsString((Object)this.newTeamId));
                }
            }
            if (this.newRole != null) {
                if (this.isFileTypeOrListOfFiles((Object)this.newRole)) {
                    fileTypeFound = true;
                }
                if (((Object)((Object)this.newRole)).getClass().equals(File.class) || ((Object)((Object)this.newRole)).getClass().equals(Integer.class) || ((Object)((Object)this.newRole)).getClass().equals(String.class) || ((Object)((Object)this.newRole)).getClass().isEnum()) {
                    map.put(JSON_PROPERTY_NEW_ROLE, (Object)this.newRole);
                } else if (this.isListOfFile((Object)this.newRole)) {
                    for (i = 0; i < this.getListSize((Object)this.newRole); ++i) {
                        map.put("new_role[" + i + "]", this.getFromList((Object)this.newRole, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_NEW_ROLE, JSON.getDefault().getMapper().writeValueAsString((Object)this.newRole));
                }
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return fileTypeFound ? map : new HashMap<String, Object>();
    }

    private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
        return obj.getClass().equals(File.class) || this.isListOfFile(obj);
    }

    private boolean isListOfFile(Object obj) throws Exception {
        return obj instanceof List && !this.isListEmpty(obj) && this.getFromList(obj, 0) instanceof File;
    }

    private boolean isListEmpty(Object obj) throws Exception {
        return (Boolean)Class.forName(List.class.getName()).getMethod("isEmpty", new Class[0]).invoke(obj, new Object[0]);
    }

    private Object getFromList(Object obj, int index) throws Exception {
        return Class.forName(List.class.getName()).getMethod("get", Integer.TYPE).invoke(obj, index);
    }

    private int getListSize(Object obj) throws Exception {
        return (Integer)Class.forName(List.class.getName()).getMethod("size", new Class[0]).invoke(obj, new Object[0]);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum NewRoleEnum {
        MEMBER("Member"),
        DEVELOPER("Developer"),
        TEAM_MANAGER("Team Manager"),
        ADMIN("Admin");

        private String value;

        private NewRoleEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static NewRoleEnum fromValue(String value) {
            for (NewRoleEnum b : NewRoleEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

