/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.model;

import com.dropbox.sign.ApiException;
import com.dropbox.sign.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"role", "name", "email_address", "pin", "sms_phone_number", "sms_phone_number_type"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class SubSignatureRequestTemplateSigner {
    public static final String JSON_PROPERTY_ROLE = "role";
    private String role;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_EMAIL_ADDRESS = "email_address";
    private String emailAddress;
    public static final String JSON_PROPERTY_PIN = "pin";
    private String pin;
    public static final String JSON_PROPERTY_SMS_PHONE_NUMBER = "sms_phone_number";
    private String smsPhoneNumber;
    public static final String JSON_PROPERTY_SMS_PHONE_NUMBER_TYPE = "sms_phone_number_type";
    private SmsPhoneNumberTypeEnum smsPhoneNumberType;

    public static SubSignatureRequestTemplateSigner init(String jsonData) throws Exception {
        return (SubSignatureRequestTemplateSigner)new ObjectMapper().readValue(jsonData, SubSignatureRequestTemplateSigner.class);
    }

    public static SubSignatureRequestTemplateSigner init(HashMap data) throws Exception {
        return (SubSignatureRequestTemplateSigner)new ObjectMapper().readValue(new ObjectMapper().writeValueAsString((Object)data), SubSignatureRequestTemplateSigner.class);
    }

    public SubSignatureRequestTemplateSigner role(String role) {
        this.role = role;
        return this;
    }

    @Nonnull
    @JsonProperty(value="role")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRole() {
        return this.role;
    }

    @JsonProperty(value="role")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRole(String role) {
        this.role = role;
    }

    public SubSignatureRequestTemplateSigner name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public SubSignatureRequestTemplateSigner emailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
        return this;
    }

    @Nonnull
    @JsonProperty(value="email_address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getEmailAddress() {
        return this.emailAddress;
    }

    @JsonProperty(value="email_address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public SubSignatureRequestTemplateSigner pin(String pin) {
        this.pin = pin;
        return this;
    }

    @Nullable
    @JsonProperty(value="pin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPin() {
        return this.pin;
    }

    @JsonProperty(value="pin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPin(String pin) {
        this.pin = pin;
    }

    public SubSignatureRequestTemplateSigner smsPhoneNumber(String smsPhoneNumber) {
        this.smsPhoneNumber = smsPhoneNumber;
        return this;
    }

    @Nullable
    @JsonProperty(value="sms_phone_number")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSmsPhoneNumber() {
        return this.smsPhoneNumber;
    }

    @JsonProperty(value="sms_phone_number")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSmsPhoneNumber(String smsPhoneNumber) {
        this.smsPhoneNumber = smsPhoneNumber;
    }

    public SubSignatureRequestTemplateSigner smsPhoneNumberType(SmsPhoneNumberTypeEnum smsPhoneNumberType) {
        this.smsPhoneNumberType = smsPhoneNumberType;
        return this;
    }

    @Nullable
    @JsonProperty(value="sms_phone_number_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SmsPhoneNumberTypeEnum getSmsPhoneNumberType() {
        return this.smsPhoneNumberType;
    }

    @JsonProperty(value="sms_phone_number_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSmsPhoneNumberType(SmsPhoneNumberTypeEnum smsPhoneNumberType) {
        this.smsPhoneNumberType = smsPhoneNumberType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubSignatureRequestTemplateSigner subSignatureRequestTemplateSigner = (SubSignatureRequestTemplateSigner)o;
        return Objects.equals(this.role, subSignatureRequestTemplateSigner.role) && Objects.equals(this.name, subSignatureRequestTemplateSigner.name) && Objects.equals(this.emailAddress, subSignatureRequestTemplateSigner.emailAddress) && Objects.equals(this.pin, subSignatureRequestTemplateSigner.pin) && Objects.equals(this.smsPhoneNumber, subSignatureRequestTemplateSigner.smsPhoneNumber) && Objects.equals((Object)this.smsPhoneNumberType, (Object)subSignatureRequestTemplateSigner.smsPhoneNumberType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.role, this.name, this.emailAddress, this.pin, this.smsPhoneNumber, this.smsPhoneNumberType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubSignatureRequestTemplateSigner {\n");
        sb.append("    role: ").append(this.toIndentedString(this.role)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    emailAddress: ").append(this.toIndentedString(this.emailAddress)).append("\n");
        sb.append("    pin: ").append(this.toIndentedString(this.pin)).append("\n");
        sb.append("    smsPhoneNumber: ").append(this.toIndentedString(this.smsPhoneNumber)).append("\n");
        sb.append("    smsPhoneNumberType: ").append(this.toIndentedString((Object)this.smsPhoneNumberType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public Map<String, Object> createFormData() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean fileTypeFound = false;
        try {
            int i;
            if (this.role != null) {
                if (this.isFileTypeOrListOfFiles(this.role)) {
                    fileTypeFound = true;
                }
                if (this.role.getClass().equals(File.class) || this.role.getClass().equals(Integer.class) || this.role.getClass().equals(String.class) || this.role.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_ROLE, this.role);
                } else if (this.isListOfFile(this.role)) {
                    for (i = 0; i < this.getListSize(this.role); ++i) {
                        map.put("role[" + i + "]", this.getFromList(this.role, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_ROLE, JSON.getDefault().getMapper().writeValueAsString((Object)this.role));
                }
            }
            if (this.name != null) {
                if (this.isFileTypeOrListOfFiles(this.name)) {
                    fileTypeFound = true;
                }
                if (this.name.getClass().equals(File.class) || this.name.getClass().equals(Integer.class) || this.name.getClass().equals(String.class) || this.name.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_NAME, this.name);
                } else if (this.isListOfFile(this.name)) {
                    for (i = 0; i < this.getListSize(this.name); ++i) {
                        map.put("name[" + i + "]", this.getFromList(this.name, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_NAME, JSON.getDefault().getMapper().writeValueAsString((Object)this.name));
                }
            }
            if (this.emailAddress != null) {
                if (this.isFileTypeOrListOfFiles(this.emailAddress)) {
                    fileTypeFound = true;
                }
                if (this.emailAddress.getClass().equals(File.class) || this.emailAddress.getClass().equals(Integer.class) || this.emailAddress.getClass().equals(String.class) || this.emailAddress.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_EMAIL_ADDRESS, this.emailAddress);
                } else if (this.isListOfFile(this.emailAddress)) {
                    for (i = 0; i < this.getListSize(this.emailAddress); ++i) {
                        map.put("email_address[" + i + "]", this.getFromList(this.emailAddress, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_EMAIL_ADDRESS, JSON.getDefault().getMapper().writeValueAsString((Object)this.emailAddress));
                }
            }
            if (this.pin != null) {
                if (this.isFileTypeOrListOfFiles(this.pin)) {
                    fileTypeFound = true;
                }
                if (this.pin.getClass().equals(File.class) || this.pin.getClass().equals(Integer.class) || this.pin.getClass().equals(String.class) || this.pin.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_PIN, this.pin);
                } else if (this.isListOfFile(this.pin)) {
                    for (i = 0; i < this.getListSize(this.pin); ++i) {
                        map.put("pin[" + i + "]", this.getFromList(this.pin, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_PIN, JSON.getDefault().getMapper().writeValueAsString((Object)this.pin));
                }
            }
            if (this.smsPhoneNumber != null) {
                if (this.isFileTypeOrListOfFiles(this.smsPhoneNumber)) {
                    fileTypeFound = true;
                }
                if (this.smsPhoneNumber.getClass().equals(File.class) || this.smsPhoneNumber.getClass().equals(Integer.class) || this.smsPhoneNumber.getClass().equals(String.class) || this.smsPhoneNumber.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_SMS_PHONE_NUMBER, this.smsPhoneNumber);
                } else if (this.isListOfFile(this.smsPhoneNumber)) {
                    for (i = 0; i < this.getListSize(this.smsPhoneNumber); ++i) {
                        map.put("sms_phone_number[" + i + "]", this.getFromList(this.smsPhoneNumber, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_SMS_PHONE_NUMBER, JSON.getDefault().getMapper().writeValueAsString((Object)this.smsPhoneNumber));
                }
            }
            if (this.smsPhoneNumberType != null) {
                if (this.isFileTypeOrListOfFiles((Object)this.smsPhoneNumberType)) {
                    fileTypeFound = true;
                }
                if (((Object)((Object)this.smsPhoneNumberType)).getClass().equals(File.class) || ((Object)((Object)this.smsPhoneNumberType)).getClass().equals(Integer.class) || ((Object)((Object)this.smsPhoneNumberType)).getClass().equals(String.class) || ((Object)((Object)this.smsPhoneNumberType)).getClass().isEnum()) {
                    map.put(JSON_PROPERTY_SMS_PHONE_NUMBER_TYPE, (Object)this.smsPhoneNumberType);
                } else if (this.isListOfFile((Object)this.smsPhoneNumberType)) {
                    for (i = 0; i < this.getListSize((Object)this.smsPhoneNumberType); ++i) {
                        map.put("sms_phone_number_type[" + i + "]", this.getFromList((Object)this.smsPhoneNumberType, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_SMS_PHONE_NUMBER_TYPE, JSON.getDefault().getMapper().writeValueAsString((Object)this.smsPhoneNumberType));
                }
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return fileTypeFound ? map : new HashMap<String, Object>();
    }

    private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
        return obj.getClass().equals(File.class) || this.isListOfFile(obj);
    }

    private boolean isListOfFile(Object obj) throws Exception {
        return obj instanceof List && !this.isListEmpty(obj) && this.getFromList(obj, 0) instanceof File;
    }

    private boolean isListEmpty(Object obj) throws Exception {
        return (Boolean)Class.forName(List.class.getName()).getMethod("isEmpty", new Class[0]).invoke(obj, new Object[0]);
    }

    private Object getFromList(Object obj, int index) throws Exception {
        return Class.forName(List.class.getName()).getMethod("get", Integer.TYPE).invoke(obj, index);
    }

    private int getListSize(Object obj) throws Exception {
        return (Integer)Class.forName(List.class.getName()).getMethod("size", new Class[0]).invoke(obj, new Object[0]);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SmsPhoneNumberTypeEnum {
        AUTHENTICATION("authentication"),
        DELIVERY("delivery");

        private String value;

        private SmsPhoneNumberTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SmsPhoneNumberTypeEnum fromValue(String value) {
            for (SmsPhoneNumberTypeEnum b : SmsPhoneNumberTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

