/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.model;

import com.dropbox.sign.ApiException;
import com.dropbox.sign.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nullable;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"callback_url", "scopes"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class SubOAuth {
    public static final String JSON_PROPERTY_CALLBACK_URL = "callback_url";
    private String callbackUrl;
    public static final String JSON_PROPERTY_SCOPES = "scopes";
    private List<ScopesEnum> scopes = null;

    public static SubOAuth init(String jsonData) throws Exception {
        return (SubOAuth)new ObjectMapper().readValue(jsonData, SubOAuth.class);
    }

    public static SubOAuth init(HashMap data) throws Exception {
        return (SubOAuth)new ObjectMapper().readValue(new ObjectMapper().writeValueAsString((Object)data), SubOAuth.class);
    }

    public SubOAuth callbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    @Nullable
    @JsonProperty(value="callback_url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    @JsonProperty(value="callback_url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public SubOAuth scopes(List<ScopesEnum> scopes) {
        this.scopes = scopes;
        return this;
    }

    public SubOAuth addScopesItem(ScopesEnum scopesItem) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<ScopesEnum>();
        }
        this.scopes.add(scopesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="scopes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ScopesEnum> getScopes() {
        return this.scopes;
    }

    @JsonProperty(value="scopes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScopes(List<ScopesEnum> scopes) {
        this.scopes = scopes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubOAuth subOAuth = (SubOAuth)o;
        return Objects.equals(this.callbackUrl, subOAuth.callbackUrl) && Objects.equals(this.scopes, subOAuth.scopes);
    }

    public int hashCode() {
        return Objects.hash(this.callbackUrl, this.scopes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubOAuth {\n");
        sb.append("    callbackUrl: ").append(this.toIndentedString(this.callbackUrl)).append("\n");
        sb.append("    scopes: ").append(this.toIndentedString(this.scopes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public Map<String, Object> createFormData() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean fileTypeFound = false;
        try {
            int i;
            if (this.callbackUrl != null) {
                if (this.isFileTypeOrListOfFiles(this.callbackUrl)) {
                    fileTypeFound = true;
                }
                if (this.callbackUrl.getClass().equals(File.class) || this.callbackUrl.getClass().equals(Integer.class) || this.callbackUrl.getClass().equals(String.class) || this.callbackUrl.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_CALLBACK_URL, this.callbackUrl);
                } else if (this.isListOfFile(this.callbackUrl)) {
                    for (i = 0; i < this.getListSize(this.callbackUrl); ++i) {
                        map.put("callback_url[" + i + "]", this.getFromList(this.callbackUrl, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_CALLBACK_URL, JSON.getDefault().getMapper().writeValueAsString((Object)this.callbackUrl));
                }
            }
            if (this.scopes != null) {
                if (this.isFileTypeOrListOfFiles(this.scopes)) {
                    fileTypeFound = true;
                }
                if (this.scopes.getClass().equals(File.class) || this.scopes.getClass().equals(Integer.class) || this.scopes.getClass().equals(String.class) || this.scopes.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_SCOPES, this.scopes);
                } else if (this.isListOfFile(this.scopes)) {
                    for (i = 0; i < this.getListSize(this.scopes); ++i) {
                        map.put("scopes[" + i + "]", this.getFromList(this.scopes, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_SCOPES, JSON.getDefault().getMapper().writeValueAsString(this.scopes));
                }
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return fileTypeFound ? map : new HashMap<String, Object>();
    }

    private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
        return obj.getClass().equals(File.class) || this.isListOfFile(obj);
    }

    private boolean isListOfFile(Object obj) throws Exception {
        return obj instanceof List && !this.isListEmpty(obj) && this.getFromList(obj, 0) instanceof File;
    }

    private boolean isListEmpty(Object obj) throws Exception {
        return (Boolean)Class.forName(List.class.getName()).getMethod("isEmpty", new Class[0]).invoke(obj, new Object[0]);
    }

    private Object getFromList(Object obj, int index) throws Exception {
        return Class.forName(List.class.getName()).getMethod("get", Integer.TYPE).invoke(obj, index);
    }

    private int getListSize(Object obj) throws Exception {
        return (Integer)Class.forName(List.class.getName()).getMethod("size", new Class[0]).invoke(obj, new Object[0]);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ScopesEnum {
        REQUEST_SIGNATURE("request_signature"),
        BASIC_ACCOUNT_INFO("basic_account_info"),
        ACCOUNT_ACCESS("account_access"),
        SIGNATURE_REQUEST_ACCESS("signature_request_access"),
        TEMPLATE_ACCESS("template_access"),
        TEAM_ACCESS("team_access"),
        API_APP_ACCESS("api_app_access"),
        EMPTY("");

        private String value;

        private ScopesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ScopesEnum fromValue(String value) {
            for (ScopesEnum b : ScopesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

