/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.model;

import com.dropbox.sign.ApiException;
import com.dropbox.sign.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"id", "operator", "value", "values"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class SubFormFieldRuleTrigger {
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_OPERATOR = "operator";
    private OperatorEnum operator;
    public static final String JSON_PROPERTY_VALUE = "value";
    private String value;
    public static final String JSON_PROPERTY_VALUES = "values";
    private List<String> values = null;

    public static SubFormFieldRuleTrigger init(String jsonData) throws Exception {
        return (SubFormFieldRuleTrigger)new ObjectMapper().readValue(jsonData, SubFormFieldRuleTrigger.class);
    }

    public static SubFormFieldRuleTrigger init(HashMap data) throws Exception {
        return (SubFormFieldRuleTrigger)new ObjectMapper().readValue(new ObjectMapper().writeValueAsString((Object)data), SubFormFieldRuleTrigger.class);
    }

    public SubFormFieldRuleTrigger id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(String id) {
        this.id = id;
    }

    public SubFormFieldRuleTrigger operator(OperatorEnum operator) {
        this.operator = operator;
        return this;
    }

    @Nonnull
    @JsonProperty(value="operator")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OperatorEnum getOperator() {
        return this.operator;
    }

    @JsonProperty(value="operator")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOperator(OperatorEnum operator) {
        this.operator = operator;
    }

    public SubFormFieldRuleTrigger value(String value) {
        this.value = value;
        return this;
    }

    @Nullable
    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getValue() {
        return this.value;
    }

    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setValue(String value) {
        this.value = value;
    }

    public SubFormFieldRuleTrigger values(List<String> values) {
        this.values = values;
        return this;
    }

    public SubFormFieldRuleTrigger addValuesItem(String valuesItem) {
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        this.values.add(valuesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="values")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getValues() {
        return this.values;
    }

    @JsonProperty(value="values")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setValues(List<String> values) {
        this.values = values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubFormFieldRuleTrigger subFormFieldRuleTrigger = (SubFormFieldRuleTrigger)o;
        return Objects.equals(this.id, subFormFieldRuleTrigger.id) && Objects.equals((Object)this.operator, (Object)subFormFieldRuleTrigger.operator) && Objects.equals(this.value, subFormFieldRuleTrigger.value) && Objects.equals(this.values, subFormFieldRuleTrigger.values);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.operator, this.value, this.values});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubFormFieldRuleTrigger {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    operator: ").append(this.toIndentedString((Object)this.operator)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    values: ").append(this.toIndentedString(this.values)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public Map<String, Object> createFormData() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean fileTypeFound = false;
        try {
            int i;
            if (this.id != null) {
                if (this.isFileTypeOrListOfFiles(this.id)) {
                    fileTypeFound = true;
                }
                if (this.id.getClass().equals(File.class) || this.id.getClass().equals(Integer.class) || this.id.getClass().equals(String.class) || this.id.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_ID, this.id);
                } else if (this.isListOfFile(this.id)) {
                    for (i = 0; i < this.getListSize(this.id); ++i) {
                        map.put("id[" + i + "]", this.getFromList(this.id, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_ID, JSON.getDefault().getMapper().writeValueAsString((Object)this.id));
                }
            }
            if (this.operator != null) {
                if (this.isFileTypeOrListOfFiles((Object)this.operator)) {
                    fileTypeFound = true;
                }
                if (((Object)((Object)this.operator)).getClass().equals(File.class) || ((Object)((Object)this.operator)).getClass().equals(Integer.class) || ((Object)((Object)this.operator)).getClass().equals(String.class) || ((Object)((Object)this.operator)).getClass().isEnum()) {
                    map.put(JSON_PROPERTY_OPERATOR, (Object)this.operator);
                } else if (this.isListOfFile((Object)this.operator)) {
                    for (i = 0; i < this.getListSize((Object)this.operator); ++i) {
                        map.put("operator[" + i + "]", this.getFromList((Object)this.operator, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_OPERATOR, JSON.getDefault().getMapper().writeValueAsString((Object)this.operator));
                }
            }
            if (this.value != null) {
                if (this.isFileTypeOrListOfFiles(this.value)) {
                    fileTypeFound = true;
                }
                if (this.value.getClass().equals(File.class) || this.value.getClass().equals(Integer.class) || this.value.getClass().equals(String.class) || this.value.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_VALUE, this.value);
                } else if (this.isListOfFile(this.value)) {
                    for (i = 0; i < this.getListSize(this.value); ++i) {
                        map.put("value[" + i + "]", this.getFromList(this.value, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_VALUE, JSON.getDefault().getMapper().writeValueAsString((Object)this.value));
                }
            }
            if (this.values != null) {
                if (this.isFileTypeOrListOfFiles(this.values)) {
                    fileTypeFound = true;
                }
                if (this.values.getClass().equals(File.class) || this.values.getClass().equals(Integer.class) || this.values.getClass().equals(String.class) || this.values.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_VALUES, this.values);
                } else if (this.isListOfFile(this.values)) {
                    for (i = 0; i < this.getListSize(this.values); ++i) {
                        map.put("values[" + i + "]", this.getFromList(this.values, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_VALUES, JSON.getDefault().getMapper().writeValueAsString(this.values));
                }
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return fileTypeFound ? map : new HashMap<String, Object>();
    }

    private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
        return obj.getClass().equals(File.class) || this.isListOfFile(obj);
    }

    private boolean isListOfFile(Object obj) throws Exception {
        return obj instanceof List && !this.isListEmpty(obj) && this.getFromList(obj, 0) instanceof File;
    }

    private boolean isListEmpty(Object obj) throws Exception {
        return (Boolean)Class.forName(List.class.getName()).getMethod("isEmpty", new Class[0]).invoke(obj, new Object[0]);
    }

    private Object getFromList(Object obj, int index) throws Exception {
        return Class.forName(List.class.getName()).getMethod("get", Integer.TYPE).invoke(obj, index);
    }

    private int getListSize(Object obj) throws Exception {
        return (Integer)Class.forName(List.class.getName()).getMethod("size", new Class[0]).invoke(obj, new Object[0]);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum OperatorEnum {
        ANY("any"),
        IS("is"),
        MATCH("match"),
        NONE("none"),
        NOT("not");

        private String value;

        private OperatorEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OperatorEnum fromValue(String value) {
            for (OperatorEnum b : OperatorEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

