/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.model;

import com.dropbox.sign.ApiException;
import com.dropbox.sign.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"hidden", "type", "field_id", "group_id"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class SubFormFieldRuleAction {
    public static final String JSON_PROPERTY_HIDDEN = "hidden";
    private Boolean hidden;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_FIELD_ID = "field_id";
    private String fieldId;
    public static final String JSON_PROPERTY_GROUP_ID = "group_id";
    private String groupId;

    public static SubFormFieldRuleAction init(String jsonData) throws Exception {
        return (SubFormFieldRuleAction)new ObjectMapper().readValue(jsonData, SubFormFieldRuleAction.class);
    }

    public static SubFormFieldRuleAction init(HashMap data) throws Exception {
        return (SubFormFieldRuleAction)new ObjectMapper().readValue(new ObjectMapper().writeValueAsString((Object)data), SubFormFieldRuleAction.class);
    }

    public SubFormFieldRuleAction hidden(Boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    @Nonnull
    @JsonProperty(value="hidden")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getHidden() {
        return this.hidden;
    }

    @JsonProperty(value="hidden")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public SubFormFieldRuleAction type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public SubFormFieldRuleAction fieldId(String fieldId) {
        this.fieldId = fieldId;
        return this;
    }

    @Nullable
    @JsonProperty(value="field_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFieldId() {
        return this.fieldId;
    }

    @JsonProperty(value="field_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFieldId(String fieldId) {
        this.fieldId = fieldId;
    }

    public SubFormFieldRuleAction groupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    @Nullable
    @JsonProperty(value="group_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGroupId() {
        return this.groupId;
    }

    @JsonProperty(value="group_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubFormFieldRuleAction subFormFieldRuleAction = (SubFormFieldRuleAction)o;
        return Objects.equals(this.hidden, subFormFieldRuleAction.hidden) && Objects.equals((Object)this.type, (Object)subFormFieldRuleAction.type) && Objects.equals(this.fieldId, subFormFieldRuleAction.fieldId) && Objects.equals(this.groupId, subFormFieldRuleAction.groupId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.hidden, this.type, this.fieldId, this.groupId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubFormFieldRuleAction {\n");
        sb.append("    hidden: ").append(this.toIndentedString(this.hidden)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    fieldId: ").append(this.toIndentedString(this.fieldId)).append("\n");
        sb.append("    groupId: ").append(this.toIndentedString(this.groupId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public Map<String, Object> createFormData() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean fileTypeFound = false;
        try {
            int i;
            if (this.hidden != null) {
                if (this.isFileTypeOrListOfFiles(this.hidden)) {
                    fileTypeFound = true;
                }
                if (this.hidden.getClass().equals(File.class) || this.hidden.getClass().equals(Integer.class) || this.hidden.getClass().equals(String.class) || this.hidden.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_HIDDEN, this.hidden);
                } else if (this.isListOfFile(this.hidden)) {
                    for (i = 0; i < this.getListSize(this.hidden); ++i) {
                        map.put("hidden[" + i + "]", this.getFromList(this.hidden, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_HIDDEN, JSON.getDefault().getMapper().writeValueAsString((Object)this.hidden));
                }
            }
            if (this.type != null) {
                if (this.isFileTypeOrListOfFiles((Object)this.type)) {
                    fileTypeFound = true;
                }
                if (((Object)((Object)this.type)).getClass().equals(File.class) || ((Object)((Object)this.type)).getClass().equals(Integer.class) || ((Object)((Object)this.type)).getClass().equals(String.class) || ((Object)((Object)this.type)).getClass().isEnum()) {
                    map.put(JSON_PROPERTY_TYPE, (Object)this.type);
                } else if (this.isListOfFile((Object)this.type)) {
                    for (i = 0; i < this.getListSize((Object)this.type); ++i) {
                        map.put("type[" + i + "]", this.getFromList((Object)this.type, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_TYPE, JSON.getDefault().getMapper().writeValueAsString((Object)this.type));
                }
            }
            if (this.fieldId != null) {
                if (this.isFileTypeOrListOfFiles(this.fieldId)) {
                    fileTypeFound = true;
                }
                if (this.fieldId.getClass().equals(File.class) || this.fieldId.getClass().equals(Integer.class) || this.fieldId.getClass().equals(String.class) || this.fieldId.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_FIELD_ID, this.fieldId);
                } else if (this.isListOfFile(this.fieldId)) {
                    for (i = 0; i < this.getListSize(this.fieldId); ++i) {
                        map.put("field_id[" + i + "]", this.getFromList(this.fieldId, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_FIELD_ID, JSON.getDefault().getMapper().writeValueAsString((Object)this.fieldId));
                }
            }
            if (this.groupId != null) {
                if (this.isFileTypeOrListOfFiles(this.groupId)) {
                    fileTypeFound = true;
                }
                if (this.groupId.getClass().equals(File.class) || this.groupId.getClass().equals(Integer.class) || this.groupId.getClass().equals(String.class) || this.groupId.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_GROUP_ID, this.groupId);
                } else if (this.isListOfFile(this.groupId)) {
                    for (i = 0; i < this.getListSize(this.groupId); ++i) {
                        map.put("group_id[" + i + "]", this.getFromList(this.groupId, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_GROUP_ID, JSON.getDefault().getMapper().writeValueAsString((Object)this.groupId));
                }
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return fileTypeFound ? map : new HashMap<String, Object>();
    }

    private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
        return obj.getClass().equals(File.class) || this.isListOfFile(obj);
    }

    private boolean isListOfFile(Object obj) throws Exception {
        return obj instanceof List && !this.isListEmpty(obj) && this.getFromList(obj, 0) instanceof File;
    }

    private boolean isListEmpty(Object obj) throws Exception {
        return (Boolean)Class.forName(List.class.getName()).getMethod("isEmpty", new Class[0]).invoke(obj, new Object[0]);
    }

    private Object getFromList(Object obj, int index) throws Exception {
        return Class.forName(List.class.getName()).getMethod("get", Integer.TYPE).invoke(obj, index);
    }

    private int getListSize(Object obj) throws Exception {
        return (Integer)Class.forName(List.class.getName()).getMethod("size", new Class[0]).invoke(obj, new Object[0]);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        FIELD_VISIBILITY("change-field-visibility"),
        GROUP_VISIBILITY("change-group-visibility");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

