/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.model;

import com.dropbox.sign.ApiException;
import com.dropbox.sign.JSON;
import com.dropbox.sign.model.SubFormFieldRuleAction;
import com.dropbox.sign.model.SubFormFieldRuleTrigger;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"id", "trigger_operator", "triggers", "actions"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class SubFormFieldRule {
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_TRIGGER_OPERATOR = "trigger_operator";
    private String triggerOperator = "AND";
    public static final String JSON_PROPERTY_TRIGGERS = "triggers";
    private List<SubFormFieldRuleTrigger> triggers = new ArrayList<SubFormFieldRuleTrigger>();
    public static final String JSON_PROPERTY_ACTIONS = "actions";
    private List<SubFormFieldRuleAction> actions = new ArrayList<SubFormFieldRuleAction>();

    public static SubFormFieldRule init(String jsonData) throws Exception {
        return (SubFormFieldRule)new ObjectMapper().readValue(jsonData, SubFormFieldRule.class);
    }

    public static SubFormFieldRule init(HashMap data) throws Exception {
        return (SubFormFieldRule)new ObjectMapper().readValue(new ObjectMapper().writeValueAsString((Object)data), SubFormFieldRule.class);
    }

    public SubFormFieldRule id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(String id) {
        this.id = id;
    }

    public SubFormFieldRule triggerOperator(String triggerOperator) {
        this.triggerOperator = triggerOperator;
        return this;
    }

    @Nonnull
    @JsonProperty(value="trigger_operator")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTriggerOperator() {
        return this.triggerOperator;
    }

    @JsonProperty(value="trigger_operator")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTriggerOperator(String triggerOperator) {
        this.triggerOperator = triggerOperator;
    }

    public SubFormFieldRule triggers(List<SubFormFieldRuleTrigger> triggers) {
        this.triggers = triggers;
        return this;
    }

    public SubFormFieldRule addTriggersItem(SubFormFieldRuleTrigger triggersItem) {
        if (this.triggers == null) {
            this.triggers = new ArrayList<SubFormFieldRuleTrigger>();
        }
        this.triggers.add(triggersItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="triggers")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<SubFormFieldRuleTrigger> getTriggers() {
        return this.triggers;
    }

    @JsonProperty(value="triggers")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTriggers(List<SubFormFieldRuleTrigger> triggers) {
        this.triggers = triggers;
    }

    public SubFormFieldRule actions(List<SubFormFieldRuleAction> actions) {
        this.actions = actions;
        return this;
    }

    public SubFormFieldRule addActionsItem(SubFormFieldRuleAction actionsItem) {
        if (this.actions == null) {
            this.actions = new ArrayList<SubFormFieldRuleAction>();
        }
        this.actions.add(actionsItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="actions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<SubFormFieldRuleAction> getActions() {
        return this.actions;
    }

    @JsonProperty(value="actions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setActions(List<SubFormFieldRuleAction> actions) {
        this.actions = actions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubFormFieldRule subFormFieldRule = (SubFormFieldRule)o;
        return Objects.equals(this.id, subFormFieldRule.id) && Objects.equals(this.triggerOperator, subFormFieldRule.triggerOperator) && Objects.equals(this.triggers, subFormFieldRule.triggers) && Objects.equals(this.actions, subFormFieldRule.actions);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.triggerOperator, this.triggers, this.actions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubFormFieldRule {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    triggerOperator: ").append(this.toIndentedString(this.triggerOperator)).append("\n");
        sb.append("    triggers: ").append(this.toIndentedString(this.triggers)).append("\n");
        sb.append("    actions: ").append(this.toIndentedString(this.actions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public Map<String, Object> createFormData() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean fileTypeFound = false;
        try {
            int i;
            if (this.id != null) {
                if (this.isFileTypeOrListOfFiles(this.id)) {
                    fileTypeFound = true;
                }
                if (this.id.getClass().equals(File.class) || this.id.getClass().equals(Integer.class) || this.id.getClass().equals(String.class) || this.id.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_ID, this.id);
                } else if (this.isListOfFile(this.id)) {
                    for (i = 0; i < this.getListSize(this.id); ++i) {
                        map.put("id[" + i + "]", this.getFromList(this.id, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_ID, JSON.getDefault().getMapper().writeValueAsString((Object)this.id));
                }
            }
            if (this.triggerOperator != null) {
                if (this.isFileTypeOrListOfFiles(this.triggerOperator)) {
                    fileTypeFound = true;
                }
                if (this.triggerOperator.getClass().equals(File.class) || this.triggerOperator.getClass().equals(Integer.class) || this.triggerOperator.getClass().equals(String.class) || this.triggerOperator.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_TRIGGER_OPERATOR, this.triggerOperator);
                } else if (this.isListOfFile(this.triggerOperator)) {
                    for (i = 0; i < this.getListSize(this.triggerOperator); ++i) {
                        map.put("trigger_operator[" + i + "]", this.getFromList(this.triggerOperator, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_TRIGGER_OPERATOR, JSON.getDefault().getMapper().writeValueAsString((Object)this.triggerOperator));
                }
            }
            if (this.triggers != null) {
                if (this.isFileTypeOrListOfFiles(this.triggers)) {
                    fileTypeFound = true;
                }
                if (this.triggers.getClass().equals(File.class) || this.triggers.getClass().equals(Integer.class) || this.triggers.getClass().equals(String.class) || this.triggers.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_TRIGGERS, this.triggers);
                } else if (this.isListOfFile(this.triggers)) {
                    for (i = 0; i < this.getListSize(this.triggers); ++i) {
                        map.put("triggers[" + i + "]", this.getFromList(this.triggers, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_TRIGGERS, JSON.getDefault().getMapper().writeValueAsString(this.triggers));
                }
            }
            if (this.actions != null) {
                if (this.isFileTypeOrListOfFiles(this.actions)) {
                    fileTypeFound = true;
                }
                if (this.actions.getClass().equals(File.class) || this.actions.getClass().equals(Integer.class) || this.actions.getClass().equals(String.class) || this.actions.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_ACTIONS, this.actions);
                } else if (this.isListOfFile(this.actions)) {
                    for (i = 0; i < this.getListSize(this.actions); ++i) {
                        map.put("actions[" + i + "]", this.getFromList(this.actions, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_ACTIONS, JSON.getDefault().getMapper().writeValueAsString(this.actions));
                }
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return fileTypeFound ? map : new HashMap<String, Object>();
    }

    private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
        return obj.getClass().equals(File.class) || this.isListOfFile(obj);
    }

    private boolean isListOfFile(Object obj) throws Exception {
        return obj instanceof List && !this.isListEmpty(obj) && this.getFromList(obj, 0) instanceof File;
    }

    private boolean isListEmpty(Object obj) throws Exception {
        return (Boolean)Class.forName(List.class.getName()).getMethod("isEmpty", new Class[0]).invoke(obj, new Object[0]);
    }

    private Object getFromList(Object obj, int index) throws Exception {
        return Class.forName(List.class.getName()).getMethod("get", Integer.TYPE).invoke(obj, index);
    }

    private int getListSize(Object obj) throws Exception {
        return (Integer)Class.forName(List.class.getName()).getMethod("size", new Class[0]).invoke(obj, new Object[0]);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

