/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.model;

import com.dropbox.sign.ApiException;
import com.dropbox.sign.JSON;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"group_id", "group_label", "requirement"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class SubFormFieldGroup {
    public static final String JSON_PROPERTY_GROUP_ID = "group_id";
    private String groupId;
    public static final String JSON_PROPERTY_GROUP_LABEL = "group_label";
    private String groupLabel;
    public static final String JSON_PROPERTY_REQUIREMENT = "requirement";
    private String requirement;

    public static SubFormFieldGroup init(String jsonData) throws Exception {
        return (SubFormFieldGroup)new ObjectMapper().readValue(jsonData, SubFormFieldGroup.class);
    }

    public static SubFormFieldGroup init(HashMap data) throws Exception {
        return (SubFormFieldGroup)new ObjectMapper().readValue(new ObjectMapper().writeValueAsString((Object)data), SubFormFieldGroup.class);
    }

    public SubFormFieldGroup groupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="group_id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getGroupId() {
        return this.groupId;
    }

    @JsonProperty(value="group_id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public SubFormFieldGroup groupLabel(String groupLabel) {
        this.groupLabel = groupLabel;
        return this;
    }

    @Nonnull
    @JsonProperty(value="group_label")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getGroupLabel() {
        return this.groupLabel;
    }

    @JsonProperty(value="group_label")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setGroupLabel(String groupLabel) {
        this.groupLabel = groupLabel;
    }

    public SubFormFieldGroup requirement(String requirement) {
        this.requirement = requirement;
        return this;
    }

    @Nonnull
    @JsonProperty(value="requirement")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRequirement() {
        return this.requirement;
    }

    @JsonProperty(value="requirement")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRequirement(String requirement) {
        this.requirement = requirement;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubFormFieldGroup subFormFieldGroup = (SubFormFieldGroup)o;
        return Objects.equals(this.groupId, subFormFieldGroup.groupId) && Objects.equals(this.groupLabel, subFormFieldGroup.groupLabel) && Objects.equals(this.requirement, subFormFieldGroup.requirement);
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.groupLabel, this.requirement);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubFormFieldGroup {\n");
        sb.append("    groupId: ").append(this.toIndentedString(this.groupId)).append("\n");
        sb.append("    groupLabel: ").append(this.toIndentedString(this.groupLabel)).append("\n");
        sb.append("    requirement: ").append(this.toIndentedString(this.requirement)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public Map<String, Object> createFormData() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean fileTypeFound = false;
        try {
            int i;
            if (this.groupId != null) {
                if (this.isFileTypeOrListOfFiles(this.groupId)) {
                    fileTypeFound = true;
                }
                if (this.groupId.getClass().equals(File.class) || this.groupId.getClass().equals(Integer.class) || this.groupId.getClass().equals(String.class) || this.groupId.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_GROUP_ID, this.groupId);
                } else if (this.isListOfFile(this.groupId)) {
                    for (i = 0; i < this.getListSize(this.groupId); ++i) {
                        map.put("group_id[" + i + "]", this.getFromList(this.groupId, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_GROUP_ID, JSON.getDefault().getMapper().writeValueAsString((Object)this.groupId));
                }
            }
            if (this.groupLabel != null) {
                if (this.isFileTypeOrListOfFiles(this.groupLabel)) {
                    fileTypeFound = true;
                }
                if (this.groupLabel.getClass().equals(File.class) || this.groupLabel.getClass().equals(Integer.class) || this.groupLabel.getClass().equals(String.class) || this.groupLabel.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_GROUP_LABEL, this.groupLabel);
                } else if (this.isListOfFile(this.groupLabel)) {
                    for (i = 0; i < this.getListSize(this.groupLabel); ++i) {
                        map.put("group_label[" + i + "]", this.getFromList(this.groupLabel, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_GROUP_LABEL, JSON.getDefault().getMapper().writeValueAsString((Object)this.groupLabel));
                }
            }
            if (this.requirement != null) {
                if (this.isFileTypeOrListOfFiles(this.requirement)) {
                    fileTypeFound = true;
                }
                if (this.requirement.getClass().equals(File.class) || this.requirement.getClass().equals(Integer.class) || this.requirement.getClass().equals(String.class) || this.requirement.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_REQUIREMENT, this.requirement);
                } else if (this.isListOfFile(this.requirement)) {
                    for (i = 0; i < this.getListSize(this.requirement); ++i) {
                        map.put("requirement[" + i + "]", this.getFromList(this.requirement, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_REQUIREMENT, JSON.getDefault().getMapper().writeValueAsString((Object)this.requirement));
                }
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return fileTypeFound ? map : new HashMap<String, Object>();
    }

    private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
        return obj.getClass().equals(File.class) || this.isListOfFile(obj);
    }

    private boolean isListOfFile(Object obj) throws Exception {
        return obj instanceof List && !this.isListEmpty(obj) && this.getFromList(obj, 0) instanceof File;
    }

    private boolean isListEmpty(Object obj) throws Exception {
        return (Boolean)Class.forName(List.class.getName()).getMethod("isEmpty", new Class[0]).invoke(obj, new Object[0]);
    }

    private Object getFromList(Object obj, int index) throws Exception {
        return Class.forName(List.class.getName()).getMethod("get", Integer.TYPE).invoke(obj, index);
    }

    private int getListSize(Object obj) throws Exception {
        return (Integer)Class.forName(List.class.getName()).getMethod("size", new Class[0]).invoke(obj, new Object[0]);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

