/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.model;

import com.dropbox.sign.ApiException;
import com.dropbox.sign.JSON;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"name", "signer_index", "instructions", "required"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class SubAttachment {
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_SIGNER_INDEX = "signer_index";
    private Integer signerIndex;
    public static final String JSON_PROPERTY_INSTRUCTIONS = "instructions";
    private String instructions;
    public static final String JSON_PROPERTY_REQUIRED = "required";
    private Boolean required = false;

    public static SubAttachment init(String jsonData) throws Exception {
        return (SubAttachment)new ObjectMapper().readValue(jsonData, SubAttachment.class);
    }

    public static SubAttachment init(HashMap data) throws Exception {
        return (SubAttachment)new ObjectMapper().readValue(new ObjectMapper().writeValueAsString((Object)data), SubAttachment.class);
    }

    public SubAttachment name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public SubAttachment signerIndex(Integer signerIndex) {
        this.signerIndex = signerIndex;
        return this;
    }

    @Nonnull
    @JsonProperty(value="signer_index")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getSignerIndex() {
        return this.signerIndex;
    }

    @JsonProperty(value="signer_index")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSignerIndex(Integer signerIndex) {
        this.signerIndex = signerIndex;
    }

    public SubAttachment instructions(String instructions) {
        this.instructions = instructions;
        return this;
    }

    @Nullable
    @JsonProperty(value="instructions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getInstructions() {
        return this.instructions;
    }

    @JsonProperty(value="instructions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInstructions(String instructions) {
        this.instructions = instructions;
    }

    public SubAttachment required(Boolean required) {
        this.required = required;
        return this;
    }

    @Nullable
    @JsonProperty(value="required")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getRequired() {
        return this.required;
    }

    @JsonProperty(value="required")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRequired(Boolean required) {
        this.required = required;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubAttachment subAttachment = (SubAttachment)o;
        return Objects.equals(this.name, subAttachment.name) && Objects.equals(this.signerIndex, subAttachment.signerIndex) && Objects.equals(this.instructions, subAttachment.instructions) && Objects.equals(this.required, subAttachment.required);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.signerIndex, this.instructions, this.required);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubAttachment {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    signerIndex: ").append(this.toIndentedString(this.signerIndex)).append("\n");
        sb.append("    instructions: ").append(this.toIndentedString(this.instructions)).append("\n");
        sb.append("    required: ").append(this.toIndentedString(this.required)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public Map<String, Object> createFormData() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean fileTypeFound = false;
        try {
            int i;
            if (this.name != null) {
                if (this.isFileTypeOrListOfFiles(this.name)) {
                    fileTypeFound = true;
                }
                if (this.name.getClass().equals(File.class) || this.name.getClass().equals(Integer.class) || this.name.getClass().equals(String.class) || this.name.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_NAME, this.name);
                } else if (this.isListOfFile(this.name)) {
                    for (i = 0; i < this.getListSize(this.name); ++i) {
                        map.put("name[" + i + "]", this.getFromList(this.name, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_NAME, JSON.getDefault().getMapper().writeValueAsString((Object)this.name));
                }
            }
            if (this.signerIndex != null) {
                if (this.isFileTypeOrListOfFiles(this.signerIndex)) {
                    fileTypeFound = true;
                }
                if (this.signerIndex.getClass().equals(File.class) || this.signerIndex.getClass().equals(Integer.class) || this.signerIndex.getClass().equals(String.class) || this.signerIndex.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_SIGNER_INDEX, this.signerIndex);
                } else if (this.isListOfFile(this.signerIndex)) {
                    for (i = 0; i < this.getListSize(this.signerIndex); ++i) {
                        map.put("signer_index[" + i + "]", this.getFromList(this.signerIndex, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_SIGNER_INDEX, JSON.getDefault().getMapper().writeValueAsString((Object)this.signerIndex));
                }
            }
            if (this.instructions != null) {
                if (this.isFileTypeOrListOfFiles(this.instructions)) {
                    fileTypeFound = true;
                }
                if (this.instructions.getClass().equals(File.class) || this.instructions.getClass().equals(Integer.class) || this.instructions.getClass().equals(String.class) || this.instructions.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_INSTRUCTIONS, this.instructions);
                } else if (this.isListOfFile(this.instructions)) {
                    for (i = 0; i < this.getListSize(this.instructions); ++i) {
                        map.put("instructions[" + i + "]", this.getFromList(this.instructions, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_INSTRUCTIONS, JSON.getDefault().getMapper().writeValueAsString((Object)this.instructions));
                }
            }
            if (this.required != null) {
                if (this.isFileTypeOrListOfFiles(this.required)) {
                    fileTypeFound = true;
                }
                if (this.required.getClass().equals(File.class) || this.required.getClass().equals(Integer.class) || this.required.getClass().equals(String.class) || this.required.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_REQUIRED, this.required);
                } else if (this.isListOfFile(this.required)) {
                    for (i = 0; i < this.getListSize(this.required); ++i) {
                        map.put("required[" + i + "]", this.getFromList(this.required, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_REQUIRED, JSON.getDefault().getMapper().writeValueAsString((Object)this.required));
                }
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return fileTypeFound ? map : new HashMap<String, Object>();
    }

    private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
        return obj.getClass().equals(File.class) || this.isListOfFile(obj);
    }

    private boolean isListOfFile(Object obj) throws Exception {
        return obj instanceof List && !this.isListEmpty(obj) && this.getFromList(obj, 0) instanceof File;
    }

    private boolean isListEmpty(Object obj) throws Exception {
        return (Boolean)Class.forName(List.class.getName()).getMethod("isEmpty", new Class[0]).invoke(obj, new Object[0]);
    }

    private Object getFromList(Object obj, int index) throws Exception {
        return Class.forName(List.class.getName()).getMethod("get", Integer.TYPE).invoke(obj, index);
    }

    private int getListSize(Object obj) throws Exception {
        return (Integer)Class.forName(List.class.getName()).getMethod("size", new Class[0]).invoke(obj, new Object[0]);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

