/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.model;

import com.dropbox.sign.ApiException;
import com.dropbox.sign.JSON;
import com.dropbox.sign.model.SubAttachment;
import com.dropbox.sign.model.SubCustomField;
import com.dropbox.sign.model.SubFieldOptions;
import com.dropbox.sign.model.SubFormFieldGroup;
import com.dropbox.sign.model.SubFormFieldRule;
import com.dropbox.sign.model.SubFormFieldsPerDocumentBase;
import com.dropbox.sign.model.SubSignatureRequestGroupedSigners;
import com.dropbox.sign.model.SubSignatureRequestSigner;
import com.dropbox.sign.model.SubSigningOptions;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nullable;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"files", "file_urls", "signers", "grouped_signers", "allow_decline", "allow_reassign", "attachments", "cc_email_addresses", "client_id", "custom_fields", "field_options", "form_field_groups", "form_field_rules", "form_fields_per_document", "hide_text_tags", "is_qualified_signature", "is_eid", "message", "metadata", "signing_options", "signing_redirect_url", "subject", "test_mode", "title", "use_text_tags", "expires_at"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class SignatureRequestSendRequest {
    public static final String JSON_PROPERTY_FILES = "files";
    private List<File> files = null;
    public static final String JSON_PROPERTY_FILE_URLS = "file_urls";
    private List<String> fileUrls = null;
    public static final String JSON_PROPERTY_SIGNERS = "signers";
    private List<SubSignatureRequestSigner> signers = null;
    public static final String JSON_PROPERTY_GROUPED_SIGNERS = "grouped_signers";
    private List<SubSignatureRequestGroupedSigners> groupedSigners = null;
    public static final String JSON_PROPERTY_ALLOW_DECLINE = "allow_decline";
    private Boolean allowDecline = false;
    public static final String JSON_PROPERTY_ALLOW_REASSIGN = "allow_reassign";
    private Boolean allowReassign = false;
    public static final String JSON_PROPERTY_ATTACHMENTS = "attachments";
    private List<SubAttachment> attachments = null;
    public static final String JSON_PROPERTY_CC_EMAIL_ADDRESSES = "cc_email_addresses";
    private List<String> ccEmailAddresses = null;
    public static final String JSON_PROPERTY_CLIENT_ID = "client_id";
    private String clientId;
    public static final String JSON_PROPERTY_CUSTOM_FIELDS = "custom_fields";
    private List<SubCustomField> customFields = null;
    public static final String JSON_PROPERTY_FIELD_OPTIONS = "field_options";
    private SubFieldOptions fieldOptions;
    public static final String JSON_PROPERTY_FORM_FIELD_GROUPS = "form_field_groups";
    private List<SubFormFieldGroup> formFieldGroups = null;
    public static final String JSON_PROPERTY_FORM_FIELD_RULES = "form_field_rules";
    private List<SubFormFieldRule> formFieldRules = null;
    public static final String JSON_PROPERTY_FORM_FIELDS_PER_DOCUMENT = "form_fields_per_document";
    private List<SubFormFieldsPerDocumentBase> formFieldsPerDocument = null;
    public static final String JSON_PROPERTY_HIDE_TEXT_TAGS = "hide_text_tags";
    private Boolean hideTextTags = false;
    public static final String JSON_PROPERTY_IS_QUALIFIED_SIGNATURE = "is_qualified_signature";
    @Deprecated
    private Boolean isQualifiedSignature = false;
    public static final String JSON_PROPERTY_IS_EID = "is_eid";
    private Boolean isEid = false;
    public static final String JSON_PROPERTY_MESSAGE = "message";
    private String message;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private Map<String, Object> metadata = null;
    public static final String JSON_PROPERTY_SIGNING_OPTIONS = "signing_options";
    private SubSigningOptions signingOptions;
    public static final String JSON_PROPERTY_SIGNING_REDIRECT_URL = "signing_redirect_url";
    private String signingRedirectUrl;
    public static final String JSON_PROPERTY_SUBJECT = "subject";
    private String subject;
    public static final String JSON_PROPERTY_TEST_MODE = "test_mode";
    private Boolean testMode = false;
    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;
    public static final String JSON_PROPERTY_USE_TEXT_TAGS = "use_text_tags";
    private Boolean useTextTags = false;
    public static final String JSON_PROPERTY_EXPIRES_AT = "expires_at";
    private Integer expiresAt;

    public static SignatureRequestSendRequest init(String jsonData) throws Exception {
        return (SignatureRequestSendRequest)new ObjectMapper().readValue(jsonData, SignatureRequestSendRequest.class);
    }

    public static SignatureRequestSendRequest init(HashMap data) throws Exception {
        return (SignatureRequestSendRequest)new ObjectMapper().readValue(new ObjectMapper().writeValueAsString((Object)data), SignatureRequestSendRequest.class);
    }

    public SignatureRequestSendRequest files(List<File> files) {
        this.files = files;
        return this;
    }

    public SignatureRequestSendRequest addFilesItem(File filesItem) {
        if (this.files == null) {
            this.files = new ArrayList<File>();
        }
        this.files.add(filesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="files")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<File> getFiles() {
        return this.files;
    }

    @JsonProperty(value="files")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFiles(List<File> files) {
        this.files = files;
    }

    public SignatureRequestSendRequest fileUrls(List<String> fileUrls) {
        this.fileUrls = fileUrls;
        return this;
    }

    public SignatureRequestSendRequest addFileUrlsItem(String fileUrlsItem) {
        if (this.fileUrls == null) {
            this.fileUrls = new ArrayList<String>();
        }
        this.fileUrls.add(fileUrlsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="file_urls")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getFileUrls() {
        return this.fileUrls;
    }

    @JsonProperty(value="file_urls")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFileUrls(List<String> fileUrls) {
        this.fileUrls = fileUrls;
    }

    public SignatureRequestSendRequest signers(List<SubSignatureRequestSigner> signers) {
        this.signers = signers;
        return this;
    }

    public SignatureRequestSendRequest addSignersItem(SubSignatureRequestSigner signersItem) {
        if (this.signers == null) {
            this.signers = new ArrayList<SubSignatureRequestSigner>();
        }
        this.signers.add(signersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="signers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SubSignatureRequestSigner> getSigners() {
        return this.signers;
    }

    @JsonProperty(value="signers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSigners(List<SubSignatureRequestSigner> signers) {
        this.signers = signers;
    }

    public SignatureRequestSendRequest groupedSigners(List<SubSignatureRequestGroupedSigners> groupedSigners) {
        this.groupedSigners = groupedSigners;
        return this;
    }

    public SignatureRequestSendRequest addGroupedSignersItem(SubSignatureRequestGroupedSigners groupedSignersItem) {
        if (this.groupedSigners == null) {
            this.groupedSigners = new ArrayList<SubSignatureRequestGroupedSigners>();
        }
        this.groupedSigners.add(groupedSignersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="grouped_signers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SubSignatureRequestGroupedSigners> getGroupedSigners() {
        return this.groupedSigners;
    }

    @JsonProperty(value="grouped_signers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGroupedSigners(List<SubSignatureRequestGroupedSigners> groupedSigners) {
        this.groupedSigners = groupedSigners;
    }

    public SignatureRequestSendRequest allowDecline(Boolean allowDecline) {
        this.allowDecline = allowDecline;
        return this;
    }

    @Nullable
    @JsonProperty(value="allow_decline")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAllowDecline() {
        return this.allowDecline;
    }

    @JsonProperty(value="allow_decline")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAllowDecline(Boolean allowDecline) {
        this.allowDecline = allowDecline;
    }

    public SignatureRequestSendRequest allowReassign(Boolean allowReassign) {
        this.allowReassign = allowReassign;
        return this;
    }

    @Nullable
    @JsonProperty(value="allow_reassign")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAllowReassign() {
        return this.allowReassign;
    }

    @JsonProperty(value="allow_reassign")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAllowReassign(Boolean allowReassign) {
        this.allowReassign = allowReassign;
    }

    public SignatureRequestSendRequest attachments(List<SubAttachment> attachments) {
        this.attachments = attachments;
        return this;
    }

    public SignatureRequestSendRequest addAttachmentsItem(SubAttachment attachmentsItem) {
        if (this.attachments == null) {
            this.attachments = new ArrayList<SubAttachment>();
        }
        this.attachments.add(attachmentsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="attachments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SubAttachment> getAttachments() {
        return this.attachments;
    }

    @JsonProperty(value="attachments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAttachments(List<SubAttachment> attachments) {
        this.attachments = attachments;
    }

    public SignatureRequestSendRequest ccEmailAddresses(List<String> ccEmailAddresses) {
        this.ccEmailAddresses = ccEmailAddresses;
        return this;
    }

    public SignatureRequestSendRequest addCcEmailAddressesItem(String ccEmailAddressesItem) {
        if (this.ccEmailAddresses == null) {
            this.ccEmailAddresses = new ArrayList<String>();
        }
        this.ccEmailAddresses.add(ccEmailAddressesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="cc_email_addresses")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getCcEmailAddresses() {
        return this.ccEmailAddresses;
    }

    @JsonProperty(value="cc_email_addresses")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCcEmailAddresses(List<String> ccEmailAddresses) {
        this.ccEmailAddresses = ccEmailAddresses;
    }

    public SignatureRequestSendRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @JsonProperty(value="client_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getClientId() {
        return this.clientId;
    }

    @JsonProperty(value="client_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public SignatureRequestSendRequest customFields(List<SubCustomField> customFields) {
        this.customFields = customFields;
        return this;
    }

    public SignatureRequestSendRequest addCustomFieldsItem(SubCustomField customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new ArrayList<SubCustomField>();
        }
        this.customFields.add(customFieldsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="custom_fields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SubCustomField> getCustomFields() {
        return this.customFields;
    }

    @JsonProperty(value="custom_fields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustomFields(List<SubCustomField> customFields) {
        this.customFields = customFields;
    }

    public SignatureRequestSendRequest fieldOptions(SubFieldOptions fieldOptions) {
        this.fieldOptions = fieldOptions;
        return this;
    }

    @Nullable
    @JsonProperty(value="field_options")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SubFieldOptions getFieldOptions() {
        return this.fieldOptions;
    }

    @JsonProperty(value="field_options")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFieldOptions(SubFieldOptions fieldOptions) {
        this.fieldOptions = fieldOptions;
    }

    public SignatureRequestSendRequest formFieldGroups(List<SubFormFieldGroup> formFieldGroups) {
        this.formFieldGroups = formFieldGroups;
        return this;
    }

    public SignatureRequestSendRequest addFormFieldGroupsItem(SubFormFieldGroup formFieldGroupsItem) {
        if (this.formFieldGroups == null) {
            this.formFieldGroups = new ArrayList<SubFormFieldGroup>();
        }
        this.formFieldGroups.add(formFieldGroupsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="form_field_groups")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SubFormFieldGroup> getFormFieldGroups() {
        return this.formFieldGroups;
    }

    @JsonProperty(value="form_field_groups")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFormFieldGroups(List<SubFormFieldGroup> formFieldGroups) {
        this.formFieldGroups = formFieldGroups;
    }

    public SignatureRequestSendRequest formFieldRules(List<SubFormFieldRule> formFieldRules) {
        this.formFieldRules = formFieldRules;
        return this;
    }

    public SignatureRequestSendRequest addFormFieldRulesItem(SubFormFieldRule formFieldRulesItem) {
        if (this.formFieldRules == null) {
            this.formFieldRules = new ArrayList<SubFormFieldRule>();
        }
        this.formFieldRules.add(formFieldRulesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="form_field_rules")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SubFormFieldRule> getFormFieldRules() {
        return this.formFieldRules;
    }

    @JsonProperty(value="form_field_rules")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFormFieldRules(List<SubFormFieldRule> formFieldRules) {
        this.formFieldRules = formFieldRules;
    }

    public SignatureRequestSendRequest formFieldsPerDocument(List<SubFormFieldsPerDocumentBase> formFieldsPerDocument) {
        this.formFieldsPerDocument = formFieldsPerDocument;
        return this;
    }

    public SignatureRequestSendRequest addFormFieldsPerDocumentItem(SubFormFieldsPerDocumentBase formFieldsPerDocumentItem) {
        if (this.formFieldsPerDocument == null) {
            this.formFieldsPerDocument = new ArrayList<SubFormFieldsPerDocumentBase>();
        }
        this.formFieldsPerDocument.add(formFieldsPerDocumentItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="form_fields_per_document")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SubFormFieldsPerDocumentBase> getFormFieldsPerDocument() {
        return this.formFieldsPerDocument;
    }

    @JsonProperty(value="form_fields_per_document")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFormFieldsPerDocument(List<SubFormFieldsPerDocumentBase> formFieldsPerDocument) {
        this.formFieldsPerDocument = formFieldsPerDocument;
    }

    public SignatureRequestSendRequest hideTextTags(Boolean hideTextTags) {
        this.hideTextTags = hideTextTags;
        return this;
    }

    @Nullable
    @JsonProperty(value="hide_text_tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHideTextTags() {
        return this.hideTextTags;
    }

    @JsonProperty(value="hide_text_tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHideTextTags(Boolean hideTextTags) {
        this.hideTextTags = hideTextTags;
    }

    @Deprecated
    public SignatureRequestSendRequest isQualifiedSignature(Boolean isQualifiedSignature) {
        this.isQualifiedSignature = isQualifiedSignature;
        return this;
    }

    @Deprecated
    @Nullable
    @JsonProperty(value="is_qualified_signature")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsQualifiedSignature() {
        return this.isQualifiedSignature;
    }

    @Deprecated
    @JsonProperty(value="is_qualified_signature")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIsQualifiedSignature(Boolean isQualifiedSignature) {
        this.isQualifiedSignature = isQualifiedSignature;
    }

    public SignatureRequestSendRequest isEid(Boolean isEid) {
        this.isEid = isEid;
        return this;
    }

    @Nullable
    @JsonProperty(value="is_eid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsEid() {
        return this.isEid;
    }

    @JsonProperty(value="is_eid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIsEid(Boolean isEid) {
        this.isEid = isEid;
    }

    public SignatureRequestSendRequest message(String message) {
        this.message = message;
        return this;
    }

    @Nullable
    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMessage() {
        return this.message;
    }

    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMessage(String message) {
        this.message = message;
    }

    public SignatureRequestSendRequest metadata(Map<String, Object> metadata) {
        this.metadata = metadata;
        return this;
    }

    public SignatureRequestSendRequest putMetadataItem(String key, Object metadataItem) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, Object>();
        }
        this.metadata.put(key, metadataItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="metadata")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public SignatureRequestSendRequest signingOptions(SubSigningOptions signingOptions) {
        this.signingOptions = signingOptions;
        return this;
    }

    @Nullable
    @JsonProperty(value="signing_options")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SubSigningOptions getSigningOptions() {
        return this.signingOptions;
    }

    @JsonProperty(value="signing_options")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSigningOptions(SubSigningOptions signingOptions) {
        this.signingOptions = signingOptions;
    }

    public SignatureRequestSendRequest signingRedirectUrl(String signingRedirectUrl) {
        this.signingRedirectUrl = signingRedirectUrl;
        return this;
    }

    @Nullable
    @JsonProperty(value="signing_redirect_url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSigningRedirectUrl() {
        return this.signingRedirectUrl;
    }

    @JsonProperty(value="signing_redirect_url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSigningRedirectUrl(String signingRedirectUrl) {
        this.signingRedirectUrl = signingRedirectUrl;
    }

    public SignatureRequestSendRequest subject(String subject) {
        this.subject = subject;
        return this;
    }

    @Nullable
    @JsonProperty(value="subject")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSubject() {
        return this.subject;
    }

    @JsonProperty(value="subject")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSubject(String subject) {
        this.subject = subject;
    }

    public SignatureRequestSendRequest testMode(Boolean testMode) {
        this.testMode = testMode;
        return this;
    }

    @Nullable
    @JsonProperty(value="test_mode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getTestMode() {
        return this.testMode;
    }

    @JsonProperty(value="test_mode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTestMode(Boolean testMode) {
        this.testMode = testMode;
    }

    public SignatureRequestSendRequest title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTitle(String title) {
        this.title = title;
    }

    public SignatureRequestSendRequest useTextTags(Boolean useTextTags) {
        this.useTextTags = useTextTags;
        return this;
    }

    @Nullable
    @JsonProperty(value="use_text_tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getUseTextTags() {
        return this.useTextTags;
    }

    @JsonProperty(value="use_text_tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUseTextTags(Boolean useTextTags) {
        this.useTextTags = useTextTags;
    }

    public SignatureRequestSendRequest expiresAt(Integer expiresAt) {
        this.expiresAt = expiresAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="expires_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getExpiresAt() {
        return this.expiresAt;
    }

    @JsonProperty(value="expires_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExpiresAt(Integer expiresAt) {
        this.expiresAt = expiresAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignatureRequestSendRequest signatureRequestSendRequest = (SignatureRequestSendRequest)o;
        return Objects.equals(this.files, signatureRequestSendRequest.files) && Objects.equals(this.fileUrls, signatureRequestSendRequest.fileUrls) && Objects.equals(this.signers, signatureRequestSendRequest.signers) && Objects.equals(this.groupedSigners, signatureRequestSendRequest.groupedSigners) && Objects.equals(this.allowDecline, signatureRequestSendRequest.allowDecline) && Objects.equals(this.allowReassign, signatureRequestSendRequest.allowReassign) && Objects.equals(this.attachments, signatureRequestSendRequest.attachments) && Objects.equals(this.ccEmailAddresses, signatureRequestSendRequest.ccEmailAddresses) && Objects.equals(this.clientId, signatureRequestSendRequest.clientId) && Objects.equals(this.customFields, signatureRequestSendRequest.customFields) && Objects.equals(this.fieldOptions, signatureRequestSendRequest.fieldOptions) && Objects.equals(this.formFieldGroups, signatureRequestSendRequest.formFieldGroups) && Objects.equals(this.formFieldRules, signatureRequestSendRequest.formFieldRules) && Objects.equals(this.formFieldsPerDocument, signatureRequestSendRequest.formFieldsPerDocument) && Objects.equals(this.hideTextTags, signatureRequestSendRequest.hideTextTags) && Objects.equals(this.isQualifiedSignature, signatureRequestSendRequest.isQualifiedSignature) && Objects.equals(this.isEid, signatureRequestSendRequest.isEid) && Objects.equals(this.message, signatureRequestSendRequest.message) && Objects.equals(this.metadata, signatureRequestSendRequest.metadata) && Objects.equals(this.signingOptions, signatureRequestSendRequest.signingOptions) && Objects.equals(this.signingRedirectUrl, signatureRequestSendRequest.signingRedirectUrl) && Objects.equals(this.subject, signatureRequestSendRequest.subject) && Objects.equals(this.testMode, signatureRequestSendRequest.testMode) && Objects.equals(this.title, signatureRequestSendRequest.title) && Objects.equals(this.useTextTags, signatureRequestSendRequest.useTextTags) && Objects.equals(this.expiresAt, signatureRequestSendRequest.expiresAt);
    }

    public int hashCode() {
        return Objects.hash(this.files, this.fileUrls, this.signers, this.groupedSigners, this.allowDecline, this.allowReassign, this.attachments, this.ccEmailAddresses, this.clientId, this.customFields, this.fieldOptions, this.formFieldGroups, this.formFieldRules, this.formFieldsPerDocument, this.hideTextTags, this.isQualifiedSignature, this.isEid, this.message, this.metadata, this.signingOptions, this.signingRedirectUrl, this.subject, this.testMode, this.title, this.useTextTags, this.expiresAt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SignatureRequestSendRequest {\n");
        sb.append("    files: ").append(this.toIndentedString(this.files)).append("\n");
        sb.append("    fileUrls: ").append(this.toIndentedString(this.fileUrls)).append("\n");
        sb.append("    signers: ").append(this.toIndentedString(this.signers)).append("\n");
        sb.append("    groupedSigners: ").append(this.toIndentedString(this.groupedSigners)).append("\n");
        sb.append("    allowDecline: ").append(this.toIndentedString(this.allowDecline)).append("\n");
        sb.append("    allowReassign: ").append(this.toIndentedString(this.allowReassign)).append("\n");
        sb.append("    attachments: ").append(this.toIndentedString(this.attachments)).append("\n");
        sb.append("    ccEmailAddresses: ").append(this.toIndentedString(this.ccEmailAddresses)).append("\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    fieldOptions: ").append(this.toIndentedString(this.fieldOptions)).append("\n");
        sb.append("    formFieldGroups: ").append(this.toIndentedString(this.formFieldGroups)).append("\n");
        sb.append("    formFieldRules: ").append(this.toIndentedString(this.formFieldRules)).append("\n");
        sb.append("    formFieldsPerDocument: ").append(this.toIndentedString(this.formFieldsPerDocument)).append("\n");
        sb.append("    hideTextTags: ").append(this.toIndentedString(this.hideTextTags)).append("\n");
        sb.append("    isQualifiedSignature: ").append(this.toIndentedString(this.isQualifiedSignature)).append("\n");
        sb.append("    isEid: ").append(this.toIndentedString(this.isEid)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    signingOptions: ").append(this.toIndentedString(this.signingOptions)).append("\n");
        sb.append("    signingRedirectUrl: ").append(this.toIndentedString(this.signingRedirectUrl)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("    testMode: ").append(this.toIndentedString(this.testMode)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    useTextTags: ").append(this.toIndentedString(this.useTextTags)).append("\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public Map<String, Object> createFormData() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean fileTypeFound = false;
        try {
            int i;
            if (this.files != null) {
                if (this.isFileTypeOrListOfFiles(this.files)) {
                    fileTypeFound = true;
                }
                if (this.files.getClass().equals(File.class) || this.files.getClass().equals(Integer.class) || this.files.getClass().equals(String.class) || this.files.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_FILES, this.files);
                } else if (this.isListOfFile(this.files)) {
                    for (i = 0; i < this.getListSize(this.files); ++i) {
                        map.put("files[" + i + "]", this.getFromList(this.files, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_FILES, JSON.getDefault().getMapper().writeValueAsString(this.files));
                }
            }
            if (this.fileUrls != null) {
                if (this.isFileTypeOrListOfFiles(this.fileUrls)) {
                    fileTypeFound = true;
                }
                if (this.fileUrls.getClass().equals(File.class) || this.fileUrls.getClass().equals(Integer.class) || this.fileUrls.getClass().equals(String.class) || this.fileUrls.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_FILE_URLS, this.fileUrls);
                } else if (this.isListOfFile(this.fileUrls)) {
                    for (i = 0; i < this.getListSize(this.fileUrls); ++i) {
                        map.put("file_urls[" + i + "]", this.getFromList(this.fileUrls, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_FILE_URLS, JSON.getDefault().getMapper().writeValueAsString(this.fileUrls));
                }
            }
            if (this.signers != null) {
                if (this.isFileTypeOrListOfFiles(this.signers)) {
                    fileTypeFound = true;
                }
                if (this.signers.getClass().equals(File.class) || this.signers.getClass().equals(Integer.class) || this.signers.getClass().equals(String.class) || this.signers.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_SIGNERS, this.signers);
                } else if (this.isListOfFile(this.signers)) {
                    for (i = 0; i < this.getListSize(this.signers); ++i) {
                        map.put("signers[" + i + "]", this.getFromList(this.signers, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_SIGNERS, JSON.getDefault().getMapper().writeValueAsString(this.signers));
                }
            }
            if (this.groupedSigners != null) {
                if (this.isFileTypeOrListOfFiles(this.groupedSigners)) {
                    fileTypeFound = true;
                }
                if (this.groupedSigners.getClass().equals(File.class) || this.groupedSigners.getClass().equals(Integer.class) || this.groupedSigners.getClass().equals(String.class) || this.groupedSigners.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_GROUPED_SIGNERS, this.groupedSigners);
                } else if (this.isListOfFile(this.groupedSigners)) {
                    for (i = 0; i < this.getListSize(this.groupedSigners); ++i) {
                        map.put("grouped_signers[" + i + "]", this.getFromList(this.groupedSigners, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_GROUPED_SIGNERS, JSON.getDefault().getMapper().writeValueAsString(this.groupedSigners));
                }
            }
            if (this.allowDecline != null) {
                if (this.isFileTypeOrListOfFiles(this.allowDecline)) {
                    fileTypeFound = true;
                }
                if (this.allowDecline.getClass().equals(File.class) || this.allowDecline.getClass().equals(Integer.class) || this.allowDecline.getClass().equals(String.class) || this.allowDecline.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_ALLOW_DECLINE, this.allowDecline);
                } else if (this.isListOfFile(this.allowDecline)) {
                    for (i = 0; i < this.getListSize(this.allowDecline); ++i) {
                        map.put("allow_decline[" + i + "]", this.getFromList(this.allowDecline, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_ALLOW_DECLINE, JSON.getDefault().getMapper().writeValueAsString((Object)this.allowDecline));
                }
            }
            if (this.allowReassign != null) {
                if (this.isFileTypeOrListOfFiles(this.allowReassign)) {
                    fileTypeFound = true;
                }
                if (this.allowReassign.getClass().equals(File.class) || this.allowReassign.getClass().equals(Integer.class) || this.allowReassign.getClass().equals(String.class) || this.allowReassign.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_ALLOW_REASSIGN, this.allowReassign);
                } else if (this.isListOfFile(this.allowReassign)) {
                    for (i = 0; i < this.getListSize(this.allowReassign); ++i) {
                        map.put("allow_reassign[" + i + "]", this.getFromList(this.allowReassign, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_ALLOW_REASSIGN, JSON.getDefault().getMapper().writeValueAsString((Object)this.allowReassign));
                }
            }
            if (this.attachments != null) {
                if (this.isFileTypeOrListOfFiles(this.attachments)) {
                    fileTypeFound = true;
                }
                if (this.attachments.getClass().equals(File.class) || this.attachments.getClass().equals(Integer.class) || this.attachments.getClass().equals(String.class) || this.attachments.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_ATTACHMENTS, this.attachments);
                } else if (this.isListOfFile(this.attachments)) {
                    for (i = 0; i < this.getListSize(this.attachments); ++i) {
                        map.put("attachments[" + i + "]", this.getFromList(this.attachments, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_ATTACHMENTS, JSON.getDefault().getMapper().writeValueAsString(this.attachments));
                }
            }
            if (this.ccEmailAddresses != null) {
                if (this.isFileTypeOrListOfFiles(this.ccEmailAddresses)) {
                    fileTypeFound = true;
                }
                if (this.ccEmailAddresses.getClass().equals(File.class) || this.ccEmailAddresses.getClass().equals(Integer.class) || this.ccEmailAddresses.getClass().equals(String.class) || this.ccEmailAddresses.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_CC_EMAIL_ADDRESSES, this.ccEmailAddresses);
                } else if (this.isListOfFile(this.ccEmailAddresses)) {
                    for (i = 0; i < this.getListSize(this.ccEmailAddresses); ++i) {
                        map.put("cc_email_addresses[" + i + "]", this.getFromList(this.ccEmailAddresses, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_CC_EMAIL_ADDRESSES, JSON.getDefault().getMapper().writeValueAsString(this.ccEmailAddresses));
                }
            }
            if (this.clientId != null) {
                if (this.isFileTypeOrListOfFiles(this.clientId)) {
                    fileTypeFound = true;
                }
                if (this.clientId.getClass().equals(File.class) || this.clientId.getClass().equals(Integer.class) || this.clientId.getClass().equals(String.class) || this.clientId.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_CLIENT_ID, this.clientId);
                } else if (this.isListOfFile(this.clientId)) {
                    for (i = 0; i < this.getListSize(this.clientId); ++i) {
                        map.put("client_id[" + i + "]", this.getFromList(this.clientId, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_CLIENT_ID, JSON.getDefault().getMapper().writeValueAsString((Object)this.clientId));
                }
            }
            if (this.customFields != null) {
                if (this.isFileTypeOrListOfFiles(this.customFields)) {
                    fileTypeFound = true;
                }
                if (this.customFields.getClass().equals(File.class) || this.customFields.getClass().equals(Integer.class) || this.customFields.getClass().equals(String.class) || this.customFields.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_CUSTOM_FIELDS, this.customFields);
                } else if (this.isListOfFile(this.customFields)) {
                    for (i = 0; i < this.getListSize(this.customFields); ++i) {
                        map.put("custom_fields[" + i + "]", this.getFromList(this.customFields, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_CUSTOM_FIELDS, JSON.getDefault().getMapper().writeValueAsString(this.customFields));
                }
            }
            if (this.fieldOptions != null) {
                if (this.isFileTypeOrListOfFiles(this.fieldOptions)) {
                    fileTypeFound = true;
                }
                if (this.fieldOptions.getClass().equals(File.class) || this.fieldOptions.getClass().equals(Integer.class) || this.fieldOptions.getClass().equals(String.class) || this.fieldOptions.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_FIELD_OPTIONS, this.fieldOptions);
                } else if (this.isListOfFile(this.fieldOptions)) {
                    for (i = 0; i < this.getListSize(this.fieldOptions); ++i) {
                        map.put("field_options[" + i + "]", this.getFromList(this.fieldOptions, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_FIELD_OPTIONS, JSON.getDefault().getMapper().writeValueAsString((Object)this.fieldOptions));
                }
            }
            if (this.formFieldGroups != null) {
                if (this.isFileTypeOrListOfFiles(this.formFieldGroups)) {
                    fileTypeFound = true;
                }
                if (this.formFieldGroups.getClass().equals(File.class) || this.formFieldGroups.getClass().equals(Integer.class) || this.formFieldGroups.getClass().equals(String.class) || this.formFieldGroups.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_FORM_FIELD_GROUPS, this.formFieldGroups);
                } else if (this.isListOfFile(this.formFieldGroups)) {
                    for (i = 0; i < this.getListSize(this.formFieldGroups); ++i) {
                        map.put("form_field_groups[" + i + "]", this.getFromList(this.formFieldGroups, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_FORM_FIELD_GROUPS, JSON.getDefault().getMapper().writeValueAsString(this.formFieldGroups));
                }
            }
            if (this.formFieldRules != null) {
                if (this.isFileTypeOrListOfFiles(this.formFieldRules)) {
                    fileTypeFound = true;
                }
                if (this.formFieldRules.getClass().equals(File.class) || this.formFieldRules.getClass().equals(Integer.class) || this.formFieldRules.getClass().equals(String.class) || this.formFieldRules.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_FORM_FIELD_RULES, this.formFieldRules);
                } else if (this.isListOfFile(this.formFieldRules)) {
                    for (i = 0; i < this.getListSize(this.formFieldRules); ++i) {
                        map.put("form_field_rules[" + i + "]", this.getFromList(this.formFieldRules, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_FORM_FIELD_RULES, JSON.getDefault().getMapper().writeValueAsString(this.formFieldRules));
                }
            }
            if (this.formFieldsPerDocument != null) {
                if (this.isFileTypeOrListOfFiles(this.formFieldsPerDocument)) {
                    fileTypeFound = true;
                }
                if (this.formFieldsPerDocument.getClass().equals(File.class) || this.formFieldsPerDocument.getClass().equals(Integer.class) || this.formFieldsPerDocument.getClass().equals(String.class) || this.formFieldsPerDocument.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_FORM_FIELDS_PER_DOCUMENT, this.formFieldsPerDocument);
                } else if (this.isListOfFile(this.formFieldsPerDocument)) {
                    for (i = 0; i < this.getListSize(this.formFieldsPerDocument); ++i) {
                        map.put("form_fields_per_document[" + i + "]", this.getFromList(this.formFieldsPerDocument, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_FORM_FIELDS_PER_DOCUMENT, JSON.getDefault().getMapper().writeValueAsString(this.formFieldsPerDocument));
                }
            }
            if (this.hideTextTags != null) {
                if (this.isFileTypeOrListOfFiles(this.hideTextTags)) {
                    fileTypeFound = true;
                }
                if (this.hideTextTags.getClass().equals(File.class) || this.hideTextTags.getClass().equals(Integer.class) || this.hideTextTags.getClass().equals(String.class) || this.hideTextTags.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_HIDE_TEXT_TAGS, this.hideTextTags);
                } else if (this.isListOfFile(this.hideTextTags)) {
                    for (i = 0; i < this.getListSize(this.hideTextTags); ++i) {
                        map.put("hide_text_tags[" + i + "]", this.getFromList(this.hideTextTags, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_HIDE_TEXT_TAGS, JSON.getDefault().getMapper().writeValueAsString((Object)this.hideTextTags));
                }
            }
            if (this.isQualifiedSignature != null) {
                if (this.isFileTypeOrListOfFiles(this.isQualifiedSignature)) {
                    fileTypeFound = true;
                }
                if (this.isQualifiedSignature.getClass().equals(File.class) || this.isQualifiedSignature.getClass().equals(Integer.class) || this.isQualifiedSignature.getClass().equals(String.class) || this.isQualifiedSignature.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_IS_QUALIFIED_SIGNATURE, this.isQualifiedSignature);
                } else if (this.isListOfFile(this.isQualifiedSignature)) {
                    for (i = 0; i < this.getListSize(this.isQualifiedSignature); ++i) {
                        map.put("is_qualified_signature[" + i + "]", this.getFromList(this.isQualifiedSignature, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_IS_QUALIFIED_SIGNATURE, JSON.getDefault().getMapper().writeValueAsString((Object)this.isQualifiedSignature));
                }
            }
            if (this.isEid != null) {
                if (this.isFileTypeOrListOfFiles(this.isEid)) {
                    fileTypeFound = true;
                }
                if (this.isEid.getClass().equals(File.class) || this.isEid.getClass().equals(Integer.class) || this.isEid.getClass().equals(String.class) || this.isEid.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_IS_EID, this.isEid);
                } else if (this.isListOfFile(this.isEid)) {
                    for (i = 0; i < this.getListSize(this.isEid); ++i) {
                        map.put("is_eid[" + i + "]", this.getFromList(this.isEid, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_IS_EID, JSON.getDefault().getMapper().writeValueAsString((Object)this.isEid));
                }
            }
            if (this.message != null) {
                if (this.isFileTypeOrListOfFiles(this.message)) {
                    fileTypeFound = true;
                }
                if (this.message.getClass().equals(File.class) || this.message.getClass().equals(Integer.class) || this.message.getClass().equals(String.class) || this.message.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_MESSAGE, this.message);
                } else if (this.isListOfFile(this.message)) {
                    for (i = 0; i < this.getListSize(this.message); ++i) {
                        map.put("message[" + i + "]", this.getFromList(this.message, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_MESSAGE, JSON.getDefault().getMapper().writeValueAsString((Object)this.message));
                }
            }
            if (this.metadata != null) {
                if (this.isFileTypeOrListOfFiles(this.metadata)) {
                    fileTypeFound = true;
                }
                if (this.metadata.getClass().equals(File.class) || this.metadata.getClass().equals(Integer.class) || this.metadata.getClass().equals(String.class) || this.metadata.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_METADATA, this.metadata);
                } else if (this.isListOfFile(this.metadata)) {
                    for (i = 0; i < this.getListSize(this.metadata); ++i) {
                        map.put("metadata[" + i + "]", this.getFromList(this.metadata, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_METADATA, JSON.getDefault().getMapper().writeValueAsString(this.metadata));
                }
            }
            if (this.signingOptions != null) {
                if (this.isFileTypeOrListOfFiles(this.signingOptions)) {
                    fileTypeFound = true;
                }
                if (this.signingOptions.getClass().equals(File.class) || this.signingOptions.getClass().equals(Integer.class) || this.signingOptions.getClass().equals(String.class) || this.signingOptions.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_SIGNING_OPTIONS, this.signingOptions);
                } else if (this.isListOfFile(this.signingOptions)) {
                    for (i = 0; i < this.getListSize(this.signingOptions); ++i) {
                        map.put("signing_options[" + i + "]", this.getFromList(this.signingOptions, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_SIGNING_OPTIONS, JSON.getDefault().getMapper().writeValueAsString((Object)this.signingOptions));
                }
            }
            if (this.signingRedirectUrl != null) {
                if (this.isFileTypeOrListOfFiles(this.signingRedirectUrl)) {
                    fileTypeFound = true;
                }
                if (this.signingRedirectUrl.getClass().equals(File.class) || this.signingRedirectUrl.getClass().equals(Integer.class) || this.signingRedirectUrl.getClass().equals(String.class) || this.signingRedirectUrl.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_SIGNING_REDIRECT_URL, this.signingRedirectUrl);
                } else if (this.isListOfFile(this.signingRedirectUrl)) {
                    for (i = 0; i < this.getListSize(this.signingRedirectUrl); ++i) {
                        map.put("signing_redirect_url[" + i + "]", this.getFromList(this.signingRedirectUrl, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_SIGNING_REDIRECT_URL, JSON.getDefault().getMapper().writeValueAsString((Object)this.signingRedirectUrl));
                }
            }
            if (this.subject != null) {
                if (this.isFileTypeOrListOfFiles(this.subject)) {
                    fileTypeFound = true;
                }
                if (this.subject.getClass().equals(File.class) || this.subject.getClass().equals(Integer.class) || this.subject.getClass().equals(String.class) || this.subject.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_SUBJECT, this.subject);
                } else if (this.isListOfFile(this.subject)) {
                    for (i = 0; i < this.getListSize(this.subject); ++i) {
                        map.put("subject[" + i + "]", this.getFromList(this.subject, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_SUBJECT, JSON.getDefault().getMapper().writeValueAsString((Object)this.subject));
                }
            }
            if (this.testMode != null) {
                if (this.isFileTypeOrListOfFiles(this.testMode)) {
                    fileTypeFound = true;
                }
                if (this.testMode.getClass().equals(File.class) || this.testMode.getClass().equals(Integer.class) || this.testMode.getClass().equals(String.class) || this.testMode.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_TEST_MODE, this.testMode);
                } else if (this.isListOfFile(this.testMode)) {
                    for (i = 0; i < this.getListSize(this.testMode); ++i) {
                        map.put("test_mode[" + i + "]", this.getFromList(this.testMode, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_TEST_MODE, JSON.getDefault().getMapper().writeValueAsString((Object)this.testMode));
                }
            }
            if (this.title != null) {
                if (this.isFileTypeOrListOfFiles(this.title)) {
                    fileTypeFound = true;
                }
                if (this.title.getClass().equals(File.class) || this.title.getClass().equals(Integer.class) || this.title.getClass().equals(String.class) || this.title.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_TITLE, this.title);
                } else if (this.isListOfFile(this.title)) {
                    for (i = 0; i < this.getListSize(this.title); ++i) {
                        map.put("title[" + i + "]", this.getFromList(this.title, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_TITLE, JSON.getDefault().getMapper().writeValueAsString((Object)this.title));
                }
            }
            if (this.useTextTags != null) {
                if (this.isFileTypeOrListOfFiles(this.useTextTags)) {
                    fileTypeFound = true;
                }
                if (this.useTextTags.getClass().equals(File.class) || this.useTextTags.getClass().equals(Integer.class) || this.useTextTags.getClass().equals(String.class) || this.useTextTags.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_USE_TEXT_TAGS, this.useTextTags);
                } else if (this.isListOfFile(this.useTextTags)) {
                    for (i = 0; i < this.getListSize(this.useTextTags); ++i) {
                        map.put("use_text_tags[" + i + "]", this.getFromList(this.useTextTags, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_USE_TEXT_TAGS, JSON.getDefault().getMapper().writeValueAsString((Object)this.useTextTags));
                }
            }
            if (this.expiresAt != null) {
                if (this.isFileTypeOrListOfFiles(this.expiresAt)) {
                    fileTypeFound = true;
                }
                if (this.expiresAt.getClass().equals(File.class) || this.expiresAt.getClass().equals(Integer.class) || this.expiresAt.getClass().equals(String.class) || this.expiresAt.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_EXPIRES_AT, this.expiresAt);
                } else if (this.isListOfFile(this.expiresAt)) {
                    for (i = 0; i < this.getListSize(this.expiresAt); ++i) {
                        map.put("expires_at[" + i + "]", this.getFromList(this.expiresAt, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_EXPIRES_AT, JSON.getDefault().getMapper().writeValueAsString((Object)this.expiresAt));
                }
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return fileTypeFound ? map : new HashMap<String, Object>();
    }

    private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
        return obj.getClass().equals(File.class) || this.isListOfFile(obj);
    }

    private boolean isListOfFile(Object obj) throws Exception {
        return obj instanceof List && !this.isListEmpty(obj) && this.getFromList(obj, 0) instanceof File;
    }

    private boolean isListEmpty(Object obj) throws Exception {
        return (Boolean)Class.forName(List.class.getName()).getMethod("isEmpty", new Class[0]).invoke(obj, new Object[0]);
    }

    private Object getFromList(Object obj, int index) throws Exception {
        return Class.forName(List.class.getName()).getMethod("get", Integer.TYPE).invoke(obj, index);
    }

    private int getListSize(Object obj) throws Exception {
        return (Integer)Class.forName(List.class.getName()).getMethod("size", new Class[0]).invoke(obj, new Object[0]);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

