/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.model;

import com.dropbox.sign.ApiException;
import com.dropbox.sign.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nullable;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"success", "start_date", "end_date", "report_type"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class ReportResponse {
    public static final String JSON_PROPERTY_SUCCESS = "success";
    private String success;
    public static final String JSON_PROPERTY_START_DATE = "start_date";
    private String startDate;
    public static final String JSON_PROPERTY_END_DATE = "end_date";
    private String endDate;
    public static final String JSON_PROPERTY_REPORT_TYPE = "report_type";
    private List<ReportTypeEnum> reportType = null;

    public static ReportResponse init(String jsonData) throws Exception {
        return (ReportResponse)new ObjectMapper().readValue(jsonData, ReportResponse.class);
    }

    public static ReportResponse init(HashMap data) throws Exception {
        return (ReportResponse)new ObjectMapper().readValue(new ObjectMapper().writeValueAsString((Object)data), ReportResponse.class);
    }

    public ReportResponse success(String success) {
        this.success = success;
        return this;
    }

    @Nullable
    @JsonProperty(value="success")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSuccess() {
        return this.success;
    }

    @JsonProperty(value="success")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSuccess(String success) {
        this.success = success;
    }

    public ReportResponse startDate(String startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nullable
    @JsonProperty(value="start_date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="start_date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public ReportResponse endDate(String endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nullable
    @JsonProperty(value="end_date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEndDate() {
        return this.endDate;
    }

    @JsonProperty(value="end_date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public ReportResponse reportType(List<ReportTypeEnum> reportType) {
        this.reportType = reportType;
        return this;
    }

    public ReportResponse addReportTypeItem(ReportTypeEnum reportTypeItem) {
        if (this.reportType == null) {
            this.reportType = new ArrayList<ReportTypeEnum>();
        }
        this.reportType.add(reportTypeItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="report_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ReportTypeEnum> getReportType() {
        return this.reportType;
    }

    @JsonProperty(value="report_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReportType(List<ReportTypeEnum> reportType) {
        this.reportType = reportType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReportResponse reportResponse = (ReportResponse)o;
        return Objects.equals(this.success, reportResponse.success) && Objects.equals(this.startDate, reportResponse.startDate) && Objects.equals(this.endDate, reportResponse.endDate) && Objects.equals(this.reportType, reportResponse.reportType);
    }

    public int hashCode() {
        return Objects.hash(this.success, this.startDate, this.endDate, this.reportType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReportResponse {\n");
        sb.append("    success: ").append(this.toIndentedString(this.success)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    reportType: ").append(this.toIndentedString(this.reportType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public Map<String, Object> createFormData() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean fileTypeFound = false;
        try {
            int i;
            if (this.success != null) {
                if (this.isFileTypeOrListOfFiles(this.success)) {
                    fileTypeFound = true;
                }
                if (this.success.getClass().equals(File.class) || this.success.getClass().equals(Integer.class) || this.success.getClass().equals(String.class) || this.success.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_SUCCESS, this.success);
                } else if (this.isListOfFile(this.success)) {
                    for (i = 0; i < this.getListSize(this.success); ++i) {
                        map.put("success[" + i + "]", this.getFromList(this.success, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_SUCCESS, JSON.getDefault().getMapper().writeValueAsString((Object)this.success));
                }
            }
            if (this.startDate != null) {
                if (this.isFileTypeOrListOfFiles(this.startDate)) {
                    fileTypeFound = true;
                }
                if (this.startDate.getClass().equals(File.class) || this.startDate.getClass().equals(Integer.class) || this.startDate.getClass().equals(String.class) || this.startDate.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_START_DATE, this.startDate);
                } else if (this.isListOfFile(this.startDate)) {
                    for (i = 0; i < this.getListSize(this.startDate); ++i) {
                        map.put("start_date[" + i + "]", this.getFromList(this.startDate, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_START_DATE, JSON.getDefault().getMapper().writeValueAsString((Object)this.startDate));
                }
            }
            if (this.endDate != null) {
                if (this.isFileTypeOrListOfFiles(this.endDate)) {
                    fileTypeFound = true;
                }
                if (this.endDate.getClass().equals(File.class) || this.endDate.getClass().equals(Integer.class) || this.endDate.getClass().equals(String.class) || this.endDate.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_END_DATE, this.endDate);
                } else if (this.isListOfFile(this.endDate)) {
                    for (i = 0; i < this.getListSize(this.endDate); ++i) {
                        map.put("end_date[" + i + "]", this.getFromList(this.endDate, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_END_DATE, JSON.getDefault().getMapper().writeValueAsString((Object)this.endDate));
                }
            }
            if (this.reportType != null) {
                if (this.isFileTypeOrListOfFiles(this.reportType)) {
                    fileTypeFound = true;
                }
                if (this.reportType.getClass().equals(File.class) || this.reportType.getClass().equals(Integer.class) || this.reportType.getClass().equals(String.class) || this.reportType.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_REPORT_TYPE, this.reportType);
                } else if (this.isListOfFile(this.reportType)) {
                    for (i = 0; i < this.getListSize(this.reportType); ++i) {
                        map.put("report_type[" + i + "]", this.getFromList(this.reportType, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_REPORT_TYPE, JSON.getDefault().getMapper().writeValueAsString(this.reportType));
                }
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return fileTypeFound ? map : new HashMap<String, Object>();
    }

    private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
        return obj.getClass().equals(File.class) || this.isListOfFile(obj);
    }

    private boolean isListOfFile(Object obj) throws Exception {
        return obj instanceof List && !this.isListEmpty(obj) && this.getFromList(obj, 0) instanceof File;
    }

    private boolean isListEmpty(Object obj) throws Exception {
        return (Boolean)Class.forName(List.class.getName()).getMethod("isEmpty", new Class[0]).invoke(obj, new Object[0]);
    }

    private Object getFromList(Object obj, int index) throws Exception {
        return Class.forName(List.class.getName()).getMethod("get", Integer.TYPE).invoke(obj, index);
    }

    private int getListSize(Object obj) throws Exception {
        return (Integer)Class.forName(List.class.getName()).getMethod("size", new Class[0]).invoke(obj, new Object[0]);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ReportTypeEnum {
        USER_ACTIVITY("user_activity"),
        DOCUMENT_STATUS("document_status");

        private String value;

        private ReportTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ReportTypeEnum fromValue(String value) {
            for (ReportTypeEnum b : ReportTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

