/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.model;

import com.dropbox.sign.ApiException;
import com.dropbox.sign.JSON;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nullable;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"access_token", "token_type", "refresh_token", "expires_in", "state"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class OAuthTokenResponse {
    public static final String JSON_PROPERTY_ACCESS_TOKEN = "access_token";
    private String accessToken;
    public static final String JSON_PROPERTY_TOKEN_TYPE = "token_type";
    private String tokenType;
    public static final String JSON_PROPERTY_REFRESH_TOKEN = "refresh_token";
    private String refreshToken;
    public static final String JSON_PROPERTY_EXPIRES_IN = "expires_in";
    private Integer expiresIn;
    public static final String JSON_PROPERTY_STATE = "state";
    private String state;

    public static OAuthTokenResponse init(String jsonData) throws Exception {
        return (OAuthTokenResponse)new ObjectMapper().readValue(jsonData, OAuthTokenResponse.class);
    }

    public static OAuthTokenResponse init(HashMap data) throws Exception {
        return (OAuthTokenResponse)new ObjectMapper().readValue(new ObjectMapper().writeValueAsString((Object)data), OAuthTokenResponse.class);
    }

    public OAuthTokenResponse accessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    @Nullable
    @JsonProperty(value="access_token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccessToken() {
        return this.accessToken;
    }

    @JsonProperty(value="access_token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public OAuthTokenResponse tokenType(String tokenType) {
        this.tokenType = tokenType;
        return this;
    }

    @Nullable
    @JsonProperty(value="token_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTokenType() {
        return this.tokenType;
    }

    @JsonProperty(value="token_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public OAuthTokenResponse refreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
        return this;
    }

    @Nullable
    @JsonProperty(value="refresh_token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRefreshToken() {
        return this.refreshToken;
    }

    @JsonProperty(value="refresh_token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public OAuthTokenResponse expiresIn(Integer expiresIn) {
        this.expiresIn = expiresIn;
        return this;
    }

    @Nullable
    @JsonProperty(value="expires_in")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getExpiresIn() {
        return this.expiresIn;
    }

    @JsonProperty(value="expires_in")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExpiresIn(Integer expiresIn) {
        this.expiresIn = expiresIn;
    }

    public OAuthTokenResponse state(String state) {
        this.state = state;
        return this;
    }

    @Nullable
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setState(String state) {
        this.state = state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuthTokenResponse oauthTokenResponse = (OAuthTokenResponse)o;
        return Objects.equals(this.accessToken, oauthTokenResponse.accessToken) && Objects.equals(this.tokenType, oauthTokenResponse.tokenType) && Objects.equals(this.refreshToken, oauthTokenResponse.refreshToken) && Objects.equals(this.expiresIn, oauthTokenResponse.expiresIn) && Objects.equals(this.state, oauthTokenResponse.state);
    }

    public int hashCode() {
        return Objects.hash(this.accessToken, this.tokenType, this.refreshToken, this.expiresIn, this.state);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OAuthTokenResponse {\n");
        sb.append("    accessToken: ").append(this.toIndentedString(this.accessToken)).append("\n");
        sb.append("    tokenType: ").append(this.toIndentedString(this.tokenType)).append("\n");
        sb.append("    refreshToken: ").append(this.toIndentedString(this.refreshToken)).append("\n");
        sb.append("    expiresIn: ").append(this.toIndentedString(this.expiresIn)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public Map<String, Object> createFormData() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean fileTypeFound = false;
        try {
            int i;
            if (this.accessToken != null) {
                if (this.isFileTypeOrListOfFiles(this.accessToken)) {
                    fileTypeFound = true;
                }
                if (this.accessToken.getClass().equals(File.class) || this.accessToken.getClass().equals(Integer.class) || this.accessToken.getClass().equals(String.class) || this.accessToken.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_ACCESS_TOKEN, this.accessToken);
                } else if (this.isListOfFile(this.accessToken)) {
                    for (i = 0; i < this.getListSize(this.accessToken); ++i) {
                        map.put("access_token[" + i + "]", this.getFromList(this.accessToken, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_ACCESS_TOKEN, JSON.getDefault().getMapper().writeValueAsString((Object)this.accessToken));
                }
            }
            if (this.tokenType != null) {
                if (this.isFileTypeOrListOfFiles(this.tokenType)) {
                    fileTypeFound = true;
                }
                if (this.tokenType.getClass().equals(File.class) || this.tokenType.getClass().equals(Integer.class) || this.tokenType.getClass().equals(String.class) || this.tokenType.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_TOKEN_TYPE, this.tokenType);
                } else if (this.isListOfFile(this.tokenType)) {
                    for (i = 0; i < this.getListSize(this.tokenType); ++i) {
                        map.put("token_type[" + i + "]", this.getFromList(this.tokenType, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_TOKEN_TYPE, JSON.getDefault().getMapper().writeValueAsString((Object)this.tokenType));
                }
            }
            if (this.refreshToken != null) {
                if (this.isFileTypeOrListOfFiles(this.refreshToken)) {
                    fileTypeFound = true;
                }
                if (this.refreshToken.getClass().equals(File.class) || this.refreshToken.getClass().equals(Integer.class) || this.refreshToken.getClass().equals(String.class) || this.refreshToken.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_REFRESH_TOKEN, this.refreshToken);
                } else if (this.isListOfFile(this.refreshToken)) {
                    for (i = 0; i < this.getListSize(this.refreshToken); ++i) {
                        map.put("refresh_token[" + i + "]", this.getFromList(this.refreshToken, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_REFRESH_TOKEN, JSON.getDefault().getMapper().writeValueAsString((Object)this.refreshToken));
                }
            }
            if (this.expiresIn != null) {
                if (this.isFileTypeOrListOfFiles(this.expiresIn)) {
                    fileTypeFound = true;
                }
                if (this.expiresIn.getClass().equals(File.class) || this.expiresIn.getClass().equals(Integer.class) || this.expiresIn.getClass().equals(String.class) || this.expiresIn.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_EXPIRES_IN, this.expiresIn);
                } else if (this.isListOfFile(this.expiresIn)) {
                    for (i = 0; i < this.getListSize(this.expiresIn); ++i) {
                        map.put("expires_in[" + i + "]", this.getFromList(this.expiresIn, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_EXPIRES_IN, JSON.getDefault().getMapper().writeValueAsString((Object)this.expiresIn));
                }
            }
            if (this.state != null) {
                if (this.isFileTypeOrListOfFiles(this.state)) {
                    fileTypeFound = true;
                }
                if (this.state.getClass().equals(File.class) || this.state.getClass().equals(Integer.class) || this.state.getClass().equals(String.class) || this.state.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_STATE, this.state);
                } else if (this.isListOfFile(this.state)) {
                    for (i = 0; i < this.getListSize(this.state); ++i) {
                        map.put("state[" + i + "]", this.getFromList(this.state, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_STATE, JSON.getDefault().getMapper().writeValueAsString((Object)this.state));
                }
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return fileTypeFound ? map : new HashMap<String, Object>();
    }

    private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
        return obj.getClass().equals(File.class) || this.isListOfFile(obj);
    }

    private boolean isListOfFile(Object obj) throws Exception {
        return obj instanceof List && !this.isListEmpty(obj) && this.getFromList(obj, 0) instanceof File;
    }

    private boolean isListEmpty(Object obj) throws Exception {
        return (Boolean)Class.forName(List.class.getName()).getMethod("isEmpty", new Class[0]).invoke(obj, new Object[0]);
    }

    private Object getFromList(Object obj, int index) throws Exception {
        return Class.forName(List.class.getName()).getMethod("get", Integer.TYPE).invoke(obj, index);
    }

    private int getListSize(Object obj) throws Exception {
        return (Integer)Class.forName(List.class.getName()).getMethod("size", new Class[0]).invoke(obj, new Object[0]);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

