/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.model;

import com.dropbox.sign.ApiException;
import com.dropbox.sign.JSON;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"grant_type", "refresh_token", "client_id", "client_secret"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class OAuthTokenRefreshRequest {
    public static final String JSON_PROPERTY_GRANT_TYPE = "grant_type";
    private String grantType = "refresh_token";
    public static final String JSON_PROPERTY_REFRESH_TOKEN = "refresh_token";
    private String refreshToken;
    public static final String JSON_PROPERTY_CLIENT_ID = "client_id";
    private String clientId;
    public static final String JSON_PROPERTY_CLIENT_SECRET = "client_secret";
    private String clientSecret;

    public static OAuthTokenRefreshRequest init(String jsonData) throws Exception {
        return (OAuthTokenRefreshRequest)new ObjectMapper().readValue(jsonData, OAuthTokenRefreshRequest.class);
    }

    public static OAuthTokenRefreshRequest init(HashMap data) throws Exception {
        return (OAuthTokenRefreshRequest)new ObjectMapper().readValue(new ObjectMapper().writeValueAsString((Object)data), OAuthTokenRefreshRequest.class);
    }

    public OAuthTokenRefreshRequest grantType(String grantType) {
        this.grantType = grantType;
        return this;
    }

    @Nonnull
    @JsonProperty(value="grant_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getGrantType() {
        return this.grantType;
    }

    @JsonProperty(value="grant_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setGrantType(String grantType) {
        this.grantType = grantType;
    }

    public OAuthTokenRefreshRequest refreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
        return this;
    }

    @Nonnull
    @JsonProperty(value="refresh_token")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRefreshToken() {
        return this.refreshToken;
    }

    @JsonProperty(value="refresh_token")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public OAuthTokenRefreshRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @JsonProperty(value="client_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getClientId() {
        return this.clientId;
    }

    @JsonProperty(value="client_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public OAuthTokenRefreshRequest clientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    @Nullable
    @JsonProperty(value="client_secret")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getClientSecret() {
        return this.clientSecret;
    }

    @JsonProperty(value="client_secret")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuthTokenRefreshRequest oauthTokenRefreshRequest = (OAuthTokenRefreshRequest)o;
        return Objects.equals(this.grantType, oauthTokenRefreshRequest.grantType) && Objects.equals(this.refreshToken, oauthTokenRefreshRequest.refreshToken) && Objects.equals(this.clientId, oauthTokenRefreshRequest.clientId) && Objects.equals(this.clientSecret, oauthTokenRefreshRequest.clientSecret);
    }

    public int hashCode() {
        return Objects.hash(this.grantType, this.refreshToken, this.clientId, this.clientSecret);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OAuthTokenRefreshRequest {\n");
        sb.append("    grantType: ").append(this.toIndentedString(this.grantType)).append("\n");
        sb.append("    refreshToken: ").append(this.toIndentedString(this.refreshToken)).append("\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    clientSecret: ").append(this.toIndentedString(this.clientSecret)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public Map<String, Object> createFormData() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean fileTypeFound = false;
        try {
            int i;
            if (this.grantType != null) {
                if (this.isFileTypeOrListOfFiles(this.grantType)) {
                    fileTypeFound = true;
                }
                if (this.grantType.getClass().equals(File.class) || this.grantType.getClass().equals(Integer.class) || this.grantType.getClass().equals(String.class) || this.grantType.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_GRANT_TYPE, this.grantType);
                } else if (this.isListOfFile(this.grantType)) {
                    for (i = 0; i < this.getListSize(this.grantType); ++i) {
                        map.put("grant_type[" + i + "]", this.getFromList(this.grantType, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_GRANT_TYPE, JSON.getDefault().getMapper().writeValueAsString((Object)this.grantType));
                }
            }
            if (this.refreshToken != null) {
                if (this.isFileTypeOrListOfFiles(this.refreshToken)) {
                    fileTypeFound = true;
                }
                if (this.refreshToken.getClass().equals(File.class) || this.refreshToken.getClass().equals(Integer.class) || this.refreshToken.getClass().equals(String.class) || this.refreshToken.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_REFRESH_TOKEN, this.refreshToken);
                } else if (this.isListOfFile(this.refreshToken)) {
                    for (i = 0; i < this.getListSize(this.refreshToken); ++i) {
                        map.put("refresh_token[" + i + "]", this.getFromList(this.refreshToken, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_REFRESH_TOKEN, JSON.getDefault().getMapper().writeValueAsString((Object)this.refreshToken));
                }
            }
            if (this.clientId != null) {
                if (this.isFileTypeOrListOfFiles(this.clientId)) {
                    fileTypeFound = true;
                }
                if (this.clientId.getClass().equals(File.class) || this.clientId.getClass().equals(Integer.class) || this.clientId.getClass().equals(String.class) || this.clientId.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_CLIENT_ID, this.clientId);
                } else if (this.isListOfFile(this.clientId)) {
                    for (i = 0; i < this.getListSize(this.clientId); ++i) {
                        map.put("client_id[" + i + "]", this.getFromList(this.clientId, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_CLIENT_ID, JSON.getDefault().getMapper().writeValueAsString((Object)this.clientId));
                }
            }
            if (this.clientSecret != null) {
                if (this.isFileTypeOrListOfFiles(this.clientSecret)) {
                    fileTypeFound = true;
                }
                if (this.clientSecret.getClass().equals(File.class) || this.clientSecret.getClass().equals(Integer.class) || this.clientSecret.getClass().equals(String.class) || this.clientSecret.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_CLIENT_SECRET, this.clientSecret);
                } else if (this.isListOfFile(this.clientSecret)) {
                    for (i = 0; i < this.getListSize(this.clientSecret); ++i) {
                        map.put("client_secret[" + i + "]", this.getFromList(this.clientSecret, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_CLIENT_SECRET, JSON.getDefault().getMapper().writeValueAsString((Object)this.clientSecret));
                }
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return fileTypeFound ? map : new HashMap<String, Object>();
    }

    private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
        return obj.getClass().equals(File.class) || this.isListOfFile(obj);
    }

    private boolean isListOfFile(Object obj) throws Exception {
        return obj instanceof List && !this.isListEmpty(obj) && this.getFromList(obj, 0) instanceof File;
    }

    private boolean isListEmpty(Object obj) throws Exception {
        return (Boolean)Class.forName(List.class.getName()).getMethod("isEmpty", new Class[0]).invoke(obj, new Object[0]);
    }

    private Object getFromList(Object obj, int index) throws Exception {
        return Class.forName(List.class.getName()).getMethod("get", Integer.TYPE).invoke(obj, index);
    }

    private int getListSize(Object obj) throws Exception {
        return (Integer)Class.forName(List.class.getName()).getMethod("size", new Class[0]).invoke(obj, new Object[0]);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

