/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.model;

import com.dropbox.sign.ApiException;
import com.dropbox.sign.JSON;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nullable;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"num_pages", "num_results", "page", "page_size"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class ListInfoResponse {
    public static final String JSON_PROPERTY_NUM_PAGES = "num_pages";
    private Integer numPages;
    public static final String JSON_PROPERTY_NUM_RESULTS = "num_results";
    private Integer numResults;
    public static final String JSON_PROPERTY_PAGE = "page";
    private Integer page;
    public static final String JSON_PROPERTY_PAGE_SIZE = "page_size";
    private Integer pageSize;

    public static ListInfoResponse init(String jsonData) throws Exception {
        return (ListInfoResponse)new ObjectMapper().readValue(jsonData, ListInfoResponse.class);
    }

    public static ListInfoResponse init(HashMap data) throws Exception {
        return (ListInfoResponse)new ObjectMapper().readValue(new ObjectMapper().writeValueAsString((Object)data), ListInfoResponse.class);
    }

    public ListInfoResponse numPages(Integer numPages) {
        this.numPages = numPages;
        return this;
    }

    @Nullable
    @JsonProperty(value="num_pages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getNumPages() {
        return this.numPages;
    }

    @JsonProperty(value="num_pages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNumPages(Integer numPages) {
        this.numPages = numPages;
    }

    public ListInfoResponse numResults(Integer numResults) {
        this.numResults = numResults;
        return this;
    }

    @Nullable
    @JsonProperty(value="num_results")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getNumResults() {
        return this.numResults;
    }

    @JsonProperty(value="num_results")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNumResults(Integer numResults) {
        this.numResults = numResults;
    }

    public ListInfoResponse page(Integer page) {
        this.page = page;
        return this;
    }

    @Nullable
    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getPage() {
        return this.page;
    }

    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPage(Integer page) {
        this.page = page;
    }

    public ListInfoResponse pageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Nullable
    @JsonProperty(value="page_size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getPageSize() {
        return this.pageSize;
    }

    @JsonProperty(value="page_size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListInfoResponse listInfoResponse = (ListInfoResponse)o;
        return Objects.equals(this.numPages, listInfoResponse.numPages) && Objects.equals(this.numResults, listInfoResponse.numResults) && Objects.equals(this.page, listInfoResponse.page) && Objects.equals(this.pageSize, listInfoResponse.pageSize);
    }

    public int hashCode() {
        return Objects.hash(this.numPages, this.numResults, this.page, this.pageSize);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListInfoResponse {\n");
        sb.append("    numPages: ").append(this.toIndentedString(this.numPages)).append("\n");
        sb.append("    numResults: ").append(this.toIndentedString(this.numResults)).append("\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("    pageSize: ").append(this.toIndentedString(this.pageSize)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public Map<String, Object> createFormData() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean fileTypeFound = false;
        try {
            int i;
            if (this.numPages != null) {
                if (this.isFileTypeOrListOfFiles(this.numPages)) {
                    fileTypeFound = true;
                }
                if (this.numPages.getClass().equals(File.class) || this.numPages.getClass().equals(Integer.class) || this.numPages.getClass().equals(String.class) || this.numPages.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_NUM_PAGES, this.numPages);
                } else if (this.isListOfFile(this.numPages)) {
                    for (i = 0; i < this.getListSize(this.numPages); ++i) {
                        map.put("num_pages[" + i + "]", this.getFromList(this.numPages, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_NUM_PAGES, JSON.getDefault().getMapper().writeValueAsString((Object)this.numPages));
                }
            }
            if (this.numResults != null) {
                if (this.isFileTypeOrListOfFiles(this.numResults)) {
                    fileTypeFound = true;
                }
                if (this.numResults.getClass().equals(File.class) || this.numResults.getClass().equals(Integer.class) || this.numResults.getClass().equals(String.class) || this.numResults.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_NUM_RESULTS, this.numResults);
                } else if (this.isListOfFile(this.numResults)) {
                    for (i = 0; i < this.getListSize(this.numResults); ++i) {
                        map.put("num_results[" + i + "]", this.getFromList(this.numResults, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_NUM_RESULTS, JSON.getDefault().getMapper().writeValueAsString((Object)this.numResults));
                }
            }
            if (this.page != null) {
                if (this.isFileTypeOrListOfFiles(this.page)) {
                    fileTypeFound = true;
                }
                if (this.page.getClass().equals(File.class) || this.page.getClass().equals(Integer.class) || this.page.getClass().equals(String.class) || this.page.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_PAGE, this.page);
                } else if (this.isListOfFile(this.page)) {
                    for (i = 0; i < this.getListSize(this.page); ++i) {
                        map.put("page[" + i + "]", this.getFromList(this.page, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_PAGE, JSON.getDefault().getMapper().writeValueAsString((Object)this.page));
                }
            }
            if (this.pageSize != null) {
                if (this.isFileTypeOrListOfFiles(this.pageSize)) {
                    fileTypeFound = true;
                }
                if (this.pageSize.getClass().equals(File.class) || this.pageSize.getClass().equals(Integer.class) || this.pageSize.getClass().equals(String.class) || this.pageSize.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_PAGE_SIZE, this.pageSize);
                } else if (this.isListOfFile(this.pageSize)) {
                    for (i = 0; i < this.getListSize(this.pageSize); ++i) {
                        map.put("page_size[" + i + "]", this.getFromList(this.pageSize, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_PAGE_SIZE, JSON.getDefault().getMapper().writeValueAsString((Object)this.pageSize));
                }
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return fileTypeFound ? map : new HashMap<String, Object>();
    }

    private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
        return obj.getClass().equals(File.class) || this.isListOfFile(obj);
    }

    private boolean isListOfFile(Object obj) throws Exception {
        return obj instanceof List && !this.isListEmpty(obj) && this.getFromList(obj, 0) instanceof File;
    }

    private boolean isListEmpty(Object obj) throws Exception {
        return (Boolean)Class.forName(List.class.getName()).getMethod("isEmpty", new Class[0]).invoke(obj, new Object[0]);
    }

    private Object getFromList(Object obj, int index) throws Exception {
        return Class.forName(List.class.getName()).getMethod("get", Integer.TYPE).invoke(obj, index);
    }

    private int getListSize(Object obj) throws Exception {
        return (Integer)Class.forName(List.class.getName()).getMethod("size", new Class[0]).invoke(obj, new Object[0]);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

