/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.model;

import com.dropbox.sign.ApiException;
import com.dropbox.sign.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"recipient", "status_code", "sent_at"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class FaxResponseTransmission {
    public static final String JSON_PROPERTY_RECIPIENT = "recipient";
    private String recipient;
    public static final String JSON_PROPERTY_STATUS_CODE = "status_code";
    private StatusCodeEnum statusCode;
    public static final String JSON_PROPERTY_SENT_AT = "sent_at";
    private Integer sentAt;

    public static FaxResponseTransmission init(String jsonData) throws Exception {
        return (FaxResponseTransmission)new ObjectMapper().readValue(jsonData, FaxResponseTransmission.class);
    }

    public static FaxResponseTransmission init(HashMap data) throws Exception {
        return (FaxResponseTransmission)new ObjectMapper().readValue(new ObjectMapper().writeValueAsString((Object)data), FaxResponseTransmission.class);
    }

    public FaxResponseTransmission recipient(String recipient) {
        this.recipient = recipient;
        return this;
    }

    @Nonnull
    @JsonProperty(value="recipient")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRecipient() {
        return this.recipient;
    }

    @JsonProperty(value="recipient")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    public FaxResponseTransmission statusCode(StatusCodeEnum statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    @Nonnull
    @JsonProperty(value="status_code")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public StatusCodeEnum getStatusCode() {
        return this.statusCode;
    }

    @JsonProperty(value="status_code")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStatusCode(StatusCodeEnum statusCode) {
        this.statusCode = statusCode;
    }

    public FaxResponseTransmission sentAt(Integer sentAt) {
        this.sentAt = sentAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="sent_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSentAt() {
        return this.sentAt;
    }

    @JsonProperty(value="sent_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSentAt(Integer sentAt) {
        this.sentAt = sentAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FaxResponseTransmission faxResponseTransmission = (FaxResponseTransmission)o;
        return Objects.equals(this.recipient, faxResponseTransmission.recipient) && Objects.equals((Object)this.statusCode, (Object)faxResponseTransmission.statusCode) && Objects.equals(this.sentAt, faxResponseTransmission.sentAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.recipient, this.statusCode, this.sentAt});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FaxResponseTransmission {\n");
        sb.append("    recipient: ").append(this.toIndentedString(this.recipient)).append("\n");
        sb.append("    statusCode: ").append(this.toIndentedString((Object)this.statusCode)).append("\n");
        sb.append("    sentAt: ").append(this.toIndentedString(this.sentAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public Map<String, Object> createFormData() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean fileTypeFound = false;
        try {
            int i;
            if (this.recipient != null) {
                if (this.isFileTypeOrListOfFiles(this.recipient)) {
                    fileTypeFound = true;
                }
                if (this.recipient.getClass().equals(File.class) || this.recipient.getClass().equals(Integer.class) || this.recipient.getClass().equals(String.class) || this.recipient.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_RECIPIENT, this.recipient);
                } else if (this.isListOfFile(this.recipient)) {
                    for (i = 0; i < this.getListSize(this.recipient); ++i) {
                        map.put("recipient[" + i + "]", this.getFromList(this.recipient, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_RECIPIENT, JSON.getDefault().getMapper().writeValueAsString((Object)this.recipient));
                }
            }
            if (this.statusCode != null) {
                if (this.isFileTypeOrListOfFiles((Object)this.statusCode)) {
                    fileTypeFound = true;
                }
                if (((Object)((Object)this.statusCode)).getClass().equals(File.class) || ((Object)((Object)this.statusCode)).getClass().equals(Integer.class) || ((Object)((Object)this.statusCode)).getClass().equals(String.class) || ((Object)((Object)this.statusCode)).getClass().isEnum()) {
                    map.put(JSON_PROPERTY_STATUS_CODE, (Object)this.statusCode);
                } else if (this.isListOfFile((Object)this.statusCode)) {
                    for (i = 0; i < this.getListSize((Object)this.statusCode); ++i) {
                        map.put("status_code[" + i + "]", this.getFromList((Object)this.statusCode, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_STATUS_CODE, JSON.getDefault().getMapper().writeValueAsString((Object)this.statusCode));
                }
            }
            if (this.sentAt != null) {
                if (this.isFileTypeOrListOfFiles(this.sentAt)) {
                    fileTypeFound = true;
                }
                if (this.sentAt.getClass().equals(File.class) || this.sentAt.getClass().equals(Integer.class) || this.sentAt.getClass().equals(String.class) || this.sentAt.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_SENT_AT, this.sentAt);
                } else if (this.isListOfFile(this.sentAt)) {
                    for (i = 0; i < this.getListSize(this.sentAt); ++i) {
                        map.put("sent_at[" + i + "]", this.getFromList(this.sentAt, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_SENT_AT, JSON.getDefault().getMapper().writeValueAsString((Object)this.sentAt));
                }
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return fileTypeFound ? map : new HashMap<String, Object>();
    }

    private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
        return obj.getClass().equals(File.class) || this.isListOfFile(obj);
    }

    private boolean isListOfFile(Object obj) throws Exception {
        return obj instanceof List && !this.isListEmpty(obj) && this.getFromList(obj, 0) instanceof File;
    }

    private boolean isListEmpty(Object obj) throws Exception {
        return (Boolean)Class.forName(List.class.getName()).getMethod("isEmpty", new Class[0]).invoke(obj, new Object[0]);
    }

    private Object getFromList(Object obj, int index) throws Exception {
        return Class.forName(List.class.getName()).getMethod("get", Integer.TYPE).invoke(obj, index);
    }

    private int getListSize(Object obj) throws Exception {
        return (Integer)Class.forName(List.class.getName()).getMethod("size", new Class[0]).invoke(obj, new Object[0]);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusCodeEnum {
        SUCCESS("success"),
        TRANSMITTING("transmitting"),
        ERROR_COULD_NOT_FAX("error_could_not_fax"),
        ERROR_UNKNOWN("error_unknown"),
        ERROR_BUSY("error_busy"),
        ERROR_NO_ANSWER("error_no_answer"),
        ERROR_DISCONNECTED("error_disconnected"),
        ERROR_BAD_DESTINATION("error_bad_destination");

        private String value;

        private StatusCodeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusCodeEnum fromValue(String value) {
            for (StatusCodeEnum b : StatusCodeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

