/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.model;

import com.dropbox.sign.ApiException;
import com.dropbox.sign.JSON;
import com.dropbox.sign.model.FaxResponseTransmission;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"fax_id", "title", "original_title", "metadata", "created_at", "sender", "files_url", "transmissions", "subject", "message", "final_copy_uri"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class FaxResponse {
    public static final String JSON_PROPERTY_FAX_ID = "fax_id";
    private String faxId;
    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;
    public static final String JSON_PROPERTY_ORIGINAL_TITLE = "original_title";
    private String originalTitle;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private Map<String, Object> metadata = new HashMap<String, Object>();
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private Integer createdAt;
    public static final String JSON_PROPERTY_SENDER = "sender";
    private String sender;
    public static final String JSON_PROPERTY_FILES_URL = "files_url";
    private String filesUrl;
    public static final String JSON_PROPERTY_TRANSMISSIONS = "transmissions";
    private List<FaxResponseTransmission> transmissions = new ArrayList<FaxResponseTransmission>();
    public static final String JSON_PROPERTY_SUBJECT = "subject";
    private String subject;
    public static final String JSON_PROPERTY_MESSAGE = "message";
    private String message;
    public static final String JSON_PROPERTY_FINAL_COPY_URI = "final_copy_uri";
    private String finalCopyUri;

    public static FaxResponse init(String jsonData) throws Exception {
        return (FaxResponse)new ObjectMapper().readValue(jsonData, FaxResponse.class);
    }

    public static FaxResponse init(HashMap data) throws Exception {
        return (FaxResponse)new ObjectMapper().readValue(new ObjectMapper().writeValueAsString((Object)data), FaxResponse.class);
    }

    public FaxResponse faxId(String faxId) {
        this.faxId = faxId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="fax_id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getFaxId() {
        return this.faxId;
    }

    @JsonProperty(value="fax_id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFaxId(String faxId) {
        this.faxId = faxId;
    }

    public FaxResponse title(String title) {
        this.title = title;
        return this;
    }

    @Nonnull
    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTitle(String title) {
        this.title = title;
    }

    public FaxResponse originalTitle(String originalTitle) {
        this.originalTitle = originalTitle;
        return this;
    }

    @Nonnull
    @JsonProperty(value="original_title")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getOriginalTitle() {
        return this.originalTitle;
    }

    @JsonProperty(value="original_title")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOriginalTitle(String originalTitle) {
        this.originalTitle = originalTitle;
    }

    public FaxResponse metadata(Map<String, Object> metadata) {
        this.metadata = metadata;
        return this;
    }

    public FaxResponse putMetadataItem(String key, Object metadataItem) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, Object>();
        }
        this.metadata.put(key, metadataItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="metadata")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.ALWAYS)
    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.ALWAYS)
    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public FaxResponse createdAt(Integer createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nonnull
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCreatedAt(Integer createdAt) {
        this.createdAt = createdAt;
    }

    public FaxResponse sender(String sender) {
        this.sender = sender;
        return this;
    }

    @Nonnull
    @JsonProperty(value="sender")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSender() {
        return this.sender;
    }

    @JsonProperty(value="sender")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSender(String sender) {
        this.sender = sender;
    }

    public FaxResponse filesUrl(String filesUrl) {
        this.filesUrl = filesUrl;
        return this;
    }

    @Nonnull
    @JsonProperty(value="files_url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getFilesUrl() {
        return this.filesUrl;
    }

    @JsonProperty(value="files_url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFilesUrl(String filesUrl) {
        this.filesUrl = filesUrl;
    }

    public FaxResponse transmissions(List<FaxResponseTransmission> transmissions) {
        this.transmissions = transmissions;
        return this;
    }

    public FaxResponse addTransmissionsItem(FaxResponseTransmission transmissionsItem) {
        if (this.transmissions == null) {
            this.transmissions = new ArrayList<FaxResponseTransmission>();
        }
        this.transmissions.add(transmissionsItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="transmissions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<FaxResponseTransmission> getTransmissions() {
        return this.transmissions;
    }

    @JsonProperty(value="transmissions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTransmissions(List<FaxResponseTransmission> transmissions) {
        this.transmissions = transmissions;
    }

    public FaxResponse subject(String subject) {
        this.subject = subject;
        return this;
    }

    @Nullable
    @JsonProperty(value="subject")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSubject() {
        return this.subject;
    }

    @JsonProperty(value="subject")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSubject(String subject) {
        this.subject = subject;
    }

    public FaxResponse message(String message) {
        this.message = message;
        return this;
    }

    @Nullable
    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMessage() {
        return this.message;
    }

    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMessage(String message) {
        this.message = message;
    }

    public FaxResponse finalCopyUri(String finalCopyUri) {
        this.finalCopyUri = finalCopyUri;
        return this;
    }

    @Nullable
    @JsonProperty(value="final_copy_uri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFinalCopyUri() {
        return this.finalCopyUri;
    }

    @JsonProperty(value="final_copy_uri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFinalCopyUri(String finalCopyUri) {
        this.finalCopyUri = finalCopyUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FaxResponse faxResponse = (FaxResponse)o;
        return Objects.equals(this.faxId, faxResponse.faxId) && Objects.equals(this.title, faxResponse.title) && Objects.equals(this.originalTitle, faxResponse.originalTitle) && Objects.equals(this.metadata, faxResponse.metadata) && Objects.equals(this.createdAt, faxResponse.createdAt) && Objects.equals(this.sender, faxResponse.sender) && Objects.equals(this.filesUrl, faxResponse.filesUrl) && Objects.equals(this.transmissions, faxResponse.transmissions) && Objects.equals(this.subject, faxResponse.subject) && Objects.equals(this.message, faxResponse.message) && Objects.equals(this.finalCopyUri, faxResponse.finalCopyUri);
    }

    public int hashCode() {
        return Objects.hash(this.faxId, this.title, this.originalTitle, this.metadata, this.createdAt, this.sender, this.filesUrl, this.transmissions, this.subject, this.message, this.finalCopyUri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FaxResponse {\n");
        sb.append("    faxId: ").append(this.toIndentedString(this.faxId)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    originalTitle: ").append(this.toIndentedString(this.originalTitle)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    sender: ").append(this.toIndentedString(this.sender)).append("\n");
        sb.append("    filesUrl: ").append(this.toIndentedString(this.filesUrl)).append("\n");
        sb.append("    transmissions: ").append(this.toIndentedString(this.transmissions)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    finalCopyUri: ").append(this.toIndentedString(this.finalCopyUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public Map<String, Object> createFormData() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean fileTypeFound = false;
        try {
            int i;
            if (this.faxId != null) {
                if (this.isFileTypeOrListOfFiles(this.faxId)) {
                    fileTypeFound = true;
                }
                if (this.faxId.getClass().equals(File.class) || this.faxId.getClass().equals(Integer.class) || this.faxId.getClass().equals(String.class) || this.faxId.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_FAX_ID, this.faxId);
                } else if (this.isListOfFile(this.faxId)) {
                    for (i = 0; i < this.getListSize(this.faxId); ++i) {
                        map.put("fax_id[" + i + "]", this.getFromList(this.faxId, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_FAX_ID, JSON.getDefault().getMapper().writeValueAsString((Object)this.faxId));
                }
            }
            if (this.title != null) {
                if (this.isFileTypeOrListOfFiles(this.title)) {
                    fileTypeFound = true;
                }
                if (this.title.getClass().equals(File.class) || this.title.getClass().equals(Integer.class) || this.title.getClass().equals(String.class) || this.title.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_TITLE, this.title);
                } else if (this.isListOfFile(this.title)) {
                    for (i = 0; i < this.getListSize(this.title); ++i) {
                        map.put("title[" + i + "]", this.getFromList(this.title, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_TITLE, JSON.getDefault().getMapper().writeValueAsString((Object)this.title));
                }
            }
            if (this.originalTitle != null) {
                if (this.isFileTypeOrListOfFiles(this.originalTitle)) {
                    fileTypeFound = true;
                }
                if (this.originalTitle.getClass().equals(File.class) || this.originalTitle.getClass().equals(Integer.class) || this.originalTitle.getClass().equals(String.class) || this.originalTitle.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_ORIGINAL_TITLE, this.originalTitle);
                } else if (this.isListOfFile(this.originalTitle)) {
                    for (i = 0; i < this.getListSize(this.originalTitle); ++i) {
                        map.put("original_title[" + i + "]", this.getFromList(this.originalTitle, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_ORIGINAL_TITLE, JSON.getDefault().getMapper().writeValueAsString((Object)this.originalTitle));
                }
            }
            if (this.metadata != null) {
                if (this.isFileTypeOrListOfFiles(this.metadata)) {
                    fileTypeFound = true;
                }
                if (this.metadata.getClass().equals(File.class) || this.metadata.getClass().equals(Integer.class) || this.metadata.getClass().equals(String.class) || this.metadata.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_METADATA, this.metadata);
                } else if (this.isListOfFile(this.metadata)) {
                    for (i = 0; i < this.getListSize(this.metadata); ++i) {
                        map.put("metadata[" + i + "]", this.getFromList(this.metadata, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_METADATA, JSON.getDefault().getMapper().writeValueAsString(this.metadata));
                }
            }
            if (this.createdAt != null) {
                if (this.isFileTypeOrListOfFiles(this.createdAt)) {
                    fileTypeFound = true;
                }
                if (this.createdAt.getClass().equals(File.class) || this.createdAt.getClass().equals(Integer.class) || this.createdAt.getClass().equals(String.class) || this.createdAt.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_CREATED_AT, this.createdAt);
                } else if (this.isListOfFile(this.createdAt)) {
                    for (i = 0; i < this.getListSize(this.createdAt); ++i) {
                        map.put("created_at[" + i + "]", this.getFromList(this.createdAt, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_CREATED_AT, JSON.getDefault().getMapper().writeValueAsString((Object)this.createdAt));
                }
            }
            if (this.sender != null) {
                if (this.isFileTypeOrListOfFiles(this.sender)) {
                    fileTypeFound = true;
                }
                if (this.sender.getClass().equals(File.class) || this.sender.getClass().equals(Integer.class) || this.sender.getClass().equals(String.class) || this.sender.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_SENDER, this.sender);
                } else if (this.isListOfFile(this.sender)) {
                    for (i = 0; i < this.getListSize(this.sender); ++i) {
                        map.put("sender[" + i + "]", this.getFromList(this.sender, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_SENDER, JSON.getDefault().getMapper().writeValueAsString((Object)this.sender));
                }
            }
            if (this.filesUrl != null) {
                if (this.isFileTypeOrListOfFiles(this.filesUrl)) {
                    fileTypeFound = true;
                }
                if (this.filesUrl.getClass().equals(File.class) || this.filesUrl.getClass().equals(Integer.class) || this.filesUrl.getClass().equals(String.class) || this.filesUrl.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_FILES_URL, this.filesUrl);
                } else if (this.isListOfFile(this.filesUrl)) {
                    for (i = 0; i < this.getListSize(this.filesUrl); ++i) {
                        map.put("files_url[" + i + "]", this.getFromList(this.filesUrl, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_FILES_URL, JSON.getDefault().getMapper().writeValueAsString((Object)this.filesUrl));
                }
            }
            if (this.transmissions != null) {
                if (this.isFileTypeOrListOfFiles(this.transmissions)) {
                    fileTypeFound = true;
                }
                if (this.transmissions.getClass().equals(File.class) || this.transmissions.getClass().equals(Integer.class) || this.transmissions.getClass().equals(String.class) || this.transmissions.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_TRANSMISSIONS, this.transmissions);
                } else if (this.isListOfFile(this.transmissions)) {
                    for (i = 0; i < this.getListSize(this.transmissions); ++i) {
                        map.put("transmissions[" + i + "]", this.getFromList(this.transmissions, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_TRANSMISSIONS, JSON.getDefault().getMapper().writeValueAsString(this.transmissions));
                }
            }
            if (this.subject != null) {
                if (this.isFileTypeOrListOfFiles(this.subject)) {
                    fileTypeFound = true;
                }
                if (this.subject.getClass().equals(File.class) || this.subject.getClass().equals(Integer.class) || this.subject.getClass().equals(String.class) || this.subject.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_SUBJECT, this.subject);
                } else if (this.isListOfFile(this.subject)) {
                    for (i = 0; i < this.getListSize(this.subject); ++i) {
                        map.put("subject[" + i + "]", this.getFromList(this.subject, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_SUBJECT, JSON.getDefault().getMapper().writeValueAsString((Object)this.subject));
                }
            }
            if (this.message != null) {
                if (this.isFileTypeOrListOfFiles(this.message)) {
                    fileTypeFound = true;
                }
                if (this.message.getClass().equals(File.class) || this.message.getClass().equals(Integer.class) || this.message.getClass().equals(String.class) || this.message.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_MESSAGE, this.message);
                } else if (this.isListOfFile(this.message)) {
                    for (i = 0; i < this.getListSize(this.message); ++i) {
                        map.put("message[" + i + "]", this.getFromList(this.message, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_MESSAGE, JSON.getDefault().getMapper().writeValueAsString((Object)this.message));
                }
            }
            if (this.finalCopyUri != null) {
                if (this.isFileTypeOrListOfFiles(this.finalCopyUri)) {
                    fileTypeFound = true;
                }
                if (this.finalCopyUri.getClass().equals(File.class) || this.finalCopyUri.getClass().equals(Integer.class) || this.finalCopyUri.getClass().equals(String.class) || this.finalCopyUri.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_FINAL_COPY_URI, this.finalCopyUri);
                } else if (this.isListOfFile(this.finalCopyUri)) {
                    for (i = 0; i < this.getListSize(this.finalCopyUri); ++i) {
                        map.put("final_copy_uri[" + i + "]", this.getFromList(this.finalCopyUri, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_FINAL_COPY_URI, JSON.getDefault().getMapper().writeValueAsString((Object)this.finalCopyUri));
                }
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return fileTypeFound ? map : new HashMap<String, Object>();
    }

    private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
        return obj.getClass().equals(File.class) || this.isListOfFile(obj);
    }

    private boolean isListOfFile(Object obj) throws Exception {
        return obj instanceof List && !this.isListEmpty(obj) && this.getFromList(obj, 0) instanceof File;
    }

    private boolean isListEmpty(Object obj) throws Exception {
        return (Boolean)Class.forName(List.class.getName()).getMethod("isEmpty", new Class[0]).invoke(obj, new Object[0]);
    }

    private Object getFromList(Object obj, int index) throws Exception {
        return Class.forName(List.class.getName()).getMethod("get", Integer.TYPE).invoke(obj, index);
    }

    private int getListSize(Object obj) throws Exception {
        return (Integer)Class.forName(List.class.getName()).getMethod("size", new Class[0]).invoke(obj, new Object[0]);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

