/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.model;

import com.dropbox.sign.ApiException;
import com.dropbox.sign.JSON;
import com.dropbox.sign.model.FaxResponse;
import com.dropbox.sign.model.ListInfoResponse;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"faxes", "list_info"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class FaxListResponse {
    public static final String JSON_PROPERTY_FAXES = "faxes";
    private List<FaxResponse> faxes = new ArrayList<FaxResponse>();
    public static final String JSON_PROPERTY_LIST_INFO = "list_info";
    private ListInfoResponse listInfo;

    public static FaxListResponse init(String jsonData) throws Exception {
        return (FaxListResponse)new ObjectMapper().readValue(jsonData, FaxListResponse.class);
    }

    public static FaxListResponse init(HashMap data) throws Exception {
        return (FaxListResponse)new ObjectMapper().readValue(new ObjectMapper().writeValueAsString((Object)data), FaxListResponse.class);
    }

    public FaxListResponse faxes(List<FaxResponse> faxes) {
        this.faxes = faxes;
        return this;
    }

    public FaxListResponse addFaxesItem(FaxResponse faxesItem) {
        if (this.faxes == null) {
            this.faxes = new ArrayList<FaxResponse>();
        }
        this.faxes.add(faxesItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="faxes")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<FaxResponse> getFaxes() {
        return this.faxes;
    }

    @JsonProperty(value="faxes")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFaxes(List<FaxResponse> faxes) {
        this.faxes = faxes;
    }

    public FaxListResponse listInfo(ListInfoResponse listInfo) {
        this.listInfo = listInfo;
        return this;
    }

    @Nonnull
    @JsonProperty(value="list_info")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ListInfoResponse getListInfo() {
        return this.listInfo;
    }

    @JsonProperty(value="list_info")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setListInfo(ListInfoResponse listInfo) {
        this.listInfo = listInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FaxListResponse faxListResponse = (FaxListResponse)o;
        return Objects.equals(this.faxes, faxListResponse.faxes) && Objects.equals(this.listInfo, faxListResponse.listInfo);
    }

    public int hashCode() {
        return Objects.hash(this.faxes, this.listInfo);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FaxListResponse {\n");
        sb.append("    faxes: ").append(this.toIndentedString(this.faxes)).append("\n");
        sb.append("    listInfo: ").append(this.toIndentedString(this.listInfo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public Map<String, Object> createFormData() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean fileTypeFound = false;
        try {
            int i;
            if (this.faxes != null) {
                if (this.isFileTypeOrListOfFiles(this.faxes)) {
                    fileTypeFound = true;
                }
                if (this.faxes.getClass().equals(File.class) || this.faxes.getClass().equals(Integer.class) || this.faxes.getClass().equals(String.class) || this.faxes.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_FAXES, this.faxes);
                } else if (this.isListOfFile(this.faxes)) {
                    for (i = 0; i < this.getListSize(this.faxes); ++i) {
                        map.put("faxes[" + i + "]", this.getFromList(this.faxes, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_FAXES, JSON.getDefault().getMapper().writeValueAsString(this.faxes));
                }
            }
            if (this.listInfo != null) {
                if (this.isFileTypeOrListOfFiles(this.listInfo)) {
                    fileTypeFound = true;
                }
                if (this.listInfo.getClass().equals(File.class) || this.listInfo.getClass().equals(Integer.class) || this.listInfo.getClass().equals(String.class) || this.listInfo.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_LIST_INFO, this.listInfo);
                } else if (this.isListOfFile(this.listInfo)) {
                    for (i = 0; i < this.getListSize(this.listInfo); ++i) {
                        map.put("list_info[" + i + "]", this.getFromList(this.listInfo, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_LIST_INFO, JSON.getDefault().getMapper().writeValueAsString((Object)this.listInfo));
                }
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return fileTypeFound ? map : new HashMap<String, Object>();
    }

    private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
        return obj.getClass().equals(File.class) || this.isListOfFile(obj);
    }

    private boolean isListOfFile(Object obj) throws Exception {
        return obj instanceof List && !this.isListEmpty(obj) && this.getFromList(obj, 0) instanceof File;
    }

    private boolean isListEmpty(Object obj) throws Exception {
        return (Boolean)Class.forName(List.class.getName()).getMethod("isEmpty", new Class[0]).invoke(obj, new Object[0]);
    }

    private Object getFromList(Object obj, int index) throws Exception {
        return Class.forName(List.class.getName()).getMethod("get", Integer.TYPE).invoke(obj, index);
    }

    private int getListSize(Object obj) throws Exception {
        return (Integer)Class.forName(List.class.getName()).getMethod("size", new Class[0]).invoke(obj, new Object[0]);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

