/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.model;

import com.dropbox.sign.ApiException;
import com.dropbox.sign.JSON;
import com.dropbox.sign.model.FaxLineResponseFaxLine;
import com.dropbox.sign.model.ListInfoResponse;
import com.dropbox.sign.model.WarningResponse;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"list_info", "fax_lines", "warnings"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class FaxLineListResponse {
    public static final String JSON_PROPERTY_LIST_INFO = "list_info";
    private ListInfoResponse listInfo;
    public static final String JSON_PROPERTY_FAX_LINES = "fax_lines";
    private List<FaxLineResponseFaxLine> faxLines = new ArrayList<FaxLineResponseFaxLine>();
    public static final String JSON_PROPERTY_WARNINGS = "warnings";
    private WarningResponse warnings;

    public static FaxLineListResponse init(String jsonData) throws Exception {
        return (FaxLineListResponse)new ObjectMapper().readValue(jsonData, FaxLineListResponse.class);
    }

    public static FaxLineListResponse init(HashMap data) throws Exception {
        return (FaxLineListResponse)new ObjectMapper().readValue(new ObjectMapper().writeValueAsString((Object)data), FaxLineListResponse.class);
    }

    public FaxLineListResponse listInfo(ListInfoResponse listInfo) {
        this.listInfo = listInfo;
        return this;
    }

    @Nonnull
    @JsonProperty(value="list_info")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ListInfoResponse getListInfo() {
        return this.listInfo;
    }

    @JsonProperty(value="list_info")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setListInfo(ListInfoResponse listInfo) {
        this.listInfo = listInfo;
    }

    public FaxLineListResponse faxLines(List<FaxLineResponseFaxLine> faxLines) {
        this.faxLines = faxLines;
        return this;
    }

    public FaxLineListResponse addFaxLinesItem(FaxLineResponseFaxLine faxLinesItem) {
        if (this.faxLines == null) {
            this.faxLines = new ArrayList<FaxLineResponseFaxLine>();
        }
        this.faxLines.add(faxLinesItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="fax_lines")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<FaxLineResponseFaxLine> getFaxLines() {
        return this.faxLines;
    }

    @JsonProperty(value="fax_lines")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFaxLines(List<FaxLineResponseFaxLine> faxLines) {
        this.faxLines = faxLines;
    }

    public FaxLineListResponse warnings(WarningResponse warnings) {
        this.warnings = warnings;
        return this;
    }

    @Nullable
    @JsonProperty(value="warnings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WarningResponse getWarnings() {
        return this.warnings;
    }

    @JsonProperty(value="warnings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWarnings(WarningResponse warnings) {
        this.warnings = warnings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FaxLineListResponse faxLineListResponse = (FaxLineListResponse)o;
        return Objects.equals(this.listInfo, faxLineListResponse.listInfo) && Objects.equals(this.faxLines, faxLineListResponse.faxLines) && Objects.equals(this.warnings, faxLineListResponse.warnings);
    }

    public int hashCode() {
        return Objects.hash(this.listInfo, this.faxLines, this.warnings);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FaxLineListResponse {\n");
        sb.append("    listInfo: ").append(this.toIndentedString(this.listInfo)).append("\n");
        sb.append("    faxLines: ").append(this.toIndentedString(this.faxLines)).append("\n");
        sb.append("    warnings: ").append(this.toIndentedString(this.warnings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public Map<String, Object> createFormData() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean fileTypeFound = false;
        try {
            int i;
            if (this.listInfo != null) {
                if (this.isFileTypeOrListOfFiles(this.listInfo)) {
                    fileTypeFound = true;
                }
                if (this.listInfo.getClass().equals(File.class) || this.listInfo.getClass().equals(Integer.class) || this.listInfo.getClass().equals(String.class) || this.listInfo.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_LIST_INFO, this.listInfo);
                } else if (this.isListOfFile(this.listInfo)) {
                    for (i = 0; i < this.getListSize(this.listInfo); ++i) {
                        map.put("list_info[" + i + "]", this.getFromList(this.listInfo, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_LIST_INFO, JSON.getDefault().getMapper().writeValueAsString((Object)this.listInfo));
                }
            }
            if (this.faxLines != null) {
                if (this.isFileTypeOrListOfFiles(this.faxLines)) {
                    fileTypeFound = true;
                }
                if (this.faxLines.getClass().equals(File.class) || this.faxLines.getClass().equals(Integer.class) || this.faxLines.getClass().equals(String.class) || this.faxLines.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_FAX_LINES, this.faxLines);
                } else if (this.isListOfFile(this.faxLines)) {
                    for (i = 0; i < this.getListSize(this.faxLines); ++i) {
                        map.put("fax_lines[" + i + "]", this.getFromList(this.faxLines, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_FAX_LINES, JSON.getDefault().getMapper().writeValueAsString(this.faxLines));
                }
            }
            if (this.warnings != null) {
                if (this.isFileTypeOrListOfFiles(this.warnings)) {
                    fileTypeFound = true;
                }
                if (this.warnings.getClass().equals(File.class) || this.warnings.getClass().equals(Integer.class) || this.warnings.getClass().equals(String.class) || this.warnings.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_WARNINGS, this.warnings);
                } else if (this.isListOfFile(this.warnings)) {
                    for (i = 0; i < this.getListSize(this.warnings); ++i) {
                        map.put("warnings[" + i + "]", this.getFromList(this.warnings, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_WARNINGS, JSON.getDefault().getMapper().writeValueAsString((Object)this.warnings));
                }
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return fileTypeFound ? map : new HashMap<String, Object>();
    }

    private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
        return obj.getClass().equals(File.class) || this.isListOfFile(obj);
    }

    private boolean isListOfFile(Object obj) throws Exception {
        return obj instanceof List && !this.isListEmpty(obj) && this.getFromList(obj, 0) instanceof File;
    }

    private boolean isListEmpty(Object obj) throws Exception {
        return (Boolean)Class.forName(List.class.getName()).getMethod("isEmpty", new Class[0]).invoke(obj, new Object[0]);
    }

    private Object getFromList(Object obj, int index) throws Exception {
        return Class.forName(List.class.getName()).getMethod("get", Integer.TYPE).invoke(obj, index);
    }

    private int getListSize(Object obj) throws Exception {
        return (Integer)Class.forName(List.class.getName()).getMethod("size", new Class[0]).invoke(obj, new Object[0]);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

