/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.model;

import com.dropbox.sign.ApiException;
import com.dropbox.sign.JSON;
import com.dropbox.sign.model.EventCallbackRequestEventMetadata;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"event_time", "event_type", "event_hash", "event_metadata"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class EventCallbackRequestEvent {
    public static final String JSON_PROPERTY_EVENT_TIME = "event_time";
    private String eventTime;
    public static final String JSON_PROPERTY_EVENT_TYPE = "event_type";
    private EventTypeEnum eventType;
    public static final String JSON_PROPERTY_EVENT_HASH = "event_hash";
    private String eventHash;
    public static final String JSON_PROPERTY_EVENT_METADATA = "event_metadata";
    private EventCallbackRequestEventMetadata eventMetadata;

    public static EventCallbackRequestEvent init(String jsonData) throws Exception {
        return (EventCallbackRequestEvent)new ObjectMapper().readValue(jsonData, EventCallbackRequestEvent.class);
    }

    public static EventCallbackRequestEvent init(HashMap data) throws Exception {
        return (EventCallbackRequestEvent)new ObjectMapper().readValue(new ObjectMapper().writeValueAsString((Object)data), EventCallbackRequestEvent.class);
    }

    public EventCallbackRequestEvent eventTime(String eventTime) {
        this.eventTime = eventTime;
        return this;
    }

    @Nonnull
    @JsonProperty(value="event_time")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getEventTime() {
        return this.eventTime;
    }

    @JsonProperty(value="event_time")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEventTime(String eventTime) {
        this.eventTime = eventTime;
    }

    public EventCallbackRequestEvent eventType(EventTypeEnum eventType) {
        this.eventType = eventType;
        return this;
    }

    @Nonnull
    @JsonProperty(value="event_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public EventTypeEnum getEventType() {
        return this.eventType;
    }

    @JsonProperty(value="event_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEventType(EventTypeEnum eventType) {
        this.eventType = eventType;
    }

    public EventCallbackRequestEvent eventHash(String eventHash) {
        this.eventHash = eventHash;
        return this;
    }

    @Nonnull
    @JsonProperty(value="event_hash")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getEventHash() {
        return this.eventHash;
    }

    @JsonProperty(value="event_hash")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEventHash(String eventHash) {
        this.eventHash = eventHash;
    }

    public EventCallbackRequestEvent eventMetadata(EventCallbackRequestEventMetadata eventMetadata) {
        this.eventMetadata = eventMetadata;
        return this;
    }

    @Nullable
    @JsonProperty(value="event_metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EventCallbackRequestEventMetadata getEventMetadata() {
        return this.eventMetadata;
    }

    @JsonProperty(value="event_metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEventMetadata(EventCallbackRequestEventMetadata eventMetadata) {
        this.eventMetadata = eventMetadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventCallbackRequestEvent eventCallbackRequestEvent = (EventCallbackRequestEvent)o;
        return Objects.equals(this.eventTime, eventCallbackRequestEvent.eventTime) && Objects.equals((Object)this.eventType, (Object)eventCallbackRequestEvent.eventType) && Objects.equals(this.eventHash, eventCallbackRequestEvent.eventHash) && Objects.equals(this.eventMetadata, eventCallbackRequestEvent.eventMetadata);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.eventTime, this.eventType, this.eventHash, this.eventMetadata});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EventCallbackRequestEvent {\n");
        sb.append("    eventTime: ").append(this.toIndentedString(this.eventTime)).append("\n");
        sb.append("    eventType: ").append(this.toIndentedString((Object)this.eventType)).append("\n");
        sb.append("    eventHash: ").append(this.toIndentedString(this.eventHash)).append("\n");
        sb.append("    eventMetadata: ").append(this.toIndentedString(this.eventMetadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public Map<String, Object> createFormData() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean fileTypeFound = false;
        try {
            int i;
            if (this.eventTime != null) {
                if (this.isFileTypeOrListOfFiles(this.eventTime)) {
                    fileTypeFound = true;
                }
                if (this.eventTime.getClass().equals(File.class) || this.eventTime.getClass().equals(Integer.class) || this.eventTime.getClass().equals(String.class) || this.eventTime.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_EVENT_TIME, this.eventTime);
                } else if (this.isListOfFile(this.eventTime)) {
                    for (i = 0; i < this.getListSize(this.eventTime); ++i) {
                        map.put("event_time[" + i + "]", this.getFromList(this.eventTime, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_EVENT_TIME, JSON.getDefault().getMapper().writeValueAsString((Object)this.eventTime));
                }
            }
            if (this.eventType != null) {
                if (this.isFileTypeOrListOfFiles((Object)this.eventType)) {
                    fileTypeFound = true;
                }
                if (((Object)((Object)this.eventType)).getClass().equals(File.class) || ((Object)((Object)this.eventType)).getClass().equals(Integer.class) || ((Object)((Object)this.eventType)).getClass().equals(String.class) || ((Object)((Object)this.eventType)).getClass().isEnum()) {
                    map.put(JSON_PROPERTY_EVENT_TYPE, (Object)this.eventType);
                } else if (this.isListOfFile((Object)this.eventType)) {
                    for (i = 0; i < this.getListSize((Object)this.eventType); ++i) {
                        map.put("event_type[" + i + "]", this.getFromList((Object)this.eventType, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_EVENT_TYPE, JSON.getDefault().getMapper().writeValueAsString((Object)this.eventType));
                }
            }
            if (this.eventHash != null) {
                if (this.isFileTypeOrListOfFiles(this.eventHash)) {
                    fileTypeFound = true;
                }
                if (this.eventHash.getClass().equals(File.class) || this.eventHash.getClass().equals(Integer.class) || this.eventHash.getClass().equals(String.class) || this.eventHash.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_EVENT_HASH, this.eventHash);
                } else if (this.isListOfFile(this.eventHash)) {
                    for (i = 0; i < this.getListSize(this.eventHash); ++i) {
                        map.put("event_hash[" + i + "]", this.getFromList(this.eventHash, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_EVENT_HASH, JSON.getDefault().getMapper().writeValueAsString((Object)this.eventHash));
                }
            }
            if (this.eventMetadata != null) {
                if (this.isFileTypeOrListOfFiles(this.eventMetadata)) {
                    fileTypeFound = true;
                }
                if (this.eventMetadata.getClass().equals(File.class) || this.eventMetadata.getClass().equals(Integer.class) || this.eventMetadata.getClass().equals(String.class) || this.eventMetadata.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_EVENT_METADATA, this.eventMetadata);
                } else if (this.isListOfFile(this.eventMetadata)) {
                    for (i = 0; i < this.getListSize(this.eventMetadata); ++i) {
                        map.put("event_metadata[" + i + "]", this.getFromList(this.eventMetadata, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_EVENT_METADATA, JSON.getDefault().getMapper().writeValueAsString((Object)this.eventMetadata));
                }
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return fileTypeFound ? map : new HashMap<String, Object>();
    }

    private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
        return obj.getClass().equals(File.class) || this.isListOfFile(obj);
    }

    private boolean isListOfFile(Object obj) throws Exception {
        return obj instanceof List && !this.isListEmpty(obj) && this.getFromList(obj, 0) instanceof File;
    }

    private boolean isListEmpty(Object obj) throws Exception {
        return (Boolean)Class.forName(List.class.getName()).getMethod("isEmpty", new Class[0]).invoke(obj, new Object[0]);
    }

    private Object getFromList(Object obj, int index) throws Exception {
        return Class.forName(List.class.getName()).getMethod("get", Integer.TYPE).invoke(obj, index);
    }

    private int getListSize(Object obj) throws Exception {
        return (Integer)Class.forName(List.class.getName()).getMethod("size", new Class[0]).invoke(obj, new Object[0]);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum EventTypeEnum {
        ACCOUNT_CONFIRMED("account_confirmed"),
        UNKNOWN_ERROR("unknown_error"),
        FILE_ERROR("file_error"),
        SIGN_URL_INVALID("sign_url_invalid"),
        SIGNATURE_REQUEST_VIEWED("signature_request_viewed"),
        SIGNATURE_REQUEST_SIGNED("signature_request_signed"),
        SIGNATURE_REQUEST_SENT("signature_request_sent"),
        SIGNATURE_REQUEST_ALL_SIGNED("signature_request_all_signed"),
        SIGNATURE_REQUEST_EMAIL_BOUNCE("signature_request_email_bounce"),
        SIGNATURE_REQUEST_REMIND("signature_request_remind"),
        SIGNATURE_REQUEST_INCOMPLETE_QES("signature_request_incomplete_qes"),
        SIGNATURE_REQUEST_DESTROYED("signature_request_destroyed"),
        SIGNATURE_REQUEST_CANCELED("signature_request_canceled"),
        SIGNATURE_REQUEST_DOWNLOADABLE("signature_request_downloadable"),
        SIGNATURE_REQUEST_DECLINED("signature_request_declined"),
        SIGNATURE_REQUEST_REASSIGNED("signature_request_reassigned"),
        SIGNATURE_REQUEST_INVALID("signature_request_invalid"),
        SIGNATURE_REQUEST_PREPARED("signature_request_prepared"),
        SIGNATURE_REQUEST_EXPIRED("signature_request_expired"),
        TEMPLATE_CREATED("template_created"),
        TEMPLATE_ERROR("template_error"),
        CALLBACK_TEST("callback_test"),
        SIGNATURE_REQUEST_SIGNER_REMOVED("signature_request_signer_removed");

        private String value;

        private EventTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EventTypeEnum fromValue(String value) {
            for (EventTypeEnum b : EventTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

