/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.model;

import com.dropbox.sign.ApiException;
import com.dropbox.sign.JSON;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nullable;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"callback_url", "secret", "scopes", "charges_users"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class ApiAppResponseOAuth {
    public static final String JSON_PROPERTY_CALLBACK_URL = "callback_url";
    private String callbackUrl;
    public static final String JSON_PROPERTY_SECRET = "secret";
    private String secret;
    public static final String JSON_PROPERTY_SCOPES = "scopes";
    private List<String> scopes = null;
    public static final String JSON_PROPERTY_CHARGES_USERS = "charges_users";
    private Boolean chargesUsers;

    public static ApiAppResponseOAuth init(String jsonData) throws Exception {
        return (ApiAppResponseOAuth)new ObjectMapper().readValue(jsonData, ApiAppResponseOAuth.class);
    }

    public static ApiAppResponseOAuth init(HashMap data) throws Exception {
        return (ApiAppResponseOAuth)new ObjectMapper().readValue(new ObjectMapper().writeValueAsString((Object)data), ApiAppResponseOAuth.class);
    }

    public ApiAppResponseOAuth callbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    @Nullable
    @JsonProperty(value="callback_url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    @JsonProperty(value="callback_url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public ApiAppResponseOAuth secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @JsonProperty(value="secret")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSecret() {
        return this.secret;
    }

    @JsonProperty(value="secret")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSecret(String secret) {
        this.secret = secret;
    }

    public ApiAppResponseOAuth scopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    public ApiAppResponseOAuth addScopesItem(String scopesItem) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        this.scopes.add(scopesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="scopes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getScopes() {
        return this.scopes;
    }

    @JsonProperty(value="scopes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public ApiAppResponseOAuth chargesUsers(Boolean chargesUsers) {
        this.chargesUsers = chargesUsers;
        return this;
    }

    @Nullable
    @JsonProperty(value="charges_users")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getChargesUsers() {
        return this.chargesUsers;
    }

    @JsonProperty(value="charges_users")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChargesUsers(Boolean chargesUsers) {
        this.chargesUsers = chargesUsers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiAppResponseOAuth apiAppResponseOAuth = (ApiAppResponseOAuth)o;
        return Objects.equals(this.callbackUrl, apiAppResponseOAuth.callbackUrl) && Objects.equals(this.secret, apiAppResponseOAuth.secret) && Objects.equals(this.scopes, apiAppResponseOAuth.scopes) && Objects.equals(this.chargesUsers, apiAppResponseOAuth.chargesUsers);
    }

    public int hashCode() {
        return Objects.hash(this.callbackUrl, this.secret, this.scopes, this.chargesUsers);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiAppResponseOAuth {\n");
        sb.append("    callbackUrl: ").append(this.toIndentedString(this.callbackUrl)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    scopes: ").append(this.toIndentedString(this.scopes)).append("\n");
        sb.append("    chargesUsers: ").append(this.toIndentedString(this.chargesUsers)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public Map<String, Object> createFormData() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean fileTypeFound = false;
        try {
            int i;
            if (this.callbackUrl != null) {
                if (this.isFileTypeOrListOfFiles(this.callbackUrl)) {
                    fileTypeFound = true;
                }
                if (this.callbackUrl.getClass().equals(File.class) || this.callbackUrl.getClass().equals(Integer.class) || this.callbackUrl.getClass().equals(String.class) || this.callbackUrl.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_CALLBACK_URL, this.callbackUrl);
                } else if (this.isListOfFile(this.callbackUrl)) {
                    for (i = 0; i < this.getListSize(this.callbackUrl); ++i) {
                        map.put("callback_url[" + i + "]", this.getFromList(this.callbackUrl, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_CALLBACK_URL, JSON.getDefault().getMapper().writeValueAsString((Object)this.callbackUrl));
                }
            }
            if (this.secret != null) {
                if (this.isFileTypeOrListOfFiles(this.secret)) {
                    fileTypeFound = true;
                }
                if (this.secret.getClass().equals(File.class) || this.secret.getClass().equals(Integer.class) || this.secret.getClass().equals(String.class) || this.secret.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_SECRET, this.secret);
                } else if (this.isListOfFile(this.secret)) {
                    for (i = 0; i < this.getListSize(this.secret); ++i) {
                        map.put("secret[" + i + "]", this.getFromList(this.secret, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_SECRET, JSON.getDefault().getMapper().writeValueAsString((Object)this.secret));
                }
            }
            if (this.scopes != null) {
                if (this.isFileTypeOrListOfFiles(this.scopes)) {
                    fileTypeFound = true;
                }
                if (this.scopes.getClass().equals(File.class) || this.scopes.getClass().equals(Integer.class) || this.scopes.getClass().equals(String.class) || this.scopes.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_SCOPES, this.scopes);
                } else if (this.isListOfFile(this.scopes)) {
                    for (i = 0; i < this.getListSize(this.scopes); ++i) {
                        map.put("scopes[" + i + "]", this.getFromList(this.scopes, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_SCOPES, JSON.getDefault().getMapper().writeValueAsString(this.scopes));
                }
            }
            if (this.chargesUsers != null) {
                if (this.isFileTypeOrListOfFiles(this.chargesUsers)) {
                    fileTypeFound = true;
                }
                if (this.chargesUsers.getClass().equals(File.class) || this.chargesUsers.getClass().equals(Integer.class) || this.chargesUsers.getClass().equals(String.class) || this.chargesUsers.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_CHARGES_USERS, this.chargesUsers);
                } else if (this.isListOfFile(this.chargesUsers)) {
                    for (i = 0; i < this.getListSize(this.chargesUsers); ++i) {
                        map.put("charges_users[" + i + "]", this.getFromList(this.chargesUsers, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_CHARGES_USERS, JSON.getDefault().getMapper().writeValueAsString((Object)this.chargesUsers));
                }
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return fileTypeFound ? map : new HashMap<String, Object>();
    }

    private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
        return obj.getClass().equals(File.class) || this.isListOfFile(obj);
    }

    private boolean isListOfFile(Object obj) throws Exception {
        return obj instanceof List && !this.isListEmpty(obj) && this.getFromList(obj, 0) instanceof File;
    }

    private boolean isListEmpty(Object obj) throws Exception {
        return (Boolean)Class.forName(List.class.getName()).getMethod("isEmpty", new Class[0]).invoke(obj, new Object[0]);
    }

    private Object getFromList(Object obj, int index) throws Exception {
        return Class.forName(List.class.getName()).getMethod("get", Integer.TYPE).invoke(obj, index);
    }

    private int getListSize(Object obj) throws Exception {
        return (Integer)Class.forName(List.class.getName()).getMethod("size", new Class[0]).invoke(obj, new Object[0]);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

