/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.model;

import com.dropbox.sign.ApiException;
import com.dropbox.sign.JSON;
import com.dropbox.sign.model.SubOAuth;
import com.dropbox.sign.model.SubOptions;
import com.dropbox.sign.model.SubWhiteLabelingOptions;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"domains", "name", "callback_url", "custom_logo_file", "oauth", "options", "white_labeling_options"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class ApiAppCreateRequest {
    public static final String JSON_PROPERTY_DOMAINS = "domains";
    private List<String> domains = new ArrayList<String>();
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_CALLBACK_URL = "callback_url";
    private String callbackUrl;
    public static final String JSON_PROPERTY_CUSTOM_LOGO_FILE = "custom_logo_file";
    private File customLogoFile;
    public static final String JSON_PROPERTY_OAUTH = "oauth";
    private SubOAuth oauth;
    public static final String JSON_PROPERTY_OPTIONS = "options";
    private SubOptions options;
    public static final String JSON_PROPERTY_WHITE_LABELING_OPTIONS = "white_labeling_options";
    private SubWhiteLabelingOptions whiteLabelingOptions;

    public static ApiAppCreateRequest init(String jsonData) throws Exception {
        return (ApiAppCreateRequest)new ObjectMapper().readValue(jsonData, ApiAppCreateRequest.class);
    }

    public static ApiAppCreateRequest init(HashMap data) throws Exception {
        return (ApiAppCreateRequest)new ObjectMapper().readValue(new ObjectMapper().writeValueAsString((Object)data), ApiAppCreateRequest.class);
    }

    public ApiAppCreateRequest domains(List<String> domains) {
        this.domains = domains;
        return this;
    }

    public ApiAppCreateRequest addDomainsItem(String domainsItem) {
        if (this.domains == null) {
            this.domains = new ArrayList<String>();
        }
        this.domains.add(domainsItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="domains")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getDomains() {
        return this.domains;
    }

    @JsonProperty(value="domains")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDomains(List<String> domains) {
        this.domains = domains;
    }

    public ApiAppCreateRequest name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public ApiAppCreateRequest callbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    @Nullable
    @JsonProperty(value="callback_url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    @JsonProperty(value="callback_url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public ApiAppCreateRequest customLogoFile(File customLogoFile) {
        this.customLogoFile = customLogoFile;
        return this;
    }

    @Nullable
    @JsonProperty(value="custom_logo_file")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public File getCustomLogoFile() {
        return this.customLogoFile;
    }

    @JsonProperty(value="custom_logo_file")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustomLogoFile(File customLogoFile) {
        this.customLogoFile = customLogoFile;
    }

    public ApiAppCreateRequest oauth(SubOAuth oauth) {
        this.oauth = oauth;
        return this;
    }

    @Nullable
    @JsonProperty(value="oauth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SubOAuth getOauth() {
        return this.oauth;
    }

    @JsonProperty(value="oauth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOauth(SubOAuth oauth) {
        this.oauth = oauth;
    }

    public ApiAppCreateRequest options(SubOptions options) {
        this.options = options;
        return this;
    }

    @Nullable
    @JsonProperty(value="options")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SubOptions getOptions() {
        return this.options;
    }

    @JsonProperty(value="options")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOptions(SubOptions options) {
        this.options = options;
    }

    public ApiAppCreateRequest whiteLabelingOptions(SubWhiteLabelingOptions whiteLabelingOptions) {
        this.whiteLabelingOptions = whiteLabelingOptions;
        return this;
    }

    @Nullable
    @JsonProperty(value="white_labeling_options")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SubWhiteLabelingOptions getWhiteLabelingOptions() {
        return this.whiteLabelingOptions;
    }

    @JsonProperty(value="white_labeling_options")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWhiteLabelingOptions(SubWhiteLabelingOptions whiteLabelingOptions) {
        this.whiteLabelingOptions = whiteLabelingOptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiAppCreateRequest apiAppCreateRequest = (ApiAppCreateRequest)o;
        return Objects.equals(this.domains, apiAppCreateRequest.domains) && Objects.equals(this.name, apiAppCreateRequest.name) && Objects.equals(this.callbackUrl, apiAppCreateRequest.callbackUrl) && Objects.equals(this.customLogoFile, apiAppCreateRequest.customLogoFile) && Objects.equals(this.oauth, apiAppCreateRequest.oauth) && Objects.equals(this.options, apiAppCreateRequest.options) && Objects.equals(this.whiteLabelingOptions, apiAppCreateRequest.whiteLabelingOptions);
    }

    public int hashCode() {
        return Objects.hash(this.domains, this.name, this.callbackUrl, this.customLogoFile, this.oauth, this.options, this.whiteLabelingOptions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiAppCreateRequest {\n");
        sb.append("    domains: ").append(this.toIndentedString(this.domains)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    callbackUrl: ").append(this.toIndentedString(this.callbackUrl)).append("\n");
        sb.append("    customLogoFile: ").append(this.toIndentedString(this.customLogoFile)).append("\n");
        sb.append("    oauth: ").append(this.toIndentedString(this.oauth)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("    whiteLabelingOptions: ").append(this.toIndentedString(this.whiteLabelingOptions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public Map<String, Object> createFormData() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean fileTypeFound = false;
        try {
            int i;
            if (this.domains != null) {
                if (this.isFileTypeOrListOfFiles(this.domains)) {
                    fileTypeFound = true;
                }
                if (this.domains.getClass().equals(File.class) || this.domains.getClass().equals(Integer.class) || this.domains.getClass().equals(String.class) || this.domains.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_DOMAINS, this.domains);
                } else if (this.isListOfFile(this.domains)) {
                    for (i = 0; i < this.getListSize(this.domains); ++i) {
                        map.put("domains[" + i + "]", this.getFromList(this.domains, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_DOMAINS, JSON.getDefault().getMapper().writeValueAsString(this.domains));
                }
            }
            if (this.name != null) {
                if (this.isFileTypeOrListOfFiles(this.name)) {
                    fileTypeFound = true;
                }
                if (this.name.getClass().equals(File.class) || this.name.getClass().equals(Integer.class) || this.name.getClass().equals(String.class) || this.name.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_NAME, this.name);
                } else if (this.isListOfFile(this.name)) {
                    for (i = 0; i < this.getListSize(this.name); ++i) {
                        map.put("name[" + i + "]", this.getFromList(this.name, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_NAME, JSON.getDefault().getMapper().writeValueAsString((Object)this.name));
                }
            }
            if (this.callbackUrl != null) {
                if (this.isFileTypeOrListOfFiles(this.callbackUrl)) {
                    fileTypeFound = true;
                }
                if (this.callbackUrl.getClass().equals(File.class) || this.callbackUrl.getClass().equals(Integer.class) || this.callbackUrl.getClass().equals(String.class) || this.callbackUrl.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_CALLBACK_URL, this.callbackUrl);
                } else if (this.isListOfFile(this.callbackUrl)) {
                    for (i = 0; i < this.getListSize(this.callbackUrl); ++i) {
                        map.put("callback_url[" + i + "]", this.getFromList(this.callbackUrl, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_CALLBACK_URL, JSON.getDefault().getMapper().writeValueAsString((Object)this.callbackUrl));
                }
            }
            if (this.customLogoFile != null) {
                if (this.isFileTypeOrListOfFiles(this.customLogoFile)) {
                    fileTypeFound = true;
                }
                if (this.customLogoFile.getClass().equals(File.class) || this.customLogoFile.getClass().equals(Integer.class) || this.customLogoFile.getClass().equals(String.class) || this.customLogoFile.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_CUSTOM_LOGO_FILE, this.customLogoFile);
                } else if (this.isListOfFile(this.customLogoFile)) {
                    for (i = 0; i < this.getListSize(this.customLogoFile); ++i) {
                        map.put("custom_logo_file[" + i + "]", this.getFromList(this.customLogoFile, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_CUSTOM_LOGO_FILE, JSON.getDefault().getMapper().writeValueAsString((Object)this.customLogoFile));
                }
            }
            if (this.oauth != null) {
                if (this.isFileTypeOrListOfFiles(this.oauth)) {
                    fileTypeFound = true;
                }
                if (this.oauth.getClass().equals(File.class) || this.oauth.getClass().equals(Integer.class) || this.oauth.getClass().equals(String.class) || this.oauth.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_OAUTH, this.oauth);
                } else if (this.isListOfFile(this.oauth)) {
                    for (i = 0; i < this.getListSize(this.oauth); ++i) {
                        map.put("oauth[" + i + "]", this.getFromList(this.oauth, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_OAUTH, JSON.getDefault().getMapper().writeValueAsString((Object)this.oauth));
                }
            }
            if (this.options != null) {
                if (this.isFileTypeOrListOfFiles(this.options)) {
                    fileTypeFound = true;
                }
                if (this.options.getClass().equals(File.class) || this.options.getClass().equals(Integer.class) || this.options.getClass().equals(String.class) || this.options.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_OPTIONS, this.options);
                } else if (this.isListOfFile(this.options)) {
                    for (i = 0; i < this.getListSize(this.options); ++i) {
                        map.put("options[" + i + "]", this.getFromList(this.options, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_OPTIONS, JSON.getDefault().getMapper().writeValueAsString((Object)this.options));
                }
            }
            if (this.whiteLabelingOptions != null) {
                if (this.isFileTypeOrListOfFiles(this.whiteLabelingOptions)) {
                    fileTypeFound = true;
                }
                if (this.whiteLabelingOptions.getClass().equals(File.class) || this.whiteLabelingOptions.getClass().equals(Integer.class) || this.whiteLabelingOptions.getClass().equals(String.class) || this.whiteLabelingOptions.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_WHITE_LABELING_OPTIONS, this.whiteLabelingOptions);
                } else if (this.isListOfFile(this.whiteLabelingOptions)) {
                    for (i = 0; i < this.getListSize(this.whiteLabelingOptions); ++i) {
                        map.put("white_labeling_options[" + i + "]", this.getFromList(this.whiteLabelingOptions, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_WHITE_LABELING_OPTIONS, JSON.getDefault().getMapper().writeValueAsString((Object)this.whiteLabelingOptions));
                }
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return fileTypeFound ? map : new HashMap<String, Object>();
    }

    private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
        return obj.getClass().equals(File.class) || this.isListOfFile(obj);
    }

    private boolean isListOfFile(Object obj) throws Exception {
        return obj instanceof List && !this.isListEmpty(obj) && this.getFromList(obj, 0) instanceof File;
    }

    private boolean isListEmpty(Object obj) throws Exception {
        return (Boolean)Class.forName(List.class.getName()).getMethod("isEmpty", new Class[0]).invoke(obj, new Object[0]);
    }

    private Object getFromList(Object obj, int index) throws Exception {
        return Class.forName(List.class.getName()).getMethod("get", Integer.TYPE).invoke(obj, index);
    }

    private int getListSize(Object obj) throws Exception {
        return (Integer)Class.forName(List.class.getName()).getMethod("size", new Class[0]).invoke(obj, new Object[0]);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

