/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.model;

import com.dropbox.sign.ApiException;
import com.dropbox.sign.JSON;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nullable;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"account_id", "callback_url", "locale"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class AccountUpdateRequest {
    public static final String JSON_PROPERTY_ACCOUNT_ID = "account_id";
    private String accountId;
    public static final String JSON_PROPERTY_CALLBACK_URL = "callback_url";
    private String callbackUrl;
    public static final String JSON_PROPERTY_LOCALE = "locale";
    private String locale;

    public static AccountUpdateRequest init(String jsonData) throws Exception {
        return (AccountUpdateRequest)new ObjectMapper().readValue(jsonData, AccountUpdateRequest.class);
    }

    public static AccountUpdateRequest init(HashMap data) throws Exception {
        return (AccountUpdateRequest)new ObjectMapper().readValue(new ObjectMapper().writeValueAsString((Object)data), AccountUpdateRequest.class);
    }

    public AccountUpdateRequest accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    @JsonProperty(value="account_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountId() {
        return this.accountId;
    }

    @JsonProperty(value="account_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public AccountUpdateRequest callbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    @Nullable
    @JsonProperty(value="callback_url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    @JsonProperty(value="callback_url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public AccountUpdateRequest locale(String locale) {
        this.locale = locale;
        return this;
    }

    @Nullable
    @JsonProperty(value="locale")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLocale() {
        return this.locale;
    }

    @JsonProperty(value="locale")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLocale(String locale) {
        this.locale = locale;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountUpdateRequest accountUpdateRequest = (AccountUpdateRequest)o;
        return Objects.equals(this.accountId, accountUpdateRequest.accountId) && Objects.equals(this.callbackUrl, accountUpdateRequest.callbackUrl) && Objects.equals(this.locale, accountUpdateRequest.locale);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.callbackUrl, this.locale);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountUpdateRequest {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    callbackUrl: ").append(this.toIndentedString(this.callbackUrl)).append("\n");
        sb.append("    locale: ").append(this.toIndentedString(this.locale)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public Map<String, Object> createFormData() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean fileTypeFound = false;
        try {
            int i;
            if (this.accountId != null) {
                if (this.isFileTypeOrListOfFiles(this.accountId)) {
                    fileTypeFound = true;
                }
                if (this.accountId.getClass().equals(File.class) || this.accountId.getClass().equals(Integer.class) || this.accountId.getClass().equals(String.class) || this.accountId.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_ACCOUNT_ID, this.accountId);
                } else if (this.isListOfFile(this.accountId)) {
                    for (i = 0; i < this.getListSize(this.accountId); ++i) {
                        map.put("account_id[" + i + "]", this.getFromList(this.accountId, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_ACCOUNT_ID, JSON.getDefault().getMapper().writeValueAsString((Object)this.accountId));
                }
            }
            if (this.callbackUrl != null) {
                if (this.isFileTypeOrListOfFiles(this.callbackUrl)) {
                    fileTypeFound = true;
                }
                if (this.callbackUrl.getClass().equals(File.class) || this.callbackUrl.getClass().equals(Integer.class) || this.callbackUrl.getClass().equals(String.class) || this.callbackUrl.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_CALLBACK_URL, this.callbackUrl);
                } else if (this.isListOfFile(this.callbackUrl)) {
                    for (i = 0; i < this.getListSize(this.callbackUrl); ++i) {
                        map.put("callback_url[" + i + "]", this.getFromList(this.callbackUrl, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_CALLBACK_URL, JSON.getDefault().getMapper().writeValueAsString((Object)this.callbackUrl));
                }
            }
            if (this.locale != null) {
                if (this.isFileTypeOrListOfFiles(this.locale)) {
                    fileTypeFound = true;
                }
                if (this.locale.getClass().equals(File.class) || this.locale.getClass().equals(Integer.class) || this.locale.getClass().equals(String.class) || this.locale.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_LOCALE, this.locale);
                } else if (this.isListOfFile(this.locale)) {
                    for (i = 0; i < this.getListSize(this.locale); ++i) {
                        map.put("locale[" + i + "]", this.getFromList(this.locale, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_LOCALE, JSON.getDefault().getMapper().writeValueAsString((Object)this.locale));
                }
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return fileTypeFound ? map : new HashMap<String, Object>();
    }

    private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
        return obj.getClass().equals(File.class) || this.isListOfFile(obj);
    }

    private boolean isListOfFile(Object obj) throws Exception {
        return obj instanceof List && !this.isListEmpty(obj) && this.getFromList(obj, 0) instanceof File;
    }

    private boolean isListEmpty(Object obj) throws Exception {
        return (Boolean)Class.forName(List.class.getName()).getMethod("isEmpty", new Class[0]).invoke(obj, new Object[0]);
    }

    private Object getFromList(Object obj, int index) throws Exception {
        return Class.forName(List.class.getName()).getMethod("get", Integer.TYPE).invoke(obj, index);
    }

    private int getListSize(Object obj) throws Exception {
        return (Integer)Class.forName(List.class.getName()).getMethod("size", new Class[0]).invoke(obj, new Object[0]);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

