/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.model;

import com.dropbox.sign.ApiException;
import com.dropbox.sign.JSON;
import com.dropbox.sign.model.AccountResponseQuotas;
import com.dropbox.sign.model.AccountResponseUsage;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nullable;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"account_id", "email_address", "is_locked", "is_paid_hs", "is_paid_hf", "quotas", "callback_url", "role_code", "team_id", "locale", "usage"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class AccountResponse {
    public static final String JSON_PROPERTY_ACCOUNT_ID = "account_id";
    private String accountId;
    public static final String JSON_PROPERTY_EMAIL_ADDRESS = "email_address";
    private String emailAddress;
    public static final String JSON_PROPERTY_IS_LOCKED = "is_locked";
    private Boolean isLocked;
    public static final String JSON_PROPERTY_IS_PAID_HS = "is_paid_hs";
    private Boolean isPaidHs;
    public static final String JSON_PROPERTY_IS_PAID_HF = "is_paid_hf";
    private Boolean isPaidHf;
    public static final String JSON_PROPERTY_QUOTAS = "quotas";
    private AccountResponseQuotas quotas;
    public static final String JSON_PROPERTY_CALLBACK_URL = "callback_url";
    private String callbackUrl;
    public static final String JSON_PROPERTY_ROLE_CODE = "role_code";
    private String roleCode;
    public static final String JSON_PROPERTY_TEAM_ID = "team_id";
    private String teamId;
    public static final String JSON_PROPERTY_LOCALE = "locale";
    private String locale;
    public static final String JSON_PROPERTY_USAGE = "usage";
    private AccountResponseUsage usage;

    public static AccountResponse init(String jsonData) throws Exception {
        return (AccountResponse)new ObjectMapper().readValue(jsonData, AccountResponse.class);
    }

    public static AccountResponse init(HashMap data) throws Exception {
        return (AccountResponse)new ObjectMapper().readValue(new ObjectMapper().writeValueAsString((Object)data), AccountResponse.class);
    }

    public AccountResponse accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    @JsonProperty(value="account_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountId() {
        return this.accountId;
    }

    @JsonProperty(value="account_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public AccountResponse emailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
        return this;
    }

    @Nullable
    @JsonProperty(value="email_address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEmailAddress() {
        return this.emailAddress;
    }

    @JsonProperty(value="email_address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public AccountResponse isLocked(Boolean isLocked) {
        this.isLocked = isLocked;
        return this;
    }

    @Nullable
    @JsonProperty(value="is_locked")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsLocked() {
        return this.isLocked;
    }

    @JsonProperty(value="is_locked")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIsLocked(Boolean isLocked) {
        this.isLocked = isLocked;
    }

    public AccountResponse isPaidHs(Boolean isPaidHs) {
        this.isPaidHs = isPaidHs;
        return this;
    }

    @Nullable
    @JsonProperty(value="is_paid_hs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsPaidHs() {
        return this.isPaidHs;
    }

    @JsonProperty(value="is_paid_hs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIsPaidHs(Boolean isPaidHs) {
        this.isPaidHs = isPaidHs;
    }

    public AccountResponse isPaidHf(Boolean isPaidHf) {
        this.isPaidHf = isPaidHf;
        return this;
    }

    @Nullable
    @JsonProperty(value="is_paid_hf")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsPaidHf() {
        return this.isPaidHf;
    }

    @JsonProperty(value="is_paid_hf")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIsPaidHf(Boolean isPaidHf) {
        this.isPaidHf = isPaidHf;
    }

    public AccountResponse quotas(AccountResponseQuotas quotas) {
        this.quotas = quotas;
        return this;
    }

    @Nullable
    @JsonProperty(value="quotas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AccountResponseQuotas getQuotas() {
        return this.quotas;
    }

    @JsonProperty(value="quotas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setQuotas(AccountResponseQuotas quotas) {
        this.quotas = quotas;
    }

    public AccountResponse callbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    @Nullable
    @JsonProperty(value="callback_url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    @JsonProperty(value="callback_url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public AccountResponse roleCode(String roleCode) {
        this.roleCode = roleCode;
        return this;
    }

    @Nullable
    @JsonProperty(value="role_code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRoleCode() {
        return this.roleCode;
    }

    @JsonProperty(value="role_code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRoleCode(String roleCode) {
        this.roleCode = roleCode;
    }

    public AccountResponse teamId(String teamId) {
        this.teamId = teamId;
        return this;
    }

    @Nullable
    @JsonProperty(value="team_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTeamId() {
        return this.teamId;
    }

    @JsonProperty(value="team_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTeamId(String teamId) {
        this.teamId = teamId;
    }

    public AccountResponse locale(String locale) {
        this.locale = locale;
        return this;
    }

    @Nullable
    @JsonProperty(value="locale")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLocale() {
        return this.locale;
    }

    @JsonProperty(value="locale")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLocale(String locale) {
        this.locale = locale;
    }

    public AccountResponse usage(AccountResponseUsage usage) {
        this.usage = usage;
        return this;
    }

    @Nullable
    @JsonProperty(value="usage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AccountResponseUsage getUsage() {
        return this.usage;
    }

    @JsonProperty(value="usage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUsage(AccountResponseUsage usage) {
        this.usage = usage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountResponse accountResponse = (AccountResponse)o;
        return Objects.equals(this.accountId, accountResponse.accountId) && Objects.equals(this.emailAddress, accountResponse.emailAddress) && Objects.equals(this.isLocked, accountResponse.isLocked) && Objects.equals(this.isPaidHs, accountResponse.isPaidHs) && Objects.equals(this.isPaidHf, accountResponse.isPaidHf) && Objects.equals(this.quotas, accountResponse.quotas) && Objects.equals(this.callbackUrl, accountResponse.callbackUrl) && Objects.equals(this.roleCode, accountResponse.roleCode) && Objects.equals(this.teamId, accountResponse.teamId) && Objects.equals(this.locale, accountResponse.locale) && Objects.equals(this.usage, accountResponse.usage);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.emailAddress, this.isLocked, this.isPaidHs, this.isPaidHf, this.quotas, this.callbackUrl, this.roleCode, this.teamId, this.locale, this.usage);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountResponse {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    emailAddress: ").append(this.toIndentedString(this.emailAddress)).append("\n");
        sb.append("    isLocked: ").append(this.toIndentedString(this.isLocked)).append("\n");
        sb.append("    isPaidHs: ").append(this.toIndentedString(this.isPaidHs)).append("\n");
        sb.append("    isPaidHf: ").append(this.toIndentedString(this.isPaidHf)).append("\n");
        sb.append("    quotas: ").append(this.toIndentedString(this.quotas)).append("\n");
        sb.append("    callbackUrl: ").append(this.toIndentedString(this.callbackUrl)).append("\n");
        sb.append("    roleCode: ").append(this.toIndentedString(this.roleCode)).append("\n");
        sb.append("    teamId: ").append(this.toIndentedString(this.teamId)).append("\n");
        sb.append("    locale: ").append(this.toIndentedString(this.locale)).append("\n");
        sb.append("    usage: ").append(this.toIndentedString(this.usage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public Map<String, Object> createFormData() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean fileTypeFound = false;
        try {
            int i;
            if (this.accountId != null) {
                if (this.isFileTypeOrListOfFiles(this.accountId)) {
                    fileTypeFound = true;
                }
                if (this.accountId.getClass().equals(File.class) || this.accountId.getClass().equals(Integer.class) || this.accountId.getClass().equals(String.class) || this.accountId.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_ACCOUNT_ID, this.accountId);
                } else if (this.isListOfFile(this.accountId)) {
                    for (i = 0; i < this.getListSize(this.accountId); ++i) {
                        map.put("account_id[" + i + "]", this.getFromList(this.accountId, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_ACCOUNT_ID, JSON.getDefault().getMapper().writeValueAsString((Object)this.accountId));
                }
            }
            if (this.emailAddress != null) {
                if (this.isFileTypeOrListOfFiles(this.emailAddress)) {
                    fileTypeFound = true;
                }
                if (this.emailAddress.getClass().equals(File.class) || this.emailAddress.getClass().equals(Integer.class) || this.emailAddress.getClass().equals(String.class) || this.emailAddress.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_EMAIL_ADDRESS, this.emailAddress);
                } else if (this.isListOfFile(this.emailAddress)) {
                    for (i = 0; i < this.getListSize(this.emailAddress); ++i) {
                        map.put("email_address[" + i + "]", this.getFromList(this.emailAddress, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_EMAIL_ADDRESS, JSON.getDefault().getMapper().writeValueAsString((Object)this.emailAddress));
                }
            }
            if (this.isLocked != null) {
                if (this.isFileTypeOrListOfFiles(this.isLocked)) {
                    fileTypeFound = true;
                }
                if (this.isLocked.getClass().equals(File.class) || this.isLocked.getClass().equals(Integer.class) || this.isLocked.getClass().equals(String.class) || this.isLocked.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_IS_LOCKED, this.isLocked);
                } else if (this.isListOfFile(this.isLocked)) {
                    for (i = 0; i < this.getListSize(this.isLocked); ++i) {
                        map.put("is_locked[" + i + "]", this.getFromList(this.isLocked, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_IS_LOCKED, JSON.getDefault().getMapper().writeValueAsString((Object)this.isLocked));
                }
            }
            if (this.isPaidHs != null) {
                if (this.isFileTypeOrListOfFiles(this.isPaidHs)) {
                    fileTypeFound = true;
                }
                if (this.isPaidHs.getClass().equals(File.class) || this.isPaidHs.getClass().equals(Integer.class) || this.isPaidHs.getClass().equals(String.class) || this.isPaidHs.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_IS_PAID_HS, this.isPaidHs);
                } else if (this.isListOfFile(this.isPaidHs)) {
                    for (i = 0; i < this.getListSize(this.isPaidHs); ++i) {
                        map.put("is_paid_hs[" + i + "]", this.getFromList(this.isPaidHs, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_IS_PAID_HS, JSON.getDefault().getMapper().writeValueAsString((Object)this.isPaidHs));
                }
            }
            if (this.isPaidHf != null) {
                if (this.isFileTypeOrListOfFiles(this.isPaidHf)) {
                    fileTypeFound = true;
                }
                if (this.isPaidHf.getClass().equals(File.class) || this.isPaidHf.getClass().equals(Integer.class) || this.isPaidHf.getClass().equals(String.class) || this.isPaidHf.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_IS_PAID_HF, this.isPaidHf);
                } else if (this.isListOfFile(this.isPaidHf)) {
                    for (i = 0; i < this.getListSize(this.isPaidHf); ++i) {
                        map.put("is_paid_hf[" + i + "]", this.getFromList(this.isPaidHf, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_IS_PAID_HF, JSON.getDefault().getMapper().writeValueAsString((Object)this.isPaidHf));
                }
            }
            if (this.quotas != null) {
                if (this.isFileTypeOrListOfFiles(this.quotas)) {
                    fileTypeFound = true;
                }
                if (this.quotas.getClass().equals(File.class) || this.quotas.getClass().equals(Integer.class) || this.quotas.getClass().equals(String.class) || this.quotas.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_QUOTAS, this.quotas);
                } else if (this.isListOfFile(this.quotas)) {
                    for (i = 0; i < this.getListSize(this.quotas); ++i) {
                        map.put("quotas[" + i + "]", this.getFromList(this.quotas, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_QUOTAS, JSON.getDefault().getMapper().writeValueAsString((Object)this.quotas));
                }
            }
            if (this.callbackUrl != null) {
                if (this.isFileTypeOrListOfFiles(this.callbackUrl)) {
                    fileTypeFound = true;
                }
                if (this.callbackUrl.getClass().equals(File.class) || this.callbackUrl.getClass().equals(Integer.class) || this.callbackUrl.getClass().equals(String.class) || this.callbackUrl.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_CALLBACK_URL, this.callbackUrl);
                } else if (this.isListOfFile(this.callbackUrl)) {
                    for (i = 0; i < this.getListSize(this.callbackUrl); ++i) {
                        map.put("callback_url[" + i + "]", this.getFromList(this.callbackUrl, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_CALLBACK_URL, JSON.getDefault().getMapper().writeValueAsString((Object)this.callbackUrl));
                }
            }
            if (this.roleCode != null) {
                if (this.isFileTypeOrListOfFiles(this.roleCode)) {
                    fileTypeFound = true;
                }
                if (this.roleCode.getClass().equals(File.class) || this.roleCode.getClass().equals(Integer.class) || this.roleCode.getClass().equals(String.class) || this.roleCode.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_ROLE_CODE, this.roleCode);
                } else if (this.isListOfFile(this.roleCode)) {
                    for (i = 0; i < this.getListSize(this.roleCode); ++i) {
                        map.put("role_code[" + i + "]", this.getFromList(this.roleCode, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_ROLE_CODE, JSON.getDefault().getMapper().writeValueAsString((Object)this.roleCode));
                }
            }
            if (this.teamId != null) {
                if (this.isFileTypeOrListOfFiles(this.teamId)) {
                    fileTypeFound = true;
                }
                if (this.teamId.getClass().equals(File.class) || this.teamId.getClass().equals(Integer.class) || this.teamId.getClass().equals(String.class) || this.teamId.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_TEAM_ID, this.teamId);
                } else if (this.isListOfFile(this.teamId)) {
                    for (i = 0; i < this.getListSize(this.teamId); ++i) {
                        map.put("team_id[" + i + "]", this.getFromList(this.teamId, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_TEAM_ID, JSON.getDefault().getMapper().writeValueAsString((Object)this.teamId));
                }
            }
            if (this.locale != null) {
                if (this.isFileTypeOrListOfFiles(this.locale)) {
                    fileTypeFound = true;
                }
                if (this.locale.getClass().equals(File.class) || this.locale.getClass().equals(Integer.class) || this.locale.getClass().equals(String.class) || this.locale.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_LOCALE, this.locale);
                } else if (this.isListOfFile(this.locale)) {
                    for (i = 0; i < this.getListSize(this.locale); ++i) {
                        map.put("locale[" + i + "]", this.getFromList(this.locale, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_LOCALE, JSON.getDefault().getMapper().writeValueAsString((Object)this.locale));
                }
            }
            if (this.usage != null) {
                if (this.isFileTypeOrListOfFiles(this.usage)) {
                    fileTypeFound = true;
                }
                if (this.usage.getClass().equals(File.class) || this.usage.getClass().equals(Integer.class) || this.usage.getClass().equals(String.class) || this.usage.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_USAGE, this.usage);
                } else if (this.isListOfFile(this.usage)) {
                    for (i = 0; i < this.getListSize(this.usage); ++i) {
                        map.put("usage[" + i + "]", this.getFromList(this.usage, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_USAGE, JSON.getDefault().getMapper().writeValueAsString((Object)this.usage));
                }
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return fileTypeFound ? map : new HashMap<String, Object>();
    }

    private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
        return obj.getClass().equals(File.class) || this.isListOfFile(obj);
    }

    private boolean isListOfFile(Object obj) throws Exception {
        return obj instanceof List && !this.isListEmpty(obj) && this.getFromList(obj, 0) instanceof File;
    }

    private boolean isListEmpty(Object obj) throws Exception {
        return (Boolean)Class.forName(List.class.getName()).getMethod("isEmpty", new Class[0]).invoke(obj, new Object[0]);
    }

    private Object getFromList(Object obj, int index) throws Exception {
        return Class.forName(List.class.getName()).getMethod("get", Integer.TYPE).invoke(obj, index);
    }

    private int getListSize(Object obj) throws Exception {
        return (Integer)Class.forName(List.class.getName()).getMethod("size", new Class[0]).invoke(obj, new Object[0]);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

