/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.api;

import com.dropbox.sign.ApiClient;
import com.dropbox.sign.ApiException;
import com.dropbox.sign.ApiResponse;
import com.dropbox.sign.Configuration;
import com.dropbox.sign.Pair;
import com.dropbox.sign.model.OAuthTokenGenerateRequest;
import com.dropbox.sign.model.OAuthTokenRefreshRequest;
import com.dropbox.sign.model.OAuthTokenResponse;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class OAuthApi {
    private ApiClient apiClient;

    public OAuthApi() {
        this(Configuration.getDefaultApiClient());
    }

    public OAuthApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public OAuthTokenResponse oauthTokenGenerate(OAuthTokenGenerateRequest oauthTokenGenerateRequest) throws ApiException {
        return this.oauthTokenGenerateWithHttpInfo(oauthTokenGenerateRequest).getData();
    }

    public ApiResponse<OAuthTokenResponse> oauthTokenGenerateWithHttpInfo(OAuthTokenGenerateRequest oauthTokenGenerateRequest) throws ApiException {
        if (oauthTokenGenerateRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'oauthTokenGenerateRequest' when calling oauthTokenGenerate");
        }
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        Map<Object, Object> localVarFormParams = new LinkedHashMap();
        localVarFormParams = oauthTokenGenerateRequest.createFormData();
        boolean isFileTypeFound = !localVarFormParams.isEmpty();
        String localVarContentType = isFileTypeFound ? "multipart/form-data" : this.apiClient.selectHeaderContentType("application/json");
        GenericType<OAuthTokenResponse> localVarReturnType = new GenericType<OAuthTokenResponse>(){};
        return this.apiClient.invokeAPI("OAuthApi.oauthTokenGenerate", "/oauth/token", "POST", new ArrayList<Pair>(), isFileTypeFound ? null : oauthTokenGenerateRequest, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), localVarFormParams, localVarAccept, localVarContentType, null, localVarReturnType, false);
    }

    public OAuthTokenResponse oauthTokenRefresh(OAuthTokenRefreshRequest oauthTokenRefreshRequest) throws ApiException {
        return this.oauthTokenRefreshWithHttpInfo(oauthTokenRefreshRequest).getData();
    }

    public ApiResponse<OAuthTokenResponse> oauthTokenRefreshWithHttpInfo(OAuthTokenRefreshRequest oauthTokenRefreshRequest) throws ApiException {
        if (oauthTokenRefreshRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'oauthTokenRefreshRequest' when calling oauthTokenRefresh");
        }
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        Map<Object, Object> localVarFormParams = new LinkedHashMap();
        localVarFormParams = oauthTokenRefreshRequest.createFormData();
        boolean isFileTypeFound = !localVarFormParams.isEmpty();
        String localVarContentType = isFileTypeFound ? "multipart/form-data" : this.apiClient.selectHeaderContentType("application/json");
        GenericType<OAuthTokenResponse> localVarReturnType = new GenericType<OAuthTokenResponse>(){};
        return this.apiClient.invokeAPI("OAuthApi.oauthTokenRefresh", "/oauth/token?refresh", "POST", new ArrayList<Pair>(), isFileTypeFound ? null : oauthTokenRefreshRequest, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), localVarFormParams, localVarAccept, localVarContentType, null, localVarReturnType, false);
    }
}

