/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign;

import com.dropbox.sign.model.EventCallbackRequest;
import com.dropbox.sign.model.EventCallbackRequestEventMetadata;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.codec.digest.HmacUtils;

public class EventCallbackHelper {
    public static final String EVENT_TYPE_ACCOUNT_CALLBACK = "account_callback";
    public static final String EVENT_TYPE_APP_CALLBACK = "app_callback";

    private EventCallbackHelper() {
    }

    public static boolean isValid(String apiKey, EventCallbackRequest eventCallback) {
        return new HmacUtils(HmacAlgorithms.HMAC_SHA_256, apiKey).hmacHex(eventCallback.getEvent().getEventTime() + (Object)((Object)eventCallback.getEvent().getEventType())).equals(eventCallback.getEvent().getEventHash());
    }

    public static String getCallbackType(EventCallbackRequest eventCallback) {
        EventCallbackRequestEventMetadata metadata = eventCallback.getEvent().getEventMetadata();
        if (metadata == null || metadata.getReportedForAppId() == null || metadata.getReportedForAppId().isEmpty()) {
            return EVENT_TYPE_ACCOUNT_CALLBACK;
        }
        return EVENT_TYPE_APP_CALLBACK;
    }
}

