/*
 * Dropbox Sign API
 * Dropbox Sign v3 API
 *
 * The version of the OpenAPI document: 3.0.0
 * Contact: apisupport@hellosign.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.dropbox.sign.model;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.dropbox.sign.model.SubAttachment;
import com.dropbox.sign.model.SubCustomField;
import com.dropbox.sign.model.SubEditorOptions;
import com.dropbox.sign.model.SubFieldOptions;
import com.dropbox.sign.model.SubFormFieldGroup;
import com.dropbox.sign.model.SubFormFieldRule;
import com.dropbox.sign.model.SubFormFieldsPerDocumentBase;
import com.dropbox.sign.model.SubSigningOptions;
import com.dropbox.sign.model.SubUnclaimedDraftSigner;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.dropbox.sign.JSON;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.ObjectMapper;


import com.dropbox.sign.ApiException;
/**
 * 
 */
@JsonPropertyOrder({
  UnclaimedDraftCreateEmbeddedRequest.JSON_PROPERTY_CLIENT_ID,
  UnclaimedDraftCreateEmbeddedRequest.JSON_PROPERTY_REQUESTER_EMAIL_ADDRESS,
  UnclaimedDraftCreateEmbeddedRequest.JSON_PROPERTY_FILES,
  UnclaimedDraftCreateEmbeddedRequest.JSON_PROPERTY_FILE_URLS,
  UnclaimedDraftCreateEmbeddedRequest.JSON_PROPERTY_ALLOW_CCS,
  UnclaimedDraftCreateEmbeddedRequest.JSON_PROPERTY_ALLOW_DECLINE,
  UnclaimedDraftCreateEmbeddedRequest.JSON_PROPERTY_ALLOW_REASSIGN,
  UnclaimedDraftCreateEmbeddedRequest.JSON_PROPERTY_ATTACHMENTS,
  UnclaimedDraftCreateEmbeddedRequest.JSON_PROPERTY_CC_EMAIL_ADDRESSES,
  UnclaimedDraftCreateEmbeddedRequest.JSON_PROPERTY_CUSTOM_FIELDS,
  UnclaimedDraftCreateEmbeddedRequest.JSON_PROPERTY_EDITOR_OPTIONS,
  UnclaimedDraftCreateEmbeddedRequest.JSON_PROPERTY_FIELD_OPTIONS,
  UnclaimedDraftCreateEmbeddedRequest.JSON_PROPERTY_FORCE_SIGNER_PAGE,
  UnclaimedDraftCreateEmbeddedRequest.JSON_PROPERTY_FORCE_SUBJECT_MESSAGE,
  UnclaimedDraftCreateEmbeddedRequest.JSON_PROPERTY_FORM_FIELD_GROUPS,
  UnclaimedDraftCreateEmbeddedRequest.JSON_PROPERTY_FORM_FIELD_RULES,
  UnclaimedDraftCreateEmbeddedRequest.JSON_PROPERTY_FORM_FIELDS_PER_DOCUMENT,
  UnclaimedDraftCreateEmbeddedRequest.JSON_PROPERTY_HIDE_TEXT_TAGS,
  UnclaimedDraftCreateEmbeddedRequest.JSON_PROPERTY_HOLD_REQUEST,
  UnclaimedDraftCreateEmbeddedRequest.JSON_PROPERTY_IS_FOR_EMBEDDED_SIGNING,
  UnclaimedDraftCreateEmbeddedRequest.JSON_PROPERTY_MESSAGE,
  UnclaimedDraftCreateEmbeddedRequest.JSON_PROPERTY_METADATA,
  UnclaimedDraftCreateEmbeddedRequest.JSON_PROPERTY_REQUESTING_REDIRECT_URL,
  UnclaimedDraftCreateEmbeddedRequest.JSON_PROPERTY_SHOW_PREVIEW,
  UnclaimedDraftCreateEmbeddedRequest.JSON_PROPERTY_SHOW_PROGRESS_STEPPER,
  UnclaimedDraftCreateEmbeddedRequest.JSON_PROPERTY_SIGNERS,
  UnclaimedDraftCreateEmbeddedRequest.JSON_PROPERTY_SIGNING_OPTIONS,
  UnclaimedDraftCreateEmbeddedRequest.JSON_PROPERTY_SIGNING_REDIRECT_URL,
  UnclaimedDraftCreateEmbeddedRequest.JSON_PROPERTY_SKIP_ME_NOW,
  UnclaimedDraftCreateEmbeddedRequest.JSON_PROPERTY_SUBJECT,
  UnclaimedDraftCreateEmbeddedRequest.JSON_PROPERTY_TEST_MODE,
  UnclaimedDraftCreateEmbeddedRequest.JSON_PROPERTY_TYPE,
  UnclaimedDraftCreateEmbeddedRequest.JSON_PROPERTY_USE_PREEXISTING_FIELDS,
  UnclaimedDraftCreateEmbeddedRequest.JSON_PROPERTY_USE_TEXT_TAGS,
  UnclaimedDraftCreateEmbeddedRequest.JSON_PROPERTY_POPULATE_AUTO_FILL_FIELDS,
  UnclaimedDraftCreateEmbeddedRequest.JSON_PROPERTY_EXPIRES_AT
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
@JsonIgnoreProperties(ignoreUnknown=true)
public class UnclaimedDraftCreateEmbeddedRequest {
  public static final String JSON_PROPERTY_CLIENT_ID = "client_id";
  private String clientId;

  public static final String JSON_PROPERTY_REQUESTER_EMAIL_ADDRESS = "requester_email_address";
  private String requesterEmailAddress;

  public static final String JSON_PROPERTY_FILES = "files";
  private List<File> files = null;

  public static final String JSON_PROPERTY_FILE_URLS = "file_urls";
  private List<String> fileUrls = null;

  public static final String JSON_PROPERTY_ALLOW_CCS = "allow_ccs";
  private Boolean allowCcs = true;

  public static final String JSON_PROPERTY_ALLOW_DECLINE = "allow_decline";
  private Boolean allowDecline = false;

  public static final String JSON_PROPERTY_ALLOW_REASSIGN = "allow_reassign";
  private Boolean allowReassign = false;

  public static final String JSON_PROPERTY_ATTACHMENTS = "attachments";
  private List<SubAttachment> attachments = null;

  public static final String JSON_PROPERTY_CC_EMAIL_ADDRESSES = "cc_email_addresses";
  private List<String> ccEmailAddresses = null;

  public static final String JSON_PROPERTY_CUSTOM_FIELDS = "custom_fields";
  private List<SubCustomField> customFields = null;

  public static final String JSON_PROPERTY_EDITOR_OPTIONS = "editor_options";
  private SubEditorOptions editorOptions;

  public static final String JSON_PROPERTY_FIELD_OPTIONS = "field_options";
  private SubFieldOptions fieldOptions;

  public static final String JSON_PROPERTY_FORCE_SIGNER_PAGE = "force_signer_page";
  private Boolean forceSignerPage = false;

  public static final String JSON_PROPERTY_FORCE_SUBJECT_MESSAGE = "force_subject_message";
  private Boolean forceSubjectMessage = false;

  public static final String JSON_PROPERTY_FORM_FIELD_GROUPS = "form_field_groups";
  private List<SubFormFieldGroup> formFieldGroups = null;

  public static final String JSON_PROPERTY_FORM_FIELD_RULES = "form_field_rules";
  private List<SubFormFieldRule> formFieldRules = null;

  public static final String JSON_PROPERTY_FORM_FIELDS_PER_DOCUMENT = "form_fields_per_document";
  private List<SubFormFieldsPerDocumentBase> formFieldsPerDocument = null;

  public static final String JSON_PROPERTY_HIDE_TEXT_TAGS = "hide_text_tags";
  private Boolean hideTextTags = false;

  public static final String JSON_PROPERTY_HOLD_REQUEST = "hold_request";
  private Boolean holdRequest = false;

  public static final String JSON_PROPERTY_IS_FOR_EMBEDDED_SIGNING = "is_for_embedded_signing";
  private Boolean isForEmbeddedSigning = false;

  public static final String JSON_PROPERTY_MESSAGE = "message";
  private String message;

  public static final String JSON_PROPERTY_METADATA = "metadata";
  private Map<String, Object> metadata = null;

  public static final String JSON_PROPERTY_REQUESTING_REDIRECT_URL = "requesting_redirect_url";
  private String requestingRedirectUrl;

  public static final String JSON_PROPERTY_SHOW_PREVIEW = "show_preview";
  private Boolean showPreview;

  public static final String JSON_PROPERTY_SHOW_PROGRESS_STEPPER = "show_progress_stepper";
  private Boolean showProgressStepper = true;

  public static final String JSON_PROPERTY_SIGNERS = "signers";
  private List<SubUnclaimedDraftSigner> signers = null;

  public static final String JSON_PROPERTY_SIGNING_OPTIONS = "signing_options";
  private SubSigningOptions signingOptions;

  public static final String JSON_PROPERTY_SIGNING_REDIRECT_URL = "signing_redirect_url";
  private String signingRedirectUrl;

  public static final String JSON_PROPERTY_SKIP_ME_NOW = "skip_me_now";
  private Boolean skipMeNow = false;

  public static final String JSON_PROPERTY_SUBJECT = "subject";
  private String subject;

  public static final String JSON_PROPERTY_TEST_MODE = "test_mode";
  private Boolean testMode = false;

  /**
   * The type of the draft. By default this is &#x60;request_signature&#x60;, but you can set it to &#x60;send_document&#x60; if you want to self sign a document and download it.
   */
  public enum TypeEnum {
    SEND_DOCUMENT("send_document"),
    
    REQUEST_SIGNATURE("request_signature");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type = TypeEnum.REQUEST_SIGNATURE;

  public static final String JSON_PROPERTY_USE_PREEXISTING_FIELDS = "use_preexisting_fields";
  private Boolean usePreexistingFields = false;

  public static final String JSON_PROPERTY_USE_TEXT_TAGS = "use_text_tags";
  private Boolean useTextTags = false;

  public static final String JSON_PROPERTY_POPULATE_AUTO_FILL_FIELDS = "populate_auto_fill_fields";
  private Boolean populateAutoFillFields = false;

  public static final String JSON_PROPERTY_EXPIRES_AT = "expires_at";
  private Integer expiresAt;

  public UnclaimedDraftCreateEmbeddedRequest() { 
  }

  /**
   * Attempt to instantiate and hydrate a new instance of this class
   * @param jsonData String of JSON data representing target object
   */
  static public UnclaimedDraftCreateEmbeddedRequest init(String jsonData) throws Exception {
    return new ObjectMapper().readValue(jsonData, UnclaimedDraftCreateEmbeddedRequest.class);
  }

  static public UnclaimedDraftCreateEmbeddedRequest init(HashMap data) throws Exception {
    return new ObjectMapper().readValue(
      new ObjectMapper().writeValueAsString(data),
      UnclaimedDraftCreateEmbeddedRequest.class
    );
  }

  public UnclaimedDraftCreateEmbeddedRequest clientId(String clientId) {
    this.clientId = clientId;
    return this;
  }

  /**
   * Client id of the app used to create the draft. Used to apply the branding and callback url defined for the app.
   * @return clientId
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_CLIENT_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getClientId() {
    return clientId;
  }


  @JsonProperty(JSON_PROPERTY_CLIENT_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setClientId(String clientId) {
    this.clientId = clientId;
  }


  public UnclaimedDraftCreateEmbeddedRequest requesterEmailAddress(String requesterEmailAddress) {
    this.requesterEmailAddress = requesterEmailAddress;
    return this;
  }

  /**
   * The email address of the user that should be designated as the requester of this draft, if the draft type is &#x60;request_signature&#x60;.
   * @return requesterEmailAddress
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_REQUESTER_EMAIL_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRequesterEmailAddress() {
    return requesterEmailAddress;
  }


  @JsonProperty(JSON_PROPERTY_REQUESTER_EMAIL_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRequesterEmailAddress(String requesterEmailAddress) {
    this.requesterEmailAddress = requesterEmailAddress;
  }


  public UnclaimedDraftCreateEmbeddedRequest files(List<File> files) {
    this.files = files;
    return this;
  }

  public UnclaimedDraftCreateEmbeddedRequest addFilesItem(File filesItem) {
    if (this.files == null) {
      this.files = new ArrayList<>();
    }
    this.files.add(filesItem);
    return this;
  }

  /**
   * Use &#x60;files[]&#x60; to indicate the uploaded file(s) to send for signature.  This endpoint requires either **files** or **file_urls[]**, but not both.
   * @return files
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FILES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<File> getFiles() {
    return files;
  }


  @JsonProperty(JSON_PROPERTY_FILES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFiles(List<File> files) {
    this.files = files;
  }


  public UnclaimedDraftCreateEmbeddedRequest fileUrls(List<String> fileUrls) {
    this.fileUrls = fileUrls;
    return this;
  }

  public UnclaimedDraftCreateEmbeddedRequest addFileUrlsItem(String fileUrlsItem) {
    if (this.fileUrls == null) {
      this.fileUrls = new ArrayList<>();
    }
    this.fileUrls.add(fileUrlsItem);
    return this;
  }

  /**
   * Use &#x60;file_urls[]&#x60; to have Dropbox Sign download the file(s) to send for signature.  This endpoint requires either **files** or **file_urls[]**, but not both.
   * @return fileUrls
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FILE_URLS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getFileUrls() {
    return fileUrls;
  }


  @JsonProperty(JSON_PROPERTY_FILE_URLS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFileUrls(List<String> fileUrls) {
    this.fileUrls = fileUrls;
  }


  public UnclaimedDraftCreateEmbeddedRequest allowCcs(Boolean allowCcs) {
    this.allowCcs = allowCcs;
    return this;
  }

  /**
   * This allows the requester to specify whether the user is allowed to provide email addresses to CC when claiming the draft.
   * @return allowCcs
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ALLOW_CCS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAllowCcs() {
    return allowCcs;
  }


  @JsonProperty(JSON_PROPERTY_ALLOW_CCS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAllowCcs(Boolean allowCcs) {
    this.allowCcs = allowCcs;
  }


  public UnclaimedDraftCreateEmbeddedRequest allowDecline(Boolean allowDecline) {
    this.allowDecline = allowDecline;
    return this;
  }

  /**
   * Allows signers to decline to sign a document if &#x60;true&#x60;. Defaults to &#x60;false&#x60;.
   * @return allowDecline
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ALLOW_DECLINE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAllowDecline() {
    return allowDecline;
  }


  @JsonProperty(JSON_PROPERTY_ALLOW_DECLINE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAllowDecline(Boolean allowDecline) {
    this.allowDecline = allowDecline;
  }


  public UnclaimedDraftCreateEmbeddedRequest allowReassign(Boolean allowReassign) {
    this.allowReassign = allowReassign;
    return this;
  }

  /**
   * Allows signers to reassign their signature requests to other signers if set to &#x60;true&#x60;. Defaults to &#x60;false&#x60;.  **NOTE:** Only available for Premium plan and higher.
   * @return allowReassign
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ALLOW_REASSIGN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAllowReassign() {
    return allowReassign;
  }


  @JsonProperty(JSON_PROPERTY_ALLOW_REASSIGN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAllowReassign(Boolean allowReassign) {
    this.allowReassign = allowReassign;
  }


  public UnclaimedDraftCreateEmbeddedRequest attachments(List<SubAttachment> attachments) {
    this.attachments = attachments;
    return this;
  }

  public UnclaimedDraftCreateEmbeddedRequest addAttachmentsItem(SubAttachment attachmentsItem) {
    if (this.attachments == null) {
      this.attachments = new ArrayList<>();
    }
    this.attachments.add(attachmentsItem);
    return this;
  }

  /**
   * A list describing the attachments
   * @return attachments
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ATTACHMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SubAttachment> getAttachments() {
    return attachments;
  }


  @JsonProperty(JSON_PROPERTY_ATTACHMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAttachments(List<SubAttachment> attachments) {
    this.attachments = attachments;
  }


  public UnclaimedDraftCreateEmbeddedRequest ccEmailAddresses(List<String> ccEmailAddresses) {
    this.ccEmailAddresses = ccEmailAddresses;
    return this;
  }

  public UnclaimedDraftCreateEmbeddedRequest addCcEmailAddressesItem(String ccEmailAddressesItem) {
    if (this.ccEmailAddresses == null) {
      this.ccEmailAddresses = new ArrayList<>();
    }
    this.ccEmailAddresses.add(ccEmailAddressesItem);
    return this;
  }

  /**
   * The email addresses that should be CCed.
   * @return ccEmailAddresses
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CC_EMAIL_ADDRESSES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getCcEmailAddresses() {
    return ccEmailAddresses;
  }


  @JsonProperty(JSON_PROPERTY_CC_EMAIL_ADDRESSES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCcEmailAddresses(List<String> ccEmailAddresses) {
    this.ccEmailAddresses = ccEmailAddresses;
  }


  public UnclaimedDraftCreateEmbeddedRequest customFields(List<SubCustomField> customFields) {
    this.customFields = customFields;
    return this;
  }

  public UnclaimedDraftCreateEmbeddedRequest addCustomFieldsItem(SubCustomField customFieldsItem) {
    if (this.customFields == null) {
      this.customFields = new ArrayList<>();
    }
    this.customFields.add(customFieldsItem);
    return this;
  }

  /**
   * When used together with merge fields, &#x60;custom_fields&#x60; allows users to add pre-filled data to their signature requests.  Pre-filled data can be used with \&quot;send-once\&quot; signature requests by adding merge fields with &#x60;form_fields_per_document&#x60; or [Text Tags](https://app.hellosign.com/api/textTagsWalkthrough#TextTagIntro) while passing values back with &#x60;custom_fields&#x60; together in one API call.  For using pre-filled on repeatable signature requests, merge fields are added to templates in the Dropbox Sign UI or by calling [/template/create_embedded_draft](/api/reference/operation/templateCreateEmbeddedDraft) and then passing &#x60;custom_fields&#x60; on subsequent signature requests referencing that template.
   * @return customFields
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CUSTOM_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SubCustomField> getCustomFields() {
    return customFields;
  }


  @JsonProperty(JSON_PROPERTY_CUSTOM_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCustomFields(List<SubCustomField> customFields) {
    this.customFields = customFields;
  }


  public UnclaimedDraftCreateEmbeddedRequest editorOptions(SubEditorOptions editorOptions) {
    this.editorOptions = editorOptions;
    return this;
  }

  /**
   * Get editorOptions
   * @return editorOptions
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_EDITOR_OPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SubEditorOptions getEditorOptions() {
    return editorOptions;
  }


  @JsonProperty(JSON_PROPERTY_EDITOR_OPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEditorOptions(SubEditorOptions editorOptions) {
    this.editorOptions = editorOptions;
  }


  public UnclaimedDraftCreateEmbeddedRequest fieldOptions(SubFieldOptions fieldOptions) {
    this.fieldOptions = fieldOptions;
    return this;
  }

  /**
   * Get fieldOptions
   * @return fieldOptions
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FIELD_OPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SubFieldOptions getFieldOptions() {
    return fieldOptions;
  }


  @JsonProperty(JSON_PROPERTY_FIELD_OPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFieldOptions(SubFieldOptions fieldOptions) {
    this.fieldOptions = fieldOptions;
  }


  public UnclaimedDraftCreateEmbeddedRequest forceSignerPage(Boolean forceSignerPage) {
    this.forceSignerPage = forceSignerPage;
    return this;
  }

  /**
   * Provide users the ability to review/edit the signers.
   * @return forceSignerPage
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FORCE_SIGNER_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getForceSignerPage() {
    return forceSignerPage;
  }


  @JsonProperty(JSON_PROPERTY_FORCE_SIGNER_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setForceSignerPage(Boolean forceSignerPage) {
    this.forceSignerPage = forceSignerPage;
  }


  public UnclaimedDraftCreateEmbeddedRequest forceSubjectMessage(Boolean forceSubjectMessage) {
    this.forceSubjectMessage = forceSubjectMessage;
    return this;
  }

  /**
   * Provide users the ability to review/edit the subject and message.
   * @return forceSubjectMessage
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FORCE_SUBJECT_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getForceSubjectMessage() {
    return forceSubjectMessage;
  }


  @JsonProperty(JSON_PROPERTY_FORCE_SUBJECT_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setForceSubjectMessage(Boolean forceSubjectMessage) {
    this.forceSubjectMessage = forceSubjectMessage;
  }


  public UnclaimedDraftCreateEmbeddedRequest formFieldGroups(List<SubFormFieldGroup> formFieldGroups) {
    this.formFieldGroups = formFieldGroups;
    return this;
  }

  public UnclaimedDraftCreateEmbeddedRequest addFormFieldGroupsItem(SubFormFieldGroup formFieldGroupsItem) {
    if (this.formFieldGroups == null) {
      this.formFieldGroups = new ArrayList<>();
    }
    this.formFieldGroups.add(formFieldGroupsItem);
    return this;
  }

  /**
   * Group information for fields defined in &#x60;form_fields_per_document&#x60;. String-indexed JSON array with &#x60;group_label&#x60; and &#x60;requirement&#x60; keys. &#x60;form_fields_per_document&#x60; must contain fields referencing a group defined in &#x60;form_field_groups&#x60;.
   * @return formFieldGroups
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FORM_FIELD_GROUPS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SubFormFieldGroup> getFormFieldGroups() {
    return formFieldGroups;
  }


  @JsonProperty(JSON_PROPERTY_FORM_FIELD_GROUPS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFormFieldGroups(List<SubFormFieldGroup> formFieldGroups) {
    this.formFieldGroups = formFieldGroups;
  }


  public UnclaimedDraftCreateEmbeddedRequest formFieldRules(List<SubFormFieldRule> formFieldRules) {
    this.formFieldRules = formFieldRules;
    return this;
  }

  public UnclaimedDraftCreateEmbeddedRequest addFormFieldRulesItem(SubFormFieldRule formFieldRulesItem) {
    if (this.formFieldRules == null) {
      this.formFieldRules = new ArrayList<>();
    }
    this.formFieldRules.add(formFieldRulesItem);
    return this;
  }

  /**
   * Conditional Logic rules for fields defined in &#x60;form_fields_per_document&#x60;.
   * @return formFieldRules
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FORM_FIELD_RULES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SubFormFieldRule> getFormFieldRules() {
    return formFieldRules;
  }


  @JsonProperty(JSON_PROPERTY_FORM_FIELD_RULES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFormFieldRules(List<SubFormFieldRule> formFieldRules) {
    this.formFieldRules = formFieldRules;
  }


  public UnclaimedDraftCreateEmbeddedRequest formFieldsPerDocument(List<SubFormFieldsPerDocumentBase> formFieldsPerDocument) {
    this.formFieldsPerDocument = formFieldsPerDocument;
    return this;
  }

  public UnclaimedDraftCreateEmbeddedRequest addFormFieldsPerDocumentItem(SubFormFieldsPerDocumentBase formFieldsPerDocumentItem) {
    if (this.formFieldsPerDocument == null) {
      this.formFieldsPerDocument = new ArrayList<>();
    }
    this.formFieldsPerDocument.add(formFieldsPerDocumentItem);
    return this;
  }

  /**
   * The fields that should appear on the document, expressed as an array of objects. (For more details you can read about it here: [Using Form Fields per Document](/docs/openapi/form-fields-per-document).)  **NOTE:** Fields like **text**, **dropdown**, **checkbox**, **radio**, and **hyperlink** have additional required and optional parameters. Check out the list of [additional parameters](/api/reference/constants/#form-fields-per-document) for these field types.  * Text Field use &#x60;SubFormFieldsPerDocumentText&#x60; * Dropdown Field use &#x60;SubFormFieldsPerDocumentDropdown&#x60; * Hyperlink Field use &#x60;SubFormFieldsPerDocumentHyperlink&#x60; * Checkbox Field use &#x60;SubFormFieldsPerDocumentCheckbox&#x60; * Radio Field use &#x60;SubFormFieldsPerDocumentRadio&#x60; * Signature Field use &#x60;SubFormFieldsPerDocumentSignature&#x60; * Date Signed Field use &#x60;SubFormFieldsPerDocumentDateSigned&#x60; * Initials Field use &#x60;SubFormFieldsPerDocumentInitials&#x60; * Text Merge Field use &#x60;SubFormFieldsPerDocumentTextMerge&#x60; * Checkbox Merge Field use &#x60;SubFormFieldsPerDocumentCheckboxMerge&#x60;
   * @return formFieldsPerDocument
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FORM_FIELDS_PER_DOCUMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SubFormFieldsPerDocumentBase> getFormFieldsPerDocument() {
    return formFieldsPerDocument;
  }


  @JsonProperty(JSON_PROPERTY_FORM_FIELDS_PER_DOCUMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFormFieldsPerDocument(List<SubFormFieldsPerDocumentBase> formFieldsPerDocument) {
    this.formFieldsPerDocument = formFieldsPerDocument;
  }


  public UnclaimedDraftCreateEmbeddedRequest hideTextTags(Boolean hideTextTags) {
    this.hideTextTags = hideTextTags;
    return this;
  }

  /**
   * Send with a value of &#x60;true&#x60; if you wish to enable automatic Text Tag removal. Defaults to &#x60;false&#x60;. When using Text Tags it is preferred that you set this to &#x60;false&#x60; and hide your tags with white text or something similar because the automatic removal system can cause unwanted clipping. See the [Text Tags](https://app.hellosign.com/api/textTagsWalkthrough#TextTagIntro) walkthrough for more details.
   * @return hideTextTags
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_HIDE_TEXT_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHideTextTags() {
    return hideTextTags;
  }


  @JsonProperty(JSON_PROPERTY_HIDE_TEXT_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHideTextTags(Boolean hideTextTags) {
    this.hideTextTags = hideTextTags;
  }


  public UnclaimedDraftCreateEmbeddedRequest holdRequest(Boolean holdRequest) {
    this.holdRequest = holdRequest;
    return this;
  }

  /**
   * The request from this draft will not automatically send to signers post-claim if set to &#x60;true&#x60;. Requester must [release](/api/reference/operation/signatureRequestReleaseHold/) the request from hold when ready to send. Defaults to &#x60;false&#x60;.
   * @return holdRequest
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_HOLD_REQUEST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHoldRequest() {
    return holdRequest;
  }


  @JsonProperty(JSON_PROPERTY_HOLD_REQUEST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHoldRequest(Boolean holdRequest) {
    this.holdRequest = holdRequest;
  }


  public UnclaimedDraftCreateEmbeddedRequest isForEmbeddedSigning(Boolean isForEmbeddedSigning) {
    this.isForEmbeddedSigning = isForEmbeddedSigning;
    return this;
  }

  /**
   * The request created from this draft will also be signable in embedded mode if set to &#x60;true&#x60;. Defaults to &#x60;false&#x60;.
   * @return isForEmbeddedSigning
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_IS_FOR_EMBEDDED_SIGNING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIsForEmbeddedSigning() {
    return isForEmbeddedSigning;
  }


  @JsonProperty(JSON_PROPERTY_IS_FOR_EMBEDDED_SIGNING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsForEmbeddedSigning(Boolean isForEmbeddedSigning) {
    this.isForEmbeddedSigning = isForEmbeddedSigning;
  }


  public UnclaimedDraftCreateEmbeddedRequest message(String message) {
    this.message = message;
    return this;
  }

  /**
   * The custom message in the email that will be sent to the signers.
   * @return message
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMessage() {
    return message;
  }


  @JsonProperty(JSON_PROPERTY_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMessage(String message) {
    this.message = message;
  }


  public UnclaimedDraftCreateEmbeddedRequest metadata(Map<String, Object> metadata) {
    this.metadata = metadata;
    return this;
  }

  public UnclaimedDraftCreateEmbeddedRequest putMetadataItem(String key, Object metadataItem) {
    if (this.metadata == null) {
      this.metadata = new HashMap<>();
    }
    this.metadata.put(key, metadataItem);
    return this;
  }

  /**
   * Key-value data that should be attached to the signature request. This metadata is included in all API responses and events involving the signature request. For example, use the metadata field to store a signer&#39;s order number for look up when receiving events for the signature request.  Each request can include up to 10 metadata keys (or 50 nested metadata keys), with key names up to 40 characters long and values up to 1000 characters long.
   * @return metadata
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Object> getMetadata() {
    return metadata;
  }


  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetadata(Map<String, Object> metadata) {
    this.metadata = metadata;
  }


  public UnclaimedDraftCreateEmbeddedRequest requestingRedirectUrl(String requestingRedirectUrl) {
    this.requestingRedirectUrl = requestingRedirectUrl;
    return this;
  }

  /**
   * The URL you want signers redirected to after they successfully request a signature.
   * @return requestingRedirectUrl
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_REQUESTING_REDIRECT_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRequestingRedirectUrl() {
    return requestingRedirectUrl;
  }


  @JsonProperty(JSON_PROPERTY_REQUESTING_REDIRECT_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRequestingRedirectUrl(String requestingRedirectUrl) {
    this.requestingRedirectUrl = requestingRedirectUrl;
  }


  public UnclaimedDraftCreateEmbeddedRequest showPreview(Boolean showPreview) {
    this.showPreview = showPreview;
    return this;
  }

  /**
   * This allows the requester to enable the editor/preview experience.  - &#x60;show_preview&#x3D;true&#x60;: Allows requesters to enable the editor/preview experience. - &#x60;show_preview&#x3D;false&#x60;: Allows requesters to disable the editor/preview experience.
   * @return showPreview
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SHOW_PREVIEW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowPreview() {
    return showPreview;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_PREVIEW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowPreview(Boolean showPreview) {
    this.showPreview = showPreview;
  }


  public UnclaimedDraftCreateEmbeddedRequest showProgressStepper(Boolean showProgressStepper) {
    this.showProgressStepper = showProgressStepper;
    return this;
  }

  /**
   * When only one step remains in the signature request process and this parameter is set to &#x60;false&#x60; then the progress stepper will be hidden.
   * @return showProgressStepper
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SHOW_PROGRESS_STEPPER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowProgressStepper() {
    return showProgressStepper;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_PROGRESS_STEPPER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowProgressStepper(Boolean showProgressStepper) {
    this.showProgressStepper = showProgressStepper;
  }


  public UnclaimedDraftCreateEmbeddedRequest signers(List<SubUnclaimedDraftSigner> signers) {
    this.signers = signers;
    return this;
  }

  public UnclaimedDraftCreateEmbeddedRequest addSignersItem(SubUnclaimedDraftSigner signersItem) {
    if (this.signers == null) {
      this.signers = new ArrayList<>();
    }
    this.signers.add(signersItem);
    return this;
  }

  /**
   * Add Signers to your Unclaimed Draft Signature Request.
   * @return signers
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SIGNERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SubUnclaimedDraftSigner> getSigners() {
    return signers;
  }


  @JsonProperty(JSON_PROPERTY_SIGNERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSigners(List<SubUnclaimedDraftSigner> signers) {
    this.signers = signers;
  }


  public UnclaimedDraftCreateEmbeddedRequest signingOptions(SubSigningOptions signingOptions) {
    this.signingOptions = signingOptions;
    return this;
  }

  /**
   * Get signingOptions
   * @return signingOptions
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SIGNING_OPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SubSigningOptions getSigningOptions() {
    return signingOptions;
  }


  @JsonProperty(JSON_PROPERTY_SIGNING_OPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSigningOptions(SubSigningOptions signingOptions) {
    this.signingOptions = signingOptions;
  }


  public UnclaimedDraftCreateEmbeddedRequest signingRedirectUrl(String signingRedirectUrl) {
    this.signingRedirectUrl = signingRedirectUrl;
    return this;
  }

  /**
   * The URL you want signers redirected to after they successfully sign.
   * @return signingRedirectUrl
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SIGNING_REDIRECT_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSigningRedirectUrl() {
    return signingRedirectUrl;
  }


  @JsonProperty(JSON_PROPERTY_SIGNING_REDIRECT_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSigningRedirectUrl(String signingRedirectUrl) {
    this.signingRedirectUrl = signingRedirectUrl;
  }


  public UnclaimedDraftCreateEmbeddedRequest skipMeNow(Boolean skipMeNow) {
    this.skipMeNow = skipMeNow;
    return this;
  }

  /**
   * Disables the \&quot;Me (Now)\&quot; option for the person preparing the document. Does not work with type &#x60;send_document&#x60;. Defaults to &#x60;false&#x60;.
   * @return skipMeNow
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SKIP_ME_NOW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSkipMeNow() {
    return skipMeNow;
  }


  @JsonProperty(JSON_PROPERTY_SKIP_ME_NOW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSkipMeNow(Boolean skipMeNow) {
    this.skipMeNow = skipMeNow;
  }


  public UnclaimedDraftCreateEmbeddedRequest subject(String subject) {
    this.subject = subject;
    return this;
  }

  /**
   * The subject in the email that will be sent to the signers.
   * @return subject
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SUBJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSubject() {
    return subject;
  }


  @JsonProperty(JSON_PROPERTY_SUBJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubject(String subject) {
    this.subject = subject;
  }


  public UnclaimedDraftCreateEmbeddedRequest testMode(Boolean testMode) {
    this.testMode = testMode;
    return this;
  }

  /**
   * Whether this is a test, the signature request created from this draft will not be legally binding if set to &#x60;true&#x60;. Defaults to &#x60;false&#x60;.
   * @return testMode
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TEST_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getTestMode() {
    return testMode;
  }


  @JsonProperty(JSON_PROPERTY_TEST_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTestMode(Boolean testMode) {
    this.testMode = testMode;
  }


  public UnclaimedDraftCreateEmbeddedRequest type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * The type of the draft. By default this is &#x60;request_signature&#x60;, but you can set it to &#x60;send_document&#x60; if you want to self sign a document and download it.
   * @return type
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public UnclaimedDraftCreateEmbeddedRequest usePreexistingFields(Boolean usePreexistingFields) {
    this.usePreexistingFields = usePreexistingFields;
    return this;
  }

  /**
   * Set &#x60;use_text_tags&#x60; to &#x60;true&#x60; to enable [Text Tags](https://app.hellosign.com/api/textTagsWalkthrough#TextTagIntro) parsing in your document (defaults to disabled, or &#x60;false&#x60;). Alternatively, if your PDF contains pre-defined fields, enable the detection of these fields by setting the &#x60;use_preexisting_fields&#x60; to &#x60;true&#x60; (defaults to disabled, or &#x60;false&#x60;). Currently we only support use of either &#x60;use_text_tags&#x60; or &#x60;use_preexisting_fields&#x60; parameter, not both.
   * @return usePreexistingFields
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_USE_PREEXISTING_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getUsePreexistingFields() {
    return usePreexistingFields;
  }


  @JsonProperty(JSON_PROPERTY_USE_PREEXISTING_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUsePreexistingFields(Boolean usePreexistingFields) {
    this.usePreexistingFields = usePreexistingFields;
  }


  public UnclaimedDraftCreateEmbeddedRequest useTextTags(Boolean useTextTags) {
    this.useTextTags = useTextTags;
    return this;
  }

  /**
   * Set &#x60;use_text_tags&#x60; to &#x60;true&#x60; to enable [Text Tags](https://app.hellosign.com/api/textTagsWalkthrough#TextTagIntro) parsing in your document (defaults to disabled, or &#x60;false&#x60;). Alternatively, if your PDF contains pre-defined fields, enable the detection of these fields by setting the &#x60;use_preexisting_fields&#x60; to &#x60;true&#x60; (defaults to disabled, or &#x60;false&#x60;). Currently we only support use of either &#x60;use_text_tags&#x60; or &#x60;use_preexisting_fields&#x60; parameter, not both.
   * @return useTextTags
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_USE_TEXT_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getUseTextTags() {
    return useTextTags;
  }


  @JsonProperty(JSON_PROPERTY_USE_TEXT_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUseTextTags(Boolean useTextTags) {
    this.useTextTags = useTextTags;
  }


  public UnclaimedDraftCreateEmbeddedRequest populateAutoFillFields(Boolean populateAutoFillFields) {
    this.populateAutoFillFields = populateAutoFillFields;
    return this;
  }

  /**
   * Controls whether [auto fill fields](https://faq.hellosign.com/hc/en-us/articles/360051467511-Auto-Fill-Fields) can automatically populate a signer&#39;s information during signing.  **NOTE:** Keep your signer&#39;s information safe by ensuring that the _signer on your signature request is the intended party_ before using this feature.
   * @return populateAutoFillFields
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_POPULATE_AUTO_FILL_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getPopulateAutoFillFields() {
    return populateAutoFillFields;
  }


  @JsonProperty(JSON_PROPERTY_POPULATE_AUTO_FILL_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPopulateAutoFillFields(Boolean populateAutoFillFields) {
    this.populateAutoFillFields = populateAutoFillFields;
  }


  public UnclaimedDraftCreateEmbeddedRequest expiresAt(Integer expiresAt) {
    this.expiresAt = expiresAt;
    return this;
  }

  /**
   * When the signature request will expire. Unsigned signatures will be moved to the expired status, and no longer signable. See [Signature Request Expiration Date](https://developers.hellosign.com/docs/signature-request/expiration/) for details.  **NOTE:** This does not correspond to the **expires_at** returned in the response.
   * @return expiresAt
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_EXPIRES_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getExpiresAt() {
    return expiresAt;
  }


  @JsonProperty(JSON_PROPERTY_EXPIRES_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExpiresAt(Integer expiresAt) {
    this.expiresAt = expiresAt;
  }


  /**
   * Return true if this UnclaimedDraftCreateEmbeddedRequest object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UnclaimedDraftCreateEmbeddedRequest unclaimedDraftCreateEmbeddedRequest = (UnclaimedDraftCreateEmbeddedRequest) o;
    return Objects.equals(this.clientId, unclaimedDraftCreateEmbeddedRequest.clientId) &&
        Objects.equals(this.requesterEmailAddress, unclaimedDraftCreateEmbeddedRequest.requesterEmailAddress) &&
        Objects.equals(this.files, unclaimedDraftCreateEmbeddedRequest.files) &&
        Objects.equals(this.fileUrls, unclaimedDraftCreateEmbeddedRequest.fileUrls) &&
        Objects.equals(this.allowCcs, unclaimedDraftCreateEmbeddedRequest.allowCcs) &&
        Objects.equals(this.allowDecline, unclaimedDraftCreateEmbeddedRequest.allowDecline) &&
        Objects.equals(this.allowReassign, unclaimedDraftCreateEmbeddedRequest.allowReassign) &&
        Objects.equals(this.attachments, unclaimedDraftCreateEmbeddedRequest.attachments) &&
        Objects.equals(this.ccEmailAddresses, unclaimedDraftCreateEmbeddedRequest.ccEmailAddresses) &&
        Objects.equals(this.customFields, unclaimedDraftCreateEmbeddedRequest.customFields) &&
        Objects.equals(this.editorOptions, unclaimedDraftCreateEmbeddedRequest.editorOptions) &&
        Objects.equals(this.fieldOptions, unclaimedDraftCreateEmbeddedRequest.fieldOptions) &&
        Objects.equals(this.forceSignerPage, unclaimedDraftCreateEmbeddedRequest.forceSignerPage) &&
        Objects.equals(this.forceSubjectMessage, unclaimedDraftCreateEmbeddedRequest.forceSubjectMessage) &&
        Objects.equals(this.formFieldGroups, unclaimedDraftCreateEmbeddedRequest.formFieldGroups) &&
        Objects.equals(this.formFieldRules, unclaimedDraftCreateEmbeddedRequest.formFieldRules) &&
        Objects.equals(this.formFieldsPerDocument, unclaimedDraftCreateEmbeddedRequest.formFieldsPerDocument) &&
        Objects.equals(this.hideTextTags, unclaimedDraftCreateEmbeddedRequest.hideTextTags) &&
        Objects.equals(this.holdRequest, unclaimedDraftCreateEmbeddedRequest.holdRequest) &&
        Objects.equals(this.isForEmbeddedSigning, unclaimedDraftCreateEmbeddedRequest.isForEmbeddedSigning) &&
        Objects.equals(this.message, unclaimedDraftCreateEmbeddedRequest.message) &&
        Objects.equals(this.metadata, unclaimedDraftCreateEmbeddedRequest.metadata) &&
        Objects.equals(this.requestingRedirectUrl, unclaimedDraftCreateEmbeddedRequest.requestingRedirectUrl) &&
        Objects.equals(this.showPreview, unclaimedDraftCreateEmbeddedRequest.showPreview) &&
        Objects.equals(this.showProgressStepper, unclaimedDraftCreateEmbeddedRequest.showProgressStepper) &&
        Objects.equals(this.signers, unclaimedDraftCreateEmbeddedRequest.signers) &&
        Objects.equals(this.signingOptions, unclaimedDraftCreateEmbeddedRequest.signingOptions) &&
        Objects.equals(this.signingRedirectUrl, unclaimedDraftCreateEmbeddedRequest.signingRedirectUrl) &&
        Objects.equals(this.skipMeNow, unclaimedDraftCreateEmbeddedRequest.skipMeNow) &&
        Objects.equals(this.subject, unclaimedDraftCreateEmbeddedRequest.subject) &&
        Objects.equals(this.testMode, unclaimedDraftCreateEmbeddedRequest.testMode) &&
        Objects.equals(this.type, unclaimedDraftCreateEmbeddedRequest.type) &&
        Objects.equals(this.usePreexistingFields, unclaimedDraftCreateEmbeddedRequest.usePreexistingFields) &&
        Objects.equals(this.useTextTags, unclaimedDraftCreateEmbeddedRequest.useTextTags) &&
        Objects.equals(this.populateAutoFillFields, unclaimedDraftCreateEmbeddedRequest.populateAutoFillFields) &&
        Objects.equals(this.expiresAt, unclaimedDraftCreateEmbeddedRequest.expiresAt);
  }

  @Override
  public int hashCode() {
    return Objects.hash(clientId, requesterEmailAddress, files, fileUrls, allowCcs, allowDecline, allowReassign, attachments, ccEmailAddresses, customFields, editorOptions, fieldOptions, forceSignerPage, forceSubjectMessage, formFieldGroups, formFieldRules, formFieldsPerDocument, hideTextTags, holdRequest, isForEmbeddedSigning, message, metadata, requestingRedirectUrl, showPreview, showProgressStepper, signers, signingOptions, signingRedirectUrl, skipMeNow, subject, testMode, type, usePreexistingFields, useTextTags, populateAutoFillFields, expiresAt);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UnclaimedDraftCreateEmbeddedRequest {\n");
    sb.append("    clientId: ").append(toIndentedString(clientId)).append("\n");
    sb.append("    requesterEmailAddress: ").append(toIndentedString(requesterEmailAddress)).append("\n");
    sb.append("    files: ").append(toIndentedString(files)).append("\n");
    sb.append("    fileUrls: ").append(toIndentedString(fileUrls)).append("\n");
    sb.append("    allowCcs: ").append(toIndentedString(allowCcs)).append("\n");
    sb.append("    allowDecline: ").append(toIndentedString(allowDecline)).append("\n");
    sb.append("    allowReassign: ").append(toIndentedString(allowReassign)).append("\n");
    sb.append("    attachments: ").append(toIndentedString(attachments)).append("\n");
    sb.append("    ccEmailAddresses: ").append(toIndentedString(ccEmailAddresses)).append("\n");
    sb.append("    customFields: ").append(toIndentedString(customFields)).append("\n");
    sb.append("    editorOptions: ").append(toIndentedString(editorOptions)).append("\n");
    sb.append("    fieldOptions: ").append(toIndentedString(fieldOptions)).append("\n");
    sb.append("    forceSignerPage: ").append(toIndentedString(forceSignerPage)).append("\n");
    sb.append("    forceSubjectMessage: ").append(toIndentedString(forceSubjectMessage)).append("\n");
    sb.append("    formFieldGroups: ").append(toIndentedString(formFieldGroups)).append("\n");
    sb.append("    formFieldRules: ").append(toIndentedString(formFieldRules)).append("\n");
    sb.append("    formFieldsPerDocument: ").append(toIndentedString(formFieldsPerDocument)).append("\n");
    sb.append("    hideTextTags: ").append(toIndentedString(hideTextTags)).append("\n");
    sb.append("    holdRequest: ").append(toIndentedString(holdRequest)).append("\n");
    sb.append("    isForEmbeddedSigning: ").append(toIndentedString(isForEmbeddedSigning)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    requestingRedirectUrl: ").append(toIndentedString(requestingRedirectUrl)).append("\n");
    sb.append("    showPreview: ").append(toIndentedString(showPreview)).append("\n");
    sb.append("    showProgressStepper: ").append(toIndentedString(showProgressStepper)).append("\n");
    sb.append("    signers: ").append(toIndentedString(signers)).append("\n");
    sb.append("    signingOptions: ").append(toIndentedString(signingOptions)).append("\n");
    sb.append("    signingRedirectUrl: ").append(toIndentedString(signingRedirectUrl)).append("\n");
    sb.append("    skipMeNow: ").append(toIndentedString(skipMeNow)).append("\n");
    sb.append("    subject: ").append(toIndentedString(subject)).append("\n");
    sb.append("    testMode: ").append(toIndentedString(testMode)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    usePreexistingFields: ").append(toIndentedString(usePreexistingFields)).append("\n");
    sb.append("    useTextTags: ").append(toIndentedString(useTextTags)).append("\n");
    sb.append("    populateAutoFillFields: ").append(toIndentedString(populateAutoFillFields)).append("\n");
    sb.append("    expiresAt: ").append(toIndentedString(expiresAt)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  public Map<String, Object> createFormData() throws ApiException {
    Map<String, Object> map = new HashMap<>();
    boolean fileTypeFound = false;
    try {
    if (clientId != null) {
        if (isFileTypeOrListOfFiles(clientId)) {
            fileTypeFound = true;
        }

        if (clientId.getClass().equals(java.io.File.class) ||
            clientId.getClass().equals(Integer.class) ||
            clientId.getClass().equals(String.class) ||
            clientId.getClass().isEnum()) {
            map.put("client_id", clientId);
        } else if (isListOfFile(clientId)) {
            for(int i = 0; i< getListSize(clientId); i++) {
                map.put("client_id[" + i + "]", getFromList(clientId, i));
            }
        }
        else {
            map.put("client_id", JSON.getDefault().getMapper().writeValueAsString(clientId));
        }
    }
    if (requesterEmailAddress != null) {
        if (isFileTypeOrListOfFiles(requesterEmailAddress)) {
            fileTypeFound = true;
        }

        if (requesterEmailAddress.getClass().equals(java.io.File.class) ||
            requesterEmailAddress.getClass().equals(Integer.class) ||
            requesterEmailAddress.getClass().equals(String.class) ||
            requesterEmailAddress.getClass().isEnum()) {
            map.put("requester_email_address", requesterEmailAddress);
        } else if (isListOfFile(requesterEmailAddress)) {
            for(int i = 0; i< getListSize(requesterEmailAddress); i++) {
                map.put("requester_email_address[" + i + "]", getFromList(requesterEmailAddress, i));
            }
        }
        else {
            map.put("requester_email_address", JSON.getDefault().getMapper().writeValueAsString(requesterEmailAddress));
        }
    }
    if (files != null) {
        if (isFileTypeOrListOfFiles(files)) {
            fileTypeFound = true;
        }

        if (files.getClass().equals(java.io.File.class) ||
            files.getClass().equals(Integer.class) ||
            files.getClass().equals(String.class) ||
            files.getClass().isEnum()) {
            map.put("files", files);
        } else if (isListOfFile(files)) {
            for(int i = 0; i< getListSize(files); i++) {
                map.put("files[" + i + "]", getFromList(files, i));
            }
        }
        else {
            map.put("files", JSON.getDefault().getMapper().writeValueAsString(files));
        }
    }
    if (fileUrls != null) {
        if (isFileTypeOrListOfFiles(fileUrls)) {
            fileTypeFound = true;
        }

        if (fileUrls.getClass().equals(java.io.File.class) ||
            fileUrls.getClass().equals(Integer.class) ||
            fileUrls.getClass().equals(String.class) ||
            fileUrls.getClass().isEnum()) {
            map.put("file_urls", fileUrls);
        } else if (isListOfFile(fileUrls)) {
            for(int i = 0; i< getListSize(fileUrls); i++) {
                map.put("file_urls[" + i + "]", getFromList(fileUrls, i));
            }
        }
        else {
            map.put("file_urls", JSON.getDefault().getMapper().writeValueAsString(fileUrls));
        }
    }
    if (allowCcs != null) {
        if (isFileTypeOrListOfFiles(allowCcs)) {
            fileTypeFound = true;
        }

        if (allowCcs.getClass().equals(java.io.File.class) ||
            allowCcs.getClass().equals(Integer.class) ||
            allowCcs.getClass().equals(String.class) ||
            allowCcs.getClass().isEnum()) {
            map.put("allow_ccs", allowCcs);
        } else if (isListOfFile(allowCcs)) {
            for(int i = 0; i< getListSize(allowCcs); i++) {
                map.put("allow_ccs[" + i + "]", getFromList(allowCcs, i));
            }
        }
        else {
            map.put("allow_ccs", JSON.getDefault().getMapper().writeValueAsString(allowCcs));
        }
    }
    if (allowDecline != null) {
        if (isFileTypeOrListOfFiles(allowDecline)) {
            fileTypeFound = true;
        }

        if (allowDecline.getClass().equals(java.io.File.class) ||
            allowDecline.getClass().equals(Integer.class) ||
            allowDecline.getClass().equals(String.class) ||
            allowDecline.getClass().isEnum()) {
            map.put("allow_decline", allowDecline);
        } else if (isListOfFile(allowDecline)) {
            for(int i = 0; i< getListSize(allowDecline); i++) {
                map.put("allow_decline[" + i + "]", getFromList(allowDecline, i));
            }
        }
        else {
            map.put("allow_decline", JSON.getDefault().getMapper().writeValueAsString(allowDecline));
        }
    }
    if (allowReassign != null) {
        if (isFileTypeOrListOfFiles(allowReassign)) {
            fileTypeFound = true;
        }

        if (allowReassign.getClass().equals(java.io.File.class) ||
            allowReassign.getClass().equals(Integer.class) ||
            allowReassign.getClass().equals(String.class) ||
            allowReassign.getClass().isEnum()) {
            map.put("allow_reassign", allowReassign);
        } else if (isListOfFile(allowReassign)) {
            for(int i = 0; i< getListSize(allowReassign); i++) {
                map.put("allow_reassign[" + i + "]", getFromList(allowReassign, i));
            }
        }
        else {
            map.put("allow_reassign", JSON.getDefault().getMapper().writeValueAsString(allowReassign));
        }
    }
    if (attachments != null) {
        if (isFileTypeOrListOfFiles(attachments)) {
            fileTypeFound = true;
        }

        if (attachments.getClass().equals(java.io.File.class) ||
            attachments.getClass().equals(Integer.class) ||
            attachments.getClass().equals(String.class) ||
            attachments.getClass().isEnum()) {
            map.put("attachments", attachments);
        } else if (isListOfFile(attachments)) {
            for(int i = 0; i< getListSize(attachments); i++) {
                map.put("attachments[" + i + "]", getFromList(attachments, i));
            }
        }
        else {
            map.put("attachments", JSON.getDefault().getMapper().writeValueAsString(attachments));
        }
    }
    if (ccEmailAddresses != null) {
        if (isFileTypeOrListOfFiles(ccEmailAddresses)) {
            fileTypeFound = true;
        }

        if (ccEmailAddresses.getClass().equals(java.io.File.class) ||
            ccEmailAddresses.getClass().equals(Integer.class) ||
            ccEmailAddresses.getClass().equals(String.class) ||
            ccEmailAddresses.getClass().isEnum()) {
            map.put("cc_email_addresses", ccEmailAddresses);
        } else if (isListOfFile(ccEmailAddresses)) {
            for(int i = 0; i< getListSize(ccEmailAddresses); i++) {
                map.put("cc_email_addresses[" + i + "]", getFromList(ccEmailAddresses, i));
            }
        }
        else {
            map.put("cc_email_addresses", JSON.getDefault().getMapper().writeValueAsString(ccEmailAddresses));
        }
    }
    if (customFields != null) {
        if (isFileTypeOrListOfFiles(customFields)) {
            fileTypeFound = true;
        }

        if (customFields.getClass().equals(java.io.File.class) ||
            customFields.getClass().equals(Integer.class) ||
            customFields.getClass().equals(String.class) ||
            customFields.getClass().isEnum()) {
            map.put("custom_fields", customFields);
        } else if (isListOfFile(customFields)) {
            for(int i = 0; i< getListSize(customFields); i++) {
                map.put("custom_fields[" + i + "]", getFromList(customFields, i));
            }
        }
        else {
            map.put("custom_fields", JSON.getDefault().getMapper().writeValueAsString(customFields));
        }
    }
    if (editorOptions != null) {
        if (isFileTypeOrListOfFiles(editorOptions)) {
            fileTypeFound = true;
        }

        if (editorOptions.getClass().equals(java.io.File.class) ||
            editorOptions.getClass().equals(Integer.class) ||
            editorOptions.getClass().equals(String.class) ||
            editorOptions.getClass().isEnum()) {
            map.put("editor_options", editorOptions);
        } else if (isListOfFile(editorOptions)) {
            for(int i = 0; i< getListSize(editorOptions); i++) {
                map.put("editor_options[" + i + "]", getFromList(editorOptions, i));
            }
        }
        else {
            map.put("editor_options", JSON.getDefault().getMapper().writeValueAsString(editorOptions));
        }
    }
    if (fieldOptions != null) {
        if (isFileTypeOrListOfFiles(fieldOptions)) {
            fileTypeFound = true;
        }

        if (fieldOptions.getClass().equals(java.io.File.class) ||
            fieldOptions.getClass().equals(Integer.class) ||
            fieldOptions.getClass().equals(String.class) ||
            fieldOptions.getClass().isEnum()) {
            map.put("field_options", fieldOptions);
        } else if (isListOfFile(fieldOptions)) {
            for(int i = 0; i< getListSize(fieldOptions); i++) {
                map.put("field_options[" + i + "]", getFromList(fieldOptions, i));
            }
        }
        else {
            map.put("field_options", JSON.getDefault().getMapper().writeValueAsString(fieldOptions));
        }
    }
    if (forceSignerPage != null) {
        if (isFileTypeOrListOfFiles(forceSignerPage)) {
            fileTypeFound = true;
        }

        if (forceSignerPage.getClass().equals(java.io.File.class) ||
            forceSignerPage.getClass().equals(Integer.class) ||
            forceSignerPage.getClass().equals(String.class) ||
            forceSignerPage.getClass().isEnum()) {
            map.put("force_signer_page", forceSignerPage);
        } else if (isListOfFile(forceSignerPage)) {
            for(int i = 0; i< getListSize(forceSignerPage); i++) {
                map.put("force_signer_page[" + i + "]", getFromList(forceSignerPage, i));
            }
        }
        else {
            map.put("force_signer_page", JSON.getDefault().getMapper().writeValueAsString(forceSignerPage));
        }
    }
    if (forceSubjectMessage != null) {
        if (isFileTypeOrListOfFiles(forceSubjectMessage)) {
            fileTypeFound = true;
        }

        if (forceSubjectMessage.getClass().equals(java.io.File.class) ||
            forceSubjectMessage.getClass().equals(Integer.class) ||
            forceSubjectMessage.getClass().equals(String.class) ||
            forceSubjectMessage.getClass().isEnum()) {
            map.put("force_subject_message", forceSubjectMessage);
        } else if (isListOfFile(forceSubjectMessage)) {
            for(int i = 0; i< getListSize(forceSubjectMessage); i++) {
                map.put("force_subject_message[" + i + "]", getFromList(forceSubjectMessage, i));
            }
        }
        else {
            map.put("force_subject_message", JSON.getDefault().getMapper().writeValueAsString(forceSubjectMessage));
        }
    }
    if (formFieldGroups != null) {
        if (isFileTypeOrListOfFiles(formFieldGroups)) {
            fileTypeFound = true;
        }

        if (formFieldGroups.getClass().equals(java.io.File.class) ||
            formFieldGroups.getClass().equals(Integer.class) ||
            formFieldGroups.getClass().equals(String.class) ||
            formFieldGroups.getClass().isEnum()) {
            map.put("form_field_groups", formFieldGroups);
        } else if (isListOfFile(formFieldGroups)) {
            for(int i = 0; i< getListSize(formFieldGroups); i++) {
                map.put("form_field_groups[" + i + "]", getFromList(formFieldGroups, i));
            }
        }
        else {
            map.put("form_field_groups", JSON.getDefault().getMapper().writeValueAsString(formFieldGroups));
        }
    }
    if (formFieldRules != null) {
        if (isFileTypeOrListOfFiles(formFieldRules)) {
            fileTypeFound = true;
        }

        if (formFieldRules.getClass().equals(java.io.File.class) ||
            formFieldRules.getClass().equals(Integer.class) ||
            formFieldRules.getClass().equals(String.class) ||
            formFieldRules.getClass().isEnum()) {
            map.put("form_field_rules", formFieldRules);
        } else if (isListOfFile(formFieldRules)) {
            for(int i = 0; i< getListSize(formFieldRules); i++) {
                map.put("form_field_rules[" + i + "]", getFromList(formFieldRules, i));
            }
        }
        else {
            map.put("form_field_rules", JSON.getDefault().getMapper().writeValueAsString(formFieldRules));
        }
    }
    if (formFieldsPerDocument != null) {
        if (isFileTypeOrListOfFiles(formFieldsPerDocument)) {
            fileTypeFound = true;
        }

        if (formFieldsPerDocument.getClass().equals(java.io.File.class) ||
            formFieldsPerDocument.getClass().equals(Integer.class) ||
            formFieldsPerDocument.getClass().equals(String.class) ||
            formFieldsPerDocument.getClass().isEnum()) {
            map.put("form_fields_per_document", formFieldsPerDocument);
        } else if (isListOfFile(formFieldsPerDocument)) {
            for(int i = 0; i< getListSize(formFieldsPerDocument); i++) {
                map.put("form_fields_per_document[" + i + "]", getFromList(formFieldsPerDocument, i));
            }
        }
        else {
            map.put("form_fields_per_document", JSON.getDefault().getMapper().writeValueAsString(formFieldsPerDocument));
        }
    }
    if (hideTextTags != null) {
        if (isFileTypeOrListOfFiles(hideTextTags)) {
            fileTypeFound = true;
        }

        if (hideTextTags.getClass().equals(java.io.File.class) ||
            hideTextTags.getClass().equals(Integer.class) ||
            hideTextTags.getClass().equals(String.class) ||
            hideTextTags.getClass().isEnum()) {
            map.put("hide_text_tags", hideTextTags);
        } else if (isListOfFile(hideTextTags)) {
            for(int i = 0; i< getListSize(hideTextTags); i++) {
                map.put("hide_text_tags[" + i + "]", getFromList(hideTextTags, i));
            }
        }
        else {
            map.put("hide_text_tags", JSON.getDefault().getMapper().writeValueAsString(hideTextTags));
        }
    }
    if (holdRequest != null) {
        if (isFileTypeOrListOfFiles(holdRequest)) {
            fileTypeFound = true;
        }

        if (holdRequest.getClass().equals(java.io.File.class) ||
            holdRequest.getClass().equals(Integer.class) ||
            holdRequest.getClass().equals(String.class) ||
            holdRequest.getClass().isEnum()) {
            map.put("hold_request", holdRequest);
        } else if (isListOfFile(holdRequest)) {
            for(int i = 0; i< getListSize(holdRequest); i++) {
                map.put("hold_request[" + i + "]", getFromList(holdRequest, i));
            }
        }
        else {
            map.put("hold_request", JSON.getDefault().getMapper().writeValueAsString(holdRequest));
        }
    }
    if (isForEmbeddedSigning != null) {
        if (isFileTypeOrListOfFiles(isForEmbeddedSigning)) {
            fileTypeFound = true;
        }

        if (isForEmbeddedSigning.getClass().equals(java.io.File.class) ||
            isForEmbeddedSigning.getClass().equals(Integer.class) ||
            isForEmbeddedSigning.getClass().equals(String.class) ||
            isForEmbeddedSigning.getClass().isEnum()) {
            map.put("is_for_embedded_signing", isForEmbeddedSigning);
        } else if (isListOfFile(isForEmbeddedSigning)) {
            for(int i = 0; i< getListSize(isForEmbeddedSigning); i++) {
                map.put("is_for_embedded_signing[" + i + "]", getFromList(isForEmbeddedSigning, i));
            }
        }
        else {
            map.put("is_for_embedded_signing", JSON.getDefault().getMapper().writeValueAsString(isForEmbeddedSigning));
        }
    }
    if (message != null) {
        if (isFileTypeOrListOfFiles(message)) {
            fileTypeFound = true;
        }

        if (message.getClass().equals(java.io.File.class) ||
            message.getClass().equals(Integer.class) ||
            message.getClass().equals(String.class) ||
            message.getClass().isEnum()) {
            map.put("message", message);
        } else if (isListOfFile(message)) {
            for(int i = 0; i< getListSize(message); i++) {
                map.put("message[" + i + "]", getFromList(message, i));
            }
        }
        else {
            map.put("message", JSON.getDefault().getMapper().writeValueAsString(message));
        }
    }
    if (metadata != null) {
        if (isFileTypeOrListOfFiles(metadata)) {
            fileTypeFound = true;
        }

        if (metadata.getClass().equals(java.io.File.class) ||
            metadata.getClass().equals(Integer.class) ||
            metadata.getClass().equals(String.class) ||
            metadata.getClass().isEnum()) {
            map.put("metadata", metadata);
        } else if (isListOfFile(metadata)) {
            for(int i = 0; i< getListSize(metadata); i++) {
                map.put("metadata[" + i + "]", getFromList(metadata, i));
            }
        }
        else {
            map.put("metadata", JSON.getDefault().getMapper().writeValueAsString(metadata));
        }
    }
    if (requestingRedirectUrl != null) {
        if (isFileTypeOrListOfFiles(requestingRedirectUrl)) {
            fileTypeFound = true;
        }

        if (requestingRedirectUrl.getClass().equals(java.io.File.class) ||
            requestingRedirectUrl.getClass().equals(Integer.class) ||
            requestingRedirectUrl.getClass().equals(String.class) ||
            requestingRedirectUrl.getClass().isEnum()) {
            map.put("requesting_redirect_url", requestingRedirectUrl);
        } else if (isListOfFile(requestingRedirectUrl)) {
            for(int i = 0; i< getListSize(requestingRedirectUrl); i++) {
                map.put("requesting_redirect_url[" + i + "]", getFromList(requestingRedirectUrl, i));
            }
        }
        else {
            map.put("requesting_redirect_url", JSON.getDefault().getMapper().writeValueAsString(requestingRedirectUrl));
        }
    }
    if (showPreview != null) {
        if (isFileTypeOrListOfFiles(showPreview)) {
            fileTypeFound = true;
        }

        if (showPreview.getClass().equals(java.io.File.class) ||
            showPreview.getClass().equals(Integer.class) ||
            showPreview.getClass().equals(String.class) ||
            showPreview.getClass().isEnum()) {
            map.put("show_preview", showPreview);
        } else if (isListOfFile(showPreview)) {
            for(int i = 0; i< getListSize(showPreview); i++) {
                map.put("show_preview[" + i + "]", getFromList(showPreview, i));
            }
        }
        else {
            map.put("show_preview", JSON.getDefault().getMapper().writeValueAsString(showPreview));
        }
    }
    if (showProgressStepper != null) {
        if (isFileTypeOrListOfFiles(showProgressStepper)) {
            fileTypeFound = true;
        }

        if (showProgressStepper.getClass().equals(java.io.File.class) ||
            showProgressStepper.getClass().equals(Integer.class) ||
            showProgressStepper.getClass().equals(String.class) ||
            showProgressStepper.getClass().isEnum()) {
            map.put("show_progress_stepper", showProgressStepper);
        } else if (isListOfFile(showProgressStepper)) {
            for(int i = 0; i< getListSize(showProgressStepper); i++) {
                map.put("show_progress_stepper[" + i + "]", getFromList(showProgressStepper, i));
            }
        }
        else {
            map.put("show_progress_stepper", JSON.getDefault().getMapper().writeValueAsString(showProgressStepper));
        }
    }
    if (signers != null) {
        if (isFileTypeOrListOfFiles(signers)) {
            fileTypeFound = true;
        }

        if (signers.getClass().equals(java.io.File.class) ||
            signers.getClass().equals(Integer.class) ||
            signers.getClass().equals(String.class) ||
            signers.getClass().isEnum()) {
            map.put("signers", signers);
        } else if (isListOfFile(signers)) {
            for(int i = 0; i< getListSize(signers); i++) {
                map.put("signers[" + i + "]", getFromList(signers, i));
            }
        }
        else {
            map.put("signers", JSON.getDefault().getMapper().writeValueAsString(signers));
        }
    }
    if (signingOptions != null) {
        if (isFileTypeOrListOfFiles(signingOptions)) {
            fileTypeFound = true;
        }

        if (signingOptions.getClass().equals(java.io.File.class) ||
            signingOptions.getClass().equals(Integer.class) ||
            signingOptions.getClass().equals(String.class) ||
            signingOptions.getClass().isEnum()) {
            map.put("signing_options", signingOptions);
        } else if (isListOfFile(signingOptions)) {
            for(int i = 0; i< getListSize(signingOptions); i++) {
                map.put("signing_options[" + i + "]", getFromList(signingOptions, i));
            }
        }
        else {
            map.put("signing_options", JSON.getDefault().getMapper().writeValueAsString(signingOptions));
        }
    }
    if (signingRedirectUrl != null) {
        if (isFileTypeOrListOfFiles(signingRedirectUrl)) {
            fileTypeFound = true;
        }

        if (signingRedirectUrl.getClass().equals(java.io.File.class) ||
            signingRedirectUrl.getClass().equals(Integer.class) ||
            signingRedirectUrl.getClass().equals(String.class) ||
            signingRedirectUrl.getClass().isEnum()) {
            map.put("signing_redirect_url", signingRedirectUrl);
        } else if (isListOfFile(signingRedirectUrl)) {
            for(int i = 0; i< getListSize(signingRedirectUrl); i++) {
                map.put("signing_redirect_url[" + i + "]", getFromList(signingRedirectUrl, i));
            }
        }
        else {
            map.put("signing_redirect_url", JSON.getDefault().getMapper().writeValueAsString(signingRedirectUrl));
        }
    }
    if (skipMeNow != null) {
        if (isFileTypeOrListOfFiles(skipMeNow)) {
            fileTypeFound = true;
        }

        if (skipMeNow.getClass().equals(java.io.File.class) ||
            skipMeNow.getClass().equals(Integer.class) ||
            skipMeNow.getClass().equals(String.class) ||
            skipMeNow.getClass().isEnum()) {
            map.put("skip_me_now", skipMeNow);
        } else if (isListOfFile(skipMeNow)) {
            for(int i = 0; i< getListSize(skipMeNow); i++) {
                map.put("skip_me_now[" + i + "]", getFromList(skipMeNow, i));
            }
        }
        else {
            map.put("skip_me_now", JSON.getDefault().getMapper().writeValueAsString(skipMeNow));
        }
    }
    if (subject != null) {
        if (isFileTypeOrListOfFiles(subject)) {
            fileTypeFound = true;
        }

        if (subject.getClass().equals(java.io.File.class) ||
            subject.getClass().equals(Integer.class) ||
            subject.getClass().equals(String.class) ||
            subject.getClass().isEnum()) {
            map.put("subject", subject);
        } else if (isListOfFile(subject)) {
            for(int i = 0; i< getListSize(subject); i++) {
                map.put("subject[" + i + "]", getFromList(subject, i));
            }
        }
        else {
            map.put("subject", JSON.getDefault().getMapper().writeValueAsString(subject));
        }
    }
    if (testMode != null) {
        if (isFileTypeOrListOfFiles(testMode)) {
            fileTypeFound = true;
        }

        if (testMode.getClass().equals(java.io.File.class) ||
            testMode.getClass().equals(Integer.class) ||
            testMode.getClass().equals(String.class) ||
            testMode.getClass().isEnum()) {
            map.put("test_mode", testMode);
        } else if (isListOfFile(testMode)) {
            for(int i = 0; i< getListSize(testMode); i++) {
                map.put("test_mode[" + i + "]", getFromList(testMode, i));
            }
        }
        else {
            map.put("test_mode", JSON.getDefault().getMapper().writeValueAsString(testMode));
        }
    }
    if (type != null) {
        if (isFileTypeOrListOfFiles(type)) {
            fileTypeFound = true;
        }

        if (type.getClass().equals(java.io.File.class) ||
            type.getClass().equals(Integer.class) ||
            type.getClass().equals(String.class) ||
            type.getClass().isEnum()) {
            map.put("type", type);
        } else if (isListOfFile(type)) {
            for(int i = 0; i< getListSize(type); i++) {
                map.put("type[" + i + "]", getFromList(type, i));
            }
        }
        else {
            map.put("type", JSON.getDefault().getMapper().writeValueAsString(type));
        }
    }
    if (usePreexistingFields != null) {
        if (isFileTypeOrListOfFiles(usePreexistingFields)) {
            fileTypeFound = true;
        }

        if (usePreexistingFields.getClass().equals(java.io.File.class) ||
            usePreexistingFields.getClass().equals(Integer.class) ||
            usePreexistingFields.getClass().equals(String.class) ||
            usePreexistingFields.getClass().isEnum()) {
            map.put("use_preexisting_fields", usePreexistingFields);
        } else if (isListOfFile(usePreexistingFields)) {
            for(int i = 0; i< getListSize(usePreexistingFields); i++) {
                map.put("use_preexisting_fields[" + i + "]", getFromList(usePreexistingFields, i));
            }
        }
        else {
            map.put("use_preexisting_fields", JSON.getDefault().getMapper().writeValueAsString(usePreexistingFields));
        }
    }
    if (useTextTags != null) {
        if (isFileTypeOrListOfFiles(useTextTags)) {
            fileTypeFound = true;
        }

        if (useTextTags.getClass().equals(java.io.File.class) ||
            useTextTags.getClass().equals(Integer.class) ||
            useTextTags.getClass().equals(String.class) ||
            useTextTags.getClass().isEnum()) {
            map.put("use_text_tags", useTextTags);
        } else if (isListOfFile(useTextTags)) {
            for(int i = 0; i< getListSize(useTextTags); i++) {
                map.put("use_text_tags[" + i + "]", getFromList(useTextTags, i));
            }
        }
        else {
            map.put("use_text_tags", JSON.getDefault().getMapper().writeValueAsString(useTextTags));
        }
    }
    if (populateAutoFillFields != null) {
        if (isFileTypeOrListOfFiles(populateAutoFillFields)) {
            fileTypeFound = true;
        }

        if (populateAutoFillFields.getClass().equals(java.io.File.class) ||
            populateAutoFillFields.getClass().equals(Integer.class) ||
            populateAutoFillFields.getClass().equals(String.class) ||
            populateAutoFillFields.getClass().isEnum()) {
            map.put("populate_auto_fill_fields", populateAutoFillFields);
        } else if (isListOfFile(populateAutoFillFields)) {
            for(int i = 0; i< getListSize(populateAutoFillFields); i++) {
                map.put("populate_auto_fill_fields[" + i + "]", getFromList(populateAutoFillFields, i));
            }
        }
        else {
            map.put("populate_auto_fill_fields", JSON.getDefault().getMapper().writeValueAsString(populateAutoFillFields));
        }
    }
    if (expiresAt != null) {
        if (isFileTypeOrListOfFiles(expiresAt)) {
            fileTypeFound = true;
        }

        if (expiresAt.getClass().equals(java.io.File.class) ||
            expiresAt.getClass().equals(Integer.class) ||
            expiresAt.getClass().equals(String.class) ||
            expiresAt.getClass().isEnum()) {
            map.put("expires_at", expiresAt);
        } else if (isListOfFile(expiresAt)) {
            for(int i = 0; i< getListSize(expiresAt); i++) {
                map.put("expires_at[" + i + "]", getFromList(expiresAt, i));
            }
        }
        else {
            map.put("expires_at", JSON.getDefault().getMapper().writeValueAsString(expiresAt));
        }
    }
    } catch (Exception e) {
        throw new ApiException(e);
    }

    return fileTypeFound ? map : new HashMap<>();
  }

  private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
    return obj.getClass().equals(java.io.File.class) || isListOfFile(obj);
  }

  private boolean isListOfFile(Object obj) throws Exception {
      return obj instanceof java.util.List && !isListEmpty(obj) && getFromList(obj, 0) instanceof java.io.File;
  }

  private boolean isListEmpty(Object obj) throws Exception {
    return (boolean) Class.forName(java.util.List.class.getName()).getMethod("isEmpty").invoke(obj);
  }

  private Object getFromList(Object obj, int index) throws Exception {
    return Class.forName(java.util.List.class.getName()).getMethod("get", int.class).invoke(obj, index);
  }

  private int getListSize(Object obj) throws Exception {
    return (int) Class.forName(java.util.List.class.getName()).getMethod("size").invoke(obj);
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

