/*
 * Dropbox Sign API
 * Dropbox Sign v3 API
 *
 * The version of the OpenAPI document: 3.0.0
 * Contact: apisupport@hellosign.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.dropbox.sign.model;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.dropbox.sign.JSON;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.ObjectMapper;


import com.dropbox.sign.ApiException;
/**
 * SubFormFieldGroup
 */
@JsonPropertyOrder({
  SubFormFieldGroup.JSON_PROPERTY_GROUP_ID,
  SubFormFieldGroup.JSON_PROPERTY_GROUP_LABEL,
  SubFormFieldGroup.JSON_PROPERTY_REQUIREMENT
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
@JsonIgnoreProperties(ignoreUnknown=true)
public class SubFormFieldGroup {
  public static final String JSON_PROPERTY_GROUP_ID = "group_id";
  private String groupId;

  public static final String JSON_PROPERTY_GROUP_LABEL = "group_label";
  private String groupLabel;

  public static final String JSON_PROPERTY_REQUIREMENT = "requirement";
  private String requirement;

  public SubFormFieldGroup() { 
  }

  /**
   * Attempt to instantiate and hydrate a new instance of this class
   * @param jsonData String of JSON data representing target object
   */
  static public SubFormFieldGroup init(String jsonData) throws Exception {
    return new ObjectMapper().readValue(jsonData, SubFormFieldGroup.class);
  }

  static public SubFormFieldGroup init(HashMap data) throws Exception {
    return new ObjectMapper().readValue(
      new ObjectMapper().writeValueAsString(data),
      SubFormFieldGroup.class
    );
  }

  public SubFormFieldGroup groupId(String groupId) {
    this.groupId = groupId;
    return this;
  }

  /**
   * ID of group. Use this to reference a specific group from the &#x60;group&#x60; value in &#x60;form_fields_per_document&#x60;.
   * @return groupId
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_GROUP_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getGroupId() {
    return groupId;
  }


  @JsonProperty(JSON_PROPERTY_GROUP_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setGroupId(String groupId) {
    this.groupId = groupId;
  }


  public SubFormFieldGroup groupLabel(String groupLabel) {
    this.groupLabel = groupLabel;
    return this;
  }

  /**
   * Name of the group
   * @return groupLabel
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_GROUP_LABEL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getGroupLabel() {
    return groupLabel;
  }


  @JsonProperty(JSON_PROPERTY_GROUP_LABEL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setGroupLabel(String groupLabel) {
    this.groupLabel = groupLabel;
  }


  public SubFormFieldGroup requirement(String requirement) {
    this.requirement = requirement;
    return this;
  }

  /**
   * Examples: &#x60;require_0-1&#x60; &#x60;require_1&#x60; &#x60;require_1-ormore&#x60;  - Check out the list of [acceptable &#x60;requirement&#x60; checkbox type values](/api/reference/constants/#checkbox-field-grouping). - Check out the list of [acceptable &#x60;requirement&#x60; radio type fields](/api/reference/constants/#radio-field-grouping). - Radio groups require **at least** two fields per group.
   * @return requirement
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_REQUIREMENT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRequirement() {
    return requirement;
  }


  @JsonProperty(JSON_PROPERTY_REQUIREMENT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRequirement(String requirement) {
    this.requirement = requirement;
  }


  /**
   * Return true if this SubFormFieldGroup object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SubFormFieldGroup subFormFieldGroup = (SubFormFieldGroup) o;
    return Objects.equals(this.groupId, subFormFieldGroup.groupId) &&
        Objects.equals(this.groupLabel, subFormFieldGroup.groupLabel) &&
        Objects.equals(this.requirement, subFormFieldGroup.requirement);
  }

  @Override
  public int hashCode() {
    return Objects.hash(groupId, groupLabel, requirement);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SubFormFieldGroup {\n");
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("    groupLabel: ").append(toIndentedString(groupLabel)).append("\n");
    sb.append("    requirement: ").append(toIndentedString(requirement)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  public Map<String, Object> createFormData() throws ApiException {
    Map<String, Object> map = new HashMap<>();
    boolean fileTypeFound = false;
    try {
    if (groupId != null) {
        if (isFileTypeOrListOfFiles(groupId)) {
            fileTypeFound = true;
        }

        if (groupId.getClass().equals(java.io.File.class) ||
            groupId.getClass().equals(Integer.class) ||
            groupId.getClass().equals(String.class) ||
            groupId.getClass().isEnum()) {
            map.put("group_id", groupId);
        } else if (isListOfFile(groupId)) {
            for(int i = 0; i< getListSize(groupId); i++) {
                map.put("group_id[" + i + "]", getFromList(groupId, i));
            }
        }
        else {
            map.put("group_id", JSON.getDefault().getMapper().writeValueAsString(groupId));
        }
    }
    if (groupLabel != null) {
        if (isFileTypeOrListOfFiles(groupLabel)) {
            fileTypeFound = true;
        }

        if (groupLabel.getClass().equals(java.io.File.class) ||
            groupLabel.getClass().equals(Integer.class) ||
            groupLabel.getClass().equals(String.class) ||
            groupLabel.getClass().isEnum()) {
            map.put("group_label", groupLabel);
        } else if (isListOfFile(groupLabel)) {
            for(int i = 0; i< getListSize(groupLabel); i++) {
                map.put("group_label[" + i + "]", getFromList(groupLabel, i));
            }
        }
        else {
            map.put("group_label", JSON.getDefault().getMapper().writeValueAsString(groupLabel));
        }
    }
    if (requirement != null) {
        if (isFileTypeOrListOfFiles(requirement)) {
            fileTypeFound = true;
        }

        if (requirement.getClass().equals(java.io.File.class) ||
            requirement.getClass().equals(Integer.class) ||
            requirement.getClass().equals(String.class) ||
            requirement.getClass().isEnum()) {
            map.put("requirement", requirement);
        } else if (isListOfFile(requirement)) {
            for(int i = 0; i< getListSize(requirement); i++) {
                map.put("requirement[" + i + "]", getFromList(requirement, i));
            }
        }
        else {
            map.put("requirement", JSON.getDefault().getMapper().writeValueAsString(requirement));
        }
    }
    } catch (Exception e) {
        throw new ApiException(e);
    }

    return fileTypeFound ? map : new HashMap<>();
  }

  private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
    return obj.getClass().equals(java.io.File.class) || isListOfFile(obj);
  }

  private boolean isListOfFile(Object obj) throws Exception {
      return obj instanceof java.util.List && !isListEmpty(obj) && getFromList(obj, 0) instanceof java.io.File;
  }

  private boolean isListEmpty(Object obj) throws Exception {
    return (boolean) Class.forName(java.util.List.class.getName()).getMethod("isEmpty").invoke(obj);
  }

  private Object getFromList(Object obj, int index) throws Exception {
    return Class.forName(java.util.List.class.getName()).getMethod("get", int.class).invoke(obj, index);
  }

  private int getListSize(Object obj) throws Exception {
    return (int) Class.forName(java.util.List.class.getName()).getMethod("size").invoke(obj);
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

