/*
 * Dropbox Sign API
 * Dropbox Sign v3 API
 *
 * The version of the OpenAPI document: 3.0.0
 * Contact: apisupport@hellosign.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.dropbox.sign.model;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.dropbox.sign.JSON;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.ObjectMapper;


import com.dropbox.sign.ApiException;
/**
 * OAuthTokenResponse
 */
@JsonPropertyOrder({
  OAuthTokenResponse.JSON_PROPERTY_ACCESS_TOKEN,
  OAuthTokenResponse.JSON_PROPERTY_TOKEN_TYPE,
  OAuthTokenResponse.JSON_PROPERTY_REFRESH_TOKEN,
  OAuthTokenResponse.JSON_PROPERTY_EXPIRES_IN,
  OAuthTokenResponse.JSON_PROPERTY_STATE
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
@JsonIgnoreProperties(ignoreUnknown=true)
public class OAuthTokenResponse {
  public static final String JSON_PROPERTY_ACCESS_TOKEN = "access_token";
  private String accessToken;

  public static final String JSON_PROPERTY_TOKEN_TYPE = "token_type";
  private String tokenType;

  public static final String JSON_PROPERTY_REFRESH_TOKEN = "refresh_token";
  private String refreshToken;

  public static final String JSON_PROPERTY_EXPIRES_IN = "expires_in";
  private Integer expiresIn;

  public static final String JSON_PROPERTY_STATE = "state";
  private String state;

  public OAuthTokenResponse() { 
  }

  /**
   * Attempt to instantiate and hydrate a new instance of this class
   * @param jsonData String of JSON data representing target object
   */
  static public OAuthTokenResponse init(String jsonData) throws Exception {
    return new ObjectMapper().readValue(jsonData, OAuthTokenResponse.class);
  }

  static public OAuthTokenResponse init(HashMap data) throws Exception {
    return new ObjectMapper().readValue(
      new ObjectMapper().writeValueAsString(data),
      OAuthTokenResponse.class
    );
  }

  public OAuthTokenResponse accessToken(String accessToken) {
    this.accessToken = accessToken;
    return this;
  }

  /**
   * Get accessToken
   * @return accessToken
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ACCESS_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAccessToken() {
    return accessToken;
  }


  @JsonProperty(JSON_PROPERTY_ACCESS_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccessToken(String accessToken) {
    this.accessToken = accessToken;
  }


  public OAuthTokenResponse tokenType(String tokenType) {
    this.tokenType = tokenType;
    return this;
  }

  /**
   * Get tokenType
   * @return tokenType
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TOKEN_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTokenType() {
    return tokenType;
  }


  @JsonProperty(JSON_PROPERTY_TOKEN_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTokenType(String tokenType) {
    this.tokenType = tokenType;
  }


  public OAuthTokenResponse refreshToken(String refreshToken) {
    this.refreshToken = refreshToken;
    return this;
  }

  /**
   * Get refreshToken
   * @return refreshToken
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_REFRESH_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRefreshToken() {
    return refreshToken;
  }


  @JsonProperty(JSON_PROPERTY_REFRESH_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRefreshToken(String refreshToken) {
    this.refreshToken = refreshToken;
  }


  public OAuthTokenResponse expiresIn(Integer expiresIn) {
    this.expiresIn = expiresIn;
    return this;
  }

  /**
   * Number of seconds until the &#x60;access_token&#x60; expires. Uses epoch time.
   * @return expiresIn
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_EXPIRES_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getExpiresIn() {
    return expiresIn;
  }


  @JsonProperty(JSON_PROPERTY_EXPIRES_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExpiresIn(Integer expiresIn) {
    this.expiresIn = expiresIn;
  }


  public OAuthTokenResponse state(String state) {
    this.state = state;
    return this;
  }

  /**
   * Get state
   * @return state
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getState() {
    return state;
  }


  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setState(String state) {
    this.state = state;
  }


  /**
   * Return true if this OAuthTokenResponse object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OAuthTokenResponse oauthTokenResponse = (OAuthTokenResponse) o;
    return Objects.equals(this.accessToken, oauthTokenResponse.accessToken) &&
        Objects.equals(this.tokenType, oauthTokenResponse.tokenType) &&
        Objects.equals(this.refreshToken, oauthTokenResponse.refreshToken) &&
        Objects.equals(this.expiresIn, oauthTokenResponse.expiresIn) &&
        Objects.equals(this.state, oauthTokenResponse.state);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accessToken, tokenType, refreshToken, expiresIn, state);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OAuthTokenResponse {\n");
    sb.append("    accessToken: ").append(toIndentedString(accessToken)).append("\n");
    sb.append("    tokenType: ").append(toIndentedString(tokenType)).append("\n");
    sb.append("    refreshToken: ").append(toIndentedString(refreshToken)).append("\n");
    sb.append("    expiresIn: ").append(toIndentedString(expiresIn)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  public Map<String, Object> createFormData() throws ApiException {
    Map<String, Object> map = new HashMap<>();
    boolean fileTypeFound = false;
    try {
    if (accessToken != null) {
        if (isFileTypeOrListOfFiles(accessToken)) {
            fileTypeFound = true;
        }

        if (accessToken.getClass().equals(java.io.File.class) ||
            accessToken.getClass().equals(Integer.class) ||
            accessToken.getClass().equals(String.class) ||
            accessToken.getClass().isEnum()) {
            map.put("access_token", accessToken);
        } else if (isListOfFile(accessToken)) {
            for(int i = 0; i< getListSize(accessToken); i++) {
                map.put("access_token[" + i + "]", getFromList(accessToken, i));
            }
        }
        else {
            map.put("access_token", JSON.getDefault().getMapper().writeValueAsString(accessToken));
        }
    }
    if (tokenType != null) {
        if (isFileTypeOrListOfFiles(tokenType)) {
            fileTypeFound = true;
        }

        if (tokenType.getClass().equals(java.io.File.class) ||
            tokenType.getClass().equals(Integer.class) ||
            tokenType.getClass().equals(String.class) ||
            tokenType.getClass().isEnum()) {
            map.put("token_type", tokenType);
        } else if (isListOfFile(tokenType)) {
            for(int i = 0; i< getListSize(tokenType); i++) {
                map.put("token_type[" + i + "]", getFromList(tokenType, i));
            }
        }
        else {
            map.put("token_type", JSON.getDefault().getMapper().writeValueAsString(tokenType));
        }
    }
    if (refreshToken != null) {
        if (isFileTypeOrListOfFiles(refreshToken)) {
            fileTypeFound = true;
        }

        if (refreshToken.getClass().equals(java.io.File.class) ||
            refreshToken.getClass().equals(Integer.class) ||
            refreshToken.getClass().equals(String.class) ||
            refreshToken.getClass().isEnum()) {
            map.put("refresh_token", refreshToken);
        } else if (isListOfFile(refreshToken)) {
            for(int i = 0; i< getListSize(refreshToken); i++) {
                map.put("refresh_token[" + i + "]", getFromList(refreshToken, i));
            }
        }
        else {
            map.put("refresh_token", JSON.getDefault().getMapper().writeValueAsString(refreshToken));
        }
    }
    if (expiresIn != null) {
        if (isFileTypeOrListOfFiles(expiresIn)) {
            fileTypeFound = true;
        }

        if (expiresIn.getClass().equals(java.io.File.class) ||
            expiresIn.getClass().equals(Integer.class) ||
            expiresIn.getClass().equals(String.class) ||
            expiresIn.getClass().isEnum()) {
            map.put("expires_in", expiresIn);
        } else if (isListOfFile(expiresIn)) {
            for(int i = 0; i< getListSize(expiresIn); i++) {
                map.put("expires_in[" + i + "]", getFromList(expiresIn, i));
            }
        }
        else {
            map.put("expires_in", JSON.getDefault().getMapper().writeValueAsString(expiresIn));
        }
    }
    if (state != null) {
        if (isFileTypeOrListOfFiles(state)) {
            fileTypeFound = true;
        }

        if (state.getClass().equals(java.io.File.class) ||
            state.getClass().equals(Integer.class) ||
            state.getClass().equals(String.class) ||
            state.getClass().isEnum()) {
            map.put("state", state);
        } else if (isListOfFile(state)) {
            for(int i = 0; i< getListSize(state); i++) {
                map.put("state[" + i + "]", getFromList(state, i));
            }
        }
        else {
            map.put("state", JSON.getDefault().getMapper().writeValueAsString(state));
        }
    }
    } catch (Exception e) {
        throw new ApiException(e);
    }

    return fileTypeFound ? map : new HashMap<>();
  }

  private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
    return obj.getClass().equals(java.io.File.class) || isListOfFile(obj);
  }

  private boolean isListOfFile(Object obj) throws Exception {
      return obj instanceof java.util.List && !isListEmpty(obj) && getFromList(obj, 0) instanceof java.io.File;
  }

  private boolean isListEmpty(Object obj) throws Exception {
    return (boolean) Class.forName(java.util.List.class.getName()).getMethod("isEmpty").invoke(obj);
  }

  private Object getFromList(Object obj, int index) throws Exception {
    return Class.forName(java.util.List.class.getName()).getMethod("get", int.class).invoke(obj, index);
  }

  private int getListSize(Object obj) throws Exception {
    return (int) Class.forName(java.util.List.class.getName()).getMethod("size").invoke(obj);
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

