/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.android;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import com.dropbox.core.DbxAuthFinish;
import com.dropbox.core.DbxHost;
import com.dropbox.core.DbxPKCEManager;
import com.dropbox.core.DbxRequestConfig;
import com.dropbox.core.DbxRequestUtil;
import com.dropbox.core.IncludeGrantedScopes;
import com.dropbox.core.TokenAccessType;
import com.dropbox.core.android.DbxOfficialAppConnector;
import com.dropbox.core.android.internal.AuthParameters;
import com.dropbox.core.android.internal.AuthSessionViewModel;
import com.dropbox.core.android.internal.AuthUtils;
import com.dropbox.core.android.internal.DropboxAuthIntent;
import com.dropbox.core.android.internal.QueryParamsUtil;
import com.dropbox.core.android.internal.TokenRequestAsyncTask;
import com.dropbox.core.android.internal.TokenType;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00182\u00020\u0001:\u0002\u0018\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u0012\u0010\r\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0014J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\fH\u0014J\b\u0010\u0012\u001a\u00020\nH\u0014J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0004H\u0016J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001a"}, d2={"Lcom/dropbox/core/android/AuthActivity;", "Landroid/app/Activity;", "()V", "mActivityDispatchHandlerPosted", "", "mState", "Lcom/dropbox/core/android/internal/AuthSessionViewModel$State;", "getMState", "()Lcom/dropbox/core/android/internal/AuthSessionViewModel$State;", "authFinished", "", "authResult", "Landroid/content/Intent;", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onNewIntent", "intent", "onResume", "onTopResumedActivityChanged", "onTop", "startWebAuth", "state", "", "Companion", "SecurityProvider", "android_release"})
public class AuthActivity
extends Activity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean mActivityDispatchHandlerPosted;
    private static final String TAG = AuthActivity.class.getName();
    @NotNull
    public static final String ACTION_AUTHENTICATE_V1 = "com.dropbox.android.AUTHENTICATE_V1";
    @NotNull
    public static final String ACTION_AUTHENTICATE_V2 = "com.dropbox.android.AUTHENTICATE_V2";
    public static final int AUTH_VERSION = 1;
    @NotNull
    public static final String AUTH_PATH_CONNECT = "/connect";
    @NotNull
    private static SecurityProvider sSecurityProvider = new SecurityProvider(){

        @NotNull
        public SecureRandom getSecureRandom() {
            return new SecureRandom();
        }
    };
    @NotNull
    private static final Object sSecurityProviderLock = new Object();
    @JvmField
    @Nullable
    public static Intent result;
    @Nullable
    private static AuthParameters sAuthParams;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        if (!AuthSessionViewModel.Companion.isAuthInProgress()) {
            AuthSessionViewModel.State newStateFromAuthParams = AuthSessionViewModel.State.Companion.fromAuthParams(sAuthParams);
            AuthSessionViewModel.Companion.startAuthSession(newStateFromAuthParams);
        }
        this.setTheme(0x1030010);
        super.onCreate(savedInstanceState);
    }

    protected void onResume() {
        super.onResume();
        if (Build.VERSION.SDK_INT < 29) {
            this.onTopResumedActivityChanged(true);
        }
    }

    private final AuthSessionViewModel.State getMState() {
        return AuthSessionViewModel.Companion.getState();
    }

    public void onTopResumedActivityChanged(boolean onTop) {
        String string;
        boolean authNotFinish;
        if (this.isFinishing() || !onTop) {
            return;
        }
        boolean bl = authNotFinish = this.getMState().getMAuthStateNonce() != null || this.getMState().getMAppKey() == null;
        if (authNotFinish) {
            this.authFinished(null);
            return;
        }
        result = null;
        if (this.mActivityDispatchHandlerPosted) {
            Log.w((String)TAG, (String)"onResume called again before Handler run");
            return;
        }
        if (this.getMState().getMTokenAccessType() != null) {
            String string2 = this.getMState().getMPKCEManager().getCodeChallenge();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"mState.mPKCEManager.codeChallenge");
            string = AuthUtils.createPKCEStateNonce(string2, String.valueOf(this.getMState().getMTokenAccessType()), this.getMState().getMScope(), this.getMState().getMIncludeGrantedScopes());
        } else {
            string = AuthUtils.createStateNonce(AuthActivity.Companion.getSecurityProvider());
        }
        String stateNonce = string;
        DropboxAuthIntent dropboxAuthIntent = DropboxAuthIntent.INSTANCE;
        AuthSessionViewModel.State state = this.getMState();
        Intent officialAuthIntent = dropboxAuthIntent.buildOfficialAuthIntent(state, stateNonce, this);
        this.runOnUiThread(() -> AuthActivity.onTopResumedActivityChanged$lambda-0(this, officialAuthIntent, stateNonce));
        this.mActivityDispatchHandlerPosted = true;
    }

    protected void onNewIntent(@NotNull Intent intent) {
        Intent newResult;
        block16: {
            Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
            if (this.getMState().getMAuthStateNonce() == null) {
                this.authFinished(null);
                return;
            }
            String token = null;
            String secret = null;
            String uid = null;
            String state = null;
            if (intent.hasExtra("ACCESS_TOKEN")) {
                token = intent.getStringExtra("ACCESS_TOKEN");
                secret = intent.getStringExtra("ACCESS_SECRET");
                uid = intent.getStringExtra("UID");
                state = intent.getStringExtra("AUTH_STATE");
            } else {
                String path;
                Uri uri = intent.getData();
                if (uri != null && Intrinsics.areEqual((Object)AUTH_PATH_CONNECT, (Object)(path = uri.getPath()))) {
                    try {
                        token = uri.getQueryParameter("oauth_token");
                        secret = uri.getQueryParameter("oauth_token_secret");
                        uid = uri.getQueryParameter("uid");
                        state = uri.getQueryParameter("state");
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        // empty catch block
                    }
                }
            }
            newResult = null;
            if (!(token == null || Intrinsics.areEqual((Object)token, (Object)"") || secret == null || Intrinsics.areEqual((Object)secret, (Object)"") || uid == null || Intrinsics.areEqual((Object)uid, (Object)"") || state == null || Intrinsics.areEqual((Object)state, (Object)""))) {
                if (!Intrinsics.areEqual((Object)this.getMState().getMAuthStateNonce(), (Object)state)) {
                    this.authFinished(null);
                    return;
                }
                if (Intrinsics.areEqual((Object)token, (Object)TokenType.OAUTH2.toString())) {
                    newResult = new Intent();
                    newResult.putExtra("ACCESS_TOKEN", token);
                    newResult.putExtra("ACCESS_SECRET", secret);
                    newResult.putExtra("UID", uid);
                } else if (Intrinsics.areEqual((Object)token, (Object)TokenType.OAUTH2CODE.toString())) {
                    DbxPKCEManager dbxPKCEManager = this.getMState().getMPKCEManager();
                    DbxRequestConfig dbxRequestConfig = this.getMState().getMRequestConfig();
                    Intrinsics.checkNotNull((Object)dbxRequestConfig);
                    String string = this.getMState().getMAppKey();
                    Intrinsics.checkNotNull((Object)string);
                    DbxHost dbxHost = this.getMState().getMHost();
                    Intrinsics.checkNotNull((Object)dbxHost);
                    TokenRequestAsyncTask tokenRequest = new TokenRequestAsyncTask(secret, dbxPKCEManager, dbxRequestConfig, string, dbxHost);
                    try {
                        DbxAuthFinish dbxAuthFinish = (DbxAuthFinish)tokenRequest.execute(new Void[0]).get();
                        if (dbxAuthFinish == null) {
                            newResult = null;
                            break block16;
                        }
                        newResult = new Intent();
                        newResult.putExtra("ACCESS_TOKEN", dbxAuthFinish.getAccessToken());
                        newResult.putExtra("ACCESS_SECRET", dbxAuthFinish.getAccessToken());
                        newResult.putExtra("REFRESH_TOKEN", dbxAuthFinish.getRefreshToken());
                        Long l = dbxAuthFinish.getExpiresAt();
                        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"dbxAuthFinish.expiresAt");
                        newResult.putExtra("EXPIRES_AT", ((Number)l).longValue());
                        newResult.putExtra("UID", dbxAuthFinish.getUserId());
                        newResult.putExtra("CONSUMER_KEY", this.getMState().getMAppKey());
                        newResult.putExtra("SCOPE", dbxAuthFinish.getScope());
                    }
                    catch (Exception e) {
                        newResult = null;
                    }
                } else {
                    newResult = null;
                }
            } else {
                newResult = null;
            }
        }
        this.authFinished(newResult);
    }

    private final void authFinished(Intent authResult) {
        result = authResult;
        AuthSessionViewModel.Companion.endAuthSession();
        this.finish();
    }

    private final void startWebAuth(String state) {
        String path = "1/connect";
        Locale locale = Locale.getDefault();
        locale = new Locale(locale.getLanguage(), locale.getCountry());
        String alreadyAuthedUid = !((Collection)this.getMState().getMAlreadyAuthedUids()).isEmpty() ? this.getMState().getMAlreadyAuthedUids().get(0) : "0";
        Object[] objectArray = new String[]{"k", this.getMState().getMAppKey(), "n", alreadyAuthedUid, "api", this.getMState().getMApiType(), "state", state};
        List params = CollectionsKt.mutableListOf((Object[])objectArray);
        if (this.getMState().getMTokenAccessType() != null) {
            params.add("extra_query_params");
            TokenAccessType tokenAccessType = this.getMState().getMTokenAccessType();
            String string = this.getMState().getMScope();
            IncludeGrantedScopes includeGrantedScopes = this.getMState().getMIncludeGrantedScopes();
            String string2 = this.getMState().getMPKCEManager().getCodeChallenge();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"mState.mPKCEManager.codeChallenge");
            params.add(QueryParamsUtil.INSTANCE.createExtraQueryParams$android_release(tokenAccessType, string, includeGrantedScopes, string2));
        }
        String string = locale.toString();
        DbxHost dbxHost = this.getMState().getMHost();
        Intrinsics.checkNotNull((Object)dbxHost);
        Collection $this$toTypedArray$iv = params;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        String url = DbxRequestUtil.buildUrlWithParams((String)string, (String)dbxHost.getWeb(), (String)path, (String[])stringArray);
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
        this.startActivity(intent);
    }

    private static final void onTopResumedActivityChanged$lambda-0(AuthActivity this$0, Intent $officialAuthIntent, String $stateNonce) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$officialAuthIntent, (String)"$officialAuthIntent");
        Intrinsics.checkNotNullParameter((Object)$stateNonce, (String)"$stateNonce");
        Log.d((String)TAG, (String)"running startActivity in handler");
        try {
            Context context = this$0.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"applicationContext");
            PackageInfo dropboxAppPackage = DbxOfficialAppConnector.Companion.getDropboxAppPackage$android_release(context, $officialAuthIntent);
            if (dropboxAppPackage != null) {
                this$0.startActivity($officialAuthIntent);
            } else {
                this$0.startWebAuth($stateNonce);
            }
        }
        catch (ActivityNotFoundException e) {
            Log.e((String)TAG, (String)"Could not launch intent. User may have restricted profile", (Throwable)e);
            this$0.finish();
            return;
        }
        this$0.getMState().setMAuthStateNonce($stateNonce);
    }

    @JvmStatic
    @Deprecated(message="Use Methods in com.dropbox.core.android.Auth, This will be removed in future versions.")
    @NotNull
    public static final Intent makeIntent(@Nullable Context context, @Nullable String appKey, @Nullable String webHost, @Nullable String apiType) {
        return Companion.makeIntent(context, appKey, webHost, apiType);
    }

    @JvmStatic
    @Deprecated(message="Use Methods in com.dropbox.core.android.Auth. This will be removed in future versions.")
    @NotNull
    public static final Intent makeIntent(@Nullable Context context, @Nullable String appKey, @Nullable String desiredUid, @Nullable String[] alreadyAuthedUids, @Nullable String sessionId, @Nullable String webHost, @Nullable String apiType) {
        return Companion.makeIntent(context, appKey, desiredUid, alreadyAuthedUids, sessionId, webHost, apiType);
    }

    @JvmStatic
    @Deprecated(message="Use Methods in com.dropbox.core.android.Auth, This will be removed in future versions.")
    public static final boolean checkAppBeforeAuth(@NotNull Context context, @NotNull String appKey, boolean alertUser) {
        return Companion.checkAppBeforeAuth(context, appKey, alertUser);
    }

    @JvmStatic
    public static final void setSecurityProvider(@NotNull SecurityProvider prov) {
        Companion.setSecurityProvider(prov);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/dropbox/core/android/AuthActivity$SecurityProvider;", "", "secureRandom", "Ljava/security/SecureRandom;", "getSecureRandom", "()Ljava/security/SecureRandom;", "android_release"})
    public static interface SecurityProvider {
        @NotNull
        public SecureRandom getSecureRandom();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0013H\u0007J\b\u0010\u0018\u001a\u00020\u0010H\u0002JY\u0010\u0019\u001a\u00020\f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00042\b\u0010\u001a\u001a\u0004\u0018\u00010\u00042\u000e\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00042\b\u0010\u001e\u001a\u0004\u0018\u00010\u00042\b\u0010\u001f\u001a\u0004\u0018\u00010\u0004H\u0007\u00a2\u0006\u0002\u0010 J\u008d\u0001\u0010\u0019\u001a\u00020\f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00042\b\u0010\u001a\u001a\u0004\u0018\u00010\u00042\u000e\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00042\b\u0010\u001e\u001a\u0004\u0018\u00010\u00042\b\u0010\u001f\u001a\u0004\u0018\u00010\u00042\b\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010#\u001a\u0004\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010&2\b\u0010'\u001a\u0004\u0018\u00010\u00042\b\u0010(\u001a\u0004\u0018\u00010)H\u0000\u00a2\u0006\u0004\b*\u0010+J0\u0010\u0019\u001a\u00020\f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00042\b\u0010\u001e\u001a\u0004\u0018\u00010\u00042\b\u0010\u001f\u001a\u0004\u0018\u00010\u0004H\u0007J/\u0010,\u001a\u00020-2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00042\b\u0010\u001a\u001a\u0004\u0018\u00010\u00042\u000e\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u001c\u00a2\u0006\u0002\u0010.J9\u0010,\u001a\u00020-2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00042\b\u0010\u001a\u001a\u0004\u0018\u00010\u00042\u000e\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010/JC\u0010,\u001a\u00020-2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00042\b\u0010\u001a\u001a\u0004\u0018\u00010\u00042\u000e\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u001c2\b\u0010\u001e\u001a\u0004\u0018\u00010\u00042\b\u0010\u001f\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u00100J\u0083\u0001\u0010,\u001a\u00020-2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00042\b\u0010\u001a\u001a\u0004\u0018\u00010\u00042\u000e\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00042\b\u0010\u001e\u001a\u0004\u0018\u00010\u00042\b\u0010\u001f\u001a\u0004\u0018\u00010\u00042\b\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010#\u001a\u0004\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010&2\b\u0010'\u001a\u0004\u0018\u00010\u00042\b\u0010(\u001a\u0004\u0018\u00010)H\u0000\u00a2\u0006\u0004\b1\u00102J\u0010\u00103\u001a\u00020-2\u0006\u00104\u001a\u00020\u0010H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \n*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u0004\u0018\u00010\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/dropbox/core/android/AuthActivity$Companion;", "", "()V", "ACTION_AUTHENTICATE_V1", "", "ACTION_AUTHENTICATE_V2", "AUTH_PATH_CONNECT", "AUTH_VERSION", "", "TAG", "kotlin.jvm.PlatformType", "result", "Landroid/content/Intent;", "sAuthParams", "Lcom/dropbox/core/android/internal/AuthParameters;", "sSecurityProvider", "Lcom/dropbox/core/android/AuthActivity$SecurityProvider;", "sSecurityProviderLock", "checkAppBeforeAuth", "", "context", "Landroid/content/Context;", "appKey", "alertUser", "getSecurityProvider", "makeIntent", "desiredUid", "alreadyAuthedUids", "", "sessionId", "webHost", "apiType", "(Landroid/content/Context;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Landroid/content/Intent;", "tokenAccessType", "Lcom/dropbox/core/TokenAccessType;", "requestConfig", "Lcom/dropbox/core/DbxRequestConfig;", "host", "Lcom/dropbox/core/DbxHost;", "scope", "includeGrantedScopes", "Lcom/dropbox/core/IncludeGrantedScopes;", "makeIntent$android_release", "(Landroid/content/Context;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/dropbox/core/TokenAccessType;Lcom/dropbox/core/DbxRequestConfig;Lcom/dropbox/core/DbxHost;Ljava/lang/String;Lcom/dropbox/core/IncludeGrantedScopes;)Landroid/content/Intent;", "setAuthParams", "", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;)V", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "setAuthParams$android_release", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/dropbox/core/TokenAccessType;Lcom/dropbox/core/DbxRequestConfig;Lcom/dropbox/core/DbxHost;Ljava/lang/String;Lcom/dropbox/core/IncludeGrantedScopes;)V", "setSecurityProvider", "prov", "android_release"})
    public static final class Companion {
        private Companion() {
        }

        public final void setAuthParams(@Nullable String appKey, @Nullable String desiredUid, @Nullable String[] alreadyAuthedUids) {
            this.setAuthParams(appKey, desiredUid, alreadyAuthedUids, null);
        }

        public final void setAuthParams(@Nullable String appKey, @Nullable String desiredUid, @Nullable String[] alreadyAuthedUids, @Nullable String webHost, @Nullable String apiType) {
            this.setAuthParams$android_release(appKey, desiredUid, alreadyAuthedUids, null, null, null, null, null, null, null, null);
        }

        public final void setAuthParams(@Nullable String appKey, @Nullable String desiredUid, @Nullable String[] alreadyAuthedUids, @Nullable String sessionId) {
            this.setAuthParams$android_release(appKey, desiredUid, alreadyAuthedUids, sessionId, null, null, null, null, null, null, null);
        }

        public final void setAuthParams$android_release(@Nullable String appKey, @Nullable String desiredUid, @Nullable String[] alreadyAuthedUids, @Nullable String sessionId, @Nullable String webHost, @Nullable String apiType, @Nullable TokenAccessType tokenAccessType, @Nullable DbxRequestConfig requestConfig, @Nullable DbxHost host, @Nullable String scope, @Nullable IncludeGrantedScopes includeGrantedScopes) {
            DbxHost dbxHost;
            Object object;
            Object object2 = alreadyAuthedUids;
            if (alreadyAuthedUids == null || (object2 = ArraysKt.toList((Object[])object2)) == null) {
                object2 = object = CollectionsKt.emptyList();
            }
            if ((dbxHost = host) == null) {
                dbxHost = webHost != null ? new DbxHost(DbxHost.DEFAULT.getApi(), DbxHost.DEFAULT.getContent(), webHost, DbxHost.DEFAULT.getNotify()) : DbxHost.DEFAULT;
            }
            DbxHost dbxHost2 = dbxHost;
            sAuthParams = new AuthParameters(appKey, apiType, desiredUid, (List<String>)object, sessionId, tokenAccessType, requestConfig, dbxHost2, scope, includeGrantedScopes);
        }

        @JvmStatic
        @Deprecated(message="Use Methods in com.dropbox.core.android.Auth, This will be removed in future versions.")
        @NotNull
        public final Intent makeIntent(@Nullable Context context, @Nullable String appKey, @Nullable String webHost, @Nullable String apiType) {
            return this.makeIntent$android_release(context, appKey, null, null, null, webHost, apiType, null, null, null, null, null);
        }

        @JvmStatic
        @Deprecated(message="Use Methods in com.dropbox.core.android.Auth. This will be removed in future versions.")
        @NotNull
        public final Intent makeIntent(@Nullable Context context, @Nullable String appKey, @Nullable String desiredUid, @Nullable String[] alreadyAuthedUids, @Nullable String sessionId, @Nullable String webHost, @Nullable String apiType) {
            if (appKey == null) {
                boolean bl = false;
                String string = "'appKey' can't be null";
                throw new IllegalArgumentException(string.toString());
            }
            this.setAuthParams$android_release(appKey, desiredUid, alreadyAuthedUids, sessionId, webHost, apiType, null, null, null, null, null);
            return new Intent(context, AuthActivity.class);
        }

        @NotNull
        public final Intent makeIntent$android_release(@Nullable Context context, @Nullable String appKey, @Nullable String desiredUid, @Nullable String[] alreadyAuthedUids, @Nullable String sessionId, @Nullable String webHost, @Nullable String apiType, @Nullable TokenAccessType tokenAccessType, @Nullable DbxRequestConfig requestConfig, @Nullable DbxHost host, @Nullable String scope, @Nullable IncludeGrantedScopes includeGrantedScopes) {
            if (appKey == null) {
                boolean bl = false;
                String string = "'appKey' can't be null";
                throw new IllegalArgumentException(string.toString());
            }
            this.setAuthParams$android_release(appKey, desiredUid, alreadyAuthedUids, sessionId, webHost, apiType, tokenAccessType, requestConfig, host, scope, includeGrantedScopes);
            return new Intent(context, AuthActivity.class);
        }

        @JvmStatic
        @Deprecated(message="Use Methods in com.dropbox.core.android.Auth, This will be removed in future versions.")
        public final boolean checkAppBeforeAuth(@NotNull Context context, @NotNull String appKey, boolean alertUser) {
            ResolveInfo resolveInfo;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)appKey, (String)"appKey");
            Intent testIntent = new Intent("android.intent.action.VIEW");
            String scheme = "db-" + appKey;
            String uri = scheme + "://1/connect";
            testIntent.setData(Uri.parse((String)uri));
            PackageManager pm = context.getPackageManager();
            List list = pm.queryIntentActivities(testIntent, 0);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"pm.queryIntentActivities(testIntent, 0)");
            List activities = list;
            if (!(activities.size() != 0)) {
                boolean bl = false;
                String string = "URI scheme in your app's manifest is not set up correctly. You should have a " + AuthActivity.class.getName() + " with the scheme: " + scheme;
                throw new IllegalStateException(string.toString());
            }
            if (activities.size() > 1) {
                if (alertUser) {
                    AlertDialog.Builder builder = new AlertDialog.Builder(context);
                    builder.setTitle((CharSequence)"Security alert");
                    builder.setMessage((CharSequence)"Another app on your phone may be trying to pose as the app you are currently using. The malicious app can't access your account, but linking to Dropbox has been disabled as a precaution. Please contact support@dropbox.com.");
                    builder.setPositiveButton((CharSequence)"OK", Companion::checkAppBeforeAuth$lambda-3);
                    builder.show();
                } else {
                    Log.w((String)TAG, (String)("There are multiple apps registered for the AuthActivity URI scheme (" + scheme + ").  Another app may be trying to  impersonate this app, so authentication will be disabled."));
                }
                return false;
            }
            ResolveInfo resolveInfo2 = resolveInfo = (ResolveInfo)activities.get(0);
            if (!((resolveInfo2 != null ? resolveInfo2.activityInfo : null) != null && Intrinsics.areEqual((Object)context.getPackageName(), (Object)resolveInfo.activityInfo.packageName))) {
                boolean bl = false;
                String string = "There must be a " + AuthActivity.class.getName() + " within your app's package registered for your URI scheme (" + scheme + "). However, it appears that an activity in a different package is registered for that scheme instead. If you have multiple apps that all want to use the same accesstoken pair, designate one of them to do authentication and have the other apps launch it and then retrieve the token pair from it.";
                throw new IllegalStateException(string.toString());
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final SecurityProvider getSecurityProvider() {
            Object object = sSecurityProviderLock;
            synchronized (object) {
                boolean bl = false;
                SecurityProvider securityProvider = sSecurityProvider;
                return securityProvider;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        public final void setSecurityProvider(@NotNull SecurityProvider prov) {
            Intrinsics.checkNotNullParameter((Object)prov, (String)"prov");
            Object object = sSecurityProviderLock;
            synchronized (object) {
                boolean bl = false;
                sSecurityProvider = prov;
                Unit unit = Unit.INSTANCE;
            }
        }

        private static final void checkAppBeforeAuth$lambda-3(DialogInterface dialog, int which) {
            dialog.dismiss();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

