/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging.jpeg;

import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.imaging.jpeg.JpegSegmentData;
import com.drew.imaging.jpeg.JpegSegmentType;
import com.drew.lang.SequentialReader;
import com.drew.lang.StreamReader;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpegSegmentReader {
    private static final byte SEGMENT_SOS = -38;
    private static final byte MARKER_EOI = -39;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static JpegSegmentData readSegments(@NotNull File file, @Nullable Iterable<JpegSegmentType> segmentTypes) throws JpegProcessingException, IOException {
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
            JpegSegmentData jpegSegmentData = JpegSegmentReader.readSegments(new StreamReader(stream), segmentTypes);
            return jpegSegmentData;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    @NotNull
    public static JpegSegmentData readSegments(@NotNull SequentialReader reader, @Nullable Iterable<JpegSegmentType> segmentTypes) throws JpegProcessingException, IOException {
        assert (reader.isMotorolaByteOrder());
        int magicNumber = reader.getUInt16();
        if (magicNumber != 65496) {
            throw new JpegProcessingException("JPEG data is expected to begin with 0xFFD8 (\u00ff\u00d8) not 0x" + Integer.toHexString(magicNumber));
        }
        HashSet<Byte> segmentTypeBytes = null;
        if (segmentTypes != null) {
            segmentTypeBytes = new HashSet<Byte>();
            for (JpegSegmentType segmentType : segmentTypes) {
                segmentTypeBytes.add(segmentType.byteValue);
            }
        }
        JpegSegmentData segmentData = new JpegSegmentData();
        while (true) {
            short segmentIdentifier;
            if ((segmentIdentifier = reader.getUInt8()) != 255) {
                throw new JpegProcessingException("Expected JPEG segment start identifier 0xFF, not 0x" + Integer.toHexString(segmentIdentifier).toUpperCase());
            }
            byte segmentType = reader.getInt8();
            while (segmentType == -1) {
                segmentType = reader.getInt8();
            }
            if (segmentType == 0) {
                throw new JpegProcessingException("Expected non-zero byte as part of JPEG marker identifier");
            }
            if (segmentType == -38) {
                return segmentData;
            }
            if (segmentType == -39) {
                return segmentData;
            }
            int segmentLength = reader.getUInt16();
            if ((segmentLength -= 2) < 0) {
                throw new JpegProcessingException("JPEG segment size would be less than zero");
            }
            if (segmentTypeBytes == null || segmentTypeBytes.contains(segmentType)) {
                byte[] segmentBytes = reader.getBytes(segmentLength);
                assert (segmentLength == segmentBytes.length);
                segmentData.addSegment(segmentType, segmentBytes);
                continue;
            }
            if (!reader.trySkip(segmentLength)) break;
        }
        return segmentData;
    }

    private JpegSegmentReader() throws Exception {
        throw new Exception("Not intended for instantiation.");
    }
}

