/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.exif.ExifDescriptorBase;
import com.drew.metadata.exif.ExifThumbnailDirectory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExifThumbnailDescriptor
extends ExifDescriptorBase<ExifThumbnailDirectory> {
    public ExifThumbnailDescriptor(@NotNull ExifThumbnailDirectory directory) {
        super(directory);
    }

    @Override
    @Nullable
    public String getDescription(int tagType) {
        switch (tagType) {
            case 513: {
                return this.getThumbnailOffsetDescription();
            }
            case 514: {
                return this.getThumbnailLengthDescription();
            }
            case 259: {
                return this.getCompressionDescription();
            }
        }
        return super.getDescription(tagType);
    }

    @Override
    @Nullable
    public String getCompressionDescription() {
        Integer value = ((ExifThumbnailDirectory)this._directory).getInteger(259);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                return "Uncompressed";
            }
            case 2: {
                return "CCITT 1D";
            }
            case 3: {
                return "T4/Group 3 Fax";
            }
            case 4: {
                return "T6/Group 4 Fax";
            }
            case 5: {
                return "LZW";
            }
            case 6: {
                return "JPEG (old-style)";
            }
            case 7: {
                return "JPEG";
            }
            case 8: {
                return "Adobe Deflate";
            }
            case 9: {
                return "JBIG B&W";
            }
            case 10: {
                return "JBIG Color";
            }
            case 32766: {
                return "Next";
            }
            case 32771: {
                return "CCIRLEW";
            }
            case 32773: {
                return "PackBits";
            }
            case 32809: {
                return "Thunderscan";
            }
            case 32895: {
                return "IT8CTPAD";
            }
            case 32896: {
                return "IT8LW";
            }
            case 32897: {
                return "IT8MP";
            }
            case 32898: {
                return "IT8BL";
            }
            case 32908: {
                return "PixarFilm";
            }
            case 32909: {
                return "PixarLog";
            }
            case 32946: {
                return "Deflate";
            }
            case 32947: {
                return "DCS";
            }
            case 32661: {
                return "JBIG";
            }
            case 32676: {
                return "SGILog";
            }
            case 32677: {
                return "SGILog24";
            }
            case 32712: {
                return "JPEG 2000";
            }
            case 32713: {
                return "Nikon NEF Compressed";
            }
        }
        return "Unknown compression";
    }

    @Nullable
    public String getThumbnailLengthDescription() {
        String value = ((ExifThumbnailDirectory)this._directory).getString(514);
        return value == null ? null : value + " bytes";
    }

    @Nullable
    public String getThumbnailOffsetDescription() {
        String value = ((ExifThumbnailDirectory)this._directory).getString(513);
        return value == null ? null : value + " bytes";
    }
}

