/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.mov.atoms;

import com.drew.lang.Rational;
import com.drew.lang.SequentialReader;
import com.drew.metadata.mov.QuickTimeDirectory;
import com.drew.metadata.mov.atoms.Atom;
import com.drew.metadata.mov.atoms.FullAtom;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;

public class MovieHeaderAtom
extends FullAtom {
    long creationTime;
    long modificationTime;
    long timescale;
    long duration;
    int preferredRate;
    int preferredVolume;
    int[] matrixStructure;
    long previewTime;
    long previewDuration;
    long posterTime;
    long selectionTime;
    long selectionDuration;
    long currentTime;
    long nextTrackID;

    public MovieHeaderAtom(SequentialReader reader, Atom atom) throws IOException {
        super(reader, atom);
        this.creationTime = reader.getUInt32();
        this.modificationTime = reader.getUInt32();
        this.timescale = reader.getUInt32();
        this.duration = reader.getUInt32();
        this.preferredRate = reader.getInt32();
        this.preferredVolume = reader.getInt16();
        reader.skip(10L);
        this.matrixStructure = new int[]{reader.getInt32(), reader.getInt32(), reader.getInt32(), reader.getInt32(), reader.getInt32(), reader.getInt32(), reader.getInt32(), reader.getInt32(), reader.getInt32()};
        this.previewTime = reader.getUInt32();
        this.previewDuration = reader.getUInt32();
        this.posterTime = reader.getUInt32();
        this.selectionTime = reader.getUInt32();
        this.selectionDuration = reader.getUInt32();
        this.currentTime = reader.getUInt32();
        this.nextTrackID = reader.getUInt32();
    }

    public void addMetadata(QuickTimeDirectory directory) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1904, 0, 1, 0, 0, 0);
        Date date = calendar.getTime();
        long macToUnixEpochOffset = date.getTime();
        directory.setDate(256, new Date(this.creationTime * 1000L + macToUnixEpochOffset));
        directory.setDate(257, new Date(this.modificationTime * 1000L + macToUnixEpochOffset));
        directory.setLong(259, this.duration);
        directory.setLong(258, this.timescale);
        directory.setRational(260, new Rational(this.duration, this.timescale));
        double preferredRateInteger = (this.preferredRate & 0xFFFF0000) >> 16;
        double preferredRateFraction = (double)(this.preferredRate & 0xFFFF) / Math.pow(2.0, 4.0);
        directory.setDouble(261, preferredRateInteger + preferredRateFraction);
        double preferredVolumeInteger = (this.preferredVolume & 0xFF00) >> 8;
        double preferredVolumeFraction = (double)(this.preferredVolume & 0xFF) / Math.pow(2.0, 2.0);
        directory.setDouble(262, preferredVolumeInteger + preferredVolumeFraction);
        directory.setLong(263, this.previewTime);
        directory.setLong(264, this.previewDuration);
        directory.setLong(265, this.posterTime);
        directory.setLong(266, this.selectionTime);
        directory.setLong(267, this.selectionDuration);
        directory.setLong(268, this.currentTime);
        directory.setLong(269, this.nextTrackID);
    }
}

