package com.docusign.rooms.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/** Gets or Sets ProductVersion */
public enum ProductVersion {
  V5("v5"),

  V6("v6");

  private String value;

  ProductVersion(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static ProductVersion fromValue(String value) {
    for (ProductVersion b : ProductVersion.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    return null;
  }
}
