/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.DocumentHtmlDisplayAnchor;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="Holds the properties that define how to generate the responsive-formatted HTML for the document. See [Responsive signing](/docs/esign-rest-api/esign101/concepts/responsive/) in the [eSignature concepts guide](/docs/esign-rest-api/esign101/concepts/).")
public class DocumentHtmlDefinition {
    @JsonProperty(value="displayAnchorPrefix")
    private String displayAnchorPrefix = null;
    @JsonProperty(value="displayAnchors")
    private List<DocumentHtmlDisplayAnchor> displayAnchors = null;
    @JsonProperty(value="displayOrder")
    private String displayOrder = null;
    @JsonProperty(value="displayPageNumber")
    private String displayPageNumber = null;
    @JsonProperty(value="documentGuid")
    private String documentGuid = null;
    @JsonProperty(value="documentId")
    private String documentId = null;
    @JsonProperty(value="headerLabel")
    private String headerLabel = null;
    @JsonProperty(value="maxScreenWidth")
    private String maxScreenWidth = null;
    @JsonProperty(value="removeEmptyTags")
    private String removeEmptyTags = null;
    @JsonProperty(value="showMobileOptimizedToggle")
    private String showMobileOptimizedToggle = null;
    @JsonProperty(value="source")
    private String source = null;

    public DocumentHtmlDefinition displayAnchorPrefix(String displayAnchorPrefix) {
        this.displayAnchorPrefix = displayAnchorPrefix;
        return this;
    }

    @Schema(description="")
    public String getDisplayAnchorPrefix() {
        return this.displayAnchorPrefix;
    }

    public void setDisplayAnchorPrefix(String displayAnchorPrefix) {
        this.displayAnchorPrefix = displayAnchorPrefix;
    }

    public DocumentHtmlDefinition displayAnchors(List<DocumentHtmlDisplayAnchor> displayAnchors) {
        this.displayAnchors = displayAnchors;
        return this;
    }

    public DocumentHtmlDefinition addDisplayAnchorsItem(DocumentHtmlDisplayAnchor displayAnchorsItem) {
        if (this.displayAnchors == null) {
            this.displayAnchors = new ArrayList<DocumentHtmlDisplayAnchor>();
        }
        this.displayAnchors.add(displayAnchorsItem);
        return this;
    }

    @Schema(description="")
    public List<DocumentHtmlDisplayAnchor> getDisplayAnchors() {
        return this.displayAnchors;
    }

    public void setDisplayAnchors(List<DocumentHtmlDisplayAnchor> displayAnchors) {
        this.displayAnchors = displayAnchors;
    }

    public DocumentHtmlDefinition displayOrder(String displayOrder) {
        this.displayOrder = displayOrder;
        return this;
    }

    @Schema(description="")
    public String getDisplayOrder() {
        return this.displayOrder;
    }

    public void setDisplayOrder(String displayOrder) {
        this.displayOrder = displayOrder;
    }

    public DocumentHtmlDefinition displayPageNumber(String displayPageNumber) {
        this.displayPageNumber = displayPageNumber;
        return this;
    }

    @Schema(description="")
    public String getDisplayPageNumber() {
        return this.displayPageNumber;
    }

    public void setDisplayPageNumber(String displayPageNumber) {
        this.displayPageNumber = displayPageNumber;
    }

    public DocumentHtmlDefinition documentGuid(String documentGuid) {
        this.documentGuid = documentGuid;
        return this;
    }

    @Schema(description="")
    public String getDocumentGuid() {
        return this.documentGuid;
    }

    public void setDocumentGuid(String documentGuid) {
        this.documentGuid = documentGuid;
    }

    public DocumentHtmlDefinition documentId(String documentId) {
        this.documentId = documentId;
        return this;
    }

    @Schema(description="Specifies the document ID number that the tab is placed on. This must refer to an existing Document's ID attribute.")
    public String getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    public DocumentHtmlDefinition headerLabel(String headerLabel) {
        this.headerLabel = headerLabel;
        return this;
    }

    @Schema(description="")
    public String getHeaderLabel() {
        return this.headerLabel;
    }

    public void setHeaderLabel(String headerLabel) {
        this.headerLabel = headerLabel;
    }

    public DocumentHtmlDefinition maxScreenWidth(String maxScreenWidth) {
        this.maxScreenWidth = maxScreenWidth;
        return this;
    }

    @Schema(description="")
    public String getMaxScreenWidth() {
        return this.maxScreenWidth;
    }

    public void setMaxScreenWidth(String maxScreenWidth) {
        this.maxScreenWidth = maxScreenWidth;
    }

    public DocumentHtmlDefinition removeEmptyTags(String removeEmptyTags) {
        this.removeEmptyTags = removeEmptyTags;
        return this;
    }

    @Schema(description="")
    public String getRemoveEmptyTags() {
        return this.removeEmptyTags;
    }

    public void setRemoveEmptyTags(String removeEmptyTags) {
        this.removeEmptyTags = removeEmptyTags;
    }

    public DocumentHtmlDefinition showMobileOptimizedToggle(String showMobileOptimizedToggle) {
        this.showMobileOptimizedToggle = showMobileOptimizedToggle;
        return this;
    }

    @Schema(description="")
    public String getShowMobileOptimizedToggle() {
        return this.showMobileOptimizedToggle;
    }

    public void setShowMobileOptimizedToggle(String showMobileOptimizedToggle) {
        this.showMobileOptimizedToggle = showMobileOptimizedToggle;
    }

    public DocumentHtmlDefinition source(String source) {
        this.source = source;
        return this;
    }

    @Schema(description="")
    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentHtmlDefinition documentHtmlDefinition = (DocumentHtmlDefinition)o;
        return Objects.equals(this.displayAnchorPrefix, documentHtmlDefinition.displayAnchorPrefix) && Objects.equals(this.displayAnchors, documentHtmlDefinition.displayAnchors) && Objects.equals(this.displayOrder, documentHtmlDefinition.displayOrder) && Objects.equals(this.displayPageNumber, documentHtmlDefinition.displayPageNumber) && Objects.equals(this.documentGuid, documentHtmlDefinition.documentGuid) && Objects.equals(this.documentId, documentHtmlDefinition.documentId) && Objects.equals(this.headerLabel, documentHtmlDefinition.headerLabel) && Objects.equals(this.maxScreenWidth, documentHtmlDefinition.maxScreenWidth) && Objects.equals(this.removeEmptyTags, documentHtmlDefinition.removeEmptyTags) && Objects.equals(this.showMobileOptimizedToggle, documentHtmlDefinition.showMobileOptimizedToggle) && Objects.equals(this.source, documentHtmlDefinition.source);
    }

    public int hashCode() {
        return Objects.hash(this.displayAnchorPrefix, this.displayAnchors, this.displayOrder, this.displayPageNumber, this.documentGuid, this.documentId, this.headerLabel, this.maxScreenWidth, this.removeEmptyTags, this.showMobileOptimizedToggle, this.source);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentHtmlDefinition {\n");
        sb.append("    displayAnchorPrefix: ").append(this.toIndentedString(this.displayAnchorPrefix)).append("\n");
        sb.append("    displayAnchors: ").append(this.toIndentedString(this.displayAnchors)).append("\n");
        sb.append("    displayOrder: ").append(this.toIndentedString(this.displayOrder)).append("\n");
        sb.append("    displayPageNumber: ").append(this.toIndentedString(this.displayPageNumber)).append("\n");
        sb.append("    documentGuid: ").append(this.toIndentedString(this.documentGuid)).append("\n");
        sb.append("    documentId: ").append(this.toIndentedString(this.documentId)).append("\n");
        sb.append("    headerLabel: ").append(this.toIndentedString(this.headerLabel)).append("\n");
        sb.append("    maxScreenWidth: ").append(this.toIndentedString(this.maxScreenWidth)).append("\n");
        sb.append("    removeEmptyTags: ").append(this.toIndentedString(this.removeEmptyTags)).append("\n");
        sb.append("    showMobileOptimizedToggle: ").append(this.toIndentedString(this.showMobileOptimizedToggle)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

