/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.ErrorDetails;
import com.docusign.esign.model.UserInfo;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

public class LockInformation {
    @JsonProperty(value="errorDetails")
    private ErrorDetails errorDetails = null;
    @JsonProperty(value="lockDurationInSeconds")
    private String lockDurationInSeconds = null;
    @JsonProperty(value="lockedByApp")
    private String lockedByApp = null;
    @JsonProperty(value="lockedByUser")
    private UserInfo lockedByUser = null;
    @JsonProperty(value="lockedUntilDateTime")
    private String lockedUntilDateTime = null;
    @JsonProperty(value="lockToken")
    private String lockToken = null;
    @JsonProperty(value="lockType")
    private String lockType = null;
    @JsonProperty(value="useScratchPad")
    private String useScratchPad = null;

    public LockInformation errorDetails(ErrorDetails errorDetails) {
        this.errorDetails = errorDetails;
        return this;
    }

    @Schema(description="Array or errors.")
    public ErrorDetails getErrorDetails() {
        return this.errorDetails;
    }

    public void setErrorDetails(ErrorDetails errorDetails) {
        this.errorDetails = errorDetails;
    }

    public LockInformation lockDurationInSeconds(String lockDurationInSeconds) {
        this.lockDurationInSeconds = lockDurationInSeconds;
        return this;
    }

    @Schema(description="Sets the time, in seconds, until the lock expires when there is no activity on the envelope.  If no value is entered, then the default value of 300 seconds is used. The maximum value is 1,800 seconds.  The lock duration can be extended. ")
    public String getLockDurationInSeconds() {
        return this.lockDurationInSeconds;
    }

    public void setLockDurationInSeconds(String lockDurationInSeconds) {
        this.lockDurationInSeconds = lockDurationInSeconds;
    }

    public LockInformation lockedByApp(String lockedByApp) {
        this.lockedByApp = lockedByApp;
        return this;
    }

    @Schema(description="Specifies the friendly name of  the application that is locking the envelope.")
    public String getLockedByApp() {
        return this.lockedByApp;
    }

    public void setLockedByApp(String lockedByApp) {
        this.lockedByApp = lockedByApp;
    }

    public LockInformation lockedByUser(UserInfo lockedByUser) {
        this.lockedByUser = lockedByUser;
        return this;
    }

    @Schema(description="A complex type containing information about the user that has the envelope or template locked.")
    public UserInfo getLockedByUser() {
        return this.lockedByUser;
    }

    public void setLockedByUser(UserInfo lockedByUser) {
        this.lockedByUser = lockedByUser;
    }

    public LockInformation lockedUntilDateTime(String lockedUntilDateTime) {
        this.lockedUntilDateTime = lockedUntilDateTime;
        return this;
    }

    @Schema(description="The datetime until the envelope lock expires.")
    public String getLockedUntilDateTime() {
        return this.lockedUntilDateTime;
    }

    public void setLockedUntilDateTime(String lockedUntilDateTime) {
        this.lockedUntilDateTime = lockedUntilDateTime;
    }

    public LockInformation lockToken(String lockToken) {
        this.lockToken = lockToken;
        return this;
    }

    @Schema(description="A unique identifier provided to the owner of the envelope lock.   Used to prove ownership of the lock.")
    public String getLockToken() {
        return this.lockToken;
    }

    public void setLockToken(String lockToken) {
        this.lockToken = lockToken;
    }

    public LockInformation lockType(String lockType) {
        this.lockType = lockType;
        return this;
    }

    @Schema(description="The type of envelope lock.  Currently \"edit\" is the only supported type.")
    public String getLockType() {
        return this.lockType;
    }

    public void setLockType(String lockType) {
        this.lockType = lockType;
    }

    public LockInformation useScratchPad(String useScratchPad) {
        this.useScratchPad = useScratchPad;
        return this;
    }

    @Schema(description="Reserved for future use.  Indicates whether a scratchpad is used for editing information.  ")
    public String getUseScratchPad() {
        return this.useScratchPad;
    }

    public void setUseScratchPad(String useScratchPad) {
        this.useScratchPad = useScratchPad;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LockInformation lockInformation = (LockInformation)o;
        return Objects.equals(this.errorDetails, lockInformation.errorDetails) && Objects.equals(this.lockDurationInSeconds, lockInformation.lockDurationInSeconds) && Objects.equals(this.lockedByApp, lockInformation.lockedByApp) && Objects.equals(this.lockedByUser, lockInformation.lockedByUser) && Objects.equals(this.lockedUntilDateTime, lockInformation.lockedUntilDateTime) && Objects.equals(this.lockToken, lockInformation.lockToken) && Objects.equals(this.lockType, lockInformation.lockType) && Objects.equals(this.useScratchPad, lockInformation.useScratchPad);
    }

    public int hashCode() {
        return Objects.hash(this.errorDetails, this.lockDurationInSeconds, this.lockedByApp, this.lockedByUser, this.lockedUntilDateTime, this.lockToken, this.lockType, this.useScratchPad);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LockInformation {\n");
        sb.append("    errorDetails: ").append(this.toIndentedString(this.errorDetails)).append("\n");
        sb.append("    lockDurationInSeconds: ").append(this.toIndentedString(this.lockDurationInSeconds)).append("\n");
        sb.append("    lockedByApp: ").append(this.toIndentedString(this.lockedByApp)).append("\n");
        sb.append("    lockedByUser: ").append(this.toIndentedString(this.lockedByUser)).append("\n");
        sb.append("    lockedUntilDateTime: ").append(this.toIndentedString(this.lockedUntilDateTime)).append("\n");
        sb.append("    lockToken: ").append(this.toIndentedString(this.lockToken)).append("\n");
        sb.append("    lockType: ").append(this.toIndentedString(this.lockType)).append("\n");
        sb.append("    useScratchPad: ").append(this.toIndentedString(this.useScratchPad)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

