/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.click.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Information about a document.")
public class Document {
    @JsonProperty(value="documentBase64")
    private String documentBase64 = null;
    @JsonProperty(value="documentDisplay")
    private String documentDisplay = null;
    @JsonProperty(value="documentHtml")
    private String documentHtml = null;
    @JsonProperty(value="documentName")
    private String documentName = null;
    @JsonProperty(value="fileExtension")
    private String fileExtension = null;
    @JsonProperty(value="mustRead")
    private Boolean mustRead = null;
    @JsonProperty(value="mustView")
    private Boolean mustView = null;
    @JsonProperty(value="order")
    private Integer order = null;

    public Document documentBase64(String documentBase64) {
        this.documentBase64 = documentBase64;
        return this;
    }

    @Schema(description="The base64-encoded contents of the document.")
    public String getDocumentBase64() {
        return this.documentBase64;
    }

    public void setDocumentBase64(String documentBase64) {
        this.documentBase64 = documentBase64;
    }

    public Document documentDisplay(String documentDisplay) {
        this.documentDisplay = documentDisplay;
        return this;
    }

    @Schema(description="Display type: link, document or pdf")
    public String getDocumentDisplay() {
        return this.documentDisplay;
    }

    public void setDocumentDisplay(String documentDisplay) {
        this.documentDisplay = documentDisplay;
    }

    public Document documentHtml(String documentHtml) {
        this.documentHtml = documentHtml;
        return this;
    }

    @Schema(description="The HTML representation of the document.")
    public String getDocumentHtml() {
        return this.documentHtml;
    }

    public void setDocumentHtml(String documentHtml) {
        this.documentHtml = documentHtml;
    }

    public Document documentName(String documentName) {
        this.documentName = documentName;
        return this;
    }

    @Schema(description="The name of the document.")
    public String getDocumentName() {
        return this.documentName;
    }

    public void setDocumentName(String documentName) {
        this.documentName = documentName;
    }

    public Document fileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
        return this;
    }

    @Schema(description="The file extension of the document.")
    public String getFileExtension() {
        return this.fileExtension;
    }

    public void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    public Document mustRead(Boolean mustRead) {
        this.mustRead = mustRead;
        return this;
    }

    @Schema(description="**True** if the user needs to scroll to the end of the document.")
    public Boolean isMustRead() {
        return this.mustRead;
    }

    public void setMustRead(Boolean mustRead) {
        this.mustRead = mustRead;
    }

    public Document mustView(Boolean mustView) {
        this.mustView = mustView;
        return this;
    }

    @Schema(description="**True** if the user must view the document.")
    public Boolean isMustView() {
        return this.mustView;
    }

    public void setMustView(Boolean mustView) {
        this.mustView = mustView;
    }

    public Document order(Integer order) {
        this.order = order;
        return this;
    }

    @Schema(description="The order of document layout.")
    public Integer getOrder() {
        return this.order;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Document document = (Document)o;
        return Objects.equals(this.documentBase64, document.documentBase64) && Objects.equals(this.documentDisplay, document.documentDisplay) && Objects.equals(this.documentHtml, document.documentHtml) && Objects.equals(this.documentName, document.documentName) && Objects.equals(this.fileExtension, document.fileExtension) && Objects.equals(this.mustRead, document.mustRead) && Objects.equals(this.mustView, document.mustView) && Objects.equals(this.order, document.order);
    }

    public int hashCode() {
        return Objects.hash(this.documentBase64, this.documentDisplay, this.documentHtml, this.documentName, this.fileExtension, this.mustRead, this.mustView, this.order);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Document {\n");
        sb.append("    documentBase64: ").append(this.toIndentedString(this.documentBase64)).append("\n");
        sb.append("    documentDisplay: ").append(this.toIndentedString(this.documentDisplay)).append("\n");
        sb.append("    documentHtml: ").append(this.toIndentedString(this.documentHtml)).append("\n");
        sb.append("    documentName: ").append(this.toIndentedString(this.documentName)).append("\n");
        sb.append("    fileExtension: ").append(this.toIndentedString(this.fileExtension)).append("\n");
        sb.append("    mustRead: ").append(this.toIndentedString(this.mustRead)).append("\n");
        sb.append("    mustView: ").append(this.toIndentedString(this.mustView)).append("\n");
        sb.append("    order: ").append(this.toIndentedString(this.order)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

