/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.click.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="Information about how an agreement is displayed.")
public class DisplaySettings {
    @JsonProperty(value="actionButtonAlignment")
    private String actionButtonAlignment = null;
    @JsonProperty(value="allowClientOnly")
    private Boolean allowClientOnly = null;
    @JsonProperty(value="allowedHosts")
    private List<String> allowedHosts = null;
    @JsonProperty(value="brandId")
    private String brandId = null;
    @JsonProperty(value="consentButtonText")
    private String consentButtonText = null;
    @JsonProperty(value="consentText")
    private String consentText = null;
    @JsonProperty(value="declineButtonText")
    private String declineButtonText = null;
    @JsonProperty(value="displayName")
    private String displayName = null;
    @JsonProperty(value="documentDisplay")
    private String documentDisplay = null;
    @JsonProperty(value="downloadable")
    private Boolean downloadable = null;
    @JsonProperty(value="format")
    private String format = null;
    @JsonProperty(value="hasDeclineButton")
    private Boolean hasDeclineButton = null;
    @JsonProperty(value="mustRead")
    private Boolean mustRead = null;
    @JsonProperty(value="mustView")
    private Boolean mustView = null;
    @JsonProperty(value="recordDeclineResponses")
    private Boolean recordDeclineResponses = null;
    @JsonProperty(value="requireAccept")
    private Boolean requireAccept = null;
    @JsonProperty(value="sendToEmail")
    private Boolean sendToEmail = null;
    @JsonProperty(value="statementAlignment")
    private String statementAlignment = null;

    public DisplaySettings actionButtonAlignment(String actionButtonAlignment) {
        this.actionButtonAlignment = actionButtonAlignment;
        return this;
    }

    @Schema(description="Position of the Accept button in the agreement. One of   - `right` - `left` ")
    public String getActionButtonAlignment() {
        return this.actionButtonAlignment;
    }

    public void setActionButtonAlignment(String actionButtonAlignment) {
        this.actionButtonAlignment = actionButtonAlignment;
    }

    public DisplaySettings allowClientOnly(Boolean allowClientOnly) {
        this.allowClientOnly = allowClientOnly;
        return this;
    }

    @Schema(description="When **true,** this agreement can be be used in client-only integrations.")
    public Boolean isAllowClientOnly() {
        return this.allowClientOnly;
    }

    public void setAllowClientOnly(Boolean allowClientOnly) {
        this.allowClientOnly = allowClientOnly;
    }

    public DisplaySettings allowedHosts(List<String> allowedHosts) {
        this.allowedHosts = allowedHosts;
        return this;
    }

    public DisplaySettings addAllowedHostsItem(String allowedHostsItem) {
        if (this.allowedHosts == null) {
            this.allowedHosts = new ArrayList<String>();
        }
        this.allowedHosts.add(allowedHostsItem);
        return this;
    }

    @Schema(description="Hosts that can host the clickwrap.  It is an error if the clickwrap didn't come from one of these hosts. ")
    public List<String> getAllowedHosts() {
        return this.allowedHosts;
    }

    public void setAllowedHosts(List<String> allowedHosts) {
        this.allowedHosts = allowedHosts;
    }

    public DisplaySettings brandId(String brandId) {
        this.brandId = brandId;
        return this;
    }

    @Schema(description="The signing brand ID.")
    public String getBrandId() {
        return this.brandId;
    }

    public void setBrandId(String brandId) {
        this.brandId = brandId;
    }

    public DisplaySettings consentButtonText(String consentButtonText) {
        this.consentButtonText = consentButtonText;
        return this;
    }

    @Schema(description="Text on the agree button.")
    public String getConsentButtonText() {
        return this.consentButtonText;
    }

    public void setConsentButtonText(String consentButtonText) {
        this.consentButtonText = consentButtonText;
    }

    public DisplaySettings consentText(String consentText) {
        this.consentText = consentText;
        return this;
    }

    @Schema(description="The statement prefixing the Electronic Record and Signature Disclosure agreement.")
    public String getConsentText() {
        return this.consentText;
    }

    public void setConsentText(String consentText) {
        this.consentText = consentText;
    }

    public DisplaySettings declineButtonText(String declineButtonText) {
        this.declineButtonText = declineButtonText;
        return this;
    }

    @Schema(description="The text on the decline button.")
    public String getDeclineButtonText() {
        return this.declineButtonText;
    }

    public void setDeclineButtonText(String declineButtonText) {
        this.declineButtonText = declineButtonText;
    }

    public DisplaySettings displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Schema(description="The display name of the user agreement.")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public DisplaySettings documentDisplay(String documentDisplay) {
        this.documentDisplay = documentDisplay;
        return this;
    }

    @Schema(description="Display type: link, document or pdf")
    public String getDocumentDisplay() {
        return this.documentDisplay;
    }

    public void setDocumentDisplay(String documentDisplay) {
        this.documentDisplay = documentDisplay;
    }

    public DisplaySettings downloadable(Boolean downloadable) {
        this.downloadable = downloadable;
        return this;
    }

    @Schema(description="**True** if the agreement is downloadable.")
    public Boolean isDownloadable() {
        return this.downloadable;
    }

    public void setDownloadable(Boolean downloadable) {
        this.downloadable = downloadable;
    }

    public DisplaySettings format(String format) {
        this.format = format;
        return this;
    }

    @Schema(description="Display format: inline or modal.")
    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public DisplaySettings hasDeclineButton(Boolean hasDeclineButton) {
        this.hasDeclineButton = hasDeclineButton;
        return this;
    }

    @Schema(description="**True** if the agreement has a decline button.")
    public Boolean isHasDeclineButton() {
        return this.hasDeclineButton;
    }

    public void setHasDeclineButton(Boolean hasDeclineButton) {
        this.hasDeclineButton = hasDeclineButton;
    }

    public DisplaySettings mustRead(Boolean mustRead) {
        this.mustRead = mustRead;
        return this;
    }

    @Schema(description="**True** if the user needs to scroll to the end of the document.")
    public Boolean isMustRead() {
        return this.mustRead;
    }

    public void setMustRead(Boolean mustRead) {
        this.mustRead = mustRead;
    }

    public DisplaySettings mustView(Boolean mustView) {
        this.mustView = mustView;
        return this;
    }

    @Schema(description="**True** if the user must view the document.")
    public Boolean isMustView() {
        return this.mustView;
    }

    public void setMustView(Boolean mustView) {
        this.mustView = mustView;
    }

    public DisplaySettings recordDeclineResponses(Boolean recordDeclineResponses) {
        this.recordDeclineResponses = recordDeclineResponses;
        return this;
    }

    @Schema(description="When **true,** this agreement records decline actions.")
    public Boolean isRecordDeclineResponses() {
        return this.recordDeclineResponses;
    }

    public void setRecordDeclineResponses(Boolean recordDeclineResponses) {
        this.recordDeclineResponses = recordDeclineResponses;
    }

    public DisplaySettings requireAccept(Boolean requireAccept) {
        this.requireAccept = requireAccept;
        return this;
    }

    @Schema(description="**True** if a checkbox is required to accept.")
    public Boolean isRequireAccept() {
        return this.requireAccept;
    }

    public void setRequireAccept(Boolean requireAccept) {
        this.requireAccept = requireAccept;
    }

    public DisplaySettings sendToEmail(Boolean sendToEmail) {
        this.sendToEmail = sendToEmail;
        return this;
    }

    @Schema(description="**True** if send to email is applicable.")
    public Boolean isSendToEmail() {
        return this.sendToEmail;
    }

    public void setSendToEmail(Boolean sendToEmail) {
        this.sendToEmail = sendToEmail;
    }

    public DisplaySettings statementAlignment(String statementAlignment) {
        this.statementAlignment = statementAlignment;
        return this;
    }

    @Schema(description="Position of the agreement statement. One of   - `top` - `bottom` ")
    public String getStatementAlignment() {
        return this.statementAlignment;
    }

    public void setStatementAlignment(String statementAlignment) {
        this.statementAlignment = statementAlignment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DisplaySettings displaySettings = (DisplaySettings)o;
        return Objects.equals(this.actionButtonAlignment, displaySettings.actionButtonAlignment) && Objects.equals(this.allowClientOnly, displaySettings.allowClientOnly) && Objects.equals(this.allowedHosts, displaySettings.allowedHosts) && Objects.equals(this.brandId, displaySettings.brandId) && Objects.equals(this.consentButtonText, displaySettings.consentButtonText) && Objects.equals(this.consentText, displaySettings.consentText) && Objects.equals(this.declineButtonText, displaySettings.declineButtonText) && Objects.equals(this.displayName, displaySettings.displayName) && Objects.equals(this.documentDisplay, displaySettings.documentDisplay) && Objects.equals(this.downloadable, displaySettings.downloadable) && Objects.equals(this.format, displaySettings.format) && Objects.equals(this.hasDeclineButton, displaySettings.hasDeclineButton) && Objects.equals(this.mustRead, displaySettings.mustRead) && Objects.equals(this.mustView, displaySettings.mustView) && Objects.equals(this.recordDeclineResponses, displaySettings.recordDeclineResponses) && Objects.equals(this.requireAccept, displaySettings.requireAccept) && Objects.equals(this.sendToEmail, displaySettings.sendToEmail) && Objects.equals(this.statementAlignment, displaySettings.statementAlignment);
    }

    public int hashCode() {
        return Objects.hash(this.actionButtonAlignment, this.allowClientOnly, this.allowedHosts, this.brandId, this.consentButtonText, this.consentText, this.declineButtonText, this.displayName, this.documentDisplay, this.downloadable, this.format, this.hasDeclineButton, this.mustRead, this.mustView, this.recordDeclineResponses, this.requireAccept, this.sendToEmail, this.statementAlignment);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DisplaySettings {\n");
        sb.append("    actionButtonAlignment: ").append(this.toIndentedString(this.actionButtonAlignment)).append("\n");
        sb.append("    allowClientOnly: ").append(this.toIndentedString(this.allowClientOnly)).append("\n");
        sb.append("    allowedHosts: ").append(this.toIndentedString(this.allowedHosts)).append("\n");
        sb.append("    brandId: ").append(this.toIndentedString(this.brandId)).append("\n");
        sb.append("    consentButtonText: ").append(this.toIndentedString(this.consentButtonText)).append("\n");
        sb.append("    consentText: ").append(this.toIndentedString(this.consentText)).append("\n");
        sb.append("    declineButtonText: ").append(this.toIndentedString(this.declineButtonText)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    documentDisplay: ").append(this.toIndentedString(this.documentDisplay)).append("\n");
        sb.append("    downloadable: ").append(this.toIndentedString(this.downloadable)).append("\n");
        sb.append("    format: ").append(this.toIndentedString(this.format)).append("\n");
        sb.append("    hasDeclineButton: ").append(this.toIndentedString(this.hasDeclineButton)).append("\n");
        sb.append("    mustRead: ").append(this.toIndentedString(this.mustRead)).append("\n");
        sb.append("    mustView: ").append(this.toIndentedString(this.mustView)).append("\n");
        sb.append("    recordDeclineResponses: ").append(this.toIndentedString(this.recordDeclineResponses)).append("\n");
        sb.append("    requireAccept: ").append(this.toIndentedString(this.requireAccept)).append("\n");
        sb.append("    sendToEmail: ").append(this.toIndentedString(this.sendToEmail)).append("\n");
        sb.append("    statementAlignment: ").append(this.toIndentedString(this.statementAlignment)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

