/*
 * Decompiled with CFR 0.152.
 */
package com.ditchoom.buffer.pool;

import com.ditchoom.buffer.AllocationZone;
import com.ditchoom.buffer.BufferFactoryAndroid;
import com.ditchoom.buffer.ByteOrder;
import com.ditchoom.buffer.PlatformBuffer;
import com.ditchoom.buffer.ReadWriteBuffer;
import com.ditchoom.buffer.pool.BufferPool;
import com.ditchoom.buffer.pool.PoolStats;
import com.ditchoom.buffer.pool.PooledBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.atomicfu.AtomicFU;
import kotlinx.atomicfu.AtomicInt;
import kotlinx.atomicfu.AtomicLong;
import kotlinx.atomicfu.AtomicRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0001$B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0016H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0019H\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020 H\u0002J\n\u0010!\u001a\u0004\u0018\u00010 H\u0002J\u0010\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/ditchoom/buffer/pool/LockFreeBufferPool;", "Lcom/ditchoom/buffer/pool/BufferPool;", "maxPoolSize", "", "defaultBufferSize", "byteOrder", "Lcom/ditchoom/buffer/ByteOrder;", "allocationZone", "Lcom/ditchoom/buffer/AllocationZone;", "<init>", "(IILcom/ditchoom/buffer/ByteOrder;Lcom/ditchoom/buffer/AllocationZone;)V", "head", "Lkotlinx/atomicfu/AtomicRef;", "Lcom/ditchoom/buffer/pool/LockFreeBufferPool$Node;", "poolSize", "Lkotlinx/atomicfu/AtomicInt;", "totalAllocations", "Lkotlinx/atomicfu/AtomicLong;", "poolHits", "poolMisses", "peakPoolSize", "acquire", "Lcom/ditchoom/buffer/ReadWriteBuffer;", "minSize", "release", "", "buffer", "stats", "Lcom/ditchoom/buffer/pool/PoolStats;", "clear", "push", "", "Lcom/ditchoom/buffer/PlatformBuffer;", "pop", "updatePeak", "currentSize", "Node", "buffer_release"})
public final class LockFreeBufferPool
implements BufferPool {
    private final int maxPoolSize;
    private final int defaultBufferSize;
    @NotNull
    private final ByteOrder byteOrder;
    @NotNull
    private final AllocationZone allocationZone;
    @NotNull
    private final AtomicRef<Node> head;
    @NotNull
    private final AtomicInt poolSize;
    @NotNull
    private final AtomicLong totalAllocations;
    @NotNull
    private final AtomicLong poolHits;
    @NotNull
    private final AtomicLong poolMisses;
    @NotNull
    private final AtomicInt peakPoolSize;

    public LockFreeBufferPool(int maxPoolSize, int defaultBufferSize, @NotNull ByteOrder byteOrder, @NotNull AllocationZone allocationZone) {
        Intrinsics.checkNotNullParameter((Object)((Object)byteOrder), (String)"byteOrder");
        Intrinsics.checkNotNullParameter((Object)allocationZone, (String)"allocationZone");
        this.maxPoolSize = maxPoolSize;
        this.defaultBufferSize = defaultBufferSize;
        this.byteOrder = byteOrder;
        this.allocationZone = allocationZone;
        this.head = AtomicFU.atomic(null);
        this.poolSize = AtomicFU.atomic((int)0);
        this.totalAllocations = AtomicFU.atomic((long)0L);
        this.poolHits = AtomicFU.atomic((long)0L);
        this.poolMisses = AtomicFU.atomic((long)0L);
        this.peakPoolSize = AtomicFU.atomic((int)0);
    }

    @Override
    @NotNull
    public ReadWriteBuffer acquire(int minSize) {
        PlatformBuffer platformBuffer;
        this.totalAllocations.incrementAndGet();
        int size = Math.max(minSize, this.defaultBufferSize);
        PlatformBuffer buffer = this.pop();
        if (buffer != null && buffer.getCapacity() >= size) {
            this.poolHits.incrementAndGet();
            buffer.resetForWrite();
            platformBuffer = buffer;
        } else {
            this.poolMisses.incrementAndGet();
            platformBuffer = BufferFactoryAndroid.allocate(PlatformBuffer.Companion, size, this.allocationZone, this.byteOrder);
        }
        PlatformBuffer raw = platformBuffer;
        return new PooledBuffer(raw, this);
    }

    @Override
    public void release(@NotNull ReadWriteBuffer buffer) {
        PlatformBuffer platformBuffer;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        ReadWriteBuffer readWriteBuffer = buffer;
        if (readWriteBuffer instanceof PooledBuffer) {
            platformBuffer = ((PooledBuffer)buffer).getInner$buffer_release();
        } else if (readWriteBuffer instanceof PlatformBuffer) {
            platformBuffer = (PlatformBuffer)buffer;
        } else {
            return;
        }
        PlatformBuffer platformBuffer2 = platformBuffer;
        if (this.poolSize.getValue() < this.maxPoolSize) {
            if (this.push(platformBuffer2)) {
                int currentSize = this.poolSize.getValue();
                this.updatePeak(currentSize);
            } else {
                platformBuffer2.freeNativeMemory();
            }
        } else {
            platformBuffer2.freeNativeMemory();
        }
    }

    @Override
    @NotNull
    public PoolStats stats() {
        return new PoolStats(this.totalAllocations.getValue(), this.poolHits.getValue(), this.poolMisses.getValue(), this.poolSize.getValue(), this.peakPoolSize.getValue());
    }

    @Override
    public void clear() {
        while (this.pop() != null) {
            PlatformBuffer buffer;
            buffer.freeNativeMemory();
        }
    }

    private final boolean push(PlatformBuffer buffer) {
        Node newNode;
        Node oldHead;
        do {
            int currentSize;
            if ((currentSize = this.poolSize.getValue()) < this.maxPoolSize) continue;
            return false;
        } while (!this.head.compareAndSet((Object)(oldHead = (Node)this.head.getValue()), (Object)(newNode = new Node(buffer, oldHead))));
        this.poolSize.incrementAndGet();
        return true;
    }

    private final PlatformBuffer pop() {
        Node newHead;
        Node oldHead;
        do {
            if ((Node)this.head.getValue() != null) continue;
            return null;
        } while (!this.head.compareAndSet((Object)oldHead, (Object)(newHead = oldHead.getNext())));
        this.poolSize.decrementAndGet();
        return oldHead.getBuffer();
    }

    private final void updatePeak(int currentSize) {
        int peak;
        do {
            if (currentSize > (peak = this.peakPoolSize.getValue())) continue;
            return;
        } while (!this.peakPoolSize.compareAndSet(peak, currentSize));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/ditchoom/buffer/pool/LockFreeBufferPool$Node;", "", "buffer", "Lcom/ditchoom/buffer/PlatformBuffer;", "next", "<init>", "(Lcom/ditchoom/buffer/PlatformBuffer;Lcom/ditchoom/buffer/pool/LockFreeBufferPool$Node;)V", "getBuffer", "()Lcom/ditchoom/buffer/PlatformBuffer;", "getNext", "()Lcom/ditchoom/buffer/pool/LockFreeBufferPool$Node;", "buffer_release"})
    private static final class Node {
        @NotNull
        private final PlatformBuffer buffer;
        @Nullable
        private final Node next;

        public Node(@NotNull PlatformBuffer buffer, @Nullable Node next) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            this.buffer = buffer;
            this.next = next;
        }

        @NotNull
        public final PlatformBuffer getBuffer() {
            return this.buffer;
        }

        @Nullable
        public final Node getNext() {
            return this.next;
        }
    }
}

