/*
 * Decompiled with CFR 0.152.
 */
package com.ditchoom.buffer;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.misc.Unsafe;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\fJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u0013\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0012J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u0016\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0015J\u000e\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u0018\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eJ\u001e\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u000eJ\u001e\u0010\u001d\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\fJ&\u0010#\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\u0015J&\u0010(\u001a\u00020\n2\u0006\u0010)\u001a\u00020%2\u0006\u0010*\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020\u0015J\u0018\u00100\u001a\u0004\u0018\u0001012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u00102\u001a\u00020\u0015R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\bR\u001b\u0010\u001e\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b\u001f\u0010 R!\u0010+\u001a\b\u0012\u0002\b\u0003\u0018\u00010,8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b/\u0010\"\u001a\u0004\b-\u0010.\u00a8\u00063"}, d2={"Lcom/ditchoom/buffer/UnsafeMemory;", "", "<init>", "()V", "unsafe", "Lsun/misc/Unsafe;", "isSupported", "", "()Z", "checkSupported", "", "getByte", "", "address", "", "putByte", "value", "getShort", "", "putShort", "getInt", "", "putInt", "getLong", "putLong", "copyMemory", "srcAddress", "dstAddress", "size", "setMemory", "BYTE_ARRAY_BASE_OFFSET", "getBYTE_ARRAY_BASE_OFFSET", "()J", "BYTE_ARRAY_BASE_OFFSET$delegate", "Lkotlin/Lazy;", "copyMemoryToArray", "dest", "", "destOffset", "length", "copyMemoryFromArray", "src", "srcOffset", "directByteBufferConstructor", "Ljava/lang/reflect/Constructor;", "getDirectByteBufferConstructor", "()Ljava/lang/reflect/Constructor;", "directByteBufferConstructor$delegate", "tryWrapAsDirectByteBuffer", "Ljava/nio/ByteBuffer;", "capacity", "buffer_release"})
public final class UnsafeMemory {
    @NotNull
    public static final UnsafeMemory INSTANCE;
    @Nullable
    private static final Unsafe unsafe;
    private static final boolean isSupported;
    @NotNull
    private static final Lazy BYTE_ARRAY_BASE_OFFSET$delegate;
    @NotNull
    private static final Lazy directByteBufferConstructor$delegate;

    private UnsafeMemory() {
    }

    public final boolean isSupported() {
        return isSupported;
    }

    private final void checkSupported() {
        if (unsafe == null) {
            throw new UnsupportedOperationException("UnsafeMemory is not supported on this platform. sun.misc.Unsafe is not available.");
        }
    }

    public final byte getByte(long address) {
        this.checkSupported();
        Unsafe unsafe = UnsafeMemory.unsafe;
        Intrinsics.checkNotNull((Object)unsafe);
        return unsafe.getByte(address);
    }

    public final void putByte(long address, byte value) {
        this.checkSupported();
        Unsafe unsafe = UnsafeMemory.unsafe;
        Intrinsics.checkNotNull((Object)unsafe);
        unsafe.putByte(address, value);
    }

    public final short getShort(long address) {
        this.checkSupported();
        Unsafe unsafe = UnsafeMemory.unsafe;
        Intrinsics.checkNotNull((Object)unsafe);
        return unsafe.getShort(address);
    }

    public final void putShort(long address, short value) {
        this.checkSupported();
        Unsafe unsafe = UnsafeMemory.unsafe;
        Intrinsics.checkNotNull((Object)unsafe);
        unsafe.putShort(address, value);
    }

    public final int getInt(long address) {
        this.checkSupported();
        Unsafe unsafe = UnsafeMemory.unsafe;
        Intrinsics.checkNotNull((Object)unsafe);
        return unsafe.getInt(address);
    }

    public final void putInt(long address, int value) {
        this.checkSupported();
        Unsafe unsafe = UnsafeMemory.unsafe;
        Intrinsics.checkNotNull((Object)unsafe);
        unsafe.putInt(address, value);
    }

    public final long getLong(long address) {
        this.checkSupported();
        Unsafe unsafe = UnsafeMemory.unsafe;
        Intrinsics.checkNotNull((Object)unsafe);
        return unsafe.getLong(address);
    }

    public final void putLong(long address, long value) {
        this.checkSupported();
        Unsafe unsafe = UnsafeMemory.unsafe;
        Intrinsics.checkNotNull((Object)unsafe);
        unsafe.putLong(address, value);
    }

    public final void copyMemory(long srcAddress, long dstAddress, long size) {
        this.checkSupported();
        Unsafe unsafe = UnsafeMemory.unsafe;
        Intrinsics.checkNotNull((Object)unsafe);
        unsafe.copyMemory(srcAddress, dstAddress, size);
    }

    public final void setMemory(long address, long size, byte value) {
        this.checkSupported();
        Unsafe unsafe = UnsafeMemory.unsafe;
        Intrinsics.checkNotNull((Object)unsafe);
        unsafe.setMemory(address, size, value);
    }

    private final long getBYTE_ARRAY_BASE_OFFSET() {
        Lazy lazy = BYTE_ARRAY_BASE_OFFSET$delegate;
        return ((Number)lazy.getValue()).longValue();
    }

    public final void copyMemoryToArray(long srcAddress, @NotNull byte[] dest, int destOffset, int length) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        this.checkSupported();
        Unsafe unsafe = UnsafeMemory.unsafe;
        Intrinsics.checkNotNull((Object)unsafe);
        unsafe.copyMemory(null, srcAddress, dest, this.getBYTE_ARRAY_BASE_OFFSET() + (long)destOffset, length);
    }

    public final void copyMemoryFromArray(@NotNull byte[] src, int srcOffset, long dstAddress, int length) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        this.checkSupported();
        Unsafe unsafe = UnsafeMemory.unsafe;
        Intrinsics.checkNotNull((Object)unsafe);
        unsafe.copyMemory(src, this.getBYTE_ARRAY_BASE_OFFSET() + (long)srcOffset, null, dstAddress, length);
    }

    private final Constructor<?> getDirectByteBufferConstructor() {
        Lazy lazy = directByteBufferConstructor$delegate;
        return (Constructor)lazy.getValue();
    }

    @Nullable
    public final ByteBuffer tryWrapAsDirectByteBuffer(long address, int capacity) {
        ByteBuffer byteBuffer;
        Constructor<?> constructor = this.getDirectByteBufferConstructor();
        if (constructor == null) {
            return null;
        }
        Constructor<?> constructor2 = constructor;
        try {
            Object[] objectArray = new Object[]{address, capacity};
            Object obj = constructor2.newInstance(objectArray);
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type java.nio.ByteBuffer");
            byteBuffer = (ByteBuffer)obj;
        }
        catch (Exception e) {
            byteBuffer = null;
        }
        return byteBuffer;
    }

    private static final long BYTE_ARRAY_BASE_OFFSET_delegate$lambda$0() {
        Unsafe unsafe = UnsafeMemory.unsafe;
        Intrinsics.checkNotNull((Object)unsafe);
        return unsafe.arrayBaseOffset(byte[].class);
    }

    private static final Constructor directByteBufferConstructor_delegate$lambda$0() {
        Constructor<?> constructor;
        try {
            Class<?> clazz = Class.forName("java.nio.DirectByteBuffer");
            Class[] classArray = new Class[]{Long.TYPE, Integer.TYPE};
            Constructor<?> constructor2 = clazz.getDeclaredConstructor(classArray);
            constructor2.setAccessible(true);
            constructor = constructor2;
        }
        catch (Exception e) {
            constructor = null;
        }
        return constructor;
    }

    static {
        Unsafe unsafe;
        INSTANCE = new UnsafeMemory();
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            Object object = field.get(null);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type sun.misc.Unsafe");
            unsafe = (Unsafe)object;
        }
        catch (Exception e) {
            unsafe = null;
        }
        UnsafeMemory.unsafe = unsafe;
        isSupported = UnsafeMemory.unsafe != null;
        BYTE_ARRAY_BASE_OFFSET$delegate = LazyKt.lazy(UnsafeMemory::BYTE_ARRAY_BASE_OFFSET_delegate$lambda$0);
        directByteBufferConstructor$delegate = LazyKt.lazy(UnsafeMemory::directByteBufferConstructor_delegate$lambda$0);
    }
}

