/*
 * Decompiled with CFR 0.152.
 */
package com.ditchoom.buffer;

import com.ditchoom.buffer.ByteSwapKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0012\u001at\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u00072\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u00072\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b0\u00072\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b0\u0007H\u0080\b\u00f8\u0001\u0000\u001a\u0084\u0001\u0010\r\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u00072\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u00072\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b0\u00072\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b0\u0007H\u0080\b\u00f8\u0001\u0000\u001aL\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u000b2\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u00072\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b0\u0007H\u0080\b\u00f8\u0001\u0000\u001aL\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u000b2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00072\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b0\u0007H\u0080\b\u00f8\u0001\u0000\u001at\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00072\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00072\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b0\u00072\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b0\u0007H\u0080\b\u00f8\u0001\u0000\u001a\u0084\u0001\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00072\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00072\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b0\u00072\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b0\u0007H\u0080\b\u00f8\u0001\u0000\u001a\u0090\u0001\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u00032\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u00072\u0018\u0010 \u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001a0!2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b0\u00072\u0018\u0010\"\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u001a0!H\u0080\b\u00f8\u0001\u0000\u001a\u0098\u0001\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u00032\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u00072\u0018\u0010'\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001a0!2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b0\u00072\u0018\u0010)\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u001a0!H\u0080\b\u00f8\u0001\u0000\u001a\u0090\u0001\u0010*\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010+\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u00032\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00072\u0018\u0010,\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u001a0!2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b0\u00072\u0018\u0010\"\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u001a0!H\u0080\b\u00f8\u0001\u0000\u001a\u0098\u0001\u0010-\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010+\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u00032\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00072\u0018\u0010/\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u001a0!2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b0\u00072\u0018\u0010)\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u001a0!H\u0080\b\u00f8\u0001\u0000\u001a \u00100\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u00101\u001a\u00020\u0001H\u0000\u001a \u00102\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u00101\u001a\u00020\u0001H\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u00063"}, d2={"bulkCompareEquals", "", "thisPos", "", "otherPos", "length", "getLong", "Lkotlin/Function1;", "", "otherGetLong", "getByte", "", "otherGetByte", "bulkMismatch", "minLength", "thisRemaining", "otherRemaining", "bulkIndexOf", "startPos", "byte", "bulkIndexOfInt", "getInt", "bulkCompareEqualsInt", "otherGetInt", "bulkMismatchInt", "bulkXorMask", "", "pos", "size", "maskLong", "mask", "maskOffset", "setLong", "Lkotlin/Function2;", "setByte", "bulkXorMaskCopy", "srcPos", "dstPos", "srcGetLong", "dstSetLong", "srcGetByte", "dstSetByte", "bulkXorMaskInt", "maskInt", "setInt", "bulkXorMaskCopyInt", "srcGetInt", "dstSetInt", "buildMaskLong", "littleEndian", "buildMaskInt", "buffer_release"})
public final class BufferComparisonKt {
    public static final boolean bulkCompareEquals(int thisPos, int otherPos, int length, @NotNull Function1<? super Integer, Long> getLong, @NotNull Function1<? super Integer, Long> otherGetLong, @NotNull Function1<? super Integer, Byte> getByte, @NotNull Function1<? super Integer, Byte> otherGetByte) {
        Intrinsics.checkNotNullParameter(getLong, (String)"getLong");
        Intrinsics.checkNotNullParameter(otherGetLong, (String)"otherGetLong");
        Intrinsics.checkNotNullParameter(getByte, (String)"getByte");
        Intrinsics.checkNotNullParameter(otherGetByte, (String)"otherGetByte");
        boolean $i$f$bulkCompareEquals = false;
        int i = 0;
        while (i + 8 <= length) {
            if (((Number)getLong.invoke((Object)(thisPos + i))).longValue() != ((Number)otherGetLong.invoke((Object)(otherPos + i))).longValue()) {
                return false;
            }
            i += 8;
        }
        while (i < length) {
            if (((Number)getByte.invoke((Object)(thisPos + i))).byteValue() != ((Number)otherGetByte.invoke((Object)(otherPos + i))).byteValue()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final int bulkMismatch(int thisPos, int otherPos, int minLength, int thisRemaining, int otherRemaining, @NotNull Function1<? super Integer, Long> getLong, @NotNull Function1<? super Integer, Long> otherGetLong, @NotNull Function1<? super Integer, Byte> getByte, @NotNull Function1<? super Integer, Byte> otherGetByte) {
        Intrinsics.checkNotNullParameter(getLong, (String)"getLong");
        Intrinsics.checkNotNullParameter(otherGetLong, (String)"otherGetLong");
        Intrinsics.checkNotNullParameter(getByte, (String)"getByte");
        Intrinsics.checkNotNullParameter(otherGetByte, (String)"otherGetByte");
        boolean $i$f$bulkMismatch = false;
        int i = 0;
        while (i + 8 <= minLength) {
            if (((Number)getLong.invoke((Object)(thisPos + i))).longValue() != ((Number)otherGetLong.invoke((Object)(otherPos + i))).longValue()) {
                for (int j = 0; j < 8; ++j) {
                    if (((Number)getByte.invoke((Object)(thisPos + i + j))).byteValue() == ((Number)otherGetByte.invoke((Object)(otherPos + i + j))).byteValue()) continue;
                    return i + j;
                }
            }
            i += 8;
        }
        while (i < minLength) {
            if (((Number)getByte.invoke((Object)(thisPos + i))).byteValue() != ((Number)otherGetByte.invoke((Object)(otherPos + i))).byteValue()) {
                return i;
            }
            ++i;
        }
        return thisRemaining != otherRemaining ? minLength : -1;
    }

    public static final int bulkIndexOf(int startPos, int length, byte by, @NotNull Function1<? super Integer, Long> getLong, @NotNull Function1<? super Integer, Byte> getByte) {
        Intrinsics.checkNotNullParameter(getLong, (String)"getLong");
        Intrinsics.checkNotNullParameter(getByte, (String)"getByte");
        boolean $i$f$bulkIndexOf = false;
        if (length == 0) {
            return -1;
        }
        long targetLong = ((long)by & 0xFFL) * 0x101010101010101L;
        int i = 0;
        while (i + 8 <= length) {
            long value = ((Number)getLong.invoke((Object)(startPos + i))).longValue();
            long xor = value ^ targetLong;
            long hasZero = xor - 0x101010101010101L & 0x8080808080808080L & (xor ^ 0xFFFFFFFFFFFFFFFFL);
            if (hasZero != 0L) {
                for (int j = 0; j < 8; ++j) {
                    if (((Number)getByte.invoke((Object)(startPos + i + j))).byteValue() != by) continue;
                    return i + j;
                }
            }
            i += 8;
        }
        while (i < length) {
            if (((Number)getByte.invoke((Object)(startPos + i))).byteValue() == by) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static final int bulkIndexOfInt(int startPos, int length, byte by, @NotNull Function1<? super Integer, Integer> getInt, @NotNull Function1<? super Integer, Byte> getByte) {
        Intrinsics.checkNotNullParameter(getInt, (String)"getInt");
        Intrinsics.checkNotNullParameter(getByte, (String)"getByte");
        boolean $i$f$bulkIndexOfInt = false;
        if (length == 0) {
            return -1;
        }
        int b = by & 0xFF;
        boolean bl = false;
        int targetInt = b | b << 8 | b << 16 | b << 24;
        int i = 0;
        while (i + 4 <= length) {
            int value = ((Number)getInt.invoke((Object)(startPos + i))).intValue();
            int xor = value ^ targetInt;
            int hasZero = xor - 0x1010101 & ~xor & 0x80808080;
            if (hasZero != 0) {
                for (int j = 0; j < 4; ++j) {
                    if (((Number)getByte.invoke((Object)(startPos + i + j))).byteValue() != by) continue;
                    return i + j;
                }
            }
            i += 4;
        }
        while (i < length) {
            if (((Number)getByte.invoke((Object)(startPos + i))).byteValue() == by) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static final boolean bulkCompareEqualsInt(int thisPos, int otherPos, int length, @NotNull Function1<? super Integer, Integer> getInt, @NotNull Function1<? super Integer, Integer> otherGetInt, @NotNull Function1<? super Integer, Byte> getByte, @NotNull Function1<? super Integer, Byte> otherGetByte) {
        Intrinsics.checkNotNullParameter(getInt, (String)"getInt");
        Intrinsics.checkNotNullParameter(otherGetInt, (String)"otherGetInt");
        Intrinsics.checkNotNullParameter(getByte, (String)"getByte");
        Intrinsics.checkNotNullParameter(otherGetByte, (String)"otherGetByte");
        boolean $i$f$bulkCompareEqualsInt = false;
        int i = 0;
        while (i + 4 <= length) {
            if (((Number)getInt.invoke((Object)(thisPos + i))).intValue() != ((Number)otherGetInt.invoke((Object)(otherPos + i))).intValue()) {
                return false;
            }
            i += 4;
        }
        while (i < length) {
            if (((Number)getByte.invoke((Object)(thisPos + i))).byteValue() != ((Number)otherGetByte.invoke((Object)(otherPos + i))).byteValue()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final int bulkMismatchInt(int thisPos, int otherPos, int minLength, int thisRemaining, int otherRemaining, @NotNull Function1<? super Integer, Integer> getInt, @NotNull Function1<? super Integer, Integer> otherGetInt, @NotNull Function1<? super Integer, Byte> getByte, @NotNull Function1<? super Integer, Byte> otherGetByte) {
        Intrinsics.checkNotNullParameter(getInt, (String)"getInt");
        Intrinsics.checkNotNullParameter(otherGetInt, (String)"otherGetInt");
        Intrinsics.checkNotNullParameter(getByte, (String)"getByte");
        Intrinsics.checkNotNullParameter(otherGetByte, (String)"otherGetByte");
        boolean $i$f$bulkMismatchInt = false;
        int i = 0;
        while (i + 4 <= minLength) {
            if (((Number)getInt.invoke((Object)(thisPos + i))).intValue() != ((Number)otherGetInt.invoke((Object)(otherPos + i))).intValue()) {
                for (int j = 0; j < 4; ++j) {
                    if (((Number)getByte.invoke((Object)(thisPos + i + j))).byteValue() == ((Number)otherGetByte.invoke((Object)(otherPos + i + j))).byteValue()) continue;
                    return i + j;
                }
            }
            i += 4;
        }
        while (i < minLength) {
            if (((Number)getByte.invoke((Object)(thisPos + i))).byteValue() != ((Number)otherGetByte.invoke((Object)(otherPos + i))).byteValue()) {
                return i;
            }
            ++i;
        }
        return thisRemaining != otherRemaining ? minLength : -1;
    }

    public static final void bulkXorMask(int pos, int size, long maskLong, int mask, int maskOffset, @NotNull Function1<? super Integer, Long> getLong, @NotNull Function2<? super Integer, ? super Long, Unit> setLong, @NotNull Function1<? super Integer, Byte> getByte, @NotNull Function2<? super Integer, ? super Byte, Unit> setByte) {
        Intrinsics.checkNotNullParameter(getLong, (String)"getLong");
        Intrinsics.checkNotNullParameter(setLong, (String)"setLong");
        Intrinsics.checkNotNullParameter(getByte, (String)"getByte");
        Intrinsics.checkNotNullParameter(setByte, (String)"setByte");
        boolean $i$f$bulkXorMask = false;
        byte maskByte0 = (byte)(mask >>> 24);
        byte maskByte1 = (byte)(mask >>> 16);
        byte maskByte2 = (byte)(mask >>> 8);
        byte maskByte3 = (byte)mask;
        int i = 0;
        while (i + 8 <= size) {
            setLong.invoke((Object)(pos + i), (Object)(((Number)getLong.invoke((Object)(pos + i))).longValue() ^ maskLong));
            i += 8;
        }
        while (i < size) {
            byte by;
            switch (i + maskOffset & 3) {
                case 0: {
                    by = maskByte0;
                    break;
                }
                case 1: {
                    by = maskByte1;
                    break;
                }
                case 2: {
                    by = maskByte2;
                    break;
                }
                default: {
                    by = maskByte3;
                }
            }
            byte maskByte = by;
            setByte.invoke((Object)(pos + i), (Object)((byte)(((Number)getByte.invoke((Object)(pos + i))).byteValue() ^ maskByte)));
            ++i;
        }
    }

    public static final void bulkXorMaskCopy(int srcPos, int dstPos, int size, long maskLong, int mask, int maskOffset, @NotNull Function1<? super Integer, Long> srcGetLong, @NotNull Function2<? super Integer, ? super Long, Unit> dstSetLong, @NotNull Function1<? super Integer, Byte> srcGetByte, @NotNull Function2<? super Integer, ? super Byte, Unit> dstSetByte) {
        Intrinsics.checkNotNullParameter(srcGetLong, (String)"srcGetLong");
        Intrinsics.checkNotNullParameter(dstSetLong, (String)"dstSetLong");
        Intrinsics.checkNotNullParameter(srcGetByte, (String)"srcGetByte");
        Intrinsics.checkNotNullParameter(dstSetByte, (String)"dstSetByte");
        boolean $i$f$bulkXorMaskCopy = false;
        byte maskByte0 = (byte)(mask >>> 24);
        byte maskByte1 = (byte)(mask >>> 16);
        byte maskByte2 = (byte)(mask >>> 8);
        byte maskByte3 = (byte)mask;
        int i = 0;
        while (i + 8 <= size) {
            dstSetLong.invoke((Object)(dstPos + i), (Object)(((Number)srcGetLong.invoke((Object)(srcPos + i))).longValue() ^ maskLong));
            i += 8;
        }
        while (i < size) {
            byte by;
            switch (i + maskOffset & 3) {
                case 0: {
                    by = maskByte0;
                    break;
                }
                case 1: {
                    by = maskByte1;
                    break;
                }
                case 2: {
                    by = maskByte2;
                    break;
                }
                default: {
                    by = maskByte3;
                }
            }
            byte maskByte = by;
            dstSetByte.invoke((Object)(dstPos + i), (Object)((byte)(((Number)srcGetByte.invoke((Object)(srcPos + i))).byteValue() ^ maskByte)));
            ++i;
        }
    }

    public static final void bulkXorMaskInt(int pos, int size, int maskInt, int mask, int maskOffset, @NotNull Function1<? super Integer, Integer> getInt, @NotNull Function2<? super Integer, ? super Integer, Unit> setInt, @NotNull Function1<? super Integer, Byte> getByte, @NotNull Function2<? super Integer, ? super Byte, Unit> setByte) {
        Intrinsics.checkNotNullParameter(getInt, (String)"getInt");
        Intrinsics.checkNotNullParameter(setInt, (String)"setInt");
        Intrinsics.checkNotNullParameter(getByte, (String)"getByte");
        Intrinsics.checkNotNullParameter(setByte, (String)"setByte");
        boolean $i$f$bulkXorMaskInt = false;
        byte maskByte0 = (byte)(mask >>> 24);
        byte maskByte1 = (byte)(mask >>> 16);
        byte maskByte2 = (byte)(mask >>> 8);
        byte maskByte3 = (byte)mask;
        int i = 0;
        while (i + 4 <= size) {
            setInt.invoke((Object)(pos + i), (Object)(((Number)getInt.invoke((Object)(pos + i))).intValue() ^ maskInt));
            i += 4;
        }
        while (i < size) {
            byte by;
            switch (i + maskOffset & 3) {
                case 0: {
                    by = maskByte0;
                    break;
                }
                case 1: {
                    by = maskByte1;
                    break;
                }
                case 2: {
                    by = maskByte2;
                    break;
                }
                default: {
                    by = maskByte3;
                }
            }
            byte maskByte = by;
            setByte.invoke((Object)(pos + i), (Object)((byte)(((Number)getByte.invoke((Object)(pos + i))).byteValue() ^ maskByte)));
            ++i;
        }
    }

    public static final void bulkXorMaskCopyInt(int srcPos, int dstPos, int size, int maskInt, int mask, int maskOffset, @NotNull Function1<? super Integer, Integer> srcGetInt, @NotNull Function2<? super Integer, ? super Integer, Unit> dstSetInt, @NotNull Function1<? super Integer, Byte> srcGetByte, @NotNull Function2<? super Integer, ? super Byte, Unit> dstSetByte) {
        Intrinsics.checkNotNullParameter(srcGetInt, (String)"srcGetInt");
        Intrinsics.checkNotNullParameter(dstSetInt, (String)"dstSetInt");
        Intrinsics.checkNotNullParameter(srcGetByte, (String)"srcGetByte");
        Intrinsics.checkNotNullParameter(dstSetByte, (String)"dstSetByte");
        boolean $i$f$bulkXorMaskCopyInt = false;
        byte maskByte0 = (byte)(mask >>> 24);
        byte maskByte1 = (byte)(mask >>> 16);
        byte maskByte2 = (byte)(mask >>> 8);
        byte maskByte3 = (byte)mask;
        int i = 0;
        while (i + 4 <= size) {
            dstSetInt.invoke((Object)(dstPos + i), (Object)(((Number)srcGetInt.invoke((Object)(srcPos + i))).intValue() ^ maskInt));
            i += 4;
        }
        while (i < size) {
            byte by;
            switch (i + maskOffset & 3) {
                case 0: {
                    by = maskByte0;
                    break;
                }
                case 1: {
                    by = maskByte1;
                    break;
                }
                case 2: {
                    by = maskByte2;
                    break;
                }
                default: {
                    by = maskByte3;
                }
            }
            byte maskByte = by;
            dstSetByte.invoke((Object)(dstPos + i), (Object)((byte)(((Number)srcGetByte.invoke((Object)(srcPos + i))).byteValue() ^ maskByte)));
            ++i;
        }
    }

    public static final long buildMaskLong(int mask, int maskOffset, boolean littleEndian) {
        long l;
        int rotated;
        int shift = (maskOffset & 3) * 8;
        int n = rotated = shift == 0 ? mask : mask << shift | mask >>> 32 - shift;
        if (littleEndian) {
            int le = ByteSwapKt.reverseBytes(rotated);
            l = (long)le & 0xFFFFFFFFL | (long)le << 32;
        } else {
            l = (long)rotated << 32 | (long)rotated & 0xFFFFFFFFL;
        }
        return l;
    }

    public static final int buildMaskInt(int mask, int maskOffset, boolean littleEndian) {
        int shift = (maskOffset & 3) * 8;
        int rotated = shift == 0 ? mask : mask << shift | mask >>> 32 - shift;
        return littleEndian ? ByteSwapKt.reverseBytes(rotated) : rotated;
    }
}

