/*
 * Decompiled with CFR 0.152.
 */
package com.ditchoom.buffer.stream;

import com.ditchoom.buffer.pool.BufferPool;
import com.ditchoom.buffer.stream.StreamProcessor;
import com.ditchoom.buffer.stream.SuspendingStreamProcessor;
import com.ditchoom.buffer.stream.SyncToSuspendingProcessor;
import com.ditchoom.buffer.stream.TransformSpec;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\bJ\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/ditchoom/buffer/stream/StreamProcessorBuilder;", "", "pool", "Lcom/ditchoom/buffer/pool/BufferPool;", "<init>", "(Lcom/ditchoom/buffer/pool/BufferPool;)V", "transforms", "", "Lcom/ditchoom/buffer/stream/TransformSpec;", "addTransform", "spec", "build", "Lcom/ditchoom/buffer/stream/StreamProcessor;", "buildSuspending", "Lcom/ditchoom/buffer/stream/SuspendingStreamProcessor;", "buffer_release"})
public final class StreamProcessorBuilder {
    @NotNull
    private final BufferPool pool;
    @NotNull
    private final List<TransformSpec> transforms;

    public StreamProcessorBuilder(@NotNull BufferPool pool) {
        Intrinsics.checkNotNullParameter((Object)pool, (String)"pool");
        this.pool = pool;
        this.transforms = new ArrayList();
    }

    @NotNull
    public final StreamProcessorBuilder addTransform(@NotNull TransformSpec spec) {
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        this.transforms.add(spec);
        return this;
    }

    @NotNull
    public final StreamProcessor build() {
        StreamProcessor processor = StreamProcessor.Companion.create(this.pool);
        for (TransformSpec spec : this.transforms) {
            processor = spec.wrapSync(processor);
        }
        return processor;
    }

    @NotNull
    public final SuspendingStreamProcessor buildSuspending() {
        SuspendingStreamProcessor processor = new SyncToSuspendingProcessor(StreamProcessor.Companion.create(this.pool));
        for (TransformSpec spec : this.transforms) {
            processor = spec.wrapSuspending(processor);
        }
        return processor;
    }
}

